/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.jmx;

import com.sun.management.jmx.DefaultLoaderRepository;
import com.sun.management.jmx.MBeanServerNotificationListener;
import com.sun.management.jmx.MetaData;
import com.sun.management.jmx.NamedObject;
import com.sun.management.jmx.ObjectInputStreamWithLoader;
import com.sun.management.jmx.RepositorySupport;
import com.sun.management.jmx.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanServerImpl
implements MBeanServer {
    private transient MetaData meta = null;
    private transient RepositorySupport repository = null;
    private transient MBeanServerDelegate MBeanServerDelegateObject = null;
    private transient ObjectName MBeanServerDelegateObjectName = null;
    private transient ClassLoader loader = null;
    private String domain = null;
    private boolean queryByRepo;
    private transient Hashtable internalListener = new Hashtable();
    private int sequenceNumber = 0;
    private static ArrayList MBeanServerList = new ArrayList();
    private final String dbgTag = "MBeanServer";

    public MBeanServerImpl() {
        this.initialize(new RepositorySupport(), null);
    }

    public MBeanServerImpl(String string) {
        this.initialize(new RepositorySupport(), string);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "obj= " + objectName);
        }
        Object object2 = this.getMBean(objectName);
        NotificationBroadcaster notificationBroadcaster = null;
        if (!(object2 instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        notificationBroadcaster = (NotificationBroadcaster)object2;
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        MBeanServerNotificationListener mBeanServerNotificationListener = (MBeanServerNotificationListener)this.internalListener.get(notificationListener);
        if (mBeanServerNotificationListener == null) {
            mBeanServerNotificationListener = new MBeanServerNotificationListener(notificationListener, notificationFilter, object, objectName);
            this.internalListener.put(notificationListener, mBeanServerNotificationListener);
        }
        notificationBroadcaster.addNotificationListener(mBeanServerNotificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getMBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName2.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    private Object checkUpdateContext(Object object, Object object2) {
        if (object2 == null) {
            return null;
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader == null) {
            return object2;
        }
        ClassLoader classLoader2 = object2.getClass().getClassLoader();
        if (classLoader2 == null) {
            return object2;
        }
        if (classLoader.equals(classLoader2)) {
            return object2;
        }
        return this.transferObject(object2, classLoader);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName objectName2;
        Class clazz = null;
        Object object = null;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object creation");
        }
        if (objectName != null && objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("invalid name->" + objectName.toString()), "Exception occured during object creation");
        }
        String string2 = "null";
        if (objectName != null) {
            string2 = objectName.toString();
        }
        if (this.isTraceOn()) {
            this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + string2);
        }
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = javax.management.loading.DefaultLoaderRepository.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ReflectionException(classNotFoundException2, "The MBean class could not be loaded by the default loader repository");
            }
        }
        this.meta.testCompliance(clazz);
        object = this.internal_instantiate(clazz);
        ObjectName objectName3 = null;
        if (object instanceof MBeanRegistration) {
            objectName3 = this.preRegisterInvoker(object, objectName);
        }
        if ((objectName2 = objectName == null ? objectName3 : objectName) == null) {
            if (object instanceof MBeanRegistration) {
                this.postRegisterInvoker(object, false);
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("No object name specified"), "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            DefaultLoaderRepository.addClassLoader((ClassLoader)object);
        }
        if (object instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new NotCompliantMBeanException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new NotCompliantMBeanException("The class Name returned is null");
                }
            }
            catch (Exception exception) {
                throw new NotCompliantMBeanException("Exception " + exception.getClass().getName() + " :" + exception.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance(objectName2, string);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object object;
        Class clazz;
        Object object2;
        Object object3 = null;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid name->" + objectName.toString()), "Exception occured during MBean registration");
        }
        if (objectName2 == null) {
            object2 = "null";
            if (objectName != null) {
                object2 = objectName.toString();
            }
            if (this.isTraceOn()) {
                this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object2 + ", loader null");
            }
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the MBeanServer's loader");
            }
        }
        object2 = "null";
        if (objectName != null) {
            object2 = objectName.toString();
        }
        if (this.isTraceOn()) {
            this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object2 + ", LoaderName = " + objectName2);
        }
        try {
            clazz = this.findClass(string, objectName2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the specified loader");
        }
        this.meta.testCompliance(clazz);
        object3 = this.internal_instantiate(clazz);
        object2 = null;
        if (object3 instanceof MBeanRegistration) {
            object2 = this.preRegisterInvoker(object3, objectName);
        }
        if ((object = objectName == null ? object2 : objectName) == null) {
            if (object3 instanceof MBeanRegistration) {
                this.postRegisterInvoker(object3, false);
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("No object name specified"), "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object3, (ObjectName)object);
        if (object3 instanceof MBeanRegistration) {
            this.postRegisterInvoker(object3, true);
        }
        if (object3 instanceof ClassLoader) {
            DefaultLoaderRepository.addClassLoader((ClassLoader)object3);
        }
        if (object3 instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object3).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new NotCompliantMBeanException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new NotCompliantMBeanException("The class Name returned is null");
                }
            }
            catch (Exception exception) {
                throw new NotCompliantMBeanException("Exception " + exception.getClass().getName() + " :" + exception.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance((ObjectName)object, string);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectName objectName3;
        Class clazz;
        Object object;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid name->" + objectName.toString()), "Exception occured during MBean registration");
        }
        if (objectName2 == null) {
            object = "null";
            if (objectName != null) {
                object = objectName.toString();
            }
            if (this.isTraceOn()) {
                this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + " Loader name = null");
            }
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the MBeanServer's loader");
            }
        }
        object = "null";
        if (objectName != null) {
            object = objectName.toString();
        }
        if (this.isTraceOn()) {
            this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + ",Loader name = " + objectName2.toString());
        }
        try {
            clazz = this.findClass(string, objectName2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the specified loader");
        }
        this.meta.testCompliance(clazz);
        object = this.internal_instantiate(clazz, objectArray, stringArray);
        ObjectName objectName4 = null;
        if (object instanceof MBeanRegistration) {
            objectName4 = this.preRegisterInvoker(object, objectName);
        }
        if ((objectName3 = objectName == null ? objectName4 : objectName) == null) {
            if (object instanceof MBeanRegistration) {
                this.postRegisterInvoker(object, false);
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("No object name specified"), "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object, objectName3);
        if (object instanceof MBeanRegistration) {
            this.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            DefaultLoaderRepository.addClassLoader((ClassLoader)object);
        }
        if (object instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new NotCompliantMBeanException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new NotCompliantMBeanException("The class Name returned is null");
                }
            }
            catch (Exception exception) {
                throw new NotCompliantMBeanException("Exception " + exception.getClass().getName() + " :" + exception.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance(objectName3, string);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName objectName2;
        Class clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid name->" + objectName.toString()), "Exception occured during MBean registration");
        }
        String string2 = "null";
        if (objectName != null) {
            string2 = objectName.toString();
        }
        if (this.isTraceOn()) {
            this.trace("MBeanServer", "createMBean", "ClassName = " + string + ",ObjectName = " + string2);
        }
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = javax.management.loading.DefaultLoaderRepository.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ReflectionException(classNotFoundException2, "The MBean class could not be loaded by the default loader repository");
            }
        }
        this.meta.testCompliance(clazz);
        Object object = this.internal_instantiate(clazz, objectArray, stringArray);
        ObjectName objectName3 = null;
        if (object instanceof MBeanRegistration) {
            objectName3 = this.preRegisterInvoker(object, objectName);
        }
        if ((objectName2 = objectName == null ? objectName3 : objectName) == null) {
            if (object instanceof MBeanRegistration) {
                this.postRegisterInvoker(object, false);
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("No object name specified"), "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            DefaultLoaderRepository.addClassLoader((ClassLoader)object);
        }
        if (object instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new NotCompliantMBeanException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new NotCompliantMBeanException("The class Name returned is null");
                }
            }
            catch (Exception exception) {
                throw new NotCompliantMBeanException("Exception " + exception.getClass().getName() + " :" + exception.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance(objectName2, string);
    }

    private void debug(String string, String string2) {
        this.debug("MBeanServer", string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class<?> clazz = null;
        if (objectName == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the agent class loader");
            }
        }
        Object object = this.getMBean(objectName);
        if (!(object instanceof ClassLoader)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(String.valueOf(objectName.toString()) + " is not a ClassLoader"));
        }
        try {
            clazz = ((ClassLoader)object).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the " + objectName.toString() + " class loader");
        }
        object = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)object, clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class clazz = null;
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = javax.management.loading.DefaultLoaderRepository.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ReflectionException(classNotFoundException2, "The MBean class could not be loaded by the default loader repository");
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        Object object = this.getMBean(objectName);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, object.getClass().getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    private Set filterListOfObjects(Set set, QueryExp queryExp) {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        if (queryExp == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                NamedObject namedObject = (NamedObject)iterator.next();
                Object object = namedObject.getObject();
                String string = object.getClass().getName();
                if (object instanceof DynamicMBean) {
                    try {
                        MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                        if (mBeanInfo == null) {
                            throw new JMRuntimeException("The MBeanInfo returned is null");
                        }
                        string = mBeanInfo.getClassName();
                        if (string == null) {
                            throw new JMRuntimeException("The class Name returned is null");
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw new RuntimeMBeanException(runtimeException, "Exception " + runtimeException.getClass().getName() + " :" + runtimeException.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
                    }
                    catch (Error error) {
                        throw new RuntimeErrorException(error, "Error " + error.getClass().getName() + " :" + error.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                NamedObject namedObject = (NamedObject)iterator.next();
                Object object = namedObject.getObject();
                String string = object.getClass().getName();
                boolean bl = false;
                queryExp.setMBeanServer(this);
                try {
                    bl = queryExp.apply(namedObject.getName());
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) continue;
                if (object instanceof DynamicMBean) {
                    try {
                        MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                        if (mBeanInfo == null) {
                            throw new JMRuntimeException("The MBeanInfo returned is null");
                        }
                        string = mBeanInfo.getClassName();
                        if (string == null) {
                            throw new JMRuntimeException("The class Name returned is null");
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw new RuntimeMBeanException(runtimeException, "Exception " + runtimeException.getClass().getName() + " :" + runtimeException.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
                    }
                    catch (Error error) {
                        throw new RuntimeErrorException(error, "Error " + error.getClass().getName() + " :" + error.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        }
        return hashSet;
    }

    private Class findClass(Object object, String string) throws ReflectionException {
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader == null) {
            try {
                return this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "Failed to load class className using the MBean's class loader");
            }
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "Failed to load class className using the MBean's class loader");
        }
    }

    private Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        return clazz;
    }

    private Class findClass(String string, ObjectName objectName) throws ClassNotFoundException, InstanceNotFoundException {
        if (objectName == null) {
            return this.findClass(string);
        }
        Object object = null;
        Object object2 = this;
        synchronized (object2) {
            object = this.repository.retrieve(objectName);
        }
        if (object == null) {
            throw new InstanceNotFoundException("The loader named " + string + " is not registered in the MBeanServer");
        }
        if (!(object instanceof ClassLoader)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), String.valueOf(objectName.toString()) + " is not a ClassLoader");
        }
        object2 = ((ClassLoader)object).loadClass(string);
        return object2;
    }

    private MBeanNotificationInfo[] findNotifications(Object object) {
        if (object instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = ((NotificationBroadcaster)object).getNotificationInfo();
            if (mBeanNotificationInfoArray == null) {
                return new MBeanNotificationInfo[0];
            }
            MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
            int n = 0;
            while (n < mBeanNotificationInfoArray.length) {
                mBeanNotificationInfoArray2[n] = (MBeanNotificationInfo)mBeanNotificationInfoArray[n].clone();
                ++n;
            }
            return mBeanNotificationInfoArray2;
        }
        return new MBeanNotificationInfo[0];
    }

    Object getAttribute(Object object, String string) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        Class clazz = this.meta.getMBeanInterface(object.getClass());
        if (clazz == null) {
            try {
                return ((DynamicMBean)object).getAttribute(string);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown by the getAttribute method of the DynamicMBean  for the attribute " + string);
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown by the getAttribute method of the DynamicMBean  for the attribute " + string);
            }
        }
        Method method = null;
        method = this.meta.findGetter(clazz, string);
        if (method == null) {
            if (this.isTraceOn()) {
                this.trace("getAttribute", "Cannot find getter for " + string);
            }
            throw new AttributeNotFoundException(String.valueOf(string) + " not accessible");
        }
        if (this.isTraceOn()) {
            this.trace("getAttribute", "Invoke callback");
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "Runtime Exception thrown in the getter for the attribute " + string);
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the getter for the attribute " + string);
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the getter for the attribute " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeOperationsException(runtimeException, "Runtime exception thrown trying to invoke the getter for the attribute " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trting to invoke the getter for the attribute " + string);
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown trting to invoke the getter for the attribute " + string);
        }
        if (this.isTraceOn()) {
            this.trace("getAttribute", String.valueOf(string) + "= " + object2 + "\n");
        }
        return object2;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (this.isTraceOn()) {
            this.trace("getAttribute", "Attribute= " + string + ", obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        return this.getAttribute(object, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        Object object;
        Class clazz;
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        if (this.isTraceOn()) {
            this.trace("getAttributes", "Object= " + objectName);
        }
        if ((clazz = this.meta.getMBeanInterface((object = this.getMBean(objectName)).getClass())) == null) {
            try {
                return ((DynamicMBean)object).getAttributes(stringArray);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown trying by the getAttributes method of the DynamicMBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown by the getAttributes method of the DynamicMBean ");
            }
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                String string = stringArray[n2];
                try {
                    Object object2 = this.getAttribute(object, string);
                    attributeList.add(new Attribute(string, object2));
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug("getAttributes", "Object= " + objectName);
                }
            }
            ++n2;
        }
        return attributeList;
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    private Object getMBean(ObjectName objectName) throws InstanceNotFoundException {
        block9: {
            if (objectName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to get an MBean");
            }
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(String.valueOf(this.domain) + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!this.isDebugOn()) break block9;
                    this.debug("getMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        Object object = null;
        MBeanServerImpl mBeanServerImpl = this;
        synchronized (mBeanServerImpl) {
            object = this.repository.retrieve(objectName);
            if (object == null) {
                if (this.isTraceOn()) {
                    this.trace("getMBean", String.valueOf(String.valueOf(objectName)) + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
        }
        return object;
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mBeanInfo = null;
        Object object = this.getMBean(objectName);
        Class clazz = this.meta.getMBeanInterface(object.getClass());
        if (clazz == null) {
            try {
                mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeMBeanException(runtimeException, "Runtime Exception thrown by getMBeanInfo method of Dynamic MBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown by getMBeanInfo method of Dynamic MBean");
            }
            if (mBeanInfo != null) {
                return (MBeanInfo)mBeanInfo.clone();
            }
            throw new JMRuntimeException("Dynamic MBean " + objectName + " returns null MBeanInfo");
        }
        MBeanInfo mBeanInfo2 = this.meta.getMBeanInfo(object.getClass());
        return new MBeanInfo(mBeanInfo2.getClassName(), mBeanInfo2.getDescription(), mBeanInfo2.getAttributes(), mBeanInfo2.getConstructors(), mBeanInfo2.getOperations(), this.findNotifications(object));
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        String string = object.getClass().getName();
        if (object instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new JMRuntimeException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new JMRuntimeException("The class Name returned is null");
                }
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeMBeanException(runtimeException, "Exception " + runtimeException.getClass().getName() + " :" + runtimeException.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error " + error.getClass().getName() + " :" + error.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance(objectName, string);
    }

    private void initialize(RepositorySupport repositorySupport, String string) {
        block6: {
            this.repository = repositorySupport;
            this.domain = string == null || string.equals("") ? repositorySupport.getDefaultDomain() : string;
            repositorySupport.setDefaultDomain(this.domain);
            if (this.isTraceOn()) {
                this.trace("new", "Initializing domain " + this.domain);
            }
            try {
                this.queryByRepo = repositorySupport.isFiltering();
            }
            catch (Exception exception) {
                this.queryByRepo = false;
            }
            this.meta = new MetaData();
            try {
                this.MBeanServerDelegateObject = new MBeanServerDelegate();
                this.MBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.registerMBean(this.MBeanServerDelegateObject, this.MBeanServerDelegateObjectName);
            }
            catch (JMException jMException) {
                if (!this.isDebugOn()) break block6;
                this.debug("new", "Unexpected exception occured: " + jMException.getClass().getName());
            }
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            DefaultLoaderRepository.addClassLoader(classLoader);
        }
        DefaultLoaderRepository.addClassLoader(ClassLoader.getSystemClassLoader());
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        Class clazz;
        Object var3_2 = null;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = javax.management.loading.DefaultLoaderRepository.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ReflectionException(classNotFoundException2, "The MBean class could not be loaded by the default loader repository");
            }
        }
        return this.internal_instantiate(clazz);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class clazz;
        Object var4_3 = null;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        if (objectName == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the MBeanServer's loader");
            }
        }
        try {
            clazz = this.findClass(string, objectName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the specified loader");
        }
        return this.internal_instantiate(clazz);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        if (objectName == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the MBeanServer's loader");
            }
        }
        try {
            clazz = this.findClass(string, objectName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the specified loader");
        }
        return this.internal_instantiate(clazz, objectArray, stringArray);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        Class clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = javax.management.loading.DefaultLoaderRepository.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ReflectionException(classNotFoundException2, "The MBean class could not be loaded by the default loader repository");
            }
        }
        return this.internal_instantiate(clazz, objectArray, stringArray);
    }

    private void internal_addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        block11: {
            if (this.isTraceOn()) {
                this.trace("internal_addObject", "Name= " + objectName);
            }
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(String.valueOf(this.domain) + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!this.isDebugOn()) break block11;
                    this.debug("internal_addObject", "Unexpected MalformedObjectNameException");
                }
            }
        }
        MBeanServerImpl mBeanServerImpl = this;
        synchronized (mBeanServerImpl) {
            try {
                this.repository.addMBean(object, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (object instanceof MBeanRegistration) {
                    this.postRegisterInvoker(object, false);
                }
                throw instanceAlreadyExistsException;
            }
        }
        if (this.isTraceOn()) {
            this.trace("addObject", "Send create notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", objectName);
    }

    private Object internal_instantiate(Class clazz) throws ReflectionException, MBeanException {
        Object var2_2 = null;
        Constructor constructor = this.meta.findConstructor(clazz, null);
        if (constructor == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            var2_2 = constructor.newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return var2_2;
    }

    private Object internal_instantiate(Class clazz, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        Object object;
        Class[] classArray;
        Object var5_4 = null;
        try {
            if (stringArray == null) {
                classArray = null;
            } else {
                int n = stringArray.length;
                classArray = new Class[n];
                ClassLoader classLoader = clazz.getClassLoader();
                int n2 = 0;
                while (n2 < n) {
                    Class clazz2 = this.meta.findClassForPrim(stringArray[n2]);
                    if (clazz2 != null) {
                        classArray[n2] = clazz2;
                    } else if (classLoader != null) {
                        classArray[n2] = classLoader.loadClass(stringArray[n2]);
                        object = classArray[n2].getClassLoader();
                        if (objectArray[n2] != null && object != null && !object.equals(objectArray[n2].getClass().getClassLoader())) {
                            objectArray[n2] = this.transferObject(objectArray[n2], classLoader);
                        }
                    } else {
                        classArray[n2] = this.findClass(stringArray[n2]);
                    }
                    ++n2;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The constructor parameter classes could not be loaded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "The constructor parameter classes could not be loaded");
        }
        Constructor constructor = null;
        constructor = this.meta.findConstructor(clazz, classArray);
        if (constructor == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            var5_4 = constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException();
            if (object instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)object, "RuntimeException thrown in the MBean's constructor");
            }
            if (object instanceof Error) {
                throw new RuntimeErrorException((Error)object, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)object, "Exception thrown in the MBean's constructor");
        }
        return var5_4;
    }

    Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object2;
        Object object3;
        Class[] classArray;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name  cannot be null"), "Exception occured trying to invoke the operation on the MBean");
        }
        Class clazz = this.meta.getMBeanInterface(object.getClass());
        if (clazz == null) {
            try {
                return ((DynamicMBean)object).invoke(string, objectArray, stringArray);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown by the invoke method of the Dynamic MBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown by the invoke in the invoke method of the Dynamic MBean");
            }
        }
        if (stringArray == null) {
            classArray = null;
        } else {
            object3 = object.getClass().getClassLoader();
            int n = stringArray.length;
            classArray = new Class[n];
            try {
                int n2 = 0;
                while (n2 < n) {
                    Class clazz2 = this.meta.findClassForPrim(stringArray[n2]);
                    if (clazz2 != null) {
                        classArray[n2] = clazz2;
                    } else if (object3 != null) {
                        classArray[n2] = ((ClassLoader)object3).loadClass(stringArray[n2]);
                        object2 = classArray[n2].getClassLoader();
                        if (objectArray[n2] != null && object2 != null && !object2.equals(objectArray[n2].getClass().getClassLoader())) {
                            objectArray[n2] = this.transferObject(objectArray[n2], (ClassLoader)object3);
                        }
                    } else {
                        classArray[n2] = this.findClass(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
            }
        }
        object3 = this.meta.findMethod(clazz, string, classArray);
        if (object3 == null) {
            if (this.isTraceOn()) {
                this.trace("invoke", String.valueOf(string) + " not found");
            }
            throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
        }
        if (this.isTraceOn()) {
            this.trace("invoke", "Invoking " + string);
        }
        object2 = null;
        try {
            object2 = ((Method)object3).invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occured trying to invoke operation " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeOperationsException(runtimeException, "RuntimeException occured trying to invoke operation " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in operation " + string);
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in operation " + string);
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in operation " + string);
        }
        if (this.isTraceOn()) {
            this.trace("invoke", "Send the result");
        }
        return object2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object = this.getMBean(objectName);
        return this.invoke(object, string, objectArray, stringArray);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        Class clazz = null;
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public boolean isRegistered(ObjectName objectName) {
        block7: {
            if (objectName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
            }
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(String.valueOf(this.domain) + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!this.isDebugOn()) break block7;
                    this.debug("contains", "Unexpected MalformedObjectNameException");
                }
            }
        }
        MBeanServerImpl mBeanServerImpl = this;
        synchronized (mBeanServerImpl) {
            boolean bl = this.repository.contains(objectName);
            Object var4_4 = null;
            return bl;
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private void postDeregisterInvoker(Object object) {
        try {
            ((MBeanRegistration)object).postDeregister();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postDeregister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in postDeregister method");
        }
        catch (Exception exception) {}
    }

    private void postRegisterInvoker(Object object, boolean bl) {
        try {
            ((MBeanRegistration)object).postRegister(new Boolean(bl));
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postRegister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in postRegister method");
        }
        catch (Exception exception) {}
    }

    private void preDeregisterInvoker(Object object) throws MBeanRegistrationException {
        try {
            ((MBeanRegistration)object).preDeregister();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in preDeregister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in preDeregister method");
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (Exception exception) {
            throw new MBeanRegistrationException(exception, "Exception thrown in preDeregister method");
        }
    }

    private ObjectName preRegisterInvoker(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        try {
            objectName3 = ((MBeanRegistration)object).preRegister(this, objectName);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in preRegister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in preRegister method");
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (Exception exception) {
            throw new MBeanRegistrationException(exception, "Exception thrown in preRegister method");
        }
        objectName2 = objectName != null ? objectName : objectName3;
        return objectName2;
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set set = new HashSet();
        MBeanServerImpl mBeanServerImpl = this;
        synchronized (mBeanServerImpl) {
            set = this.repository.query(objectName, queryExp);
        }
        if (this.queryByRepo) {
            return set;
        }
        return this.filterListOfObjects(set, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        Set set = this.queryMBeans(objectName, queryExp);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(objectInstance.getObjectName());
        }
        return hashSet;
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objectName2;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        this.meta.testCompliance(clazz);
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot add null object"), "Exception occured trying to register the MBean");
        }
        String string2 = "null";
        if (objectName != null) {
            string2 = objectName.toString();
        }
        if (this.isTraceOn()) {
            this.trace("MBeanServer", "registerMBean", "ObjectName = " + string2);
        }
        ObjectName objectName3 = null;
        if (object instanceof MBeanRegistration) {
            objectName3 = this.preRegisterInvoker(object, objectName);
        }
        if ((objectName2 = objectName == null ? objectName3 : objectName) == null) {
            if (object instanceof MBeanRegistration) {
                this.postRegisterInvoker(object, false);
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("No object name specified"), "Exception occured trying to register the MBean");
        }
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            DefaultLoaderRepository.addClassLoader((ClassLoader)object);
        }
        if (object instanceof DynamicMBean) {
            try {
                MBeanInfo mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
                if (mBeanInfo == null) {
                    throw new NotCompliantMBeanException("The MBeanInfo returned is null");
                }
                string = mBeanInfo.getClassName();
                if (string == null) {
                    throw new NotCompliantMBeanException("The class Name returned is null");
                }
            }
            catch (Exception exception) {
                throw new NotCompliantMBeanException("Exception " + exception.getClass().getName() + " :" + exception.getMessage() + " thrown by the getMBeanInfo method of Dynamic MBean");
            }
        }
        return new ObjectInstance(objectName2, string);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isTraceOn()) {
            this.trace("removeNotificationListener", "obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        NotificationBroadcaster notificationBroadcaster = null;
        if (!(object instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        notificationBroadcaster = (NotificationBroadcaster)object;
        MBeanServerNotificationListener mBeanServerNotificationListener = (MBeanServerNotificationListener)this.internalListener.get(notificationListener);
        if (mBeanServerNotificationListener == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        this.internalListener.remove(notificationListener);
        notificationBroadcaster.removeNotificationListener(mBeanServerNotificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object;
        try {
            object = this.getMBean(objectName2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ListenerNotFoundException(instanceNotFoundException.getMessage());
        }
        if (!(object instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        if (this.isTraceOn()) {
            this.trace("removeNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.removeNotificationListener(objectName, (NotificationListener)object);
    }

    private void sendNotification(String string, ObjectName objectName) {
        Object object = this;
        synchronized (object) {
            ++this.sequenceNumber;
        }
        if (this.isTraceOn()) {
            this.trace("sendNotification", "Incr sequenceNumber = " + this.sequenceNumber);
        }
        object = new MBeanServerNotification(string, (Object)this.MBeanServerDelegateObjectName, (long)this.sequenceNumber, objectName);
        this.MBeanServerDelegateObject.sendNotification((Notification)object);
    }

    Object setAttribute(Object object, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object object2;
        Class clazz = this.meta.getMBeanInterface(object.getClass());
        if (clazz == null) {
            try {
                ((DynamicMBean)object).setAttribute(attribute);
                return null;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown by the setAttribute " + attribute + "method of the Dynamic MBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown by the setAttribute " + attribute + "method of the Dynamic MBean");
            }
        }
        Object object3 = null;
        Object object4 = attribute.getValue();
        object4 = this.checkUpdateContext(object, object4);
        Method method = null;
        method = object4 == null ? this.meta.findSetter(clazz, attribute.getName()) : this.meta.findSetter(clazz, attribute.getName(), object4.getClass());
        if (method == null && (object2 = this.meta.findPrimForClass(object4)) != null) {
            method = this.meta.findSetter(clazz, attribute.getName(), (Class)object2);
        }
        if (method == null) {
            method = this.meta.findSetter(clazz, attribute.getName());
            if (method == null) {
                throw new AttributeNotFoundException(String.valueOf(attribute.getName()) + " not accessible");
            }
            object2 = attribute.getValue();
            if (object2 == null) {
                throw new InvalidAttributeValueException("attribute= " + attribute.getName() + " value = null");
            }
            throw new InvalidAttributeValueException("attribute= " + attribute.getName() + " value = " + attribute.getValue());
        }
        if (this.isTraceOn()) {
            this.trace("setAttribute", "Invoking the set method for " + attribute.getName());
        }
        object2 = new Object[]{object4};
        try {
            object3 = method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occured trying to invoke the setter on the MBean");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's setter");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's setter");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's setter");
        }
        if (this.isTraceOn()) {
            this.trace("setAttribute", String.valueOf(attribute.getName()) + "= " + object4);
        }
        return object4;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (this.isTraceOn()) {
            this.trace("setAttribute", "Object= " + objectName + ", attribute=" + attribute.getName());
        }
        Object object = this.getMBean(objectName);
        Object object2 = this.setAttribute(object, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        AttributeList attributeList2 = new AttributeList();
        if (this.isTraceOn()) {
            this.trace("setAttributes", "Object= " + objectName);
        }
        if (attributeList == null || attributeList.isEmpty()) {
            return attributeList2;
        }
        Object object = this.getMBean(objectName);
        Class clazz = this.meta.getMBeanInterface(object.getClass());
        if (clazz == null) {
            try {
                return ((DynamicMBean)object).setAttributes(attributeList);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown by the setAttributes method of the Dynamic MBean");
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error thrown trying by the setAttributes method of the Dynamic MBean");
            }
        }
        Iterator iterator = ((AbstractList)attributeList).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName();
            Object object2 = attribute.getValue();
            try {
                Object object3 = null;
                object3 = this.setAttribute(object, attribute);
                if (this.isTraceOn()) {
                    this.trace("setAttributes", "Updating the repository\n");
                }
                attributeList2.add(new Attribute(string, object3));
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("setAttributes", "Unexpected exception occured: " + exception.getClass().getName());
            }
        }
        return attributeList2;
    }

    private void trace(String string, String string2) {
        this.trace("MBeanServer", string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private Object transferObject(Object object, ClassLoader classLoader) {
        Closeable closeable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(object);
            closeable.flush();
        }
        catch (Exception exception) {
            return object;
        }
        try {
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)closeable, classLoader);
            return objectInputStreamWithLoader.readObject();
        }
        catch (Exception exception) {
            return object;
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to unregister the MBean");
        }
        if (objectName.equals(this.MBeanServerDelegateObjectName)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBeanDelegate MBean cannot be unregistered"));
        }
        MBeanServerImpl mBeanServerImpl = this;
        synchronized (mBeanServerImpl) {
            Object object = this.repository.retrieve(objectName);
            if (object == null) {
                if (this.isTraceOn()) {
                    this.trace("unregisterMBean", String.valueOf(String.valueOf(objectName)) + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.preDeregisterInvoker(object);
            }
            this.repository.remove(objectName);
            if (this.isTraceOn()) {
                this.trace("unregisterMBean", "Send delete notification of object " + objectName.getCanonicalName());
            }
            this.sendNotification("JMX.mbean.unregistered", objectName);
            if (object instanceof MBeanRegistration) {
                this.postDeregisterInvoker(object);
            }
            if (object instanceof ClassLoader) {
                DefaultLoaderRepository.removeClassLoader((ClassLoader)object);
            }
        }
    }
}

