/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServletWriter;

abstract class TagGeneratorBase
extends GeneratorBase {
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;

    TagGeneratorBase() {
    }

    protected void setTagHandlerStack(Stack stack) {
        this.tagHandlerStack = stack;
    }

    protected void setTagVarNumbers(Hashtable hashtable) {
        this.tagVarNumbers = hashtable;
    }

    protected void tagBegin(TagVariableData tagVariableData) {
        this.tagHandlerStack.push(tagVariableData);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    protected TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    private String substitute(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(c, n)) < 0) {
                n3 = n2;
            }
            stringBuffer.append(string.substring(n, n3));
            if (n3 == n2) break;
            stringBuffer.append(string2);
            n = n3 + 1;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTagVarName(String string, String string2) {
        if (string.indexOf(45) >= 0) {
            string = this.substitute(string, '-', "$1");
        }
        if (string.indexOf(46) >= 0) {
            string = this.substitute(string, '.', "$2");
        }
        if (string2.indexOf(45) >= 0) {
            string2 = this.substitute(string2, '-', "$1");
        }
        if (string2.indexOf(46) >= 0) {
            string2 = this.substitute(string2, '.', "$2");
        }
        if (string2.indexOf(58) >= 0) {
            string2 = this.substitute(string2, ':', "$3");
        }
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String string3 = string + ":" + string2;
            String string4 = string + "_" + string2 + "_";
            if (this.tagVarNumbers.get(string3) != null) {
                Integer n = (Integer)this.tagVarNumbers.get(string3);
                string4 = string4 + n;
                this.tagVarNumbers.put(string3, new Integer(n + 1));
                return string4;
            }
            this.tagVarNumbers.put(string3, new Integer(1));
            return string4 + "0";
        }
    }

    protected void declareVariables(ServletWriter servletWriter, VariableInfo[] variableInfoArray, TagVariableInfo[] tagVariableInfoArray, TagData tagData, boolean bl, boolean bl2, int n) {
        block5: {
            block4: {
                if (variableInfoArray == null) break block4;
                for (int i = 0; i < variableInfoArray.length; ++i) {
                    if (variableInfoArray[i].getScope() != n) continue;
                    if (variableInfoArray[i].getDeclare() && bl) {
                        servletWriter.println(variableInfoArray[i].getClassName() + " " + variableInfoArray[i].getVarName() + " = null;");
                    }
                    if (!bl2) continue;
                    servletWriter.println(variableInfoArray[i].getVarName() + " = (" + variableInfoArray[i].getClassName() + ") pageContext.findAttribute(" + servletWriter.quoteString(variableInfoArray[i].getVarName()) + ");");
                }
                break block5;
            }
            if (tagVariableInfoArray == null) break block5;
            for (int i = 0; i < tagVariableInfoArray.length; ++i) {
                String string = tagVariableInfoArray[i].getNameGiven() != null ? tagVariableInfoArray[i].getNameGiven() : tagData.getAttributeString(tagVariableInfoArray[i].getNameFromAttribute());
                if (tagVariableInfoArray[i].getScope() != n) continue;
                if (tagVariableInfoArray[i].getDeclare() && bl) {
                    servletWriter.println(tagVariableInfoArray[i].getClassName() + " " + string + " = null;");
                }
                if (!bl2) continue;
                servletWriter.println(string + " = (" + tagVariableInfoArray[i].getClassName() + ") pageContext.findAttribute(" + servletWriter.quoteString(string) + ");");
            }
        }
    }

    class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;

        TagVariableData(String string, String string2) {
            this.tagHandlerInstanceName = string;
            this.tagEvalVarName = string2;
        }
    }
}

