/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.catalina.util.xml.AddChild;
import org.apache.catalina.util.xml.MethodParam;
import org.apache.catalina.util.xml.MethodSetter;
import org.apache.catalina.util.xml.ObjectCreate;
import org.apache.catalina.util.xml.PathMatch;
import org.apache.catalina.util.xml.PopStack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.SetParent;
import org.apache.catalina.util.xml.SetProperties;
import org.apache.catalina.util.xml.XmlAction;
import org.apache.catalina.util.xml.XmlMatch;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlMapper
extends HandlerBase
implements SaxContext {
    Locator locator;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resDTDs = new Hashtable();
    Stack oStack = new Stack();
    Object root;
    Object[] attributeStack;
    String[] tagStack;
    int oSp;
    int sp;
    String body;
    int debug = 0;
    boolean validating = false;
    String publicId = null;
    Rule[] rules = new Rule[512];
    Rule[] matching = new Rule[512];
    int ruleCount = 0;

    public XmlMapper() {
        this.attributeStack = new Object[256];
        this.tagStack = new String[256];
        this.initDefaultRules();
    }

    public void setDocumentLocator(Locator locator) {
        if (this.debug > 0) {
            this.log("Set locator : " + locator);
        }
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.sp = 0;
    }

    public void endDocument() throws SAXException {
        if (this.sp != 0) {
            System.out.println("The XML document is probably broken. " + this.sp);
        }
        this.publicId = null;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.validating) {
            this.fatalError(sAXParseException);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            this.attributeStack[this.sp] = attributeList;
            this.tagStack[this.sp] = string;
            ++this.sp;
            this.matchStart(this);
            this.body = "";
        }
        catch (Exception exception) {
            throw new SAXException(this.positionToString(), exception);
        }
    }

    private String positionToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.locator != null) {
            stringBuffer.append("Line ").append(this.locator.getLineNumber()).append(" ");
        }
        stringBuffer.append("/");
        for (int i = 0; i < this.sp; ++i) {
            stringBuffer.append(this.tagStack[i]).append("/");
        }
        stringBuffer.append(" ");
        AttributeList attributeList = (AttributeList)this.attributeStack[this.sp - 1];
        if (attributeList != null) {
            for (int i = 0; i < attributeList.getLength(); ++i) {
                stringBuffer.append(attributeList.getName(i)).append("=").append(attributeList.getValue(i));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public void endElement(String string) throws SAXException {
        try {
            this.matchEnd(this);
            if (this.sp > 1) {
                this.tagStack[this.sp] = null;
                this.attributeStack[this.sp] = null;
            }
            --this.sp;
        }
        catch (Exception exception) {
            throw new SAXException(this.positionToString(), exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.body = this.body + new String(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public AttributeList getAttributeList(int n) {
        return (AttributeList)this.attributeStack[n];
    }

    public int getTagCount() {
        return this.sp;
    }

    public String getTag(int n) {
        return this.tagStack[n];
    }

    public String getBody() {
        return this.body;
    }

    public Stack getObjectStack() {
        return this.oStack;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    public void setDebug(int n) {
        if (n != 0) {
            this.log("Debug level: " + n);
        }
        this.debug = n;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setValidating(boolean bl) {
        if (this.debug >= 1) {
            this.log("Validating = " + bl);
        }
        this.validating = bl;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void log(String string) {
        System.out.println("XmlMapper: " + string);
    }

    public Object readXml(File file, Object object) throws Exception {
        Object object2;
        if (object != null) {
            object2 = this.getObjectStack();
            this.root = object;
            ((Stack)object2).push(object);
        }
        try {
            object2 = null;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.setValidating(this.validating);
            object2 = sAXParserFactory.newSAXParser();
            ((SAXParser)object2).parse(file, (HandlerBase)this);
            return object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = "Can't open config file: " + file.getAbsolutePath() + " due to: " + iOException;
            throw new Exception(string);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("PARSE error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + " of " + file.getAbsolutePath());
            System.out.println(sAXParseException.toString());
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            System.out.println("ERROR reading " + file);
            System.out.println("At " + sAXException.getMessage());
            System.out.println();
            Exception exception = sAXException.getException();
            if (exception != null) {
                throw exception;
            }
            throw sAXException;
        }
    }

    public Object readXml(InputStream inputStream, Object object) throws Exception {
        Object object2;
        if (object != null) {
            object2 = this.getObjectStack();
            this.root = object;
            ((Stack)object2).push(object);
        }
        object2 = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.setValidating(this.validating);
            object2 = sAXParserFactory.newSAXParser();
            ((SAXParser)object2).parse(inputStream, (HandlerBase)this);
            return object;
        }
        catch (IOException iOException) {
            String string = "Can't open config file: " + inputStream + " due to: " + iOException;
            throw new Exception(string);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("PARSE error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber());
            System.out.println(sAXParseException.toString());
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            System.out.println("ERROR reading " + inputStream);
            System.out.println("At " + sAXException.getMessage());
            System.out.println();
            Exception exception = sAXException.getException();
            throw exception;
        }
    }

    public void registerDTDFile(String string, String string2) {
        this.fileDTDs.put(string, string2);
    }

    public void registerDTDRes(String string, String string2) {
        this.resDTDs.put(string, string2);
    }

    private void initDefaultRules() {
        this.addRule("xmlmapper:debug", new XmlAction(){

            public void start(SaxContext saxContext) {
                int n = saxContext.getTagCount() - 1;
                AttributeList attributeList = saxContext.getAttributeList(n);
                String string = attributeList.getValue("level");
                XmlMapper xmlMapper = (XmlMapper)saxContext;
                if (string != null) {
                    xmlMapper.setDebug(new Integer(string));
                }
            }
        });
        this.addRule("xmlmapper:taskdef", new XmlAction(){

            public void start(SaxContext saxContext) {
                XmlMapper xmlMapper = (XmlMapper)saxContext;
                int n = saxContext.getTagCount() - 1;
                AttributeList attributeList = saxContext.getAttributeList(n);
                String string = attributeList.getValue("match");
                if (string == null) {
                    return;
                }
                String string2 = attributeList.getValue("object-create");
                String string3 = attributeList.getValue("object-create-attrib");
                if (string2 != null || string3 != null) {
                    xmlMapper.addRule(string, new ObjectCreate(string2, string3));
                }
                if ((string2 = attributeList.getValue("set-properties")) != null) {
                    xmlMapper.addRule(string, new SetProperties());
                }
                if ((string2 = attributeList.getValue("set-parent")) != null) {
                    xmlMapper.addRule(string, new SetParent(string2));
                }
                string2 = attributeList.getValue("add-child");
                string3 = attributeList.getValue("child-type");
                if (string2 != null) {
                    xmlMapper.addRule(string, new AddChild(string2, string3));
                }
                if ((string2 = attributeList.getValue("action")) != null) {
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Object obj = clazz.newInstance();
                        xmlMapper.addRule(string, (XmlAction)obj);
                    }
                    catch (Exception exception) {
                        System.out.println("Can't add action " + string2);
                    }
                }
            }
        });
    }

    public void addRule(String string, XmlAction xmlAction) {
        this.rules[this.ruleCount] = new Rule(new PathMatch(string), xmlAction);
        ++this.ruleCount;
    }

    private int match(SaxContext saxContext, Rule[] ruleArray) {
        int n = 0;
        for (int i = 0; i < this.ruleCount; ++i) {
            if (!this.rules[i].match.match(saxContext) || this.rules[i].action == null) continue;
            ruleArray[n] = this.rules[i];
            ++n;
        }
        return n;
    }

    void matchStart(SaxContext saxContext) throws Exception {
        int n = this.match(saxContext, this.matching);
        for (int i = 0; i < n; ++i) {
            this.matching[i].action.start(saxContext);
        }
    }

    void matchEnd(SaxContext saxContext) throws Exception {
        int n;
        int n2 = this.match(saxContext, this.matching);
        for (n = 0; n < n2; ++n) {
            this.matching[n].action.end(saxContext);
        }
        for (n = 0; n < n2; ++n) {
            this.matching[n].action.cleanup(saxContext);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        Object object;
        if (this.debug >= 1) {
            System.out.println("Resolve: " + string + " " + string2);
        }
        this.publicId = string;
        String string3 = (String)this.fileDTDs.get(string);
        if (string3 != null && ((File)(object = new File(string3))).exists()) {
            try {
                if (this.debug >= 1) {
                    System.out.println("  Using alternate DTD " + string3);
                }
                return new InputSource(new FileInputStream((File)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((string3 = (String)this.resDTDs.get(string)) != null) {
            object = this.getClass().getResourceAsStream(string3);
            if (object != null) {
                if (this.debug >= 1) {
                    System.out.println("  Using alternate DTD " + string3);
                }
                return new InputSource((InputStream)object);
            }
            System.out.println("XXX resource not found !!! " + string3);
            System.out.println(this.getClass().getClassLoader().getClass().getName());
        }
        this.log("Can't find resource for entity: " + string + " --> " + string2 + " \"" + string3 + "\"");
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
        if (this.debug >= 1) {
            System.out.println("Notation: " + string + " " + string2 + " " + string3);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.debug >= 1) {
            System.out.println("Unparsed: " + string + " " + string2 + " " + string3 + " " + string4);
        }
    }

    public XmlAction objectCreate(String string) {
        return new ObjectCreate(string);
    }

    public XmlAction objectCreate(String string, String string2) {
        return new ObjectCreate(string, string2);
    }

    public XmlAction setProperties() {
        return new SetProperties();
    }

    public XmlAction setParent(String string) {
        return new SetParent(string);
    }

    public XmlAction setParent(String string, String string2) {
        return new SetParent(string, string2);
    }

    public XmlAction addChild(String string, String string2) {
        return new AddChild(string, string2);
    }

    public XmlAction methodSetter(String string, int n) {
        return new MethodSetter(string, n);
    }

    public XmlAction methodSetter(String string, int n, String[] stringArray) {
        return new MethodSetter(string, n, stringArray);
    }

    public XmlAction methodParam(int n) {
        return new MethodParam(n, null);
    }

    public XmlAction methodParam(int n, String string) {
        return new MethodParam(n, string);
    }

    public XmlAction popStack() {
        return new PopStack();
    }

    class Rule {
        XmlMatch match;
        XmlAction action;

        Rule(XmlMatch xmlMatch, XmlAction xmlAction) {
            this.match = xmlMatch;
            this.action = xmlAction;
        }
    }
}

