/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;

public class StandardSession
implements HttpSession,
Session,
Serializable {
    private static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private HashMap attributes = new HashMap();
    private transient String authType = null;
    private long creationTime = 0L;
    private transient int debug = 0;
    private transient boolean expiring = false;
    private transient StandardSessionFacade facade = null;
    private String id = null;
    private static final String info = "StandardSession/1.0";
    private long lastAccessedTime = this.creationTime;
    private transient ArrayList listeners = new ArrayList();
    private Manager manager = null;
    private int maxInactiveInterval = -1;
    private boolean isNew = false;
    private boolean isValid = false;
    private transient HashMap notes = new HashMap();
    private transient Principal principal = null;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    private static HttpSessionContext sessionContext = null;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long thisAccessedTime = this.creationTime;

    public StandardSession(Manager manager) {
        this.manager = manager;
        if (manager instanceof ManagerBase) {
            this.debug = ((ManagerBase)manager).getDebug();
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String string) {
        String string2 = this.authType;
        this.authType = string;
        this.support.firePropertyChange("authType", string2, this.authType);
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
        this.lastAccessedTime = l;
        this.thisAccessedTime = l;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = string;
        if (this.manager != null) {
            this.manager.add(this);
        }
        this.fireSessionEvent("createSession", null);
        StandardContext standardContext = (StandardContext)this.manager.getContainer();
        Object[] objectArray = standardContext.getApplicationListeners();
        if (objectArray != null) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener httpSessionListener = (HttpSessionListener)objectArray[i];
                try {
                    standardContext.fireContainerEvent("beforeSessionCreated", httpSessionListener);
                    httpSessionListener.sessionCreated(httpSessionEvent);
                    standardContext.fireContainerEvent("afterSessionCreated", httpSessionListener);
                    continue;
                }
                catch (Throwable throwable) {
                    standardContext.fireContainerEvent("afterSessionCreated", httpSessionListener);
                    this.log(sm.getString("standardSession.sessionEvent"), throwable);
                }
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
        if (this.isValid && n == 0) {
            this.expire();
        }
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal principal2 = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", principal2, this.principal);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            this.facade = new StandardSessionFacade(this);
        }
        return this.facade;
    }

    public boolean isValid() {
        long l;
        int n;
        if (!this.isValid || this.expiring) {
            return false;
        }
        if (this.maxInactiveInterval >= 0 && (n = (int)(((l = System.currentTimeMillis()) - this.lastAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    public void access() {
        this.isNew = false;
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        this.evaluateIfValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener sessionListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        if (this.expiring) {
            return;
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            if (this.id == null) {
                return;
            }
            this.expiring = true;
            this.setValid(false);
            if (this.manager != null) {
                this.manager.remove(this);
            }
            String[] stringArray = this.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                this.removeAttribute(stringArray[i]);
            }
            this.fireSessionEvent("destroySession", null);
            StandardContext standardContext = (StandardContext)this.manager.getContainer();
            Object[] objectArray = standardContext.getApplicationListeners();
            if (objectArray != null) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent(this.getSession());
                for (int i = 0; i < objectArray.length; ++i) {
                    int n = objectArray.length - 1 - i;
                    if (!(objectArray[n] instanceof HttpSessionListener)) continue;
                    HttpSessionListener httpSessionListener = (HttpSessionListener)objectArray[n];
                    try {
                        standardContext.fireContainerEvent("beforeSessionDestroyed", httpSessionListener);
                        httpSessionListener.sessionDestroyed(httpSessionEvent);
                        standardContext.fireContainerEvent("afterSessionDestroyed", httpSessionListener);
                        continue;
                    }
                    catch (Throwable throwable) {
                        standardContext.fireContainerEvent("afterSessionDestroyed", httpSessionListener);
                        this.log(sm.getString("standardSession.sessionEvent"), throwable);
                    }
                }
            }
            if (this.manager != null && this.manager instanceof ManagerBase) {
                this.recycle();
            }
            this.expiring = false;
        }
    }

    public void passivate() {
        HttpSessionEvent httpSessionEvent = null;
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getAttribute(stringArray[i]);
            if (!(object instanceof HttpSessionActivationListener)) continue;
            if (httpSessionEvent == null) {
                httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            }
            ((HttpSessionActivationListener)object).sessionWillPassivate(httpSessionEvent);
        }
    }

    public void activate() {
        HttpSessionEvent httpSessionEvent = null;
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getAttribute(stringArray[i]);
            if (!(object instanceof HttpSessionActivationListener)) continue;
            if (httpSessionEvent == null) {
                httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            }
            ((HttpSessionActivationListener)object).sessionDidActivate(httpSessionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.keySet().iterator();
        }
    }

    public void recycle() {
        this.attributes = null;
        this.creationTime = 0L;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.manager = null;
        this.maxInactiveInterval = -1;
        this.notes = null;
        this.isNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener sessionListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String string, Object object) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(string, object);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardSession[");
        stringBuffer.append(this.id);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void readObjectData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.readObject(objectInputStream);
    }

    void writeObjectData(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObject(objectOutputStream);
    }

    public long getCreationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.attributes.keySet()));
        }
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public String[] getValueNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        StandardContext standardContext;
        Object[] objectArray;
        if (!this.expiring && !this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        Object var2_2 = null;
        boolean bl = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            bl = this.attributes.containsKey(string);
            if (!bl) {
                return;
            }
            var2_2 = this.attributes.get(string);
            this.attributes.remove(string);
        }
        hashMap = new HttpSessionBindingEvent((HttpSession)this, string, var2_2);
        if (var2_2 != null && var2_2 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)var2_2).valueUnbound((HttpSessionBindingEvent)hashMap);
        }
        if ((objectArray = (standardContext = (StandardContext)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)objectArray[i];
            try {
                standardContext.fireContainerEvent("beforeSessionAttributeRemoved", httpSessionAttributeListener);
                httpSessionAttributeListener.attributeRemoved((HttpSessionBindingEvent)hashMap);
                standardContext.fireContainerEvent("afterSessionAttributeRemoved", httpSessionAttributeListener);
                continue;
            }
            catch (Throwable throwable) {
                standardContext.fireContainerEvent("afterSessionAttributeRemoved", httpSessionAttributeListener);
                this.log(sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        StandardContext standardContext;
        Object[] objectArray;
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(object instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        Object var3_3 = null;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            var3_3 = this.attributes.get(string);
            this.attributes.put(string, object);
        }
        if (var3_3 != null && var3_3 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)var3_3).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
        hashMap = null;
        hashMap = var3_3 != null ? new HttpSessionBindingEvent((HttpSession)this, string, var3_3) : new HttpSessionBindingEvent((HttpSession)this, string, object);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound((HttpSessionBindingEvent)hashMap);
        }
        if ((objectArray = (standardContext = (StandardContext)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)objectArray[i];
            try {
                if (var3_3 != null) {
                    standardContext.fireContainerEvent("beforeSessionAttributeReplaced", httpSessionAttributeListener);
                    httpSessionAttributeListener.attributeReplaced((HttpSessionBindingEvent)hashMap);
                    standardContext.fireContainerEvent("afterSessionAttributeReplaced", httpSessionAttributeListener);
                    continue;
                }
                standardContext.fireContainerEvent("beforeSessionAttributeAdded", httpSessionAttributeListener);
                httpSessionAttributeListener.attributeAdded((HttpSessionBindingEvent)hashMap);
                standardContext.fireContainerEvent("afterSessionAttributeAdded", httpSessionAttributeListener);
                continue;
            }
            catch (Throwable throwable) {
                if (var3_3 != null) {
                    standardContext.fireContainerEvent("afterSessionAttributeReplaced", httpSessionAttributeListener);
                } else {
                    standardContext.fireContainerEvent("afterSessionAttributeAdded", httpSessionAttributeListener);
                }
                this.log(sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)objectInputStream.readObject();
        this.lastAccessedTime = (Long)objectInputStream.readObject();
        this.maxInactiveInterval = (Integer)objectInputStream.readObject();
        this.isNew = (Boolean)objectInputStream.readObject();
        this.isValid = (Boolean)objectInputStream.readObject();
        this.thisAccessedTime = (Long)objectInputStream.readObject();
        this.principal = null;
        this.setId((String)objectInputStream.readObject());
        if (this.debug >= 2) {
            this.log("readObject() loading session " + this.id);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        int n = (Integer)objectInputStream.readObject();
        boolean bl = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            if (object instanceof String && object.equals(NOT_SERIALIZED)) continue;
            if (this.debug >= 2) {
                this.log("  loading attribute '" + string + "' with value '" + object + "'");
            }
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                this.attributes.put(string, object);
                continue;
            }
        }
        this.isValid = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeObject(new Long(this.creationTime));
        objectOutputStream.writeObject(new Long(this.lastAccessedTime));
        objectOutputStream.writeObject(new Integer(this.maxInactiveInterval));
        objectOutputStream.writeObject(new Boolean(this.isNew));
        objectOutputStream.writeObject(new Boolean(this.isValid));
        objectOutputStream.writeObject(new Long(this.thisAccessedTime));
        objectOutputStream.writeObject(this.id);
        if (this.debug >= 2) {
            this.log("writeObject() storing session " + this.id);
        }
        String[] stringArray = this.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < stringArray.length; ++n) {
            Object e = null;
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                e = this.attributes.get(stringArray[n]);
            }
            if (e == null || !(e instanceof Serializable)) continue;
            arrayList.add(stringArray[n]);
            arrayList2.add(e);
        }
        n = arrayList.size();
        objectOutputStream.writeObject(new Integer(n));
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject((String)arrayList.get(i));
            try {
                objectOutputStream.writeObject(arrayList2.get(i));
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + arrayList.get(i) + "' with value '" + arrayList2.get(i) + "'");
                continue;
            }
            catch (NotSerializableException notSerializableException) {
                this.log(sm.getString("standardSession.notSerializable", arrayList.get(i), this.id), notSerializableException);
                objectOutputStream.writeObject(NOT_SERIALIZED);
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + arrayList.get(i) + "' with value NOT_SERIALIZED");
            }
        }
    }

    private void evaluateIfValid() {
        if (!this.isValid || this.expiring || this.maxInactiveInterval < 0) {
            return;
        }
        if (!this.isValid()) {
            try {
                this.expire();
            }
            catch (Throwable throwable) {
                this.log(sm.getString("standardSession.expireException"), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String string, Object object) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(this, string, object);
        SessionListener[] sessionListenerArray = new SessionListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            sessionListenerArray = this.listeners.toArray(sessionListenerArray);
        }
        for (int i = 0; i < sessionListenerArray.length; ++i) {
            sessionListenerArray[i].sessionEvent(sessionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys() {
        String[] stringArray = new String[]{};
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.keySet().toArray(stringArray);
        }
    }

    private void log(String string) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(string);
        } else {
            System.out.println("StandardSession: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(string, throwable);
        } else {
            System.out.println("StandardSession: " + string);
            throwable.printStackTrace(System.out);
        }
    }
}

