/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.apache.catalina.Request;
import org.apache.catalina.util.StringManager;

public class RequestStream
extends ServletInputStream {
    protected boolean closed = false;
    protected int count = 0;
    protected int length = -1;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected InputStream stream = null;

    public RequestStream(Request request) {
        this.length = request.getRequest().getContentLength();
        this.stream = request.getStream();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.close.closed"));
        }
        if (this.length > 0) {
            int n;
            while (this.count < this.length && (n = this.read()) >= 0) {
            }
        }
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.read.closed"));
        }
        if (this.length >= 0 && this.count >= this.length) {
            return -1;
        }
        int n = this.stream.read();
        if (n >= 0) {
            ++this.count;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        if (this.length > 0) {
            if (this.count >= this.length) {
                return -1;
            }
            if (this.count + n2 > this.length) {
                n3 = this.length - this.count;
            }
        }
        int n4 = super.read(byArray, n, n3);
        return n4;
    }
}

