/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.LoginConfig;

public class FormAuthenticator
extends AuthenticatorBase {
    private static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest httpRequest, HttpResponse httpResponse, LoginConfig loginConfig) throws IOException {
        boolean bl;
        String string;
        String string2;
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        Session session = null;
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal != null) {
            String string3;
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            if ((string3 = (String)httpRequest.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(string3, this.getSession(httpRequest, true));
            }
            return true;
        }
        if (!this.cache) {
            session = this.getSession(httpRequest, true);
            if (this.debug >= 1) {
                this.log("Checking for reauthenticate in session " + session);
            }
            string2 = (String)session.getNote("org.apache.catalina.session.USERNAME");
            string = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (string2 != null && string != null) {
                if (this.debug >= 1) {
                    this.log("Reauthenticating username '" + string2 + "'");
                }
                if ((principal = this.context.getRealm().authenticate(string2, string)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    this.register(httpRequest, httpResponse, principal, "FORM", string2, string);
                    return true;
                }
                if (this.debug >= 1) {
                    this.log("Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(httpRequest)) {
            session = this.getSession(httpRequest, true);
            if (this.debug >= 1) {
                this.log("Restore request from session '" + session.getId() + "'");
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(httpRequest, httpResponse, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            string2 = (String)httpRequest.getNote("org.apache.catalina.request.SSOID");
            if (string2 != null) {
                this.associate(string2, session);
            }
            if (this.restoreRequest(httpRequest, session)) {
                if (this.debug >= 1) {
                    this.log("Proceed to restored request");
                }
                return true;
            }
            if (this.debug >= 1) {
                this.log("Restore of original request failed");
            }
            httpServletResponse.sendError(400);
            return false;
        }
        string2 = httpServletRequest.getContextPath();
        string = httpServletRequest.getRequestURI();
        httpResponse.setContext(httpRequest.getContext());
        String string4 = string2 + loginConfig.getLoginPage();
        if (string.equals(string4)) {
            if (this.debug >= 1) {
                this.log("Requesting login page normally");
            }
            return true;
        }
        String string5 = string2 + loginConfig.getErrorPage();
        if (string.equals(string5)) {
            if (this.debug >= 1) {
                this.log("Requesting error page normally");
            }
            return true;
        }
        boolean bl2 = bl = string.startsWith(string2) && string.endsWith("/j_security_check");
        if (!bl) {
            session = this.getSession(httpRequest, true);
            if (this.debug >= 1) {
                this.log("Save request in session '" + session.getId() + "'");
            }
            this.saveRequest(httpRequest, session);
            if (this.debug >= 1) {
                this.log("Redirect to login page '" + string4 + "'");
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string4));
            return false;
        }
        Realm realm = this.context.getRealm();
        String string6 = httpServletRequest.getParameter("j_username");
        String string7 = httpServletRequest.getParameter("j_password");
        if (this.debug >= 1) {
            this.log("Authenticating username '" + string6 + "'");
        }
        if ((principal = realm.authenticate(string6, string7)) == null) {
            if (this.debug >= 1) {
                this.log("Redirect to error page '" + string5 + "'");
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string5));
            return false;
        }
        if (this.debug >= 1) {
            this.log("Authentication of '" + string6 + "' was successful");
        }
        if (session == null) {
            session = this.getSession(httpRequest, true);
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        if (!this.cache) {
            session.setNote("org.apache.catalina.session.USERNAME", string6);
            session.setNote("org.apache.catalina.session.PASSWORD", string7);
        }
        if ((string = this.savedRequestURL(session)) == null) {
            string = string2;
            if (this.debug >= 1) {
                this.log("No saved request found. Redirect to context path instead");
            }
        }
        if (this.debug >= 1) {
            this.log("Redirecting to original '" + string + "'");
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string));
        return false;
    }

    private boolean matchRequest(HttpRequest httpRequest) {
        Session session = this.getSession(httpRequest, false);
        if (session == null) {
            return false;
        }
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (savedRequest == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        String string = httpServletRequest.getRequestURI();
        if (string == null) {
            return false;
        }
        return string.equals(savedRequest.getRequestURI());
    }

    private boolean restoreRequest(HttpRequest httpRequest, Session session) {
        Iterator iterator;
        Object object;
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (savedRequest == null) {
            return false;
        }
        httpRequest.clearCookies();
        Iterator iterator2 = savedRequest.getCookies();
        while (iterator2.hasNext()) {
            httpRequest.addCookie((Cookie)iterator2.next());
        }
        httpRequest.clearHeaders();
        Iterator iterator3 = savedRequest.getHeaderNames();
        while (iterator3.hasNext()) {
            object = (String)iterator3.next();
            iterator = savedRequest.getHeaderValues((String)object);
            while (iterator.hasNext()) {
                httpRequest.addHeader((String)object, (String)iterator.next());
            }
        }
        httpRequest.clearLocales();
        object = savedRequest.getLocales();
        while (object.hasNext()) {
            httpRequest.addLocale((Locale)object.next());
        }
        httpRequest.clearParameters();
        if ("POST".equalsIgnoreCase(savedRequest.getMethod())) {
            iterator = savedRequest.getParameterNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = savedRequest.getParameterValues(string);
                httpRequest.addParameter(string, stringArray);
            }
        }
        httpRequest.setMethod(savedRequest.getMethod());
        httpRequest.setQueryString(savedRequest.getQueryString());
        httpRequest.setRequestURI(savedRequest.getRequestURI());
        return true;
    }

    private void saveRequest(HttpRequest httpRequest, Session session) {
        Object object;
        Object object2;
        Object object3;
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        SavedRequest savedRequest = new SavedRequest();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                savedRequest.addCookie(cookieArray[i]);
            }
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = httpServletRequest.getHeaders((String)object3);
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                savedRequest.addHeader((String)object3, (String)object);
            }
        }
        object3 = httpServletRequest.getLocales();
        while (object3.hasMoreElements()) {
            object2 = (Locale)object3.nextElement();
            savedRequest.addLocale((Locale)object2);
        }
        object2 = httpServletRequest.getParameterMap();
        object = object2.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            String[] stringArray = (String[])object2.get(string);
            savedRequest.addParameter(string, stringArray);
        }
        savedRequest.setMethod(httpServletRequest.getMethod());
        savedRequest.setQueryString(httpServletRequest.getQueryString());
        savedRequest.setRequestURI(httpServletRequest.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", savedRequest);
    }

    private String savedRequestURL(Session session) {
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (savedRequest == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(savedRequest.getRequestURI());
        if (savedRequest.getQueryString() != null) {
            stringBuffer.append('?');
            stringBuffer.append(savedRequest.getQueryString());
        }
        return stringBuffer.toString();
    }
}

