/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.util;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Search;
import com.iplanet.ias.config.serverbeans.Searchcollection;
import com.sun.web.search.admin.SearchAdminException;
import com.sun.web.search.util.CollectionInfo;
import com.sun.web.search.util.SearchConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class CollectionConfig {
    private String _vsId = null;
    private boolean _autoCommit = true;
    private SearchConfig _config = null;
    private Search _search = null;
    private static final int ENABLED = 0;
    private static final int DISABLED = 1;
    private static final int ALL = 2;

    public CollectionConfig(SearchConfig searchConfig, String string) {
        this(searchConfig, string, true);
    }

    public CollectionConfig(SearchConfig searchConfig, String string, boolean bl) {
        this._config = searchConfig;
        this._search = searchConfig.getSearchBean();
        this._vsId = string;
        this._autoCommit = bl;
    }

    public void setAutoCommit(boolean bl) {
        this._autoCommit = bl;
    }

    public void createCollection(String string, String string2, String string3, String string4, String string5, String string6, Properties properties) throws ConfigException, SearchAdminException {
        if (this._search == null) {
            throw new SearchAdminException("Cannot create collection since <SEARCH ..> element is missing in server.xml");
        }
        Searchcollection searchcollection = null;
        searchcollection = this._search.getSearchcollectionByName(string);
        if (searchcollection != null) {
            throw new SearchAdminException("SearchCollection with name '" + string + "' already exists for the virtual server '" + this._vsId + "'");
        }
        searchcollection = new Searchcollection();
        searchcollection.setName(string);
        searchcollection.setDocroot(string4);
        searchcollection.setPath(string5);
        searchcollection.setUri(string6);
        searchcollection.setEnabled(true);
        if (string2 != null) {
            searchcollection.setDisplayname(string2);
        }
        if (string3 != null) {
            searchcollection.setDescription(string3);
        }
        if (properties != null) {
            this.setProperties(searchcollection, properties);
        }
        this._search.addSearchcollection(searchcollection);
        if (this._autoCommit) {
            this._config.save();
            this._search = this._config.getSearchBean();
        }
    }

    private void setProperties(Searchcollection searchcollection, Properties properties) {
        ElementProperty[] elementPropertyArray;
        Enumeration<Object> enumeration = properties.keys();
        ArrayList<ElementProperty> arrayList = new ArrayList<ElementProperty>();
        while (enumeration.hasMoreElements()) {
            elementPropertyArray = (ElementProperty[])enumeration.nextElement();
            String string = properties.getProperty((String)elementPropertyArray);
            ElementProperty elementProperty = new ElementProperty();
            elementProperty.setName((String)elementPropertyArray);
            elementProperty.setValue(string);
            arrayList.add(elementProperty);
        }
        elementPropertyArray = new ElementProperty[arrayList.size()];
        elementPropertyArray = arrayList.toArray(elementPropertyArray);
        searchcollection.setElementProperty(elementPropertyArray);
    }

    public void modifyCollection(String string, String string2, String string3, String string4, String string5, Properties properties) throws ConfigException, SearchAdminException {
        if (this._search == null) {
            throw new SearchAdminException("Cannot modify since <SEARCH ..> element is missing in server.xml");
        }
        Searchcollection searchcollection = this._search.getSearchcollectionByName(string);
        if (searchcollection == null) {
            throw new SearchAdminException("Cannot modify non-existant searchcollection.");
        }
        int n = this._search.indexOf("Searchcollection", searchcollection);
        if (string2 != null) {
            searchcollection.setDisplayname(string2);
        }
        if (string3 != null) {
            searchcollection.setDescription(string3);
        }
        if (string4 != null) {
            searchcollection.setUri(string4);
        }
        if (string5 != null) {
            boolean bl = Boolean.valueOf(string5);
            searchcollection.setEnabled(bl);
        }
        if (properties != null) {
            this.setProperties(searchcollection, properties);
        }
        this._search.setSearchcollection(n, (Searchcollection)searchcollection.clone());
        if (this._autoCommit) {
            this._config.save();
            this._search = this._config.getSearchBean();
        }
    }

    public void enableCollection(String string, boolean bl) throws ConfigException, SearchAdminException {
        if (this._search == null) {
            throw new SearchAdminException("Cannot enable collection since <SEARCH ..> element is missing in server.xml");
        }
        Searchcollection searchcollection = this._search.getSearchcollectionByName(string);
        if (searchcollection == null) {
            throw new SearchAdminException("Cannot enable non-existant searchcollection.");
        }
        int n = this._search.indexOf("Searchcollection", searchcollection);
        searchcollection.setEnabled(bl);
        this._search.setSearchcollection(n, (Searchcollection)searchcollection.clone());
        if (this._autoCommit) {
            this._config.save();
            this._search = this._config.getSearchBean();
        }
    }

    public void deleteCollection(String string) throws ConfigException, SearchAdminException {
        if (this._search == null) {
            throw new SearchAdminException("Cannot delete since <SEARCH ..> element is missing in server.xml");
        }
        Searchcollection searchcollection = this._search.getSearchcollectionByName(string);
        if (searchcollection == null) {
            throw new SearchAdminException("Cannot delete non-existant searchcollection.");
        }
        this._search.removeSearchcollection(searchcollection);
        if (this._autoCommit) {
            this._config.save();
            this._search = this._config.getSearchBean();
        }
    }

    public HashMap getEnabledCollections() {
        return this.getCollections(0);
    }

    public HashMap getDisabledCollections() {
        return this.getCollections(1);
    }

    public HashMap getAllCollections() {
        return this.getCollections(2);
    }

    public CollectionInfo getCollection(String string) {
        if (this._search == null) {
            return null;
        }
        Searchcollection searchcollection = this._search.getSearchcollectionByName(string);
        if (searchcollection == null) {
            return null;
        }
        return this.getDetails(searchcollection);
    }

    private HashMap getCollections(int n) {
        HashMap<String, CollectionInfo> hashMap = new HashMap<String, CollectionInfo>();
        if (this._search == null) {
            return hashMap;
        }
        Searchcollection[] searchcollectionArray = this._search.getSearchcollection();
        for (int i = 0; searchcollectionArray != null && i < searchcollectionArray.length; ++i) {
            boolean bl = true;
            switch (n) {
                case 0: {
                    if (searchcollectionArray[i].isEnabled()) break;
                    bl = false;
                    break;
                }
                case 1: {
                    if (!searchcollectionArray[i].isEnabled()) break;
                    bl = false;
                }
            }
            if (!bl) continue;
            CollectionInfo collectionInfo = this.getDetails(searchcollectionArray[i]);
            hashMap.put(collectionInfo.getName(), collectionInfo);
        }
        return hashMap;
    }

    private CollectionInfo getDetails(Searchcollection searchcollection) {
        Properties properties = new Properties();
        ElementProperty[] elementPropertyArray = searchcollection.getElementProperty();
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            properties.setProperty(elementPropertyArray[i].getName(), elementPropertyArray[i].getValue());
        }
        CollectionInfo collectionInfo = new CollectionInfo(searchcollection.getName(), searchcollection.getDisplayname(), searchcollection.getDescription(), searchcollection.getDocroot(), searchcollection.getPath(), searchcollection.getUri(), searchcollection.isEnabled(), properties);
        return collectionInfo;
    }
}

