/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.retrieval;

import com.sun.kt.search.MetaSearchEngine;
import com.sun.kt.search.SearchEngineException;
import com.sun.kt.search.Searcher;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.retrieval.KtResultSet;
import com.sun.web.search.retrieval.ResultSet;
import com.sun.web.search.retrieval.SearchEngine;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.util.CollectionInfo;
import com.sun.web.search.util.SearchConfig;
import com.sun.web.search.util.SearchProperties;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class KtSearchEngine
implements SearchEngine {
    private int maxHits;
    private Locale locale;
    private ArrayList filters;
    private SearchConfig config;
    private SearchProperties props;
    private Searcher engine;

    public KtSearchEngine(SearchConfig searchConfig) {
        this.config = searchConfig;
        this.maxHits = searchConfig.getMaxhits();
        this.setLocale(Locale.getDefault());
        this.filters = new ArrayList();
        this.props = new SearchProperties();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ResultSet search(final String string, final String string2, final String[] stringArray) throws SearchException {
        try {
            return (ResultSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SearchException {
                    return KtSearchEngine.this.searchHelper(string, string2, stringArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SearchException)privilegedActionException.getException();
        }
    }

    private ResultSet searchHelper(String string, String string2, String[] stringArray) throws SearchException {
        try {
            int n;
            int n2 = n = this.maxHits != -1 ? this.maxHits : 30;
            if (string.equals(" ") || string.equals("*")) {
                string = "dockey != null";
            }
            MetaSearchEngine metaSearchEngine = new MetaSearchEngine(new ArrayList());
            HashMap hashMap = this.config.getCollectionConfig().getAllCollections();
            com.sun.kt.search.SearchEngine searchEngine = null;
            int n3 = 0;
            com.sun.kt.search.SearchEngine searchEngine2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                CollectionInfo collectionInfo = (CollectionInfo)hashMap.get(stringArray[i]);
                if (collectionInfo == null) {
                    throw new SearchException("No such collection - " + stringArray[i] + ".");
                }
                IndexDirectory indexDirectory = new IndexDirectory(collectionInfo.getIndexDirectory(), false);
                String string3 = indexDirectory.getIndexDirectory().getAbsolutePath();
                String string4 = indexDirectory.getLockDirectory().getAbsolutePath();
                this.props.put("indexDir", string3);
                this.props.put("lockDir", string4);
                searchEngine2 = new com.sun.kt.search.SearchEngine((Properties)this.props);
                if (searchEngine2.getNDocs() == 0) continue;
                ++n3;
                searchEngine = searchEngine2;
                metaSearchEngine.add(searchEngine2);
            }
            this.engine = n3 > 1 ? metaSearchEngine : (n3 == 1 ? searchEngine : searchEngine2);
            if (string2.charAt(0) != '+' && string2.charAt(0) != '-') {
                string2 = "-" + string2;
            }
            com.sun.kt.search.ResultSet resultSet = this.engine.search(string, string2, (List)this.filters);
            return new KtResultSet(resultSet, this.maxHits);
        }
        catch (Exception exception) {
            if (exception instanceof SearchException) {
                throw (SearchException)exception;
            }
            throw new SearchException(exception);
        }
    }

    public void close() throws SearchEngineException {
        if (this.engine != null) {
            if (this.engine instanceof MetaSearchEngine) {
                MetaSearchEngine metaSearchEngine = (MetaSearchEngine)this.engine;
                metaSearchEngine.close();
            } else if (this.engine instanceof com.sun.kt.search.SearchEngine) {
                com.sun.kt.search.SearchEngine searchEngine = (com.sun.kt.search.SearchEngine)this.engine;
                searchEngine.close();
            }
        }
    }

    public void setMaxHits(int n) {
        this.maxHits = n;
    }
}

