/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.iplanet.ias.security.Audit;
import com.iplanet.ias.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Auditor;

public class LoginContextDriver {
    private static Logger _logger;
    private static LocalStringManagerImpl localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void login(String string, String string2, String string3) throws LoginException {
        Auditor[] auditorArray;
        final Subject subject = new Subject();
        final PasswordCredential passwordCredential = new PasswordCredential(string, string2, string3);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPrivateCredentials().add(passwordCredential);
                return subject;
            }
        });
        String string4 = Realm.getInstance(string3).getJAASContext();
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string3 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string4 == null) {
            throw new AssertionError();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Logging in user [" + string + "] into realm: " + string3 + " using JAAS module: " + string4);
        }
        try {
            auditorArray = new LoginContext(string4, subject);
            auditorArray.login();
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.INFO)) {
                Auditor[] auditorArray2;
                _logger.log(Level.INFO, "java_security.audit_auth_refused", string);
                if (Audit.isActive() && (auditorArray2 = Audit.getInstances()) != null) {
                    for (int i = 0; i < auditorArray2.length; ++i) {
                        auditorArray2[i].authentication(string, string3, false);
                    }
                }
            }
            throw new LoginException("Login failed: " + exception.toString());
        }
        if (Audit.isActive() && _logger.isLoggable(Level.INFO) && (auditorArray = Audit.getInstances()) != null) {
            for (int i = 0; i < auditorArray.length; ++i) {
                auditorArray[i].authentication(string, string3, true);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Password login succeeded for : " + string);
        }
    }

    public static void login(X509Certificate[] x509CertificateArray, String string) throws LoginException {
        Auditor[] auditorArray;
        _logger.fine("Processing X.500 name login.");
        Realm realm = Realm.getInstance(string);
        if (!$assertionsDisabled && !(realm instanceof CertificateRealm)) {
            throw new AssertionError();
        }
        CertificateRealm certificateRealm = (CertificateRealm)realm;
        certificateRealm.authenticate(x509CertificateArray);
        X509Certificate x509Certificate = x509CertificateArray[0];
        String string2 = x509Certificate.getSubjectDN().getName();
        if (Audit.isActive() && _logger.isLoggable(Level.INFO) && (auditorArray = Audit.getInstances()) != null) {
            for (int i = 0; i < auditorArray.length; ++i) {
                auditorArray[i].authentication(string2, certificateRealm.getName(), true);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("X.500 name login succeeded for : " + string2);
        }
    }

    static {
        $assertionsDisabled = !LoginContextDriver.class.desiredAssertionStatus();
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(LoginContextDriver.class);
    }
}

