/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.util;

import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.util.SemanticValidator;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionPoolValidator
extends SemanticValidator {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _isFineLevel = _logger.isLoggable(Level.FINE);

    public static boolean validate(JdbcConnectionPool jdbcConnectionPool) {
        String string = jdbcConnectionPool.getName();
        if (!ConnectionPoolValidator.validateStringNotEmpty(string)) {
            _logger.log(Level.SEVERE, "util.validator.empty_pool_name");
            return false;
        }
        if (!ConnectionPoolValidator.validateStringNotEmpty(jdbcConnectionPool.getDatasourceClassname())) {
            _logger.log(Level.SEVERE, "util.validator.empty_ds_classname", string);
            return false;
        }
        if (!ConnectionPoolValidator.validatePositiveInteger(jdbcConnectionPool.getMaxPoolSize())) {
            Object[] objectArray = new Object[]{string, jdbcConnectionPool.getMaxPoolSize()};
            _logger.log(Level.SEVERE, "util.validator.invalid_max_pool_size", objectArray);
            return false;
        }
        if (!ConnectionPoolValidator.validatePositiveInteger(jdbcConnectionPool.getPoolResizeQuantity())) {
            Object[] objectArray = new Object[]{string, jdbcConnectionPool.getPoolResizeQuantity()};
            _logger.log(Level.SEVERE, "util.validator.invalid_pool_resize", objectArray);
            return false;
        }
        if (!ConnectionPoolValidator.validatePositiveInteger(jdbcConnectionPool.getSteadyPoolSize())) {
            Object[] objectArray = new Object[]{string, jdbcConnectionPool.getSteadyPoolSize()};
            _logger.log(Level.SEVERE, "util.validator.invalid_steady_pool_size", objectArray);
            return false;
        }
        if (!ConnectionPoolValidator.validateIntegerAtMost(jdbcConnectionPool.getSteadyPoolSize(), Integer.parseInt(jdbcConnectionPool.getMaxPoolSize()))) {
            _logger.log(Level.SEVERE, "util.validator.steady_size_greater_max_size", string);
            return false;
        }
        if (!ConnectionPoolValidator.validatePositiveInteger(jdbcConnectionPool.getMaxWaitTimeInMillis())) {
            Object[] objectArray = new Object[]{string, jdbcConnectionPool.getMaxWaitTimeInMillis()};
            _logger.log(Level.SEVERE, "util.validator.invalid_max_wait", objectArray);
            return false;
        }
        if (!ConnectionPoolValidator.validatePositiveInteger(jdbcConnectionPool.getIdleTimeoutInSeconds())) {
            Object[] objectArray = new Object[]{string, jdbcConnectionPool.getIdleTimeoutInSeconds()};
            _logger.log(Level.SEVERE, "util.validator.invalid_timeout", objectArray);
            return false;
        }
        return true;
    }
}

