/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class J2EEResourceBase
implements J2EEResource,
Serializable {
    String name_;
    Map properties_;
    boolean enabled_;
    String description_;

    public J2EEResourceBase(String string) {
        this.name_ = string;
        this.properties_ = new HashMap();
    }

    public String getName() {
        return this.name_;
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setDescription(String string) {
        this.description_ = string;
    }

    public String getDescription() {
        return this.description_;
    }

    public abstract int getType();

    public Set getProperties() {
        HashSet<ResourceProperty> hashSet = new HashSet<ResourceProperty>();
        Collection collection = this.properties_.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
            hashSet.add(resourceProperty);
        }
        return hashSet;
    }

    public void addProperty(ResourceProperty resourceProperty) {
        this.properties_.put(resourceProperty.getName(), resourceProperty);
    }

    public boolean removeProperty(ResourceProperty resourceProperty) {
        Object v = this.properties_.remove(resourceProperty.getName());
        return v != null;
    }

    public ResourceProperty getProperty(String string) {
        return (ResourceProperty)this.properties_.get(string);
    }

    public J2EEResource makeClone(String string) {
        J2EEResource j2EEResource = this.doClone(string);
        Set set = this.properties_.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ResourceProperty resourceProperty = (ResourceProperty)entry.getValue();
            ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl((String)entry.getKey());
            resourcePropertyImpl.setValue(entry.getValue());
            j2EEResource.addProperty(resourcePropertyImpl);
        }
        j2EEResource.setEnabled(this.isEnabled());
        j2EEResource.setDescription(this.getDescription());
        return j2EEResource;
    }

    protected String getPropsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.getProperties();
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("[ ");
                } else {
                    stringBuffer.append(" , ");
                }
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                stringBuffer.append(resourceProperty.getName() + "=" + resourceProperty.getValue());
            }
            stringBuffer.append(" ]");
        }
        return stringBuffer.toString();
    }

    protected abstract J2EEResource doClone(String var1);
}

