/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.MultiLruCache;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class BoundedMultiLruCache
extends MultiLruCache {
    protected long maxSize = Long.MAX_VALUE;
    protected long currentSize;
    private Object currentSizeLk = new Object();

    public void init(int n, Properties properties) throws Exception {
        super.init(n, properties);
        this.currentSize = 0L;
        if (properties != null) {
            String string = properties.getProperty("MaxSize");
            int n2 = 1;
            long l = -1L;
            String string2 = string;
            if (string2 != null) {
                int n3 = (string2 = string2.toUpperCase()).indexOf("KB");
                if (n3 != -1) {
                    n2 = 1024;
                    string2 = string2.substring(0, n3);
                } else {
                    n3 = string2.indexOf("MB");
                    if (n3 != -1) {
                        n2 = 0x100000;
                        string2 = string2.substring(0, n3);
                    }
                }
                try {
                    l = Long.parseLong(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (l > 0L) {
                this.maxSize = l * (long)n2;
            } else {
                String string3 = _rb.getString("cache.BoundedMultiLruCache.illegalMaxSize");
                Object[] objectArray = new Object[]{string};
                string3 = MessageFormat.format(string3, objectArray);
                throw new IllegalArgumentException(string3);
            }
        }
    }

    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem cacheItem) {
        MultiLruCache.LruCacheItem lruCacheItem = (MultiLruCache.LruCacheItem)super.itemAdded(cacheItem);
        if (lruCacheItem != null) {
            this.decrementCurrentSize(lruCacheItem.getSize());
        }
        this.incrementCurrentSize(cacheItem.getSize());
        return lruCacheItem;
    }

    protected void itemRefreshed(BaseCache.CacheItem cacheItem, int n) {
        super.itemRefreshed(cacheItem, n);
        this.decrementCurrentSize(n);
        this.incrementCurrentSize(cacheItem.getSize());
    }

    protected void itemRemoved(BaseCache.CacheItem cacheItem) {
        super.itemRemoved(cacheItem);
        this.decrementCurrentSize(cacheItem.getSize());
    }

    protected boolean isThresholdReached() {
        return this.currentSize > this.maxSize || super.isThresholdReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementCurrentSize(int n) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementCurrentSize(int n) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize -= (long)n;
        }
    }

    public Object getStatByName(String string) {
        Object object = super.getStatByName(string);
        if (object == null && string != null) {
            if (string.equals("cache.BoundedMultiLruCache.stat_currentSize")) {
                object = new Long(this.currentSize);
            } else if (string.equals("cache.BoundedMultiLruCache.stat_maxSize")) {
                object = this.maxSize == Long.MAX_VALUE ? "default" : new Long(this.maxSize);
            }
        }
        return object;
    }

    public Map getStats() {
        Map map = super.getStats();
        map.put("cache.BoundedMultiLruCache.stat_currentSize", new Long(this.currentSize));
        if (this.maxSize == Long.MAX_VALUE) {
            map.put("cache.BoundedMultiLruCache.stat_maxSize", "default");
        } else {
            map.put("cache.BoundedMultiLruCache.stat_maxSize", new Long(this.maxSize));
        }
        return map;
    }
}

