/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSession;
import com.iplanet.server.http.session.IWSHttpSessionInputStream;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.session.SessionDataStore;
import com.iplanet.server.http.util.FileFilterImpl;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.servlet.ServletContext;

class FileStore
extends SessionDataStore {
    private static final String _ext = ".iws";
    private static final String _timeoutSuffix = "-timeout";
    private String _dir = null;
    private FileFilterImpl _timeoutFilesFilter;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public FileStore() {
        this._timeoutFilesFilter = new FileFilterImpl(null, _timeoutSuffix, _ext);
    }

    public FileStore(IWSHttpSessionManager iWSHttpSessionManager) {
        super(iWSHttpSessionManager);
    }

    public boolean init(Properties properties) {
        boolean bl = false;
        this._dir = properties.getProperty("session-data-dir");
        if (this._dir != null) {
            bl = true;
            File file = new File(this._dir);
            if (!file.isDirectory() && !file.mkdirs()) {
                LogUtil.logInfo(_res.getProp("session.FileStore.msg_MkdirError", this._dir));
                bl = false;
            }
            if (!(!bl || file.canWrite() && file.canRead())) {
                LogUtil.logInfo(_res.getProp("session.FileStore.msg_DirPermsError", this._dir));
                bl = false;
            }
            if (!bl) {
                this._dir = null;
            } else {
                if (!this._dir.endsWith(File.separator)) {
                    this._dir = this._dir.concat(File.separator);
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE(7, "FileStore: dir=" + this._dir);
                }
            }
        } else {
            LogUtil.logWarning(_res.getProp("session.FileStore.msg_DirError"));
        }
        return bl;
    }

    public IWSHttpSession load(IWSHttpSession iWSHttpSession) {
        IWSHttpSession iWSHttpSession2 = null;
        String string = iWSHttpSession.getMangledId();
        String string2 = this.getExistingSessionFile(string);
        if (string2 != null) {
            ServletContext servletContext = iWSHttpSession.getServletContext();
            if (LogUtil.enableTrace) {
                LogUtil.TRACE(7, "FileStore: loading from " + string2);
            }
            iWSHttpSession2 = this.loadFromFile(string2, servletContext);
        }
        return iWSHttpSession2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save(IWSHttpSession iWSHttpSession) {
        boolean bl;
        block26: {
            ObjectOutputStream objectOutputStream;
            ObjectOutputStream objectOutputStream2;
            String string;
            block25: {
                if (iWSHttpSession == null) {
                    return false;
                }
                if (this._dir == null) {
                    return false;
                }
                String string2 = iWSHttpSession.getMangledId();
                string = this.getSessionFilename(string2);
                String string3 = this.getSessionTimeoutFilename(string2);
                if (string == null) {
                    return false;
                }
                objectOutputStream2 = null;
                objectOutputStream = null;
                bl = false;
                objectOutputStream2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
                objectOutputStream2.writeObject(iWSHttpSession);
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(string3));
                objectOutputStream.writeInt(iWSHttpSession.getTimeout());
                bl = true;
                if (!LogUtil.enableTrace) break block25;
                LogUtil.TRACE(7, "FileStore: saved to " + string);
            }
            Object var10_8 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectOutputStream2 != null) {
                    objectOutputStream2.close();
                }
                break block26;
            }
            catch (IOException iOException) {}
            break block26;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    LogUtil.logInfo(_res.getProp("session.FileStore.msg_FileNotFound", string));
                    Object var10_9 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (objectOutputStream2 != null) {
                            objectOutputStream2.close();
                        }
                        break block26;
                    }
                    catch (IOException iOException) {}
                    break block26;
                }
                catch (SecurityException securityException) {
                    LogUtil.logInfo(_res.getProp("session.FileStore.msg_AccessError", string, (Object)LogUtil.getStackTrace(securityException)));
                    Object var10_10 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (objectOutputStream2 != null) {
                            objectOutputStream2.close();
                        }
                        break block26;
                    }
                    catch (IOException iOException) {}
                    break block26;
                }
                catch (Exception exception) {
                    LogUtil.logInfo(LogUtil.getStackTrace(exception));
                    Object var10_11 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (objectOutputStream2 != null) {
                            objectOutputStream2.close();
                        }
                        break block26;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (objectOutputStream2 != null) {
                        objectOutputStream2.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    public boolean remove(IWSHttpSession iWSHttpSession) {
        if (iWSHttpSession == null) {
            return false;
        }
        String string = iWSHttpSession.getMangledId();
        if (string == null || this._dir == null) {
            return false;
        }
        return this.removeFiles(string);
    }

    private boolean deleteFile(final File file) {
        if (System.getSecurityManager() != null) {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file.delete());
                }
            });
            return bl;
        }
        return file.delete();
    }

    private boolean removeFiles(String string) {
        File file;
        boolean bl = false;
        String string2 = this.getSessionFilename(string);
        if (string2 != null) {
            file = new File(string2);
            if (file.isFile()) {
                bl = this.deleteFile(file);
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE(7, "FileStore: deleted " + file.getAbsolutePath());
                }
            } else {
                LogUtil.logInfo(_res.getProp("session.FileStore.msg_FileNotFound", file.getAbsolutePath()));
            }
        }
        if ((string2 = this.getSessionTimeoutFilename(string)) != null) {
            file = new File(string2);
            if (file.isFile()) {
                bl = this.deleteFile(file);
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE(7, "FileStore: deleted " + file.getAbsolutePath());
                }
            } else {
                LogUtil.logInfo(_res.getProp("session.FileStore.msg_FileNotFound", file.getAbsolutePath()));
            }
        }
        return bl;
    }

    public void reap(long l) {
        if (this._dir == null) {
            return;
        }
        File file = new File(this._dir);
        File[] fileArray = file.listFiles(this._timeoutFilesFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            String string = this.getSessionId(fileArray[i].getName());
            this._sessionMgr.lock(string);
            long l2 = l - fileArray[i].lastModified();
            long l3 = this.getTimeout(fileArray[i].getAbsolutePath()) * 1000;
            if (l2 > l3 && l3 != Integer.MAX_VALUE) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE(7, "FileStore: reaped " + string);
                }
                this.removeFiles(string);
                this._sessionMgr.unlock(string);
                this._sessionMgr.reaped(string);
                continue;
            }
            this._sessionMgr.unlock(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private IWSHttpSession loadFromFile(String string, ServletContext servletContext) {
        IWSHttpSession iWSHttpSession;
        block21: {
            ObjectInputStream objectInputStream;
            block20: {
                iWSHttpSession = null;
                objectInputStream = null;
                if (servletContext != null) {
                    ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("com.iplanet.server.http.servlet.classloader");
                    objectInputStream = new IWSHttpSessionInputStream(new BufferedInputStream(new FileInputStream(string)), classLoader);
                } else {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(string)));
                }
                iWSHttpSession = (IWSHttpSession)objectInputStream.readObject();
                if (!LogUtil.enableTrace) break block20;
                LogUtil.TRACE(7, "FileStore: loaded from " + string);
            }
            Object var7_9 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                break block21;
            }
            catch (IOException iOException) {}
            break block21;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE(7, _res.getProp("session.FileStore.msg_FileNotFound", string));
                    }
                    Object var7_10 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
                catch (SecurityException securityException) {
                    LogUtil.logInfo(_res.getProp("session.FileStore.msg_AccessError", string, (Object)LogUtil.getStackTrace(securityException)));
                    Object var7_11 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
                catch (Exception exception) {
                    LogUtil.logInfo(LogUtil.getStackTrace(exception));
                    Object var7_12 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return iWSHttpSession;
    }

    private String getSessionFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer(this._dir);
        stringBuffer.append(string).append(_ext);
        return stringBuffer.toString();
    }

    private String getSessionTimeoutFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer(this._dir);
        stringBuffer.append(string).append(_timeoutSuffix).append(_ext);
        return stringBuffer.toString();
    }

    private String getExistingSessionFile(String string) {
        File file;
        String string2 = this.getSessionFilename(string);
        if (string2 != null && !(file = new File(string2)).isFile()) {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getTimeout(String string) {
        int n;
        block19: {
            n = 0;
            if (string != null) {
                ObjectInputStream objectInputStream = null;
                objectInputStream = new ObjectInputStream(new FileInputStream(string));
                n = objectInputStream.readInt();
                Object var6_4 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        if (LogUtil.enableTrace) {
                            LogUtil.TRACE(7, _res.getProp("session.FileStore.msg_FileNotFound", string));
                        }
                        Object var6_5 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                    catch (SecurityException securityException) {
                        LogUtil.logInfo(_res.getProp("session.FileStore.msg_AccessError", string, (Object)LogUtil.getStackTrace(securityException)));
                        Object var6_6 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                    catch (Exception exception) {
                        LogUtil.logInfo(LogUtil.getStackTrace(exception));
                        Object var6_7 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    private String getSessionId(String string) {
        int n = string.indexOf(_timeoutSuffix);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

