/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIRequest;
import com.iplanet.ias.web.session.SessionCookieConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.util.CookieTools;
import org.apache.catalina.util.URL;

final class NSAPIResponse
extends HttpResponseBase {
    public NSAPIResponse() {
        this.status = 0;
    }

    public void setClosing() {
        super.setClosing();
        ((NSAPIConnector)this.connector).setClosing();
    }

    public void recycle() {
        super.recycle();
        this.status = 0;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        this.output.flush();
    }

    public void setBufferSize(int n) {
        super.setBufferSize(n);
        NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
        nSAPIConnector.resize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String string) {
        String string2;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            string2 = nSAPIConnector.getResponseHeader(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderNames() {
        String[] stringArray;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            stringArray = nSAPIConnector.getResponseHeaderNames();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderValues(String string) {
        String[] stringArray;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            stringArray = nSAPIConnector.getResponseHeaderValues(string);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            nSAPIConnector.addResponseHeader(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHeader(String string) {
        boolean bl;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            bl = nSAPIConnector.containsResponseHeader(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        Object object = this.headers;
        synchronized (object) {
            NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
            nSAPIConnector.setResponseHeader(string, string2);
        }
        object = string.toLowerCase();
        if (((String)object).equals("content-length")) {
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= 0) {
                this.setContentLength(n);
            }
        } else if (((String)object).equals("content-type")) {
            this.setContentType(string2);
        }
    }

    private boolean isEncodeable(String string) {
        String string2;
        int n;
        if (string == null) {
            return false;
        }
        if (string.startsWith("#")) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return false;
        }
        if (httpServletRequest.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        if (!httpServletRequest.getScheme().equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        if (!httpServletRequest.getServerName().equalsIgnoreCase(uRL.getHost())) {
            return false;
        }
        int n2 = httpServletRequest.getServerPort();
        if (n2 == -1) {
            n2 = "https".equals(httpServletRequest.getScheme()) ? 443 : 80;
        }
        if ((n = uRL.getPort()) == -1) {
            n = "https".equals(uRL.getProtocol()) ? 443 : 80;
        }
        if (n2 != n) {
            return false;
        }
        String string3 = this.getContext().getPath();
        return string3 == null || string3.length() <= 0 || (string2 = uRL.getFile()) != null && string2.startsWith(string3);
    }

    protected void sendHeaders() throws IOException {
        String string;
        SessionCookieConfig sessionCookieConfig;
        Object object;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        int n = 0;
        Cookie cookie = null;
        if (httpSession != null && httpSession.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            cookie = new Cookie("JSESSIONID", httpSession.getId());
            int n2 = -1;
            String string2 = null;
            String string3 = null;
            object = null;
            sessionCookieConfig = null;
            if (this.context != null) {
                sessionCookieConfig = ((WebModule)this.context).getSessionCookieConfig();
                string2 = this.context.getPath();
            }
            if (sessionCookieConfig != null) {
                n2 = sessionCookieConfig.getMaxAge();
                string = sessionCookieConfig.getPath();
                if (string != null) {
                    string2 = string;
                }
                string3 = sessionCookieConfig.getComment();
                object = sessionCookieConfig.getDomain();
            }
            if (string2 == null || string2.length() == 0) {
                string2 = "/";
            }
            cookie.setMaxAge(n2);
            cookie.setPath(string2);
            if (object != null) {
                cookie.setDomain((String)object);
            }
            if (httpServletRequest.isSecure()) {
                cookie.setSecure(true);
            }
            n = 1;
        }
        String[] stringArray = null;
        int n3 = 0;
        int n4 = this.cookies.size();
        if ((n += n4) > 0) {
            stringArray = new String[n * 2];
            if (cookie != null) {
                stringArray[n3++] = CookieTools.getCookieHeaderName(cookie);
                object = new StringBuffer();
                CookieTools.getUnencodedCookieHeaderValue(cookie, (StringBuffer)object);
                stringArray[n3++] = ((StringBuffer)object).toString();
            }
            if (n4 > 0) {
                object = this.cookies.iterator();
                while (object.hasNext()) {
                    String string4;
                    sessionCookieConfig = (Cookie)object.next();
                    string = CookieTools.getCookieHeaderName((Cookie)sessionCookieConfig);
                    WebModule webModule = (WebModule)this.context;
                    if (webModule == null || webModule.getEncodeCookies()) {
                        string4 = CookieTools.getCookieHeaderValue((Cookie)sessionCookieConfig);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        CookieTools.getUnencodedCookieHeaderValue((Cookie)sessionCookieConfig, stringBuffer);
                        string4 = stringBuffer.toString();
                    }
                    stringArray[n3++] = string;
                    stringArray[n3++] = string4;
                }
            }
        }
        object = (NSAPIConnector)this.connector;
        ((NSAPIConnector)object).setAllResponseFields(this.status, this.message, this.getContentType(), this.getContentLength(), this.isError(), stringArray, n3);
        this.committed = true;
    }

    private String toAbsolute(String string) {
        if (string == null) {
            return string;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
            String string2 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
            try {
                uRL = new URL(new URL(string2), string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException(string);
            }
        }
        return uRL.toExternalForm();
    }

    private String toEncoded(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        String string4 = string;
        String string5 = "";
        int n = string.indexOf(63);
        if (n >= 0) {
            string4 = string.substring(0, n);
            string5 = string.substring(n);
        }
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.append(";jsessionid=");
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append(":");
            stringBuffer.append(string3);
        }
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    public String encodeRedirectURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            NSAPIRequest nSAPIRequest = (NSAPIRequest)this.request;
            return this.toEncoded(string, nSAPIRequest.getSession().getId(), nSAPIRequest.getJrouteId());
        }
        return string;
    }

    public String encodeURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            NSAPIRequest nSAPIRequest = (NSAPIRequest)this.request;
            return this.toEncoded(string, nSAPIRequest.getSession().getId(), nSAPIRequest.getJrouteId());
        }
        return string;
    }
}

