/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Java;
import com.iplanet.ias.config.serverbeans.Log;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.Vs;
import com.iplanet.ias.config.serverbeans.Vsclass;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.tools.common.dd.SecurityRoleMapping;
import com.iplanet.ias.tools.common.dd.webapp.ClassLoaderBean;
import com.iplanet.ias.tools.common.dd.webapp.CookieProperties;
import com.iplanet.ias.tools.common.dd.webapp.ManagerProperties;
import com.iplanet.ias.tools.common.dd.webapp.SessionConfig;
import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
import com.iplanet.ias.tools.common.dd.webapp.SessionProperties;
import com.iplanet.ias.tools.common.dd.webapp.StoreProperties;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.logging.LogLevels;
import com.iplanet.ias.web.EmbeddedWebContainer;
import com.iplanet.ias.web.VirtualServer;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.WebModuleConfig;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIProcessor;
import com.iplanet.ias.web.logger.IASLogger;
import com.iplanet.ias.web.session.IWSHttpSessionManagerAdapter;
import com.iplanet.ias.web.session.PersistenceType;
import com.iplanet.ias.web.session.SessionCookieConfig;
import com.iplanet.server.http.util.CfgUtil;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.FileStore;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.LifecycleSupport;
import org.netbeans.modules.schema2beans.BaseBean;

public final class WebContainer
implements Lifecycle {
    public static final String SSO_ENABLED = "sso-enabled";
    public static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    public static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    private EmbeddedWebContainer _embedded = null;
    private Engine _engine = null;
    private ServerContext _serverContext = null;
    private Server _serverBean = null;
    private String _id = null;
    private static Logger _logger = null;
    private static Logger _loaderlogger = null;
    private static ResourceBundle _rb = null;
    private Level _logLevel = null;
    private int _debug = 0;
    private String _modulesWorkRoot = null;
    private String _modulesRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = -1;
    private LifecycleSupport _lifecycle = new LifecycleSupport(this);
    private boolean _started = false;
    private static Hashtable _instances = new Hashtable();

    private WebContainer(String string, ServerContext serverContext) {
        this._id = string;
        this._serverContext = serverContext;
        String string2 = this._serverContext.getInstallRoot();
        String string3 = this._serverContext.getInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2, string3);
        this._modulesWorkRoot = instanceEnvironment.getWebModuleCompileJspPath();
        this._modulesRoot = instanceEnvironment.getModuleRepositoryPath();
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        if (_loaderlogger == null) {
            _loaderlogger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
        }
        try {
            ElementProperty elementProperty;
            this._serverBean = this._serverContext.getConfigBean();
            this.getDynamicReloadingSettings(this._serverBean.getJava());
            Level level = Level.INFO;
            this.setLogLevel(level);
            Log log = this._serverBean.getLog();
            if (log != null) {
                level = LogLevels.getJavaLogLevel(log.getLoglevel(), level);
                this.setLogLevel(level);
            } else {
                level = LogLevels.getJavaLogLevel(Log.getDefaultLoglevel(), level);
                this.setLogLevel(level);
            }
            level = LogLevels.getJavaLogLevel(this._serverBean.getJava().getLoglevel(), level);
            this.setLogLevel(level);
            if (this._debug > 0) {
                _logger.fine("Web container log level: " + this._logLevel);
            }
            if ((elementProperty = this._serverBean.getJava().getElementPropertyByName(DISPATCHER_MAX_DEPTH)) != null && elementProperty.getValue() != null) {
                int n = -1;
                try {
                    n = Integer.parseInt(elementProperty.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n > 0) {
                    RequestBase.setMaxDispatchDepth(n);
                    if (this._debug > 0) {
                        _logger.fine("Maximum depth for nested request dispatches set to " + elementProperty.getValue());
                    }
                }
            }
            try {
                if (this.isByteCodePreprocessingEnabled(this._serverBean.getJava())) {
                    PreprocessorUtil.init(this.getBytecodeProcessorClassNames(this._serverBean.getJava()));
                }
            }
            catch (ConfigException configException) {
                _loaderlogger.log(Level.WARNING, "loader.preprocessor_config_error", configException);
                _loaderlogger.log(Level.WARNING, "loader.preprocessor_disabled");
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "webcontainer.configError", configException);
        }
        this._embedded = new EmbeddedWebContainer();
        this._embedded.setUseNaming(true);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this._engine = this._embedded.createEngine();
        ((StandardEngine)this._engine).setMapperClass(null);
        this._embedded.addEngine(this._engine);
    }

    public String getID() {
        return this._id;
    }

    public StandardHost createVS(long l, String string, String string2) {
        Object[] objectArray;
        VirtualServer virtualServer = (VirtualServer)this._embedded.createHost(string, string2);
        virtualServer.setJNIVirtualServer(l);
        Vs vs = this.findVirtualServerBean(string);
        if (vs != null) {
            if (this.isSSOEnabled(vs)) {
                objectArray = new Object[]{virtualServer.getID()};
                _logger.log(Level.INFO, "webcontainer.ssoenabled", objectArray);
                try {
                    ElementProperty elementProperty;
                    ElementProperty elementProperty2;
                    SingleSignOn singleSignOn = new SingleSignOn();
                    if (this._debug > 1) {
                        singleSignOn.setDebug(this._debug);
                    }
                    if ((elementProperty2 = vs.getElementPropertyByName(SSO_MAX_IDLE)) != null && elementProperty2.getValue() != null) {
                        _logger.fine("SSO entry max idle time set to: " + elementProperty2.getValue());
                        int n = Integer.parseInt(elementProperty2.getValue());
                        singleSignOn.setMaxInactive(n);
                    }
                    if ((elementProperty = vs.getElementPropertyByName(SSO_REAP_INTERVAL)) != null && elementProperty.getValue() != null) {
                        _logger.fine("SSO expire thread interval set to : " + elementProperty.getValue());
                        int n = Integer.parseInt(elementProperty.getValue());
                        singleSignOn.setReapInterval(n);
                    }
                    virtualServer.addValve(singleSignOn);
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "webcontainer.ssobadconfig", exception.getMessage());
                    _logger.log(Level.WARNING, "webcontainer.ssodisabled", virtualServer.getID());
                }
            }
            this.loadWebModules(virtualServer);
        }
        if ((objectArray = this._engine.getDefaultHost()) == null && this._engine instanceof StandardEngine) {
            ((StandardEngine)this._engine).setDefaultHost(string);
        }
        this._engine.addChild(virtualServer);
        return virtualServer;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this._started) {
            String string = _rb.getString("webcontainer.alreadyStarted");
            throw new LifecycleException(string);
        }
        this._lifecycle.fireLifecycleEvent("start", null);
        this._started = true;
        this._embedded.start();
        Container[] containerArray = this._engine.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            ((VirtualServer)containerArray[i]).handleCoreMappings();
        }
    }

    public void stop() throws LifecycleException {
        if (!this._started) {
            String string = _rb.getString("webcontainer.notStarted");
            throw new LifecycleException(string);
        }
        this._started = false;
        this._embedded.stop();
    }

    public static WebContainer createInstance(long l, ServerContext serverContext) {
        WebContainer webContainer = new WebContainer(Long.toString(l), serverContext);
        _instances.put(new Long(l), webContainer);
        return webContainer;
    }

    public static WebContainer getInstance(long l) {
        Long l2 = new Long(l);
        WebContainer webContainer = (WebContainer)_instances.get(l2);
        if (webContainer == null) {
            _logger.fine("Cound not find web container associated with the configuration: " + l);
        }
        return webContainer;
    }

    public static void startInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            try {
                webContainer.start();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.startError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            _instances.remove(new Long(l));
            try {
                webContainer.stop();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.stopError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopAllInstances() throws ServerLifecycleException {
        Enumeration enumeration = _instances.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Long l = (Long)enumeration.nextElement();
                WebContainer.stopInstance(l);
            }
        }
    }

    public static NSAPIProcessor createNSAPIProcessor() {
        return new NSAPIProcessor();
    }

    public static int service(long l, NSAPIProcessor nSAPIProcessor, StandardHost standardHost, String[] stringArray, byte[][] byArray, int[] nArray, StandardContext standardContext, String string, StandardWrapper standardWrapper, String string2, String string3) {
        NSAPIConnector nSAPIConnector = nSAPIProcessor.getConnector();
        nSAPIConnector.setContainer(standardHost);
        nSAPIConnector.setJNIConnector(l);
        int n = nSAPIProcessor.process(standardHost, stringArray, byArray, nArray, standardContext, string, standardWrapper, string2, string3);
        return n;
    }

    private void loadWebModules(VirtualServer virtualServer) {
        WebModuleConfig webModuleConfig;
        List list = virtualServer.getWebModules(this._serverBean, this._modulesRoot);
        if (list != null && list.size() > 0) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                webModuleConfig = (WebModuleConfig)listIterator.next();
                this.loadStandaloneWebModule(virtualServer, webModuleConfig);
            }
        }
        if ((webModuleConfig = virtualServer.createSystemDefaultWebModuleIfNecessary()) != null) {
            this.loadStandaloneWebModule(virtualServer, webModuleConfig);
        }
    }

    private void loadStandaloneWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) {
        String string = webModuleConfig.getName();
        webModuleConfig.setWorkDirBase(this._modulesWorkRoot);
        try {
            this.loadWebModule(virtualServer, webModuleConfig);
        }
        catch (NamingException namingException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), namingException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
        catch (MalformedURLException malformedURLException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), malformedURLException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), illegalArgumentException};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
        }
    }

    private void loadWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) throws NamingException, MalformedURLException, IllegalArgumentException {
        Object object;
        ClassLoader classLoader;
        String string = webModuleConfig.getName();
        String string2 = webModuleConfig.getContextPath();
        String string3 = null;
        string3 = string2.equals("") ? "/" : string2;
        if (virtualServer.findChild(string2) != null) {
            Object[] objectArray = new Object[]{virtualServer.getID(), string3, string};
            _logger.log(Level.SEVERE, "webcontainer.duplicateContextRoot", objectArray);
            return;
        }
        Object[] objectArray = new Object[]{virtualServer.getID(), string3};
        if (webModuleConfig.isSystemDefaultContext()) {
            _logger.log(Level.FINE, "webcontainer.loadModule", objectArray);
        } else {
            _logger.log(Level.INFO, "webcontainer.loadModule", objectArray);
        }
        Context context = this._embedded.createContext(string2, webModuleConfig.getLocation());
        ((StandardContext)context).setCachingAllowed(true);
        ((StandardContext)context).setWorkDir(webModuleConfig.getWorkDir());
        if (webModuleConfig.isSystemDefaultContext()) {
            ((WebModule)context).setAsSystemDefaultContext();
        }
        if ((classLoader = webModuleConfig.getParentLoader()) == null) {
            classLoader = this._serverContext.getCommonClassLoader();
        }
        context.setParentClassLoader(classLoader);
        SunWebApp sunWebApp = null;
        String string4 = webModuleConfig.getLocation() + "/WEB-INF/" + "sun-web.xml";
        File file = new File(string4);
        if (file.canRead()) {
            try {
                object = new FileInputStream(file);
                XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(false);
                sunWebApp = (SunWebApp)BaseBean.createGraph(SunWebApp.class, (InputStream)object, false, xMLValidationHandler, xMLValidationHandler);
                ((FileInputStream)object).close();
            }
            catch (Exception exception) {
                String string5 = _rb.getString("webcontainer.sunwebError");
                Object[] objectArray2 = new Object[]{string4};
                string5 = MessageFormat.format(string5, objectArray2);
                _logger.log(Level.SEVERE, string5, exception);
            }
        }
        object = (WebModule)context;
        ((WebModule)object).setIasWebAppConfigBean(sunWebApp);
        ((WebModule)object).setVirtualServer(virtualServer);
        ((WebModule)object).setID(string);
        this.configureLoader(context, sunWebApp);
        this.configureMiscSettings(context, sunWebApp, virtualServer.getID(), string3);
        this.configureSessionSettings(context, sunWebApp, virtualServer);
        ((WebModule)object).setI18nInfo();
        this.configureRoleMapper(context, sunWebApp, string);
        virtualServer.addChild(context);
    }

    private void configureLoader(Context context, SunWebApp sunWebApp) {
        Object[] objectArray;
        Object object;
        Loader loader = this._embedded.createLoader(context.getParentClassLoader());
        boolean bl = false;
        boolean bl2 = this._reloadingEnabled;
        int n = this._pollInterval;
        List list = null;
        ClassLoaderBean classLoaderBean = null;
        if (sunWebApp != null) {
            classLoaderBean = sunWebApp.getClassLoaderBean();
        }
        if (classLoaderBean != null) {
            object = classLoaderBean.getAttributeValue("delegate");
            if (object != null) {
                bl = ConfigBean.toBoolean((String)object);
            }
            if ((object = classLoaderBean.getAttributeValue("extra-class-path")) != null) {
                list = StringUtils.parseStringList((String)object, ";:");
            }
            if ((object = classLoaderBean.getAttributeValue("dynamic-reload-interval")) != null) {
                try {
                    n = Integer.parseInt((String)object);
                    bl2 = n > 0;
                }
                catch (NumberFormatException numberFormatException) {
                    objectArray = new Object[]{object, context.getPath()};
                    _logger.log(Level.SEVERE, "webcontainer.invalidReloadInterval", objectArray);
                    bl2 = false;
                }
            }
        }
        if (this._debug > 0) {
            _logger.fine("WebModule[" + context.getPath() + "]: Setting delegate to " + bl);
        }
        loader.setDelegate(bl);
        if (list != null) {
            object = list.listIterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: Adding " + string + " to the classpath");
                }
                try {
                    objectArray = new File(string).toURI().toURL();
                    loader.addRepository(objectArray.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    String string2 = _rb.getString("webcontainer.classpathError");
                    Object[] objectArray2 = new Object[]{string};
                    string2 = MessageFormat.format(string2, objectArray2);
                    _logger.log(Level.SEVERE, string2, malformedURLException);
                }
            }
        }
        context.setReloadable(bl2);
        if (bl2) {
            if (this._debug > 0) {
                _logger.fine("WebModule[" + context.getPath() + "]: Dynamic reloading enabled (poll interval = " + n + " second(s))");
            }
            ((WebappLoader)loader).setCheckInterval(n);
        }
        context.setLoader(loader);
    }

    private void configureMiscSettings(Context context, SunWebApp sunWebApp, String string, String string2) {
        if (sunWebApp != null && sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sunWebApp.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                Object object;
                String string3 = webPropertyArray[i].getAttributeValue("name");
                String string4 = webPropertyArray[i].getAttributeValue("value");
                if (string3.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n <= 0) continue;
                        ((StandardContext)context).setSTMPoolSize(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = new Object[]{string4, string2};
                        _logger.log(Level.SEVERE, "webcontainer.invalidServletPoolSize", (Object[])object);
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("tempdir")) {
                    ((StandardContext)context).setWorkDir(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("crossContextAllowed")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    ((StandardContext)context).setCrossContext(bl);
                    continue;
                }
                if (string3.equalsIgnoreCase("reuseSessionID")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    context.setReuseSessionID(bl);
                    if (!bl) continue;
                    object = new Object[]{string2, string};
                    _logger.log(Level.WARNING, "webcontainer.sessionIDsReused", (Object[])object);
                    continue;
                }
                if (string3.equalsIgnoreCase("statsEnabled") && string4.equals("true")) {
                    WebModule webModule = (WebModule)context;
                    webModule.setStatsEnabled(true);
                    continue;
                }
                if (string3.equalsIgnoreCase("relativeRedirectAllowed")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    context.setAllowRelativeRedirect(bl);
                    continue;
                }
                if (string3.equalsIgnoreCase("encodeCookies")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    object = (WebModule)context;
                    ((WebModule)object).setEncodeCookies(bl);
                    continue;
                }
                Object[] objectArray = new Object[]{string3, string4};
                _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray);
            }
        }
    }

    private void configureSessionSettings(Context context, SunWebApp sunWebApp, VirtualServer virtualServer) {
        SessionConfig sessionConfig = null;
        SessionManager sessionManager = null;
        SessionProperties sessionProperties = null;
        CookieProperties cookieProperties = null;
        if (sunWebApp != null) {
            sessionConfig = sunWebApp.getSessionConfig();
        }
        if (sessionConfig != null) {
            sessionManager = sessionConfig.getSessionManager();
        }
        if (sessionConfig != null) {
            sessionProperties = sessionConfig.getSessionProperties();
        }
        if (sessionConfig != null) {
            cookieProperties = sessionConfig.getCookieProperties();
        }
        this.configureSessionManager(context, sessionManager, virtualServer);
        this.configureSession(context, sessionProperties);
        this.configureCookieProperties(context, cookieProperties);
    }

    private void configureSessionManager(Context context, SessionManager sessionManager, VirtualServer virtualServer) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n = 60;
        int n2 = -1;
        PersistenceType persistenceType = PersistenceType.MEMORY;
        String string = null;
        int n3 = 60;
        String string2 = ((StandardContext)context).getWorkDir();
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (sessionManager != null) {
            Object[] objectArray2;
            String string3;
            objectArray = sessionManager.getAttributeValue("persistence-type");
            persistenceType = PersistenceType.parseType((String)objectArray);
            object2 = sessionManager.getManagerProperties();
            if (object2 != null && ((ManagerProperties)object2).sizeWebProperty() > 0) {
                object = ((ManagerProperties)object2).getWebProperty();
                for (int i = 0; i < ((WebProperty[])object).length; ++i) {
                    String string4 = object[i].getAttributeValue("name");
                    string3 = object[i].getAttributeValue("value");
                    if (string4.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string4.equalsIgnoreCase("maxSessions")) {
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string4.equalsIgnoreCase("sessionFilename")) {
                        string = string3;
                    } else if (persistenceType != PersistenceType.S1WS60 && persistenceType != PersistenceType.MMAP) {
                        objectArray2 = new Object[]{string4};
                        _logger.log(Level.INFO, "webcontainer.notYet", objectArray2);
                    }
                    if (persistenceType != PersistenceType.S1WS60 && persistenceType != PersistenceType.MMAP) continue;
                    properties.put(string4, string3);
                }
            }
            if ((object = sessionManager.getStoreProperties()) != null && ((StoreProperties)object).sizeWebProperty() > 0) {
                WebProperty[] webPropertyArray = ((StoreProperties)object).getWebProperty();
                for (int i = 0; i < webPropertyArray.length; ++i) {
                    string3 = webPropertyArray[i].getAttributeValue("name");
                    objectArray2 = webPropertyArray[i].getAttributeValue("value");
                    if (string3.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            n3 = Integer.parseInt((String)objectArray2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string3.equalsIgnoreCase("directory")) {
                        string2 = objectArray2;
                    } else if (persistenceType != PersistenceType.S1WS60 && persistenceType != PersistenceType.MMAP) {
                        Object[] objectArray3 = new Object[]{string3};
                        _logger.log(Level.INFO, "webcontainer.notYet", objectArray3);
                    }
                    if (persistenceType != PersistenceType.S1WS60 && persistenceType != PersistenceType.MMAP) continue;
                    properties2.put(string3, objectArray2);
                }
            }
        } else if (!CfgUtil.isSingleProcess()) {
            persistenceType = PersistenceType.MMAP;
        }
        if (persistenceType == PersistenceType.MEMORY) {
            objectArray = new StandardManager();
            objectArray.setPathname(string);
            objectArray.setMaxActiveSessions(n2);
            objectArray.setCheckInterval(n);
            context.setManager((Manager)objectArray);
        } else if (persistenceType == PersistenceType.FILE) {
            objectArray = new Object[]{context.getPath()};
            _logger.log(Level.INFO, "webcontainer.filePersistence", objectArray);
            object2 = new PersistentManager();
            ((PersistentManagerBase)object2).setMaxActiveSessions(n2);
            ((PersistentManagerBase)object2).setCheckInterval(n);
            ((PersistentManagerBase)object2).setMaxIdleBackup(0);
            object = new FileStore();
            ((StoreBase)object).setCheckInterval(n3);
            ((FileStore)object).setDirectory(string2);
            ((PersistentManagerBase)object2).setStore((Store)object);
            context.setManager((Manager)object2);
        } else if (persistenceType == PersistenceType.S1WS60) {
            objectArray = new IWSHttpSessionManagerAdapter();
            this.check60SessionDir(properties2, context, virtualServer);
            objectArray.setManagerProperties(properties);
            objectArray.setStoreProperties(properties2);
            context.setManager((Manager)objectArray);
        } else if (persistenceType == PersistenceType.MMAP) {
            objectArray = new IWSHttpSessionManagerAdapter();
            properties.put("classname", "com.iplanet.server.http.session.MMapSessionManager");
            this.check60SessionDir(properties2, context, virtualServer);
            objectArray.setManagerProperties(properties);
            objectArray.setStoreProperties(properties2);
            context.setManager((Manager)objectArray);
        }
    }

    private void check60SessionDir(Properties properties, Context context, VirtualServer virtualServer) {
        String string = (String)properties.get("directory");
        boolean bl = true;
        if (string == null) {
            string = (String)properties.get("session-data-dir");
            bl = false;
        }
        if (string == null) {
            string = "../SessionData/";
            string = string + virtualServer.getID() + context.getPath();
            if (bl) {
                properties.put("directory", string);
            } else {
                properties.put("session-data-dir", string);
            }
        }
    }

    private void configureSession(Context context, SessionProperties sessionProperties) {
        boolean bl = false;
        int n = 60;
        boolean bl2 = true;
        if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sessionProperties.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string = webPropertyArray[i].getAttributeValue("name");
                String string2 = webPropertyArray[i].getAttributeValue("value");
                if (string.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        n = Integer.parseInt(string2);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equalsIgnoreCase("enableCookies")) {
                    bl2 = ConfigBean.toBoolean(string2);
                    continue;
                }
                Object[] objectArray = new Object[]{string};
                _logger.log(Level.INFO, "webcontainer.notYet", objectArray);
            }
        }
        if (bl) {
            context.getManager().setMaxInactiveInterval(n);
        }
        context.setCookies(bl2);
    }

    private void configureCookieProperties(Context context, CookieProperties cookieProperties) {
        WebProperty[] webPropertyArray;
        if (cookieProperties != null && (webPropertyArray = cookieProperties.getWebProperty()) != null) {
            SessionCookieConfig sessionCookieConfig = new SessionCookieConfig();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string = webPropertyArray[i].getAttributeValue("name");
                String string2 = webPropertyArray[i].getAttributeValue("value");
                if (string.equalsIgnoreCase("cookieName")) {
                    sessionCookieConfig.setName(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookiePath")) {
                    sessionCookieConfig.setPath(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        sessionCookieConfig.setMaxAge(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equalsIgnoreCase("cookieDomain")) {
                    sessionCookieConfig.setDomain(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookieComment")) {
                    sessionCookieConfig.setComment(string2);
                    continue;
                }
                Object[] objectArray = new Object[]{string, string2};
                _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray);
            }
            if (webPropertyArray.length > 0) {
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: " + sessionCookieConfig);
                }
                WebModule webModule = (WebModule)context;
                webModule.setSessionCookieConfig(sessionCookieConfig);
            }
        }
    }

    private void configureRoleMapper(Context context, SunWebApp sunWebApp, String string) {
        RoleMapper roleMapper = RoleMapper.getRoleMapper(string);
        if (sunWebApp != null) {
            SecurityRoleMapping[] securityRoleMappingArray = sunWebApp.getSecurityRoleMapping();
            for (int i = 0; i < securityRoleMappingArray.length; ++i) {
                SecurityRoleMapping securityRoleMapping = securityRoleMappingArray[i];
                String string2 = securityRoleMapping.getRoleName();
                Role role = new Role(string2);
                String[] stringArray = securityRoleMapping.getPrincipalName();
                for (int j = 0; j < stringArray.length; ++j) {
                    roleMapper.assignRole(new PrincipalImpl(stringArray[j]), role);
                }
                String[] stringArray2 = securityRoleMapping.getGroupName();
                for (int j = 0; j < stringArray2.length; ++j) {
                    roleMapper.assignRole(new Group(stringArray2[j]), role);
                }
            }
        }
        context.setRealm(new RealmAdapter(roleMapper));
    }

    private void getDynamicReloadingSettings(Java java) {
        if (java != null) {
            String string = java.getDynamicreloadinterval();
            if (string != null) {
                try {
                    this._pollInterval = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._reloadingEnabled = this._pollInterval > 0;
        }
    }

    public boolean isByteCodePreprocessingEnabled(Java java) throws ConfigException {
        boolean bl = false;
        if (java != null && java.getBytecodepreprocessors() != null) {
            bl = true;
        }
        return bl;
    }

    public String[] getBytecodeProcessorClassNames(Java java) throws ConfigException {
        String[] stringArray = null;
        if (java != null) {
            String string = java.getBytecodepreprocessors();
            _loaderlogger.log(Level.INFO, "loader.preprocessor_class_name", string);
            stringArray = string.split(",");
        }
        return stringArray;
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private boolean isSSOEnabled(Vs vs) {
        ElementProperty elementProperty = vs.getElementPropertyByName(SSO_ENABLED);
        return elementProperty != null && elementProperty.getValue() != null && ConfigBean.toBoolean(elementProperty.getValue());
    }

    private Vs findVirtualServerBean(String string) {
        Vsclass[] vsclassArray = this._serverBean.getVsclass();
        if (vsclassArray == null) {
            return null;
        }
        for (int i = 0; i < vsclassArray.length; ++i) {
            Vs[] vsArray = vsclassArray[i].getVs();
            if (vsArray == null) {
                return null;
            }
            for (int j = 0; j < vsArray.length; ++j) {
                if (!string.equals(vsArray[j].getId())) continue;
                return vsArray[j];
            }
        }
        return null;
    }
}

