/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.Assertion;
import com.iplanet.ias.util.diagnostics.CallerInfoException;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class CallerInfo {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String className;
    private String fileName;
    private String methodName;
    private int lineNumber;
    private final String badFormat = "Bad Format in stack dump line";
    private Vector ignoreVec = new Vector();
    private static Vector globalIgnoreVec = new Vector();

    public CallerInfo() throws CallerInfoException {
        this(null);
    }

    public CallerInfo(Object[] objectArray) throws CallerInfoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        Throwable throwable = new Throwable();
        String string = this.getClass().getName() + ".";
        this.ignoreVec.addElement(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.ignoreVec.addElement(objectArray[i].getClass().getName() + ".");
            }
        }
        if (globalIgnoreVec.size() > 0) {
            Enumeration enumeration = globalIgnoreVec.elements();
            while (enumeration.hasMoreElements()) {
                this.ignoreVec.addElement(enumeration.nextElement().getClass().getName() + ".");
            }
        }
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\n\r\t");
        if (stringTokenizer.countTokens() < 3) {
            throw new CallerInfoException("Expected at least 3 lines from the stack dump -- only saw " + stringTokenizer.countTokens() + " lines");
        }
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.ignoreVec(string2)) continue;
            this.parseCallerInfo(string2);
            return;
        }
        throw new CallerInfoException("Couldn't find a caller method");
    }

    public static void addToGlobalIgnore(Object object) {
        Enumeration enumeration = globalIgnoreVec.elements();
        while (enumeration.hasMoreElements()) {
            if (object != enumeration.nextElement()) continue;
            return;
        }
        globalIgnoreVec.addElement(object);
    }

    void parseCallerInfo(String string) throws CallerInfoException {
        if (!string.startsWith("at ")) {
            throw new CallerInfoException("Bad Format in stack dump line -- no \"at \" at start of line (" + string + ")");
        }
        string = string.substring(3);
        String string2 = this.parseAndRemoveLineInfo(string);
        this.parseClassInfo(string2);
    }

    public String getClassName() {
        Assertion.check(this.className);
        return this.className;
    }

    public String getFileName() {
        Assertion.check(this.fileName != null);
        return this.fileName;
    }

    public String getMethodName() {
        Assertion.check(this.methodName);
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        Assertion.check(this.className);
        Assertion.check(this.methodName);
        Assertion.check(this.fileName != null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.className);
        stringBuffer.append(".");
        stringBuffer.append(this.methodName);
        if (this.fileName.length() > 0) {
            stringBuffer.append("(" + this.fileName + ":" + this.lineNumber + ")");
        } else {
            stringBuffer.append("(Unknown Source");
        }
        return stringBuffer.toString();
    }

    public String toStringDebug() {
        Assertion.check(this.className);
        Assertion.check(this.methodName);
        Assertion.check(this.fileName != null);
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("  dump:");
        stringBuffer.append("\nClass Name: ");
        stringBuffer.append(this.className);
        stringBuffer.append("\nMethod Name: ");
        stringBuffer.append(this.methodName);
        stringBuffer.append("\nFile Name: ");
        if (this.fileName.length() > 0) {
            stringBuffer.append(this.fileName);
            stringBuffer.append("\nLine Number: ");
            stringBuffer.append(this.lineNumber);
        } else {
            stringBuffer.append("unknown");
        }
        return stringBuffer.toString();
    }

    private String parseAndRemoveLineInfo(String string) throws CallerInfoException {
        this.fileName = "";
        this.lineNumber = -1;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0 || n2 < 0 || n2 <= n) {
            throw new CallerInfoException("Bad Format in stack dump line -- no parenthesis in line:" + string);
        }
        String string2 = string.substring(n + 1, n2);
        string = string.substring(0, n);
        if (string2.length() <= 0) {
            return string;
        }
        if (string2.equals("Unknown Source")) {
            return string;
        }
        int n3 = string2.indexOf(58);
        if (n3 < 0) {
            this.fileName = string2;
            return string;
        }
        if (n3 == string2.length() - 1) {
            this.fileName = string2.substring(0, n3);
            return string;
        }
        this.fileName = string2.substring(0, n3);
        try {
            this.lineNumber = Integer.parseInt(string2.substring(n3 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string;
    }

    private void parseClassInfo(String string) throws CallerInfoException {
        if (string.indexOf(46) < 0) {
            throw new CallerInfoException("Bad Format in stack dump line -- no \".\" in the fully-qualified method name");
        }
        if (string.indexOf(46) == 0) {
            throw new CallerInfoException("Bad Format in stack dump line fully-qualified method name starts with a dot");
        }
        int n = string.lastIndexOf(46);
        this.className = string.substring(0, n);
        this.methodName = string.substring(n + 1);
    }

    private boolean ignoreVec(String string) {
        Assertion.check(this.ignoreVec);
        int n = this.ignoreVec.size();
        Assertion.check(n > 0);
        for (int i = 0; i < n; ++i) {
            if (string.indexOf((String)this.ignoreVec.elementAt(i)) < 0) continue;
            return true;
        }
        return false;
    }
}

