/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.login;

import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class PasswordLoginModule
implements LoginModule {
    protected Subject _subject;
    protected Map _sharedState;
    protected Map _options;
    protected String _username;
    protected String _password;
    protected Realm _currentRealm;
    protected boolean _succeeded = false;
    protected boolean _commitSucceeded = false;
    protected PrincipalImpl _userPrincipal;
    protected Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    protected static StringManager sm = StringManager.getManager("com.iplanet.ias.security.auth.login");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        this._sharedState = map;
        this._options = map2;
        this._logger.finest("Login module initialized: " + this.getClass().toString());
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        if (this._subject == null) {
            String string = sm.getString("pwdlm.noinfo");
            throw new LoginException(string);
        }
        PasswordCredential passwordCredential = null;
        try {
            object2 = this._subject.getPrivateCredentials().iterator();
            while (object2.hasNext() && passwordCredential == null) {
                object = object2.next();
                if (!(object instanceof PasswordCredential)) continue;
                passwordCredential = (PasswordCredential)object;
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "passwordlm.nocreds", exception.toString());
        }
        if (passwordCredential == null) {
            this._logger.warning("passwordlm.nopwdcred");
            object2 = sm.getString("pwdlm.nocreds");
            throw new LoginException((String)object2);
        }
        object2 = null;
        try {
            object2 = passwordCredential.getRealm();
            this._currentRealm = Realm.getInstance((String)object2);
        }
        catch (Exception exception) {
            String string = sm.getString("pwdlm.norealm", object2);
            throw new LoginException(string);
        }
        if (this._currentRealm == null) {
            object = sm.getString("pwdlm.norealmavail", object2);
            throw new LoginException((String)object);
        }
        this._username = passwordCredential.getUser();
        this._password = passwordCredential.getPassword();
        this.authenticate();
        this._logger.finest("JAAS login complete.");
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        this._userPrincipal = new PrincipalImpl(this._username);
        if (!this._subject.getPrincipals().contains(this._userPrincipal)) {
            this._subject.getPrincipals().add(this._userPrincipal);
        }
        this._username = null;
        this._password = null;
        this._commitSucceeded = true;
        this._logger.finest("JAAS authentication committed.");
        return true;
    }

    public boolean abort() throws LoginException {
        this._logger.finest("JAAS authentication aborted.");
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this._commitSucceeded) {
            this._succeeded = false;
            this._username = null;
            this._password = null;
            this._userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this._logger.finest("JAAS logout for: " + this._subject.toString());
        this._subject.getPrincipals().remove(this._userPrincipal);
        this._succeeded = false;
        this._succeeded = this._commitSucceeded;
        this._username = null;
        this._password = null;
        this._userPrincipal = null;
        return true;
    }

    protected AuthenticationStatus commitAuthentication(String string, String string2, Realm realm, String[] stringArray) {
        this._succeeded = true;
        return null;
    }

    protected abstract AuthenticationStatus authenticate() throws LoginException;
}

