/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.login;

import com.iplanet.ias.security.auth.login.PasswordLoginModule;
import com.iplanet.ias.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;

public class LDAPLoginModule
extends PasswordLoginModule {
    private String _ctxF;
    private String _url;
    private String _userDNbase;
    private String _searchFilter;
    private String _grpDNbase;
    private String _grpSearchFilter;
    private String _grpTarget;
    private String _authMechanism;
    private LDAPRealm _ldapRealm;
    private String[] _dnOnly = new String[]{"dn"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationStatus authenticate() throws LoginException {
        if (!(this._currentRealm instanceof LDAPRealm)) {
            String string = sm.getString("ldaplm.badrealm");
            throw new LoginException(string);
        }
        this._ldapRealm = (LDAPRealm)this._currentRealm;
        if (this._password == null || this._password.length() == 0) {
            String string = sm.getString("ldaplm.emptypassword", this._username);
            throw new LoginException(string);
        }
        if (this._username == null || this.badChars(this._username)) {
            String string = sm.getString("ldaplm.baduname", this._username);
            throw new LoginException(string);
        }
        this._ctxF = this._currentRealm.getProperty("jndiCtxFactory");
        this._url = this._currentRealm.getProperty("directory");
        this._userDNbase = this._currentRealm.getProperty("base-dn");
        this._searchFilter = this._currentRealm.getProperty("search-filter");
        this._grpDNbase = this._currentRealm.getProperty("group-base-dn");
        this._grpSearchFilter = this._currentRealm.getProperty("group-search-filter");
        this._grpTarget = this._currentRealm.getProperty("group-target");
        this._authMechanism = this._currentRealm.getProperty("authentication");
        String string = this._currentRealm.getProperty("mode");
        if ("find-bind".equals(string)) {
            Context context = null;
            try {
                context = this.getLdapCtx();
                AuthenticationStatus authenticationStatus = this.findAndBind(context);
                return authenticationStatus;
            }
            finally {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
        String string2 = sm.getString("ldaplm.badmode", string);
        throw new LoginException(string2);
    }

    private Context getLdapCtx() throws LoginException {
        InitialDirContext initialDirContext = null;
        Properties properties = this._ldapRealm.getLdapBindProp();
        try {
            initialDirContext = new InitialDirContext(properties);
        }
        catch (NamingException namingException) {
            throw new LoginException("Can't create ldap context\n" + namingException);
        }
        return initialDirContext;
    }

    private boolean badChars(String string) {
        int n = string.length();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if ("*&|!()=<>".indexOf(string.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    private AuthenticationStatus findAndBind(Context context) throws LoginException {
        StringBuffer stringBuffer = new StringBuffer(this._searchFilter);
        LDAPLoginModule.substitute(stringBuffer, "%s", this._username);
        String string = this.userSearch(context, this._userDNbase, stringBuffer.toString());
        if (string == null) {
            String string2 = sm.getString("ldaplm.usernotfound", this._username);
            throw new LoginException(string2);
        }
        DirContext dirContext = this.bindAsUser(this._ctxF, this._url, string, this._password, this._authMechanism);
        if (dirContext == null) {
            String string3 = sm.getString("ldaplm.bindfailed", string);
            throw new LoginException(string3);
        }
        stringBuffer = new StringBuffer(this._grpSearchFilter);
        LDAPLoginModule.substitute(stringBuffer, "%s", this._username);
        LDAPLoginModule.substitute(stringBuffer, "%d", string);
        String string4 = stringBuffer.toString();
        String[] stringArray = this.groupSearch(dirContext, this._grpDNbase, string4, this._grpTarget);
        try {
            dirContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("Group search filter: " + string4);
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("Group memberships found: ");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer2.append(" " + stringArray[i]);
                }
            } else {
                stringBuffer2.append("(null)");
            }
            this._logger.finest(stringBuffer2.toString());
        }
        this._ldapRealm.setGroupNames(this._username, stringArray);
        this._logger.finest("LDAP login succeeded for: " + this._username);
        return this.commitAuthentication(this._username, this._password, this._currentRealm, stringArray);
    }

    private String userSearch(Context context, String string, String string2) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("search: baseDN: " + string + "  filter: " + string2);
        }
        String string3 = null;
        DirContext dirContext = (DirContext)context;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(this._dnOnly);
        searchControls.setSearchScope(2);
        searchControls.setCountLimit(1L);
        try {
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, string2, searchControls);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(searchResult.getName());
                if (searchResult.isRelative()) {
                    stringBuffer.append(",");
                    stringBuffer.append(string);
                }
                string3 = stringBuffer.toString();
                this._logger.finest("Found user DN: " + string3);
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", string2);
            this._logger.log(Level.WARNING, "security.exception", exception);
        }
        return string3;
    }

    private DirContext bindAsUser(String string, String string2, String string3, String string4, String string5) {
        InitialDirContext initialDirContext;
        block2: {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", string);
            properties.put("java.naming.provider.url", string2);
            properties.put("java.naming.security.principal", string3);
            properties.put("java.naming.security.credentials", string4);
            properties.put("java.naming.security.authentication", string5);
            initialDirContext = null;
            try {
                initialDirContext = new InitialDirContext(properties);
            }
            catch (Exception exception) {
                if (!this._logger.isLoggable(Level.FINEST)) break block2;
                this._logger.finest("Error binding to directory as: " + string3);
                this._logger.finest("Exception from JNDI: " + exception.toString());
            }
        }
        return initialDirContext;
    }

    private String[] groupSearch(DirContext dirContext, String string, String string2, String string3) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = new String[]{string3};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, string2, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute attribute = searchResult.getAttributes().get(string3);
                int n = attribute.size();
                for (int i = 0; i < n; ++i) {
                    String string4 = (String)attribute.get(i);
                    arrayList.add(string4);
                }
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", string2);
            this._logger.log(Level.WARNING, "security.exception", exception);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static void substitute(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.indexOf(string);
        while (n >= 0) {
            stringBuffer.replace(n, n + string.length(), string2);
            n = stringBuffer.indexOf(string);
        }
    }
}

