/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.sun.web.admin.beans.DAVLockInfo;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class DavUtil {
    public static final String DL_ATTR_URL = "url";
    public static final String DL_ATTR_OWNER = "owner";
    public static final String DL_ATTR_TIMEOUT = "timeout";
    public static final String DL_ATTR_LOCKTYPE = "locktype";
    public static final String DL_ATTR_LOCKSCOPE = "lockscope";
    public static final String DL_ATTR_OPQTOKEN = "opaquelocktoken";
    public static final String DL_ATTR_SEPARATOR = "|";
    public static final String DL_LOCK_TIMEOUT_DEFAULT = "DOES NOT EXPIRE";
    private static LockInfoComparator lic = new LockInfoComparator();

    public static native String[] getNativeLockInfo(String var0, String var1);

    public static native boolean expireLock(String var0, String var1, String var2);

    public static boolean checkForDuplicate(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl;
        block6: {
            bl = false;
            try {
                XmlNode xmlNode;
                XmlNode xmlNode2 = DavUtil.getVSNode(string, string2, string4, string3);
                if (xmlNode2 == null) {
                    throw new Exception("vsnode is non-existent, we are in lalala...land");
                }
                Iterator iterator = xmlNode2.iterate("DAV");
                if (!iterator.hasNext() || (xmlNode = (XmlNode)iterator.next()) == null) break block6;
                Iterator iterator2 = xmlNode.iterate("DAVCOLLECTION");
                while (iterator2.hasNext()) {
                    xmlNode = (XmlNode)iterator2.next();
                    String string7 = xmlNode.getString("uri", null);
                    String string8 = xmlNode.getString("sourceuri", null);
                    if (string7 != null && string5 != null && string7.equals(string5)) {
                        bl = true;
                    } else {
                        if (string8 == null || string6 == null || !string8.equals(string6)) continue;
                        bl = true;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String[] getLockDBs(String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            XmlNode xmlNode = DavUtil.getVSNode(string2, string3, string, string4);
            if (xmlNode == null) {
                throw new Exception("<VS> element null for id : " + string);
            }
            Iterator iterator = xmlNode.iterate("DAV");
            if (iterator.hasNext()) {
                XmlNode xmlNode2 = (XmlNode)iterator.next();
                String string5 = xmlNode2.getString("lockdb", null);
                if (string5 != null && !string5.equals("")) {
                    string5 = SlashUtil.de_slashes(string5);
                    arrayList.add(string5);
                }
                Iterator iterator2 = xmlNode2.iterate("DAVCOLLECTION");
                while (iterator2.hasNext()) {
                    xmlNode2 = (XmlNode)iterator2.next();
                    string5 = xmlNode2.getString("lockdb", null);
                    if (string5 == null || string5.equals("") || DavUtil.contains(arrayList, string5)) continue;
                    string5 = SlashUtil.de_slashes(string5);
                    arrayList.add(string5);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("DavUtil.getLockDBs --> " + exception);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static HashMap getURIsForLockDBs(String string, String string2, String string3, String string4, String[] stringArray) {
        HashMap hashMap = new HashMap();
        try {
            XmlNode xmlNode;
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(SlashUtil.de_slashes(stringArray[i]), new ArrayList());
                }
            }
            if ((xmlNode = DavUtil.getVSNode(string2, string3, string, string4)) == null) {
                throw new Exception("<VS> element null for id : " + string);
            }
            Iterator iterator = xmlNode.iterate("DAV");
            if (iterator.hasNext()) {
                XmlNode xmlNode2 = (XmlNode)iterator.next();
                String string5 = xmlNode2.getString("lockdb", null);
                Iterator iterator2 = xmlNode2.iterate("DAVCOLLECTION");
                ArrayList arrayList = null;
                while (iterator2.hasNext()) {
                    xmlNode2 = (XmlNode)iterator2.next();
                    String string6 = xmlNode2.getString("lockdb", null);
                    String string7 = xmlNode2.getString("uri", null);
                    if (string6 == null || string6.equals("")) {
                        arrayList = (ArrayList)hashMap.get(string5);
                        arrayList.add(string7);
                        continue;
                    }
                    arrayList = (ArrayList)hashMap.get(string6);
                    arrayList.add(string7);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("DavUtil.getURIsforLockDBs --> " + exception);
        }
        return hashMap;
    }

    public static String[] getAllURIs(String string, String string2, String string3, String string4) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        XmlNode xmlNode = DavUtil.getVSNode(string2, string3, string, string4);
        if (xmlNode == null) {
            throw new Exception("<VS> element null for id : " + string);
        }
        Iterator iterator = xmlNode.iterate("DAV");
        if (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string5 = xmlNode2.getString("lockdb", null);
            Iterator iterator2 = xmlNode2.iterate("DAVCOLLECTION");
            while (iterator2.hasNext()) {
                xmlNode2 = (XmlNode)iterator2.next();
                String string6 = xmlNode2.getString("uri", null);
                arrayList.add(string6);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static DAVLockInfo[] getLockInfo(String string, String string2) {
        String[] stringArray = DavUtil.getNativeLockInfo(string, string2);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], DL_ATTR_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).startsWith(DL_ATTR_URL)) {
                    string3 = ((String)object).substring(((String)object).indexOf("=") + 1);
                }
                if (((String)object).startsWith(DL_ATTR_OWNER)) {
                    string4 = ((String)object).substring(((String)object).indexOf("=") + 1);
                }
                if (((String)object).startsWith(DL_ATTR_LOCKSCOPE)) {
                    string5 = ((String)object).substring(((String)object).indexOf("=") + 1);
                }
                if (((String)object).startsWith(DL_ATTR_TIMEOUT)) {
                    string6 = ((String)object).substring(((String)object).indexOf("=") + 1);
                }
                String string8 = string6 = string6 == null ? DL_LOCK_TIMEOUT_DEFAULT : string6;
                if (!((String)object).startsWith(DL_ATTR_OPQTOKEN)) continue;
                string7 = ((String)object).substring(((String)object).indexOf("=") + 1);
            }
            object = new DAVLockInfo(string3, string4, string6);
            ((DAVLockInfo)object).setLockScope(string5);
            ((DAVLockInfo)object).setLockToken(string7);
            arrayList.add(object);
        }
        DAVLockInfo[] dAVLockInfoArray = DavUtil.sort(arrayList);
        if (dAVLockInfoArray == null || dAVLockInfoArray.length == 0) {
            return arrayList.toArray(new DAVLockInfo[stringArray.length]);
        }
        return dAVLockInfoArray;
    }

    public static XmlNode getVSNode(String string, String string2, String string3, String string4) {
        XmlNode xmlNode = null;
        try {
            String string5 = SlashUtil.de_slashes(string) + '/' + string2;
            String string6 = null;
            string6 = string2.equals("https-admserv") ? string5 + "/config/server.xml" : string5 + "/conf_bk/server.xml";
            XmlConfig xmlConfig = new XmlConfig(string6);
            XmlNode xmlNode2 = xmlConfig.parseConfig();
            XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode2);
            if (string3 == null) {
                throw new Exception("cannot get to <VS> node without a valid vsid");
            }
            if (string4 == null) {
                string4 = xmlNodeWrapper.getParentClassName(string3);
            }
            xmlNode = xmlNodeWrapper.getVSNode(string4, string3);
        }
        catch (Exception exception) {
            System.out.println("DavUtil.getVSNode --> " + exception);
        }
        return xmlNode;
    }

    private static DAVLockInfo[] sort(List list) {
        ArrayList arrayList = (ArrayList)list;
        if (lic == null || list == null || list.size() < 3) {
            return list.toArray(new DAVLockInfo[list.size()]);
        }
        DAVLockInfo[] dAVLockInfoArray = new DAVLockInfo[arrayList.size()];
        dAVLockInfoArray = arrayList.toArray(dAVLockInfoArray);
        Arrays.sort(dAVLockInfoArray, lic);
        return dAVLockInfoArray;
    }

    private static boolean contains(ArrayList arrayList, String string) {
        string = SlashUtil.de_slashes(string);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!(string2 = SlashUtil.de_slashes(string2)).equals(string)) continue;
            return true;
        }
        return false;
    }

    static {
        System.loadLibrary("AdminNativeUtil");
    }

    private static class LockInfoComparator
    implements Comparator {
        private LockInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            DAVLockInfo dAVLockInfo = (DAVLockInfo)object;
            DAVLockInfo dAVLockInfo2 = (DAVLockInfo)object2;
            if (dAVLockInfo.getURL().compareTo(dAVLockInfo2.getURL()) > 0) {
                return 1;
            }
            if (dAVLockInfo.getURL().compareTo(dAVLockInfo2.getURL()) < 0) {
                return -1;
            }
            return 0;
        }
    }
}

