/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.XmlNode;
import java.io.IOException;

public class Realm {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String serverXml_ = null;
    private String instanceName_ = null;
    private String realmName_ = null;
    private XmlNode realmNode_ = null;
    private int numONodes = 0;
    private XmlNode[] propertyNodes = null;
    private String[] propertyNames = null;
    private String[] propertyValues = null;

    public void init(String string, String string2, String string3) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        this.realmName_ = string3.trim();
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.serverXml_ = this.serverRoot_ + "/" + this.instanceName_ + "/" + "conf_bk" + "/" + "server.xml";
        this.realmNode_ = this.wrapperXmlNode_.getAuthRealmNode(this.realmName_);
        if (this.realmNode_ != null) {
            this.loadProperties();
        }
    }

    private void loadProperties() {
        this.propertyNodes = this.wrapperXmlNode_.getAllPropertyNodes(this.realmNode_);
        if (this.propertyNodes != null) {
            this.numONodes = this.propertyNodes.length;
            this.propertyNames = new String[this.numONodes];
            this.propertyValues = new String[this.numONodes];
            for (int i = 0; i < this.numONodes; ++i) {
                this.propertyNames[i] = this.propertyNodes[i].getString("name", null);
                this.propertyValues[i] = this.propertyNodes[i].getString("value", null);
            }
        } else {
            this.numONodes = 0;
            this.propertyNames = null;
            this.propertyValues = null;
        }
    }

    public boolean exists() {
        return this.realmNode_ != null;
    }

    public String getName() {
        return this.realmName_;
    }

    public String getClassName() {
        return this.realmNode_.getString("classname", null);
    }

    public void setClassName(String string) {
        this.realmNode_.setAttribute("classname", string);
    }

    public int getNumOProperties() {
        return this.numONodes;
    }

    public String getPropertyName(int n) {
        return this.propertyNames[n];
    }

    public String getPropertyValue(int n) {
        return this.propertyValues[n];
    }

    public String getPropertyValue(String string) {
        for (int i = 0; i < this.numONodes; ++i) {
            if (!string.equals(this.propertyNames[i])) continue;
            return this.propertyValues[i];
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        this.wrapperXmlNode_.setProperty(this.realmNode_, string, string2);
        this.loadProperties();
    }

    public void removeProperty(String string) {
        this.wrapperXmlNode_.removeProperty(this.realmNode_, string);
        this.loadProperties();
    }

    public boolean saveXMLConfiguration() throws IOException {
        XmlNode xmlNode = null;
        if (this.wrapperXmlNode_ != null) {
            xmlNode = this.wrapperXmlNode_.getServerRootNode();
        }
        AdminConfig.writeXmlToFile(xmlNode, this.serverRoot_, this.serverXml_);
        return true;
    }
}

