/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.DeployException;
import com.sun.web.admin.beans.MagObj;
import com.sun.web.admin.beans.WebAppBean;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.MiscUtil;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.UnZips;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipException;

public class DeployBean {
    private String rootDir_;
    private String instanceName_;
    private String instanceDir_;
    private String vsID_;
    private XmlNode vsNode_;
    private String uri_;
    private String ctxRoot_;
    private String name_;
    private boolean newdirCreated_ = false;
    private XmlNode rootNode_;
    private boolean useBackup_;
    private boolean autoReconfig_;

    public DeployBean(String string, String string2, String string3) throws IllegalArgumentException, DeployException {
        this(string, string2, string3, true);
    }

    public DeployBean(String string, String string2, String string3, boolean bl) throws IllegalArgumentException, DeployException {
        this(string, string2, string3, "/dummy", bl);
    }

    public DeployBean(String string, String string2, String string3, String string4) throws IllegalArgumentException, DeployException {
        this(string, string2, string3, string4, true);
    }

    public DeployBean(String string, String string2, String string3, String string4, boolean bl) throws IllegalArgumentException, DeployException {
        this.useBackup_ = bl;
        this.validateParameters(string, string2, string3, string4);
        if (this.instanceName_.equals("https-admserv")) {
            this.useBackup_ = false;
        }
        String string5 = null;
        string5 = this.useBackup_ ? this.instanceDir_ + "/conf_bk/server.xml" : this.instanceDir_ + "/config/server.xml";
        this.rootNode_ = this.getRootNode(string5);
        this.getVSNode();
        this.setAutoReconfig(false);
    }

    public void deploy(String string, String string2) throws DeployException {
        Object object;
        XmlNode xmlNode = this.getWebAppNode();
        if (string.endsWith(".war")) {
            object = string.indexOf(92) != -1 ? "\\" : "/";
            this.name_ = string.substring(string.lastIndexOf((String)object) + 1, string.lastIndexOf(46));
        } else {
            this.name_ = "user-web-module";
        }
        if (string2 == null) {
            if (xmlNode != null && (object = xmlNode.findChildNode("path")) != null) {
                string2 = ((XmlNode)object).getValue();
            }
        } else if (xmlNode != null) {
            object = null;
            XmlNode xmlNode2 = xmlNode.findChildNode("path");
            if (xmlNode2 != null && !string2.equals(xmlNode2.getValue())) {
                throw new DeployException(AdminConfig.getProp("DeployBean.UriExists", this.uri_));
            }
        }
        if (string2 != null) {
            if (!this.isAbsolutePath(string2)) {
                throw new DeployException(AdminConfig.getProp("GeneralError.NotAbsolutePath", string2));
            }
            string2 = this.getAbsolutePath(string2);
        }
        if (string != null) {
            if (!this.isAbsolutePath(string)) {
                throw new DeployException(AdminConfig.getProp("GeneralError.NotAbsolutePath", string));
            }
            if (this.isDir(string = this.getAbsolutePath(string))) {
                string2 = string;
            }
        }
        if (string2 == null) {
            throw new DeployException(AdminConfig.getProp("DeployBean.EmptyDir", this.uri_));
        }
        if (string == null) {
            throw new DeployException(AdminConfig.getProp("DeployBean.EmptyWARName"));
        }
        if (!string2.equals(string)) {
            this.createWebAppDir(string2);
            this.extractWarFileContents(string, string2);
        }
        if (xmlNode == null) {
            object = new XmlNode(this.vsNode_, "WEBAPP", "", "", 0);
            ((XmlNode)object).addChild("uri", this.uri_, "", 0, true);
            ((XmlNode)object).addChild("path", string2, "", 0, true);
            ((XmlNode)object).addChild("enabled", "true", "", 0, true);
            this.vsNode_.addChild((XmlNode)object);
        } else {
            object = xmlNode.findChildNode("path");
            if (object != null) {
                ((XmlNode)object).setValue(string2);
            }
        }
        this.saveXMLConfiguration();
        if (this.autoReconfig()) {
            this.reconfigSilently();
        }
    }

    public void redeploy(String string) throws DeployException {
        this.deploy(string, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(boolean bl) throws DeployException {
        XmlNode xmlNode = this.getWebAppNode();
        if (xmlNode == null) throw new DeployException(AdminConfig.getProp("DeployBean.WebAppNotFound", this.uri_, "server.xml"));
        String string = xmlNode.getString("path", null);
        this.vsNode_.removeChild(xmlNode);
        this.saveXMLConfiguration();
        if (this.autoReconfig()) {
            this.reconfigSilently();
        }
        if (string == null) throw new DeployException(AdminConfig.getProp("DeployBean.DirectoryNotFound", this.uri_, "server.xml"));
        if (!bl) return;
        this.rm(string);
    }

    public void enable() throws DeployException {
        this.changeStatus("true");
    }

    public void disable() throws DeployException {
        this.changeStatus("false");
    }

    public void edit(String string) throws IllegalArgumentException, DeployException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyNewURI", this.uri_));
        }
        string = SlashUtil.de_slashes(string.trim());
        XmlNode xmlNode = this.getWebAppNode();
        if (xmlNode != null) {
            XmlNode xmlNode2 = xmlNode.findChildNode("uri");
            if (xmlNode2 != null) {
                if (string.indexOf(47) == -1) {
                    string = "/" + string;
                }
                xmlNode2.setValue(string);
            }
            this.saveXMLConfiguration();
            if (this.autoReconfig()) {
                this.reconfigSilently();
            }
        } else {
            throw new DeployException(AdminConfig.getProp("DeployBean.WebAppNotFound", this.uri_, "server.xml"));
        }
    }

    public Enumeration list() throws DeployException {
        Vector<WebAppBean> vector = new Vector<WebAppBean>();
        Iterator iterator = this.vsNode_.iterate("WEBAPP");
        while (iterator.hasNext()) {
            XmlNode xmlNode = (XmlNode)iterator.next();
            String string = xmlNode.getString("uri", null);
            String string2 = xmlNode.getString("path", null);
            String string3 = xmlNode.getString("enabled", "true");
            vector.add(new WebAppBean(string, string2, string3));
        }
        return vector.elements();
    }

    public void reconfig() throws DeployException {
        String string = null;
        string = File.separatorChar == '\\' ? this.instanceDir_ + "/reconfig.bat" : this.instanceDir_ + "/reconfig";
        Runtime runtime = Runtime.getRuntime();
        try {
            int n;
            BufferedInputStream bufferedInputStream;
            Process process = runtime.exec(string);
            if (process != null) {
                process.waitFor();
            }
            if ((bufferedInputStream = new BufferedInputStream(process.getErrorStream())) != null && (n = bufferedInputStream.available()) > 0) {
                byte[] byArray = new byte[n];
                while (bufferedInputStream.available() > 0) {
                    bufferedInputStream.read(byArray, 0, n);
                }
                throw new DeployException(new String(byArray));
            }
        }
        catch (IOException iOException) {
            throw new DeployException(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new DeployException(interruptedException.getMessage());
        }
    }

    private void reconfigSilently() {
        try {
            this.reconfig();
        }
        catch (DeployException deployException) {
            // empty catch block
        }
    }

    private void validateParameters(String string, String string2, String string3, String string4) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyServerRoot"));
        }
        this.rootDir_ = SlashUtil.de_slashes(string);
        if (this.rootDir_.length() == 0) {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyServerRoot"));
        }
        if (string2 != null) {
            this.instanceName_ = string2.trim();
            if (this.instanceName_.length() == 0) {
                throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyServerInstance"));
            }
        } else {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyServerInstance"));
        }
        this.instanceDir_ = this.rootDir_ + '/' + this.instanceName_;
        if (string3 != null) {
            this.vsID_ = string3.trim();
            if (this.vsID_.length() == 0) {
                throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyVS"));
            }
        } else {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyVS"));
        }
        if (string4 != null) {
            this.uri_ = SlashUtil.de_slashes(string4.trim());
            this.ctxRoot_ = this.uri_.indexOf(47) != -1 ? this.uri_.substring(1) : this.uri_;
            if (this.uri_.length() == 0) {
                throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyURI"));
            }
        } else {
            throw new IllegalArgumentException(AdminConfig.getProp("DeployBean.EmptyURI"));
        }
    }

    private void changeStatus(String string) throws DeployException {
        XmlNode xmlNode = this.getWebAppNode();
        if (xmlNode != null) {
            XmlNode xmlNode2 = xmlNode.findChildNode("enabled");
            if (xmlNode2 != null) {
                xmlNode2.setValue(string);
            } else {
                xmlNode.addChild("enabled", string, "", 0, true);
            }
            this.saveXMLConfiguration();
            if (this.autoReconfig()) {
                this.reconfigSilently();
            }
        } else {
            throw new DeployException(AdminConfig.getProp("DeployBean.WebAppNotFound", this.uri_, "server.xml"));
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getURI() {
        return this.uri_;
    }

    public String getContextRoot() {
        return this.ctxRoot_;
    }

    public String getInstance() {
        return this.instanceName_;
    }

    public String getVSID() {
        return this.vsID_;
    }

    public boolean autoReconfig() {
        return this.autoReconfig_;
    }

    public boolean setAutoReconfig(boolean bl) {
        boolean bl2 = this.autoReconfig_;
        this.autoReconfig_ = bl;
        return bl2;
    }

    public XmlNode getVSNode() throws DeployException {
        if (this.vsNode_ != null) {
            return this.vsNode_;
        }
        String string = null;
        Object var2_2 = null;
        string = this.useBackup_ ? this.instanceDir_ + "/conf_bk/server.xml" : this.instanceDir_ + "/config/server.xml";
        Object var3_3 = null;
        boolean bl = false;
        XmlNode xmlNode = this.getRootNode(string);
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        String string2 = xmlNodeWrapper.getParentClassName(this.vsID_);
        this.vsNode_ = xmlNodeWrapper.getVSNode(string2, this.vsID_);
        if (this.vsNode_ == null) {
            throw new DeployException("DeployBean.getVSNode(), node not found in server.xml against VS id : " + this.vsID_);
        }
        return this.vsNode_;
    }

    private String getWebAppFilename() throws DeployException {
        throw new DeployException(AdminConfig.getProp("DeployBean.WebAppsNotConfigured", this.vsID_, "server.xml"));
    }

    private XmlNode getRootNode(String string) throws DeployException {
        return this.getRootNode(string, null, null);
    }

    private XmlNode getRootNode(String string, String string2, String string3) throws DeployException {
        if (!this.isFile(string)) {
            throw new DeployException(AdminConfig.getProp("GeneralError.ReadFailed", string));
        }
        XmlNode xmlNode = null;
        try {
            XmlConfig xmlConfig = string2 != null && string3 != null ? new XmlConfig(string, string2, string3) : new XmlConfig(string);
            xmlNode = xmlConfig.parseConfig();
        }
        catch (Exception exception) {
            throw new DeployException(AdminConfig.getProp("GeneralError.XMLParseError", string, exception.getMessage()));
        }
        this.rootNode_ = xmlNode;
        return xmlNode;
    }

    private XmlNode getWebAppNode() {
        XmlNode xmlNode = null;
        if (this.vsNode_ == null) {
            try {
                this.vsNode_ = this.getVSNode();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.vsNode_ != null) {
            String string;
            Iterator iterator = this.vsNode_.iterate("WEBAPP");
            while (iterator.hasNext() && !this.uri_.equals((string = (xmlNode = (XmlNode)iterator.next()).getString("uri", "")).trim())) {
                xmlNode = null;
            }
        }
        return xmlNode;
    }

    private void createWebAppDir(String string) throws DeployException {
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new DeployException(AdminConfig.getProp("GeneralError.NotDirectory", string));
                }
            } else {
                if (!file.mkdirs()) {
                    throw new DeployException(AdminConfig.getProp("GeneralError.DirectoryCreateError", string));
                }
                if (!file.canWrite()) {
                    throw new DeployException(AdminConfig.getProp("GeneralError.DirectoryNotWritable", string));
                }
                this.newdirCreated_ = true;
            }
        }
    }

    private void saveXMLConfiguration() throws DeployException {
        try {
            String string = null;
            string = this.useBackup_ ? this.instanceDir_ + "/conf_bk/server.xml" : this.instanceDir_ + "/config/server.xml";
            XmlNode xmlNode = this.rootNode_.findConfig("SERVER");
            this.writeXMLToFile(xmlNode, string);
        }
        catch (Exception exception) {
            throw new DeployException(AdminConfig.getProp("GeneralError.WriteFailed", "server.xml", exception.getMessage()));
        }
    }

    private void writeXMLToFile(XmlNode xmlNode, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")));
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<!--");
        printWriter.println("   Copyright (c) 2003 Sun Microsystems, Inc.  All rights reserved.");
        printWriter.println("   Use is subject to license terms.");
        printWriter.println("-->");
        this.rootDir_ = SlashUtil.de_slashes(this.rootDir_);
        if (!this.rootDir_.startsWith("/")) {
            this.rootDir_ = "/" + this.rootDir_;
        }
        String string2 = "<!DOCTYPE SERVER PUBLIC \"-//Sun Microsystems Inc.//DTD Sun ONE Web Server 6.1//EN\" \"file://" + this.rootDir_ + "/bin/https/dtds/sun-web-server_6_1.dtd\">";
        printWriter.println(string2);
        xmlNode.writexml(printWriter, 0);
        printWriter.close();
        fileOutputStream.close();
    }

    private void extractWarFileContents(String string, String string2) throws DeployException {
        if (!this.isFile(string)) {
            throw new DeployException(AdminConfig.getProp("DeployBean.invalidWAR", string));
        }
        try {
            UnZips.unzipit(string, string2);
        }
        catch (ZipException zipException) {
            throw new DeployException(zipException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeployException(illegalArgumentException.getMessage());
        }
        if (this.newdirCreated_) {
            MagObj magObj = new MagObj();
            try {
                magObj.init(this.rootDir_, this.instanceName_);
                MiscUtil.changeOwner(magObj.get_mag_var("User"), string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.newdirCreated_ = false;
        }
    }

    private boolean isFile(String string) {
        File file;
        boolean bl = false;
        if (string != null && string.trim().length() > 0 && (file = new File(string)).exists() && file.canRead() && file.length() > 0L) {
            bl = true;
        }
        return bl;
    }

    private boolean isDir(String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            bl = this.isDir(file);
        }
        return bl;
    }

    private boolean isDir(File file) {
        boolean bl = false;
        if (file != null && file.exists() && file.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    private boolean isAbsolutePath(String string) {
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            return file.isAbsolute();
        }
        return false;
    }

    private String getAbsolutePath(String string) {
        String string2 = null;
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            try {
                string2 = file.getCanonicalPath();
                if (string2 != null) {
                    string2 = SlashUtil.de_slashes(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private boolean rm(String string) {
        if (string != null) {
            return this.rm(new File(string));
        }
        return false;
    }

    private boolean rm(File file) {
        boolean bl = true;
        if (file != null) {
            File[] fileArray;
            if (file.isDirectory() && (fileArray = file.listFiles()).length > 0) {
                for (int i = 0; i < fileArray.length && (bl = this.rm(fileArray[i])); ++i) {
                }
            }
            if (bl) {
                bl = file.delete();
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

