/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;
import org.apache.taglibs.standard.tag.common.fmt.TimeZoneSupport;

public abstract class ParseDateSupport
extends BodyTagSupport {
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String DATETIME = "both";
    protected String value;
    protected String type;
    protected String pattern;
    protected Object timeZone;
    protected Locale parseLocale;
    protected String dateStyle;
    protected String timeStyle;
    private String var;
    private int scope;

    public ParseDateSupport() {
        this.init();
    }

    private void init() {
        this.timeStyle = null;
        this.dateStyle = null;
        this.type = null;
        this.var = null;
        this.pattern = null;
        this.value = null;
        this.timeZone = null;
        this.scope = 1;
        this.parseLocale = null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        if (this.value == null) {
            BodyContent bc = null;
            String bcs = null;
            bc = this.getBodyContent();
            if (bc != null && (bcs = bc.getString()) != null) {
                this.value = bcs.trim();
            }
        }
        if (this.value == null || this.value.equals("")) {
            if (this.var == null) return 6;
            this.pageContext.removeAttribute(this.var, this.scope);
            return 6;
        }
        Locale locale = this.parseLocale;
        if (locale == null) {
            locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, false, DateFormat.getAvailableLocales());
        }
        if (locale == null) {
            throw new JspException(Resources.getMessage("PARSE_DATE_NO_PARSE_LOCALE"));
        }
        DateFormat parser = this.createParser(locale);
        if (this.pattern != null) {
            try {
                ((SimpleDateFormat)parser).applyPattern(this.pattern);
            }
            catch (ClassCastException cce) {
                parser = new SimpleDateFormat(this.pattern, locale);
            }
        }
        TimeZone tz = null;
        if (this.timeZone instanceof String && ((String)this.timeZone).equals("")) {
            this.timeZone = null;
        }
        if (this.timeZone != null) {
            if (this.timeZone instanceof String) {
                tz = TimeZone.getTimeZone((String)this.timeZone);
            } else {
                if (!(this.timeZone instanceof TimeZone)) throw new JspException(Resources.getMessage("PARSE_DATE_BAD_TIMEZONE"));
                tz = (TimeZone)this.timeZone;
            }
        } else {
            tz = TimeZoneSupport.getTimeZone(this.pageContext, (Tag)this);
        }
        if (tz != null) {
            parser.setTimeZone(tz);
        }
        Date parsed = null;
        try {
            parsed = parser.parse(this.value);
        }
        catch (ParseException pe) {
            throw new JspException(Resources.getMessage("PARSE_DATE_PARSE_ERROR", this.value), (Throwable)pe);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)parsed, this.scope);
            return 6;
        }
        try {
            this.pageContext.getOut().print((Object)parsed);
            return 6;
        }
        catch (IOException ioe) {
            throw new JspTagException(ioe.getMessage());
        }
    }

    public void release() {
        this.init();
    }

    private DateFormat createParser(Locale loc) throws JspException {
        DateFormat parser = null;
        if (this.type == null || DATE.equalsIgnoreCase(this.type)) {
            parser = DateFormat.getDateInstance(Util.getStyle(this.dateStyle, "PARSE_DATE_INVALID_DATE_STYLE"), loc);
        } else if (TIME.equalsIgnoreCase(this.type)) {
            parser = DateFormat.getTimeInstance(Util.getStyle(this.timeStyle, "PARSE_DATE_INVALID_TIME_STYLE"), loc);
        } else if (DATETIME.equalsIgnoreCase(this.type)) {
            parser = DateFormat.getDateTimeInstance(Util.getStyle(this.dateStyle, "PARSE_DATE_INVALID_DATE_STYLE"), Util.getStyle(this.timeStyle, "PARSE_DATE_INVALID_TIME_STYLE"), loc);
        } else {
            throw new JspException(Resources.getMessage("PARSE_DATE_INVALID_TYPE", this.type));
        }
        parser.setLenient(false);
        return parser;
    }

    static {
        DATE = DATE;
        TIME = TIME;
        DATETIME = DATETIME;
    }
}

