/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarClassLoader
extends ClassLoader {
    private Hashtable jarContents;

    /*
     * WARNING - void declaration
     */
    public JarClassLoader(String jarFileName) throws IOException {
        ZipEntry je;
        Hashtable<String, Integer> sizes = new Hashtable<String, Integer>();
        ZipFile zf = new ZipFile(jarFileName);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            sizes.put(ze.getName().replace('\\', '/'), new Integer((int)ze.getSize()));
        }
        zf.close();
        this.jarContents = new Hashtable();
        ZipInputStream jis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFileName)));
        while ((je = jis.getNextEntry()) != null) {
            void var6_6;
            if (var6_6.isDirectory()) continue;
            String name = var6_6.getName().replace('\\', '/');
            int size = 0;
            size = (int)var6_6.getSize();
            if (size < 0) {
                size = (Integer)sizes.get(name);
            }
            byte[] ba = new byte[size];
            int bytes_read = 0;
            while (bytes_read != size) {
                int r = jis.read(ba, bytes_read, size - bytes_read);
                if (r < 0) break;
                bytes_read += r;
            }
            if (bytes_read != size) {
                throw new IOException("cannot read entry");
            }
            this.jarContents.put(name, ba);
        }
        jis.close();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/') + ".class";
        byte[] bytes = (byte[])this.jarContents.get(path);
        if (bytes == null) {
            throw new ClassNotFoundException();
        }
        System.out.println("Find " + name);
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

