/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ServerConfig {
    private static ServerConfig sc;
    private Properties props;
    private static final String MODULE = "iim_server";
    private static final String MODULEKEY = "iim.comm.modules";

    private ServerConfig() {
    }

    public static synchronized ServerConfig getServerConfig() {
        if (sc == null) {
            sc = new ServerConfig();
            sc.load();
        }
        return sc;
    }

    private boolean load() {
        boolean ret = true;
        this.props = new Properties();
        try {
            File f = new File(NMS.getConfigurationFile());
            FileInputStream is = new FileInputStream(f);
            this.props.load(is);
            String module = this.props.getProperty(MODULEKEY, "");
            if (!module.equals("") && module.indexOf(MODULE) == -1) {
                Log.out.error("Configuation file is not for iim_server");
                this.props = null;
                ret = false;
            }
            is.close();
            return ret;
        }
        catch (Exception e) {
            Log.out.error("Could not load configuration file " + e.toString());
            Log.out.printStackTrace(e);
            return false;
        }
    }

    public String getSetting(String name, String defaultValue) {
        String s = this.props.getProperty(name, defaultValue);
        if (s != null) {
            s.trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    public String getSetting(String name) {
        String s = this.getSetting(name, null);
        if (s != null) {
            s.trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    public String[] getSettingKeys(String startswith) {
        Vector<String> v = new Vector<String>();
        Enumeration e = ((Hashtable)this.props).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(startswith)) continue;
            v.add(key);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }
}

