/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSConnection;
import com.iplanet.im.server.RoomStorage;
import com.iplanet.im.server.Settings;
import com.iplanet.im.server.Storage;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.StringUtility;
import com.sun.im.xmpp.RosterDocument;
import com.sun.im.xmpp.RosterItem;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public final class RosterManager {
    private static Hashtable _uid2roster = new Hashtable();
    private static Hashtable _uid2croster = new Hashtable();
    private static Hashtable _uid2nroster = new Hashtable();
    private static UserSettings us = UserSettings.get();
    private static Settings settings = Settings.getSettings();
    private static final String ID_TOPIC_DESCRIPTOR = "topic.sub.";
    private static final String ID_VERSION = "version";

    protected static void removeSubscription(Destination d, iIMUser u) throws Exception {
        if (d instanceof Room) {
            RosterDocument roster = RosterManager.getConferenceRoster(u);
            roster.removeItem(d.getFQName());
            us.saveConferenceRoster(u, roster);
        } else if (d instanceof Topic) {
            RosterDocument roster = RosterManager.getNewsRoster(u);
            roster.removeItem(d.getFQName());
            us.saveNewsRoster(u, roster);
        }
    }

    protected static void addSubscription(Destination d, iIMUser u) throws Exception {
        if (d instanceof Room) {
            RosterDocument roster = RosterManager.getConferenceRoster(u);
            RosterItem item = new RosterItem(d.getFQName(), d.getName(), null);
            roster.updateRoster(item);
            us.saveConferenceRoster(u, roster);
        } else if (d instanceof Topic) {
            RosterDocument roster = RosterManager.getNewsRoster(u);
            RosterItem item = new RosterItem(d.getFQName(), d.getName(), null);
            roster.updateRoster(item);
            us.saveNewsRoster(u, roster);
        }
    }

    private static RosterDocument getRoster(iIMUser u) throws Exception {
        RosterDocument roster = null;
        iIMUser iIMUser2 = u;
        synchronized (iIMUser2) {
            roster = us.getRoster(u);
            if (roster == null) {
                roster = new RosterDocument();
            }
        }
        return roster;
    }

    private static RosterDocument getConferenceRoster(iIMUser u) throws Exception {
        RosterDocument roster = null;
        iIMUser iIMUser2 = u;
        synchronized (iIMUser2) {
            roster = us.getConferenceRoster(u);
            if (roster == null) {
                roster = new RosterDocument();
            }
        }
        return roster;
    }

    private static RosterDocument getNewsRoster(iIMUser u) throws Exception {
        RosterDocument roster = null;
        iIMUser iIMUser2 = u;
        synchronized (iIMUser2) {
            roster = us.getNewsRoster(u);
            if (roster == null) {
                roster = new RosterDocument();
            }
        }
        return roster;
    }

    private static synchronized void releaseRoster(String uid) {
        _uid2roster.remove(uid);
    }

    protected static Room[] getSubscribedRooms(iIMUser u, NMSConnection nmsConnection) {
        try {
            LinkedList<Room> l = new LinkedList<Room>();
            RosterDocument roster = RosterManager.getConferenceRoster(u);
            _uid2croster.remove(u.getUID());
            if (roster == null || roster.size() == 0) {
                return null;
            }
            ArrayList<RosterItem> staleRosterItems = new ArrayList<RosterItem>();
            Iterator i = roster.getItems().iterator();
            while (i.hasNext()) {
                RosterItem ri = (RosterItem)i.next();
                String roomDomain = StringUtility.getDomainFromAddress(ri.getJID(), NMS.getName());
                String userDomain = u.getServer();
                if (userDomain.equalsIgnoreCase(roomDomain)) {
                    RoomStorage rs = RoomStorage.get(ri.getJID());
                    if (rs != null) {
                        l.add(rs.getRoom());
                        continue;
                    }
                    staleRosterItems.add(ri);
                    continue;
                }
                if (!userDomain.equalsIgnoreCase(NMS.getName())) continue;
                CommandData cd = Command.create((int)217, (Object)roomDomain, (Object)ri.getName(), (Object)new Integer(2));
                CommandData rep = nmsConnection.forwardToServer(roomDomain, cd);
                Room[] r = (Room[])Command.getReplyArg1((CommandData)rep);
                if (r != null && r.length > 0) {
                    int j = 0;
                    while (j < r.length) {
                        l.add(r[j]);
                        ++j;
                    }
                    continue;
                }
                staleRosterItems.add(ri);
            }
            if (l.size() == 0) {
                return null;
            }
            Room[] ra = new Room[l.size()];
            int n = 0;
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                ra[n++] = (Room)i2.next();
            }
            Iterator i3 = staleRosterItems.iterator();
            while (i3.hasNext()) {
                RosterItem ritem = (RosterItem)i3.next();
                roster.removeItem(ritem.getJID());
            }
            if (staleRosterItems.size() > 0) {
                us.saveConferenceRoster(u, roster);
            }
            return ra;
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.error("[RosterManager] failed to get rooms: " + e.toString());
            return null;
        }
    }

    protected static Topic[] getSubscribedTopics(iIMUser u) {
        try {
            LinkedList<Topic> l = new LinkedList<Topic>();
            RosterDocument roster = RosterManager.getNewsRoster(u);
            if (roster == null || roster.size() == 0) {
                return null;
            }
            Iterator i = roster.getItems().iterator();
            while (i.hasNext()) {
                RosterItem ri = (RosterItem)i.next();
                Storage ts = Storage.get(ri.getJID());
                if (ts == null) continue;
                l.add(ts.getTopic());
            }
            if (l.size() == 0) {
                return null;
            }
            Topic[] ta = new Topic[l.size()];
            int n = 0;
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                ta[n++] = (Topic)i2.next();
            }
            return ta;
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.error("[RosterManager] failed to get topics: " + e.toString());
            return null;
        }
    }

    public static final Properties migrate(iIMUser u, Properties props) {
        if (props == null || props.getProperty(ID_VERSION) != null) {
            return props;
        }
        Properties p = (Properties)((Hashtable)props).clone();
        try {
            RosterDocument roster = RosterManager.getNewsRoster(u);
            Enumeration e = ((Hashtable)p).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(ID_TOPIC_DESCRIPTOR)) continue;
                String id = p.getProperty(key);
                roster.updateRoster(new RosterItem(id, id, null));
                ((Hashtable)props).remove(key);
            }
            us.saveNewsRoster(u, roster);
            ((Hashtable)props).put(ID_VERSION, "1.1");
        }
        catch (Exception e) {
            Log.out.error("[RosterManager] failed to properties for " + u.getUID() + " - " + e.toString());
            Log.out.printStackTrace(e);
        }
        return props;
    }
}

