/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.AccessControlListImpl;
import com.iplanet.im.server.Counters;
import com.iplanet.im.server.DestinationAcl;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.RoomUser;
import com.sun.im.provider.AccessControlList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class RoomStorage {
    private static Hashtable storages = new Hashtable();
    protected Vector listeners = new Vector();
    private Room _room;
    private Object context = null;
    private boolean tempRoom;
    private AccessControlListImpl archiveAcl;
    private Hashtable _participants = new Hashtable();

    public void setContext(String key, Object o) {
        this.context = o;
    }

    public Object getContext(String key) {
        return this.context;
    }

    public static RoomStorage create(Room r, boolean temp) {
        Log.out.debug("PERF|BEGIN   RoomStorage.create " + r.getUID());
        String lcase = r.getFQName().toLowerCase();
        RoomStorage s = (RoomStorage)storages.get(lcase);
        if (s == null) {
            s = new RoomStorage(r, temp);
            storages.put(lcase, s);
            Counters.increment(Counters.CNT_CHAT_ROOMS);
            return s;
        }
        Log.out.warning("RoomStorage.create: " + r.getUID() + " already exisits.");
        s = null;
        Log.out.debug("PERF|END   RoomStorage.create " + r.getUID());
        return s;
    }

    public static RoomStorage get(String fqName) {
        return (RoomStorage)storages.get(fqName.toLowerCase());
    }

    public static RoomStorage get(Room r) {
        return RoomStorage.get(r.getFQName());
    }

    public static boolean remove(String fqName) {
        Object o = storages.remove(fqName.toLowerCase());
        if (o != null) {
            Counters.decrement(Counters.CNT_CHAT_ROOMS);
        }
        return o != null;
    }

    public static boolean remove(Room r) {
        return RoomStorage.remove(r.getFQName());
    }

    public static void removeAll() {
        storages.clear();
    }

    private RoomStorage(Room r, boolean temp) {
        this._room = r;
        this.tempRoom = temp;
        if (temp) {
            this.archiveAcl = new AccessControlListImpl(1);
        }
    }

    public String getName() {
        return this._room.getFQName();
    }

    public boolean isTempRoom() {
        return this.tempRoom;
    }

    public Room getRoom() {
        return this._room;
    }

    public void addMessage(RoomMsg m, RoomUser ru) {
        this.fireMessageAdded(m, ru);
    }

    protected void setArchive(iIMPrincipal p, boolean enable) {
        if (this.archiveAcl == null) {
            return;
        }
        if (enable) {
            Log.out.debug("ROOM " + this._room.getUID() + " Archive enabled for " + p.getUID());
            this.archiveAcl.addPrincipal(p, 2);
        } else {
            this.archiveAcl.removePrincipal(p);
            Log.out.debug("ROOM " + this._room.getUID() + " Archive disabled for " + p.getUID());
        }
    }

    protected AccessControlList getAccessControlList() {
        return this.archiveAcl;
    }

    public synchronized void addUser(RoomUser ru, boolean serverConnection, String note, int access) {
        Participant p;
        Log.out.debug("PERF|BEGIN RoomStorage.addUser " + this._room.getUID());
        boolean newParticipant = true;
        if (this.listeners.contains(ru)) {
            newParticipant = false;
        }
        if (newParticipant) {
            this.listeners.addElement(ru);
            Log.out.debug("User " + ru.getUser().getUID() + " added to " + this._room.getUID() + " listener=" + ru.hashCode());
        }
        this.fireUserAdded(ru.getUser(), ru, note);
        if (newParticipant || serverConnection) {
            Iterator i = this._participants.values().iterator();
            while (i.hasNext()) {
                p = (Participant)i.next();
                if (p.uid.equals(ru.getUser().getUID())) continue;
                ru.userAdded(this._room, p.uid, p.note);
            }
        }
        String uid = ru.getUser().getUID();
        p = new Participant(uid, note, access);
        this._participants.put(uid, p);
        Log.out.debug("PERF|END   RoomStorage.addUser " + this._room.getUID());
    }

    public synchronized void removeUser(RoomUser ru, boolean serverConnection) {
        String uid;
        Participant p;
        String note = null;
        iIMUser u = ru.getUser();
        if (u != null && (p = (Participant)this._participants.get(uid = u.getUID())) != null) {
            Counters.decrement(Counters.CNT_CHAT_SUBSCRIPTIONS);
            note = p.note;
            this._participants.remove(uid);
        }
        if (this.archiveAcl != null) {
            this.archiveAcl.removePrincipal((iIMPrincipal)u);
        }
        if (!serverConnection) {
            this.listeners.removeElement(ru);
        }
        if (this._participants.size() == 0) {
            this.listeners.clear();
        }
        if (this.listeners.size() != 0) {
            this.fireUserRemoved(ru.getUser(), note);
        } else if (this.tempRoom) {
            RoomStorage.remove(this._room);
        }
    }

    public int size() {
        return this.listeners.size();
    }

    protected void fireMessageAdded(RoomMsg m, RoomUser ru) {
        int size = this.listeners.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            RoomUser listener = (RoomUser)this.listeners.elementAt(i);
            if (ru != listener) {
                iIMUser u = listener.getUser();
                int listenerAccessLevel = 1;
                String uid = null;
                if (u != null) {
                    uid = u.getUID();
                    listenerAccessLevel = this.getParticipantAccess(uid);
                }
                if (u == null || this.isMember(uid) && listenerAccessLevel >= 2) {
                    listener.messageAdded(this, m);
                    if (u != null) {
                        Log.out.debug("Message relayed to " + uid);
                    } else {
                        Log.out.debug("Message relayed to other server");
                    }
                }
            }
            ++i;
        }
    }

    private void fireUserAdded(iIMUser u, RoomUser ru, String note) {
        Counters.increment(Counters.CNT_CHAT_SUBSCRIPTIONS);
        int size = this.listeners.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            RoomUser listener = (RoomUser)this.listeners.elementAt(i);
            if (ru != listener) {
                listener.userAdded(this, u, note);
            }
            ++i;
        }
    }

    private void fireUserRemoved(iIMUser u, String note) {
        int size = this.listeners.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            RoomUser listener = (RoomUser)this.listeners.elementAt(i);
            listener.userRemoved(this, u, note);
            if (listener.getUser() != null) {
                Log.out.debug(u.getUID() + " left relayed to " + listener.getUser().getUID());
            }
            ++i;
        }
    }

    public boolean isMember(String uid) {
        return this._participants.get(uid) != null;
    }

    public int getParticipantAccess(String uid) {
        Participant p = (Participant)this._participants.get(uid);
        if (p != null) {
            return p.access;
        }
        return 0;
    }

    public static void updateParticipantAccess(Destination dest, DestinationAccessControlList acl, iIMUser user) {
        RoomStorage rs = null;
        if (dest instanceof Room) {
            rs = RoomStorage.get(((Room)dest).getFQName().toLowerCase());
            if (rs.isTempRoom()) {
                return;
            }
        } else {
            return;
        }
        if (!DestinationAcl.check(dest, user, 14)) {
            return;
        }
        Enumeration e = acl.entries();
        while (e.hasMoreElements()) {
            iIMPrincipal p = (iIMPrincipal)e.nextElement();
            int access = acl.getAccess(p);
            if (!(p instanceof iIMUser)) continue;
            rs.setParticipantAccess(p.getUID(), access);
        }
    }

    public void setParticipantAccess(String uid, int accessLevel) {
        Participant p = (Participant)this._participants.get(uid);
        if (p != null) {
            p.access = accessLevel;
        }
    }

    class Participant {
        String note;
        String uid;
        int access;

        Participant(String s, String n, int a) {
            this.note = n;
            this.uid = s;
            this.access = a;
        }
    }
}

