/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.Counters;
import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSConnection;
import com.iplanet.im.server.UserLogEvent;
import com.iplanet.im.server.UserLogListener;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.SafeResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Vector;

public class NMSUser {
    protected Vector listeners = new Vector();
    private NMSConnection connection;
    private iIMUser nluser;
    private int status = 2;
    private int prevStatus = 2;
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    private String reason = "";
    private BooleanAccessControlList _acl;
    private static UserSettings us = UserSettings.get();
    private static final int ID_ARCHIVE_ENABLED = 1;
    public static final int ID_ARCHIVE_ALERTS_ENABLED = 4;
    public static final int ID_ARCHIVE_POLLS_ENABLED = 8;

    public NMSUser(iIMUser nluser) {
        this.nluser = nluser;
    }

    private String getProperty(String name, String defaultVal) {
        try {
            Properties p = us.getUserProperties(this.nluser);
            return p.getProperty(name, defaultVal);
        }
        catch (Exception e) {
            Log.out.error("Failed to get user properties: " + e.toString());
            return null;
        }
    }

    public boolean hasForwarding() {
        Properties p = null;
        try {
            p = us.getUserProperties(this.nluser);
        }
        catch (Exception e) {
            Log.out.error("Failed to get user properties: " + e.toString());
        }
        if (p == null) {
            return false;
        }
        String b = p.getProperty("forward.email", "false");
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        b = p.getProperty("forward.pager", "false");
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        b = p.getProperty("forward.sms", "false");
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        b = p.getProperty("alerts.offline.deliver", "false");
        return b.equalsIgnoreCase("true");
    }

    public boolean hasAlertArchiving() {
        String b = this.getProperty("archive.options", "0");
        int mask = Integer.parseInt(b);
        return (mask & 4) != 0 && (mask & 1) != 0;
    }

    public void forward(Message m, iIMUser originator) {
        String to;
        Properties p = null;
        try {
            p = us.getUserProperties(this.nluser);
        }
        catch (Exception e) {
            Log.out.error("Failed to get user properties: " + e.toString());
        }
        if (p == null) {
            return;
        }
        String b = p.getProperty("forward.email", "false");
        if (b.equalsIgnoreCase("true")) {
            to = p.getProperty("forward.email.addr");
            NMS.get().sendEmail(m, originator, to, false);
        }
        if ((b = p.getProperty("forward.pager", "false")).equalsIgnoreCase("true")) {
            to = p.getProperty("forward.pager.addr");
            NMS.get().sendEmail(m, originator, to, true);
        }
        if ((b = p.getProperty("forward.sms", "false")).equalsIgnoreCase("true")) {
            to = p.getProperty("forward.sms.addr");
            NMS.get().sendEmail(m, originator, to, true);
        }
        if ((b = p.getProperty("alerts.offline.deliver", "false")).equalsIgnoreCase("true")) {
            File f = FileUserSettings.getUserRootDir(this.getiIMUser(), true);
            f = new File(f, m.getMsgid() + ".msg");
            try {
                FileOutputStream os = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(m);
                oos.close();
                os.close();
            }
            catch (Exception e) {
                Log.out.error("Unable to save alert for later delivery: " + e.toString());
            }
        }
    }

    public iIMUser getiIMUser() {
        return this.nluser;
    }

    public void setiIMUser(iIMUser nluser) {
        this.nluser = nluser;
    }

    public void setUserStatus(int status, String reason) {
        this.prevStatus = this.status;
        this.status = status;
        this.reason = reason;
        this.fireUserStatusEvent();
    }

    public boolean isLoggedOn() {
        return this.connection != null;
    }

    public int getUserStatus() {
        if (this.status == 2 && this.hasForwarding()) {
            return 6;
        }
        return this.status;
    }

    public int getPrevUserStatus() {
        return this.prevStatus;
    }

    public String getUserStatusReason() {
        return this.reason;
    }

    public void setConnection(NMSConnection c) {
        NMSUser nMSUser = this;
        synchronized (nMSUser) {
            if (this.connection != null) {
                Log.out.error(c.getUser().getUID() + " cannot log on twice");
                return;
            }
            this.connection = c;
            Log.out.debug(c.getUser().getUID() + " connection set");
        }
        this.prevStatus = this.status;
        this.status = 1;
        this.reason = this.res.getString("Online");
        this.fireUserStatusEvent();
        NMS.get().getWorker().addRunnable(new SendQueued());
    }

    public void deleteConnection(boolean close) {
        NMSUser nMSUser = this;
        synchronized (nMSUser) {
            if (this.connection == null) {
                Log.out.debug("Internal error no user was logged on");
                return;
            }
        }
        if (this.status != 2) {
            this.prevStatus = this.status;
            this.status = 2;
            this.reason = this.res.getString("Offline");
            this.fireUserStatusEvent();
        }
        NMSConnection c = null;
        NMSUser nMSUser2 = this;
        synchronized (nMSUser2) {
            if (this.connection != null) {
                c = this.connection;
                this.connection = null;
                Log.out.debug(c.getUser().getUID() + " connection unset");
            } else {
                Log.out.warning("??? connection already unset");
            }
        }
        if (close && c != null) {
            c.close();
        }
    }

    public void send(Message m) {
        NMSConnection c = null;
        NMSUser nMSUser = this;
        synchronized (nMSUser) {
            if (this.connection != null) {
                c = this.connection;
            }
        }
        if (c != null) {
            c.sendMessage(this.getiIMUser(), m);
        }
    }

    public void send(CommandData cd) {
        NMSConnection c = null;
        NMSUser nMSUser = this;
        synchronized (nMSUser) {
            if (this.connection != null) {
                c = this.connection;
            }
        }
        if (c != null) {
            c.sendCommand(cd);
        }
    }

    public synchronized void addListener(UserLogListener l) {
        if (!this.listeners.contains(l)) {
            iIMUser u = l.getUser();
            if (u != null && this.nluser != null) {
                Log.out.debug("Adding watcher to " + this.nluser.getUID() + " :" + u.getUID());
            }
            this.listeners.addElement(l);
        }
    }

    public synchronized void removeListener(UserLogListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireUserStatusEvent() {
        Vector tl;
        NMSUser nMSUser = this;
        synchronized (nMSUser) {
            tl = (Vector)this.listeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        UserLogEvent event = new UserLogEvent(this);
        Counters.increment(Counters.CNT_PRESENCE, size);
        int i = 0;
        while (i < size) {
            UserLogListener listener = (UserLogListener)tl.elementAt(i);
            iIMUser u = listener.getUser();
            if (u == null || this._acl == null || u.equals((Object)this.nluser) || this._acl.findEntry((iIMPrincipal)u, (iIMRealm)NMS.getRealm()) != null ^ this._acl.getDefault()) {
                if (u != null) {
                    Log.out.debug("Relaying presence update to " + u.getUID());
                }
                listener.statusChanged(event);
            }
            ++i;
        }
    }

    public synchronized void aclChanged(BooleanAccessControlList acl) {
        int listenersCount = this.listeners.size();
        if (listenersCount == 0) {
            return;
        }
        UserLogEvent event = new UserLogEvent(this);
        int i = 0;
        if (this._acl != null && this._acl.getDefault() != acl.getDefault()) {
            i = 0;
            while (i < listenersCount) {
                UserLogListener listener = (UserLogListener)this.listeners.elementAt(i);
                iIMUser u = listener.getUser();
                if (!u.getUID().equalsIgnoreCase(this.nluser.getUID())) {
                    if (acl.findEntry((iIMPrincipal)u) != null ^ acl.getDefault()) {
                        listener.statusChanged(event);
                    } else {
                        listener.accessDenied(event);
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < listenersCount) {
                UserLogListener listener = (UserLogListener)this.listeners.elementAt(i);
                iIMUser u = listener.getUser();
                if (!(u.getUID().equalsIgnoreCase(this.nluser.getUID()) || acl.findEntry((iIMPrincipal)u, (iIMRealm)NMS.getRealm()) != null && this._acl != null && this._acl.findEntry((iIMPrincipal)u, (iIMRealm)NMS.getRealm()) != null)) {
                    if (acl.findEntry((iIMPrincipal)u, (iIMRealm)NMS.getRealm()) != null ^ acl.getDefault()) {
                        listener.statusChanged(event);
                    } else {
                        listener.accessDenied(event);
                    }
                }
                ++i;
            }
        }
        this._acl = acl;
    }

    public void setACL(BooleanAccessControlList acl) {
        this._acl = acl;
    }

    class SendQueued
    implements Runnable {
        SendQueued() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            File root = FileUserSettings.getUserRootDir(NMSUser.this.getiIMUser(), false);
            if (root == null) {
                return;
            }
            String[] filenames = root.list(new FilenameFilter(this){
                private final /* synthetic */ SendQueued this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String fname) {
                    return fname.endsWith(".msg");
                }
            });
            int i = 0;
            while (true) {
                Message m;
                block11: {
                    Object var9_9;
                    if (i >= filenames.length) {
                        return;
                    }
                    m = null;
                    File f = null;
                    try {
                        try {
                            f = new File(root, filenames[i]);
                            FileInputStream is = new FileInputStream(f);
                            ObjectInputStream ois = new ObjectInputStream(is);
                            m = (Message)ois.readObject();
                            ois.close();
                            is.close();
                        }
                        catch (Exception e) {
                            Log.out.error("attempting opening stored message " + e);
                            var9_9 = null;
                            if (f != null) {
                                f.delete();
                            }
                            break block11;
                        }
                        var9_9 = null;
                        if (f != null) {
                            f.delete();
                        }
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        if (f != null) {
                            f.delete();
                        }
                        throw throwable;
                    }
                }
                if (m != null) {
                    NMSUser.this.send(m);
                }
                ++i;
            }
        }
    }
}

