/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.IdentityRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.sun.im.identity.util.Auth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPRealm
extends Realm {
    private static final String rootConfigName = "iim_ldap.searchbase";
    private static final String serverConfigName = "iim_ldap.host";
    private static final String groupSearchFilterName = "iim_ldap.groupbrowsefilter";
    private static final String userSearchFilterName = "iim_ldap.userbrowsefilter";
    private static final String searchByIDFilterName = "iim_ldap.usergroupbyidsearchfilter";
    private static final String searchByNameFilterName = "iim_ldap.usergroupbynamesearchfilter";
    private static final String allowWildCardInIdName = "iim_ldap.allowwildcardinuid";
    private static final String loginFilterName = "iim_ldap.loginfilter";
    private static final String userClassName = "iim_ldap.userclass";
    private static final String groupClassName = "iim_ldap.groupclass";
    private static final String ldapUserNameName = "iim_ldap.usergroupbinddn";
    private static final String ldapPasswordName = "iim_ldap.usergroupbindcred";
    private static final String useIdentityAdminName = "iim_ldap.useidentityadmin";
    private static final String groupDisplayAttrName = "iim_ldap.groupdisplay";
    private static final String userAttributesName = "iim_ldap.user.attributes";
    private static final String groupAttributesName = "iim_ldap.group.attributes";
    private static final String userDisplayAttrName = "iim_ldap.userdisplay";
    private static final String userUIDAttrName = "iim_ldap.useruidattr";
    private static final String groupMemberAttrName = "iim_ldap.groupmemberattr";
    private static final String userMailAttrName = "iim_ldap.usermailattr";
    private static final String groupMemberURLAttrName = "iim_ldap.groupmemberurlattr";
    private static final String roleFilterAttrName = "iim_ldap.rolefilterattr";
    private static final String roleDNAttrName = "iim_ldap.rolednattr";
    private static final String managedRoleObjectClassName = "iim_ldap.managedroleobjectclass";
    private static final String searchLimitName = "iim_ldap.searchlimit";
    private static final String maxContextsName = "iim_ldap.maxconns";
    private static final String groupSearchFilterDef = "(objectclass=groupofuniquenames)";
    private static final String userSearchFilterDef = "(objectclass=inetorgperson)";
    private static final String searchByIDFilterDef = "(|(&(objectclass=groupofuniquenames)(uid={0}))(&(objectclass=inetorgperson)(uid={0})))";
    private static final String searchByNameFilterDef = "(|(&(objectclass=groupofuniquenames)(cn={0}))(&(objectclass=inetorgperson)(cn={0})))";
    private static final String loginFilterDef = "(&(objectclass=inetorgperson)(uid={0}))";
    private static final String userClassDef = "inetOrgPerson";
    private static final String groupClassDef = "groupOfUniqueNames";
    private static final String orgDepthName = "iim_ldap.orgdepth";
    private static final String groupDisplayAttrDef = "cn";
    private static final String userDisplayAttrDef = "cn";
    private static final String userUIDAttrDef = "uid";
    private static final String userMailAttrDef = "mail";
    private static final String groupMemberAttrDef = "uniquemember";
    private static final String groupMemberURLAttrDef = "memberurl";
    private static final String managedRoleObjectClassDef = "nsManagedRoleDefinition";
    private static final String roleFilterAttrDef = "nsRoleFilter";
    private static final String roleDNAttrDef = "nsRoleDN";
    private static final String userDomainAttrDef = "sunPreferredDomain";
    private static int _orgDepth = 0;
    private String[] userAttributeArray = null;
    private String[] groupAttributeArray = null;
    private String[] userGroupAttributeArray = null;
    String root = "";
    private String server = "";
    private int searchLimit = 40;
    private String groupSearchFilter = "(objectclass=groupofuniquenames)";
    private String userSearchFilter = "(objectclass=inetorgperson)";
    private String loginFilter = "(&(objectclass=inetorgperson)(uid={0}))";
    private String searchByNameFilter = "(|(&(objectclass=groupofuniquenames)(cn={0}))(&(objectclass=inetorgperson)(cn={0})))";
    private String searchByIDFilter = "(|(&(objectclass=groupofuniquenames)(uid={0}))(&(objectclass=inetorgperson)(uid={0})))";
    private ArrayList userClass = new ArrayList();
    private ArrayList groupClass = new ArrayList();
    String ldapUserName = "";
    String ldapPassword = "";
    private boolean allowWildCardInId = false;
    String groupDisplayAttr = "cn";
    String userDisplayAttr = "cn";
    String userUIDAttr = "uid";
    String userMailAttr = "mail";
    String groupMemberAttr = "uniquemember";
    String groupMemberURLAttr = "memberurl";
    String roleFilterAttr = "nsRoleFilter";
    String roleDNAttr = "nsRoleDN";
    private String managedRoleObjectClass = "nsManagedRoleDefinition";
    int authcount;
    private Vector _contexts = new Vector();
    private int _maxContexts = 10;
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    HashSet userAttributeSet = new HashSet(7);
    HashSet groupAttributeSet = new HashSet(7);

    private synchronized DirContext getContext() throws RealmException {
        int size = this._contexts.size();
        if (size > 0) {
            Log.out.debug("[LDAP] At least one LDAP connection available");
            DirContext dc = (DirContext)this._contexts.elementAt(size - 1);
            this._contexts.removeElementAt(size - 1);
            return dc;
        }
        Log.out.debug("[LDAP] No LDAP connection available. Empty LDAP pool so create a new one");
        try {
            Log.out.debug("[LDAP] Connecting to LDAP server");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + this.server);
            if (this.ldapUserName.length() > 0) {
                Log.out.debug("[LDAP] ldap binding to " + this.ldapUserName);
                env.put("java.naming.security.principal", this.ldapUserName);
                env.put("java.naming.security.credentials", this.ldapPassword);
            }
            InitialDirContext dc = new InitialDirContext(env);
            Log.out.debug("[LDAP] Connected to LDAP server");
            return dc;
        }
        catch (Exception e) {
            String error = "[LDAP] Connection error " + e.toString();
            Log.out.error(error);
            throw new RealmException(error);
        }
    }

    private synchronized void recycleContext(DirContext dc) {
        if (dc == null) {
            return;
        }
        int size = this._contexts.size();
        if (size < this._maxContexts) {
            this._contexts.addElement(dc);
        } else {
            Log.out.debug("[LDAP] Too many LDAP connections. So let the GC get it");
            try {
                dc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            dc = null;
        }
    }

    public LDAPRealm() throws RealmException, FileNotFoundException, IOException {
        String t;
        String tmaxContexts;
        ServerConfig sc = ServerConfig.getServerConfig();
        this.root = LDAPRealm.removeSpaces(sc.getSetting(rootConfigName, ""));
        this.server = sc.getSetting(serverConfigName, "");
        this.groupSearchFilter = sc.getSetting(groupSearchFilterName, groupSearchFilterDef);
        this.userSearchFilter = sc.getSetting(userSearchFilterName, userSearchFilterDef);
        this.loginFilter = sc.getSetting(loginFilterName, loginFilterDef);
        this.searchByIDFilter = sc.getSetting(searchByIDFilterName, searchByIDFilterDef);
        this.searchByNameFilter = sc.getSetting(searchByNameFilterName, searchByNameFilterDef);
        String vals = sc.getSetting(userClassName, userClassDef);
        StringTokenizer st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.userClass.add(st.nextToken().trim().toLowerCase());
        }
        vals = sc.getSetting(groupClassName, groupClassDef);
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.groupClass.add(st.nextToken().trim().toLowerCase());
        }
        this.userDisplayAttr = sc.getSetting(userDisplayAttrName, "cn");
        this.userAttributeSet.add(this.userDisplayAttr);
        this.userUIDAttr = sc.getSetting(userUIDAttrName, userUIDAttrDef);
        this.userAttributeSet.add(this.userUIDAttr);
        this.userMailAttr = sc.getSetting(userMailAttrName, userMailAttrDef);
        this.userAttributeSet.add(this.userMailAttr);
        vals = sc.getSetting(userAttributesName, "");
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.userAttributeSet.add(st.nextToken().trim().toLowerCase());
        }
        this.userAttributeArray = new String[this.userAttributeSet.size()];
        int ix = 0;
        Iterator i = this.userAttributeSet.iterator();
        while (i.hasNext()) {
            this.userAttributeArray[ix++] = (String)i.next();
        }
        this.groupMemberAttr = sc.getSetting(groupMemberAttrName, groupMemberAttrDef);
        this.groupAttributeSet.add(this.groupMemberAttr);
        this.groupDisplayAttr = sc.getSetting(groupDisplayAttrName, "cn");
        this.groupAttributeSet.add(this.groupDisplayAttr);
        this.groupMemberURLAttr = sc.getSetting(groupMemberURLAttrName, groupMemberURLAttrDef);
        this.groupAttributeSet.add(this.groupMemberURLAttr);
        this.roleFilterAttr = sc.getSetting(roleFilterAttrName, roleFilterAttrDef);
        this.roleDNAttr = sc.getSetting(roleDNAttrName, roleDNAttrDef);
        this.managedRoleObjectClass = sc.getSetting(managedRoleObjectClassName, managedRoleObjectClassDef);
        vals = sc.getSetting(groupAttributesName, "");
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.groupAttributeSet.add(st.nextToken().trim().toLowerCase());
        }
        this.groupAttributeArray = new String[this.groupAttributeSet.size()];
        ix = 0;
        Iterator i2 = this.groupAttributeSet.iterator();
        while (i2.hasNext()) {
            this.groupAttributeArray[ix++] = (String)i2.next();
        }
        this.userAttributeSet.addAll(this.groupAttributeSet);
        this.userAttributeSet.add("objectclass");
        this.userGroupAttributeArray = new String[this.userAttributeSet.size()];
        ix = 0;
        Iterator i3 = this.userAttributeSet.iterator();
        while (i3.hasNext()) {
            this.userGroupAttributeArray[ix++] = (String)i3.next();
        }
        String tsearchLimit = sc.getSetting(searchLimitName);
        if (tsearchLimit != null && tsearchLimit.length() != 0) {
            this.searchLimit = Integer.parseInt(tsearchLimit);
        }
        if ((tmaxContexts = sc.getSetting(maxContextsName)) != null && tmaxContexts.length() != 0) {
            this._maxContexts = Integer.parseInt(tmaxContexts);
        }
        if ((t = sc.getSetting(allowWildCardInIdName, "false")).equalsIgnoreCase("true")) {
            this.allowWildCardInId = true;
        }
        this.ldapUserName = sc.getSetting(ldapUserNameName, "");
        this.ldapPassword = sc.getSetting(ldapPasswordName, "");
        vals = sc.getSetting(orgDepthName);
        if (vals != null && vals.length() > 0) {
            _orgDepth = Integer.parseInt(vals);
        }
        boolean useIdentityAdminCreds = false;
        try {
            useIdentityAdminCreds = StringUtility.getBoolean(sc.getSetting(useIdentityAdminName));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (useIdentityAdminCreds) {
            this.ldapUserName = Auth.getAdminDN();
            this.ldapPassword = Auth.getAdminPassword();
        }
    }

    public String getAdminDN() {
        return this.ldapUserName;
    }

    public String getAdminPassword() {
        return this.ldapPassword;
    }

    public void stop() {
        try {
            Vector vector = this._contexts;
            synchronized (vector) {
                int i = 0;
                while (i < this._contexts.size()) {
                    DirContext dc = (DirContext)this._contexts.elementAt(i);
                    dc.close();
                    ++i;
                }
                this._contexts.removeAllElements();
            }
        }
        catch (Exception e) {
            Log.out.warning("[LDAP] exception closing all ldap contexts " + e);
        }
    }

    public NMSGroup _getNMSGroup(iIMPrincipal principal, iIMGroup nlg) throws RealmException {
        int retry = 0;
        String uid = nlg.getName();
        uid = LDAPRealm.removeSpaces(uid);
        while (retry < 2) {
            Object var13_13;
            DirContext dc = this.getContext();
            try {
                try {
                    Attribute attr;
                    NMSGroup nmsg = new NMSGroup(nlg, this);
                    Attributes attrs = dc.getAttributes(uid, this.groupAttributeArray);
                    Vector<String> v = new Vector<String>();
                    if (attrs != null && (attr = attrs.get(this.groupMemberAttr)) != null) {
                        NamingEnumeration<?> e = attr.getAll();
                        while (e != null && e.hasMore()) {
                            Object s = e.next();
                            v.add(LDAPRealm.removeSpaces(s.toString()));
                        }
                    }
                    int i = 0;
                    while (i < v.size()) {
                        String id = (String)v.elementAt(i);
                        iIMUser nlu = this._getiIMUser(principal, id);
                        if (nlu != null) {
                            nmsg.addMember((iIMPrincipal)nlu);
                        }
                        ++i;
                    }
                    NMSGroup nMSGroup = nmsg;
                    var13_13 = null;
                    this.recycleContext(dc);
                    return nMSGroup;
                }
                catch (CommunicationException e) {
                    String error = this.res.getString("Getting_group") + uid + " : " + e;
                    Log.out.error(error);
                    try {
                        dc.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc = null;
                    ++retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception se) {
                    }
                    var13_13 = null;
                    this.recycleContext(dc);
                }
                catch (Exception e) {
                    Log.out.printStackTrace(e);
                    String error = this.res.getString("Getting_group") + uid + " : " + e;
                    Log.out.error(error);
                    throw new RealmException(error);
                }
            }
            catch (Throwable throwable) {
                var13_13 = null;
                this.recycleContext(dc);
                throw throwable;
            }
        }
        String error = this.res.getString("Getting_group") + uid;
        Log.out.error(error);
        throw new RealmException(error);
    }

    public iIMGroup[] _getiIMGroups() throws RealmException {
        throw new RealmException("Cannot search all groups");
    }

    private iIMGroup createGroup(Attributes attrs, String name, String domain) throws NamingException, RealmException {
        String displayname = name;
        Attribute attr = attrs.get(this.groupDisplayAttr);
        if (attr != null) {
            displayname = attr.get().toString();
        } else {
            Log.out.info("[LDAP] " + name + " has no value for " + this.groupDisplayAttr);
        }
        String filter = null;
        String scope = this.getSearchBase(domain);
        attr = attrs.get(this.groupMemberURLAttr);
        if (attr != null && (filter = attr.get().toString()).startsWith("ldap:")) {
            try {
                String[] s = LDAPRealm.parseLDAPURL(filter, this.root);
                scope = s[0];
                filter = s[1];
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                filter = null;
            }
        }
        if (filter == null && (attr = attrs.get(this.roleFilterAttr)) != null) {
            filter = "(" + attr.get().toString() + ")";
        }
        if (filter == null && (attr = attrs.get("objectclass")) != null && attr.contains(this.managedRoleObjectClass)) {
            filter = "(" + this.roleDNAttr + "=" + name + ")";
        }
        iIMGroup g = null;
        if (filter != null) {
            if (filter.length() > 0 && !filter.startsWith("(")) {
                filter = "(" + filter + ")";
            }
            filter = "(&" + filter + this.userSearchFilter + ")";
            Log.out.debug("[LDAP] Found dynamic group: " + displayname + " <" + name + "> " + filter);
            g = new iIMGroup(name, domain, displayname, filter, scope);
        } else {
            Log.out.debug("[LDAP] Found static group: " + displayname + " <" + name + ">");
            g = new iIMGroup(name, domain, displayname);
        }
        LDAPRealm.setAttributes((iIMPrincipal)g, attrs);
        return g;
    }

    private iIMUser createUser(Attributes attrs, String defaultUid, String domain) throws NamingException {
        String uid = defaultUid;
        Attribute attr = attrs.get(this.userUIDAttr);
        if (attr != null) {
            uid = attr.get().toString();
        }
        if (uid == null) {
            Log.out.error("[LDAP] Cannot find a UID attribute for user " + uid);
            return null;
        }
        attr = attrs.get(this.userDisplayAttr);
        String displayName = attr != null ? attr.get().toString().trim() : uid;
        String mailaddr = null;
        attr = attrs.get(this.userMailAttr);
        if (attr != null) {
            mailaddr = attr.get().toString();
        } else {
            Log.out.info("[LDAP] Cannot find mail address for user " + uid);
        }
        iIMUser u = new iIMUser(StringUtility.quoteSpecialCharacters(uid), domain, displayName, mailaddr);
        u.setDistinguishedName(defaultUid);
        u.setAttribute("dn", (Object)defaultUid);
        LDAPRealm.setAttributes((iIMPrincipal)u, attrs);
        return u;
    }

    public iIMGroup _getiIMGroup(iIMPrincipal principal, String dn) throws RealmException {
        return this._getiIMGroup(this.getSearchBase(principal), dn);
    }

    iIMGroup _getiIMGroup(String searchBase, String dn) throws RealmException {
        int retry = 0;
        while (retry < 2) {
            Object var8_11;
            DirContext dc = this.getContext();
            Log.out.debug("[LDAP] searching group : " + dn);
            try {
                try {
                    Attributes attrs = dc.getAttributes(dn, this.groupAttributeArray);
                    if (attrs != null) {
                        iIMGroup iIMGroup2 = this.createGroup(attrs, dn, this.getDomainName(searchBase));
                        var8_11 = null;
                        this.recycleContext(dc);
                        return iIMGroup2;
                    }
                    var8_11 = null;
                    this.recycleContext(dc);
                    break;
                }
                catch (CommunicationException e) {
                    Log.out.error("[LDAP] group get attributes failed: " + dn + " " + e);
                    try {
                        dc.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc = null;
                    ++retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception se) {
                    }
                    var8_11 = null;
                    this.recycleContext(dc);
                }
                catch (Exception e) {
                    Log.out.error("[LDAP] group get attributes failed: " + dn + " " + e);
                    Log.out.printStackTrace(e);
                    var8_11 = null;
                    this.recycleContext(dc);
                    break;
                }
            }
            catch (Throwable throwable) {
                var8_11 = null;
                this.recycleContext(dc);
                throw throwable;
            }
        }
        return null;
    }

    public iIMUser _getiIMUser(iIMPrincipal principal, String uid) throws RealmException {
        return this._getiIMUser(this.getSearchBase(principal), uid);
    }

    public iIMUser _getiIMUser(String searchBase, String uid) throws RealmException {
        int i = uid.indexOf(61);
        if (i == -1) {
            uid = StringUtility.getLocalPartFromAddress(uid);
            String searchfor = StringUtility.replaceString("{0}", StringUtility.unquoteSpecialCharacters(uid), this.loginFilter);
            int retry = 0;
            while (retry < 2) {
                Object var13_22;
                DirContext dc = this.getContext();
                SearchControls con = new SearchControls();
                con.setSearchScope(2);
                con.setReturningAttributes(this.userAttributeArray);
                try {
                    try {
                        SearchResult si;
                        Attributes attrs;
                        Log.out.debug("[LDAP] Searching for user by uid: filter=" + searchfor + " base=" + this.root);
                        NamingEnumeration<SearchResult> e = dc.search(searchBase, searchfor, con);
                        if (e != null && e.hasMore() && (attrs = (si = e.next()).getAttributes()) != null) {
                            Log.out.debug("[LDAP] User found: " + uid);
                            iIMUser iIMUser2 = this.createUser(attrs, this.getAbsoluteName(si), this.getDomainName(searchBase));
                            var13_22 = null;
                            this.recycleContext(dc);
                            return iIMUser2;
                        }
                        var13_22 = null;
                        this.recycleContext(dc);
                        break;
                    }
                    catch (CommunicationException e) {
                        Log.out.error("[LDAP] UID search failed: " + uid + " " + e);
                        try {
                            dc.close();
                        }
                        catch (Exception ce) {
                            // empty catch block
                        }
                        dc = null;
                        ++retry;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception se) {
                        }
                        var13_22 = null;
                        this.recycleContext(dc);
                    }
                    catch (Exception e) {
                        Log.out.error("UID search failed: " + uid + " " + e);
                        Log.out.printStackTrace(e);
                        var13_22 = null;
                        this.recycleContext(dc);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    var13_22 = null;
                    this.recycleContext(dc);
                    throw throwable;
                }
            }
        } else {
            int retry = 0;
            while (retry < 2) {
                Object var15_26;
                DirContext dc = this.getContext();
                Log.out.debug("[LDAP] Getting displayname for user : " + uid);
                try {
                    try {
                        Attributes attrs = dc.getAttributes(uid, this.userAttributeArray);
                        if (attrs != null) {
                            iIMUser con = this.createUser(attrs, uid, this.getDomainName(searchBase));
                            var15_26 = null;
                            this.recycleContext(dc);
                            return con;
                        }
                        var15_26 = null;
                        this.recycleContext(dc);
                        break;
                    }
                    catch (CommunicationException e) {
                        Log.out.error("[LDAP] UID get attributes failed: " + uid + " " + e);
                        try {
                            dc.close();
                        }
                        catch (Exception ce) {
                            // empty catch block
                        }
                        dc = null;
                        ++retry;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception se) {
                        }
                        var15_26 = null;
                        this.recycleContext(dc);
                    }
                    catch (Exception e) {
                        Log.out.error("[LDAP] UID get attributes failed: " + uid + " " + e);
                        Log.out.printStackTrace(e);
                        var15_26 = null;
                        this.recycleContext(dc);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    var15_26 = null;
                    this.recycleContext(dc);
                    throw throwable;
                }
            }
        }
        return null;
    }

    public UserSearchReply _search(iIMPrincipal principal, String pattern, boolean byid, String filter) throws RealmException {
        String base = this.getSearchBase(principal);
        return this._search(base, pattern, byid, filter);
    }

    public UserSearchReply _search(String base, String pattern, boolean byid, String filter) {
        String searchfor;
        if (this.searchLimit == -1) {
            return new UserSearchReply(4, null);
        }
        if (byid) {
            if (!this.allowWildCardInId) {
                pattern = StringUtility.replaceString("*", "", pattern);
            }
            searchfor = StringUtility.replaceString("{0}", pattern, this.searchByIDFilter);
        } else {
            searchfor = StringUtility.replaceString("{0}", pattern, this.searchByNameFilter);
        }
        if (filter != null && filter.length() > 0) {
            searchfor = "(&" + filter + searchfor + ")";
        }
        return this._search(searchfor, base);
    }

    public UserSearchReply _search(String searchFilter, String baseDN) {
        String base = baseDN;
        if (base == null) {
            base = this.root;
        }
        for (int retry = 0; retry < 2; ++retry) {
            Object var17_5;
            DirContext dc = null;
            Vector<Object> v = new Vector<Object>();
            try {
                try {
                    dc = this.getContext();
                    SearchControls con = new SearchControls();
                    con.setSearchScope(2);
                    con.setReturningAttributes(this.userGroupAttributeArray);
                    if (this.searchLimit > 0) {
                        con.setCountLimit(this.searchLimit);
                    }
                    Log.out.debug("[LDAP] Search: filter=" + searchFilter + " base=" + baseDN);
                    NamingEnumeration<SearchResult> e2 = dc.search(baseDN, searchFilter, con);
                    while (e2.hasMore()) {
                        boolean userentry = false;
                        boolean groupentry = false;
                        SearchResult si = e2.next();
                        Attributes attrs = si.getAttributes();
                        Attribute objectclass = attrs.get("objectclass");
                        NamingEnumeration<?> values = objectclass.getAll();
                        while (values != null && values.hasMore()) {
                            String attrvalue = values.next().toString().toLowerCase();
                            if (this.userClass.contains(attrvalue)) {
                                userentry = true;
                                break;
                            }
                            if (!this.groupClass.contains(attrvalue)) continue;
                            groupentry = true;
                            break;
                        }
                        if (userentry) {
                            v.add(this.createUser(attrs, this.getAbsoluteName(si), this.getDomainName(base)));
                            continue;
                        }
                        if (!groupentry) continue;
                        String uid = this.getAbsoluteName(si);
                        v.add(this.createGroup(attrs, uid, this.getDomainName(base)));
                    }
                    Object[] princ = new iIMPrincipal[v.size()];
                    v.copyInto(princ);
                    UserSearchReply groupentry = new UserSearchReply(2, (iIMPrincipal[])princ);
                    var17_5 = null;
                    this.recycleContext(dc);
                    return groupentry;
                }
                catch (InvalidSearchFilterException e) {
                    UserSearchReply e2 = new UserSearchReply(3, null);
                    var17_5 = null;
                    this.recycleContext(dc);
                    return e2;
                }
                catch (LimitExceededException e) {
                    Object[] princ = new iIMPrincipal[v.size()];
                    v.copyInto(princ);
                    UserSearchReply groupentry = new UserSearchReply(1, (iIMPrincipal[])princ);
                    var17_5 = null;
                    this.recycleContext(dc);
                    return groupentry;
                }
                catch (CommunicationException e) {
                    Log.out.error("[LDAP] search failed: " + searchFilter + " " + e);
                    try {
                        dc.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc = null;
                    var17_5 = null;
                    this.recycleContext(dc);
                    continue;
                }
                catch (Exception e) {
                    Log.out.warning("[LDAP] search failed: " + searchFilter + " " + e);
                    UserSearchReply userSearchReply = new UserSearchReply(5, null);
                    var17_5 = null;
                    this.recycleContext(dc);
                    return userSearchReply;
                }
            }
            catch (Throwable throwable) {
                var17_5 = null;
                this.recycleContext(dc);
                throw throwable;
            }
        }
        return new UserSearchReply(5, null);
    }

    private String getAbsoluteName(SearchResult si) {
        if (si.isRelative()) {
            String relativeName = LDAPRealm.removeSpaces(si.getName());
            if (relativeName.endsWith("\"")) {
                return relativeName.substring(0, relativeName.length() - 1) + "," + this.root + "\"";
            }
            return relativeName + "," + this.root;
        }
        return LDAPRealm.removeSpaces(si.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDN(String uid) throws RealmException {
        Object var10_12;
        String string;
        DirContext dc;
        String searchfor = StringUtility.replaceString("{0}", StringUtility.unquoteSpecialCharacters(uid), this.loginFilter);
        int retry = 0;
        while (true) {
            if (retry >= 2) {
                return null;
            }
            dc = this.getContext();
            SearchControls con = new SearchControls();
            con.setSearchScope(2);
            con.setReturningAttributes(null);
            try {
                try {
                    Log.out.debug("[LDAP] getDN: filter=" + searchfor + " base=" + this.root);
                    NamingEnumeration<SearchResult> e = dc.search(this.root, searchfor, con);
                    if (e != null && e.hasMore()) {
                        string = this.getAbsoluteName(e.next());
                        var10_12 = null;
                        this.recycleContext(dc);
                        return string;
                    }
                    string = null;
                }
                catch (CommunicationException e) {
                    Log.out.error("[LDAP] UID search failed: " + uid + " " + e);
                    try {
                        dc.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc = null;
                    ++retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception se) {
                    }
                    var10_12 = null;
                    this.recycleContext(dc);
                    continue;
                }
                catch (Exception e) {
                    Log.out.error("[LDAP] UID search failed: " + uid + " " + e);
                    Log.out.printStackTrace(e);
                    String string2 = null;
                    var10_12 = null;
                    this.recycleContext(dc);
                    return string2;
                }
            }
            catch (Throwable throwable) {
                var10_12 = null;
                this.recycleContext(dc);
                throw throwable;
            }
            break;
        }
        var10_12 = null;
        this.recycleContext(dc);
        return string;
    }

    private boolean LDAPSimpleBindAuth(String dn, String possiblePass) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.server);
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", possiblePass);
        int retry = 0;
        InitialDirContext ctx = null;
        boolean ret = false;
        while (retry < 2) {
            try {
                ctx = new InitialDirContext(env);
                Log.out.debug("[LDAP] Success Authenticating user " + dn);
                ret = true;
                break;
            }
            catch (CommunicationException e) {
                Log.out.error("[LDAP] Error Authenticating " + dn + " - CommunicationException - " + e.getMessage());
            }
            catch (Exception e) {
                Log.out.error("[LDAP] Error Authenticating " + dn + " - " + e.getMessage());
            }
            ++retry;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public iIMUser _auth(String uid, String possiblePass) throws RealmException {
        if (possiblePass == null || possiblePass.equals("")) {
            return null;
        }
        Log.out.debug("[LDAP] Authenticating user " + uid);
        ++this.authcount;
        if (this.authcount % 1000 == 0) {
            System.gc();
            System.runFinalization();
        }
        iIMUser u = null;
        try {
            u = this.trySSO(uid, possiblePass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (u != null || SSO.getMode() == -1) {
            return u;
        }
        u = this._getiIMUser(this.root, uid);
        if (u == null) {
            throw new RealmException("[LDAP] " + uid + " not found.");
        }
        try {
            if (this.LDAPSimpleBindAuth(u.getDistinguishedName(), possiblePass)) {
                return u;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public iIMUser trySSO(String uid, String pass) {
        if (SSO.getMode() != 0) {
            try {
                HashMap attributes = new HashMap();
                if (SSO.verify(uid, pass, attributes, this.userAttributeSet)) {
                    String domain = null;
                    String orgDN = null;
                    if (this instanceof IdentityRealm) {
                        orgDN = Auth.getOrganizationDN((String)pass);
                        domain = this.getDomainName(orgDN);
                    } else {
                        domain = NMS.getName();
                    }
                    Object uda = attributes.get(this.userDisplayAttr);
                    String str_uda = uda instanceof Set ? StringUtility.getFirstAttr(uda) : (String)uda;
                    Object uma = attributes.get(this.userMailAttr);
                    String str_uma = uma instanceof Set ? StringUtility.getFirstAttr(uma) : (String)uma;
                    iIMUser u = new iIMUser(StringUtility.quoteSpecialCharacters(uid), domain, str_uda, str_uma);
                    Object obj_dn = attributes.get("dn");
                    String str_dn = obj_dn instanceof Set ? StringUtility.getFirstAttr(obj_dn) : (String)obj_dn;
                    u.setDistinguishedName(str_dn);
                    u.setAllAttributes(attributes);
                    return u;
                }
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
            }
        }
        return null;
    }

    public static final String removeSpaces(String in) {
        int start = 0;
        int foundAt = in.indexOf(", ", start);
        if (foundAt < 0) {
            return in;
        }
        StringBuffer ret = new StringBuffer();
        do {
            ret.append(in.substring(start, foundAt));
            ret.append(",");
        } while ((foundAt = in.indexOf(", ", start = foundAt + 2)) >= 0);
        ret.append(in.substring(start));
        return ret.toString();
    }

    static void setAttributes(iIMPrincipal p, Attributes attrs) {
        NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attr = (Attribute)namingEnumeration.nextElement();
            String name = attr.getID();
            try {
                String value;
                if (attr.size() <= 0 || (value = attr.get().toString()) == null) continue;
                p.setAttribute(name, (Object)value);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }

    static String[] parseLDAPURL(String url, String root) throws Exception {
        String[] result = new String[]{root, ""};
        int index = url.indexOf(47, 7);
        if (index >= 0) {
            int end = url.indexOf(63, index + 1);
            if (end >= 0) {
                result[0] = url.substring(index + 1, end);
                index = url.indexOf(63, end + 1);
                if (index >= 0 && (index = url.indexOf(63, index + 1)) >= 0) {
                    end = url.indexOf(63, index + 1);
                    result[1] = end > 0 ? url.substring(index + 1, end) : url.substring(index + 1);
                }
            } else {
                result[0] = url.substring(index + 1);
                if (result[0].length() < 3) {
                    result[0] = root;
                }
            }
        }
        return result;
    }

    public String getSearchBase(iIMPrincipal u) throws RealmException {
        if (_orgDepth == 0 || u == null) {
            return this.root;
        }
        DirContext dc = this.getContext();
        try {
            try {
                NameParser parser = dc.getNameParser(this.root);
                Name name = parser.parse(u.getDistinguishedName());
                int nComponents = name.size();
                if (nComponents > _orgDepth) {
                    int i = 1;
                    while (i <= _orgDepth) {
                        name.remove(nComponents - i);
                        ++i;
                    }
                }
                String string = name.toString();
                Object var8_9 = null;
                this.recycleContext(dc);
                return string;
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                throw new RealmException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.recycleContext(dc);
            throw throwable;
        }
    }

    public String getSearchBase(String domainName) throws RealmException {
        Log.out.debug("LDAPRealm:getSearchBase(String): " + this.root);
        return this.root;
    }

    public String getDomainName(String searchBase) throws RealmException {
        Log.out.debug("LDAPRealm:getDomainName: " + NMS.getName());
        return NMS.getName();
    }
}

