/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.LDAPRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.StringUtility;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ProtectedResource;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.im.identity.util.Auth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IdentityRealm
extends LDAPRealm {
    public static final String USER_SERVICE = "iPlanetAMUserService";
    public static final String IM_SERVICE = "SunIM";
    public static final String PRESENCE_SERVICE = "SunPresence";
    public static final String SERVICE_VERSION = "1.0";
    public static final String IM_51_SERVICE = "SunIMService";
    public static final String TOPICS_ATTR = "sunIMAllowNewsManage";
    public static final String ROOMS_ATTR = "sunIMAllowForumManage";
    public static final String SENDALERTS_ATTR = "sunIMAllowAlertsSend";
    public static final String WATCH_ATTR = "sunPresenceAllowAccess";
    public static final String SAVEUSERSETTINGS_ATTR = "sunIMAllowUserSettings";
    public static final String DEFAULT_POLICY = "Default instant messaging and presence access";
    public static final String ADMIN_POLICY = "Ability to administer Instant Messaging and Presence Service";
    public static final String TOPICS_POLICY = "Ability to manage instant messaging news channels";
    public static final String ROOMS_POLICY = "Ability to manage instant messaging conference rooms";
    public static final String SENDALERTS_POLICY = "Ability to send instant messaging alerts";
    public static final String WATCH_POLICY = "Ability to watch changes on other instant messaging users";
    public static final String SAVEUSERSETTINGS_POLICY = "Ability to change own instant messaging user settings";
    public static final String IM_DEFAULT_RULE = "IMDefaultRule";
    public static final String PRESENCE_DEFAULT_RULE = "PresenceDefaultRule";
    public static final String ADMIN_ROLE = "IM Administrator";
    public static final String TOPICS_ROLE = "IM News Administrator";
    public static final String ROOMS_ROLE = "IM Conference Rooms Administrator";
    public static final String SENDALERTS_ROLE = "IM Allow Send Alerts Role";
    public static final String WATCH_ROLE = "IM Allow Watch Changes Role";
    public static final String SAVEUSERSETTINGS_ROLE = "IM Allow User Settings Role";
    public static Set _userAttributeNames = null;
    public static Set _imPolicyAttributeNames = null;
    public static Set _presencePolicyAttributeNames = null;
    public static Set _oldIMServiceAttributeNames = null;
    public static Set _dynamicAttributeNames = null;
    public static String _IMAdminRoleDN = null;
    public static String _IMTopicsRoleDN = null;
    public static String _IMRoomsRoleDN = null;
    public static String _IMSendAlertsRoleDN = null;
    public static String _IMWatchRoleDN = null;
    public static String _IMSaveUserSettingsRoleDN = null;
    public static Set _IMAdminUsers = null;
    private static String _topicsDefault = null;
    private static String _roomsDefault = null;
    private static String _sendAlertsDefault = null;
    private static String _watchDefault = null;
    private static String _saveUserSettingsDefault = null;
    private static String userDomainAttrDef = "sunPreferredDomain";
    private static String aliasDomainAttrDef = "associatedDomain";
    private static String userDomainAttrName = userDomainAttrDef;
    private static String aliasDomainAttrName = aliasDomainAttrDef;
    protected static String userDomainAttr;
    protected static String aliasDomainAttr;
    private HashMap _orgToDomainMap;
    private AMStoreConnection _adminConnection;
    private SSOToken _adminToken;

    public IdentityRealm() throws RealmException, FileNotFoundException, IOException, SSOException, SMSException, AMException {
        block16: {
            this._orgToDomainMap = new HashMap();
            this._adminConnection = null;
            this._adminToken = null;
            _userAttributeNames = new HashSet();
            _imPolicyAttributeNames = new HashSet();
            _presencePolicyAttributeNames = new HashSet();
            _dynamicAttributeNames = new HashSet();
            try {
                Rule pr;
                Map actionValues;
                Set _IMTopicsRoleDNs;
                ServerConfig sc = ServerConfig.getServerConfig();
                userDomainAttr = sc.getSetting(userDomainAttrName, userDomainAttrDef);
                aliasDomainAttr = sc.getSetting(aliasDomainAttrName, aliasDomainAttrDef);
                this.getAdminConnection();
                if (NMS.getAclStore() != 1) break block16;
                Log.out.debug("[Identity] open called, getting user attributes names.");
                ServiceSchemaManager imSsm = new ServiceSchemaManager(this._adminToken, IM_SERVICE, SERVICE_VERSION);
                ServiceSchema imSs = imSsm.getSchema(SchemaType.USER);
                _userAttributeNames = imSs.getAttributeSchemaNames();
                Log.out.debug("[Identity] sunIM user service attributes: " + _userAttributeNames);
                ServiceSchema imDss = imSsm.getSchema(SchemaType.DYNAMIC);
                _dynamicAttributeNames = imDss.getAttributeSchemaNames();
                Log.out.debug("[Identity] sunIM dynamic service attributes: " + _dynamicAttributeNames);
                _imPolicyAttributeNames = imSsm.getServiceAttributeNames(SchemaType.POLICY);
                Log.out.debug("[Identity] sunIM policy attributes: " + _imPolicyAttributeNames);
                ServiceSchemaManager presenceSsm = new ServiceSchemaManager(this._adminToken, PRESENCE_SERVICE, SERVICE_VERSION);
                ServiceSchema presenceSs = presenceSsm.getSchema(SchemaType.USER);
                Set presenceUserAttributeNames = presenceSs.getAttributeSchemaNames();
                Log.out.debug("[Identity] sunPresence user service attributes: " + presenceUserAttributeNames);
                _userAttributeNames.addAll(presenceUserAttributeNames);
                ServiceSchema presenceDss = presenceSsm.getSchema(SchemaType.DYNAMIC);
                Set presenceDynamicAttributeNames = presenceDss.getAttributeSchemaNames();
                Log.out.debug("[Identity] sunPresence dynamic service attributes: " + presenceDynamicAttributeNames);
                _dynamicAttributeNames.addAll(presenceDynamicAttributeNames);
                Set _presencePolicyAttributeNames = presenceSsm.getServiceAttributeNames(SchemaType.POLICY);
                Log.out.debug("[Identity] sunPresence policy attributes: " + _presencePolicyAttributeNames);
                try {
                    ServiceSchemaManager oldIMSsm = new ServiceSchemaManager(this._adminToken, IM_51_SERVICE, SERVICE_VERSION);
                    Set _oldIMServiceAttributeNames = oldIMSsm.getServiceAttributeNames(SchemaType.DYNAMIC);
                    Log.out.debug("[Identity] old sunIMService dynamic attributes: " + _oldIMServiceAttributeNames);
                }
                catch (Exception oe) {
                    Log.out.info("[Identity] no old sunIMService attributes: " + oe.getMessage());
                }
                String orgDN = LDAPRealm.removeSpaces(sc.getSetting("iim_ldap.searchbase", ""));
                AMOrganization org = this._adminConnection.getOrganization(orgDN);
                Set _IMAdminRoleDNs = org.searchRoles(ADMIN_ROLE, 1);
                if (_IMAdminRoleDNs != null && _IMAdminRoleDNs.size() > 0) {
                    _IMAdminRoleDN = (String)_IMAdminRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] admin role DNs: " + _IMAdminRoleDNs);
                Log.out.debug("[Identity] admin role DN:  " + _IMAdminRoleDN);
                if (_IMAdminRoleDN != null) {
                    AMRole role = this._adminConnection.getRole(_IMAdminRoleDN);
                    _IMAdminUsers = role.getUserDNs();
                    Log.out.debug("[Identity] admin user DNs: " + _IMAdminUsers);
                }
                if ((_IMTopicsRoleDNs = org.searchRoles(TOPICS_ROLE, 1)) != null && _IMTopicsRoleDNs.size() > 0) {
                    _IMTopicsRoleDN = (String)_IMTopicsRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] topics role DN:  " + _IMTopicsRoleDN);
                Set _IMRoomsRoleDNs = org.searchRoles(ROOMS_ROLE, 1);
                if (_IMRoomsRoleDNs != null && _IMRoomsRoleDNs.size() > 0) {
                    _IMRoomsRoleDN = (String)_IMRoomsRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] rooms role DN:  " + _IMRoomsRoleDN);
                Set _IMSendAlertsRoleDNs = org.searchRoles(SENDALERTS_ROLE, 1);
                if (_IMSendAlertsRoleDNs != null && _IMSendAlertsRoleDNs.size() > 0) {
                    _IMSendAlertsRoleDN = (String)_IMSendAlertsRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] send alerts role DN:  " + _IMSendAlertsRoleDN);
                Set _IMWatchRoleDNs = org.searchRoles(WATCH_ROLE, 1);
                if (_IMWatchRoleDNs != null && _IMWatchRoleDNs.size() > 0) {
                    _IMWatchRoleDN = (String)_IMWatchRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] watch role DN:  " + _IMWatchRoleDN);
                Set _IMSaveUserSettingsRoleDNs = org.searchRoles(SAVEUSERSETTINGS_ROLE, 1);
                if (_IMSaveUserSettingsRoleDNs != null && _IMSaveUserSettingsRoleDNs.size() > 0) {
                    _IMSaveUserSettingsRoleDN = (String)_IMSaveUserSettingsRoleDNs.iterator().next();
                }
                Log.out.debug("[Identity] save user settings role DN:  " + _IMSaveUserSettingsRoleDN);
                PolicyManager pm = new PolicyManager(this._adminToken);
                Policy p = pm.getPolicy(DEFAULT_POLICY);
                Rule r = p.getRule(IM_DEFAULT_RULE);
                Map actVals = r.getActionValues();
                if (actVals != null) {
                    _topicsDefault = StringUtility.getFirstAttr(actVals.get(TOPICS_ATTR));
                    _roomsDefault = StringUtility.getFirstAttr(actVals.get(ROOMS_ATTR));
                    _sendAlertsDefault = StringUtility.getFirstAttr(actVals.get(SENDALERTS_ATTR));
                    _saveUserSettingsDefault = StringUtility.getFirstAttr(actVals.get(SAVEUSERSETTINGS_ATTR));
                }
                if ((actionValues = (pr = p.getRule(PRESENCE_DEFAULT_RULE)).getActionValues()) != null) {
                    _watchDefault = StringUtility.getFirstAttr(actionValues.get(WATCH_ATTR));
                }
                Log.out.debug("[Identity] _topicsDefault: " + _topicsDefault);
                Log.out.debug("[Identity] _roomsDefault: " + _roomsDefault);
                Log.out.debug("[Identity] _sendAlertsDefault: " + _sendAlertsDefault);
                Log.out.debug("[Identity] _saveUserSettingsDefault: " + _saveUserSettingsDefault);
                Log.out.debug("[Identity] _watchDefault: " + _watchDefault);
            }
            catch (SSOException se) {
                Log.out.info("[Identity] SSOException: " + se.getMessage());
            }
            catch (SMSException sme) {
                Log.out.info("[Identity] SMSException: " + sme.getMessage());
            }
            catch (AMException ae) {
                Log.out.info("[Identity] AMException: " + ae.getMessage());
            }
            catch (PolicyException pe) {
                Log.out.info("[Identity] PolicyException: " + pe.getMessage());
            }
        }
    }

    public void stop() {
    }

    private AMStoreConnection getAdminConnection() throws AMException, SSOException {
        if (this._adminConnection == null) {
            IdentityRealm identityRealm = this;
            synchronized (identityRealm) {
                this._adminToken = Auth.getAdminSSOToken((String)this.ldapUserName, (String)this.ldapPassword);
                this._adminConnection = new AMStoreConnection(this._adminToken);
            }
        }
        return this._adminConnection;
    }

    public Map getPolicyUsers(String policy) {
        HashMap<String, Set> policyUsers = new HashMap<String, Set>();
        try {
            this.getAdminConnection();
            PolicyManager pm = new PolicyManager(this._adminToken);
            SubjectTypeManager stm = pm.getSubjectTypeManager();
            Policy p = pm.getPolicy(policy);
            Set subjects = p.getSubjectNames();
            Iterator i = subjects.iterator();
            while (i.hasNext()) {
                String subjectName = (String)i.next();
                Subject subject = p.getSubject(subjectName);
                String subjectType = stm.getSubjectTypeName(subject);
                Log.out.debug("getPolicyUsers - TypeName: " + subjectType);
                Set subjectValues = subject.getValues();
                Log.out.debug("getPolicyUsers: " + subjectValues);
                policyUsers.put(subjectType + ":" + subjectName, subjectValues);
            }
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.warning("[Identity] admin connection reset: " + ssoe.getMessage());
        }
        catch (Exception e) {
            Log.out.warning("[Identity] getPolicyUsers exception: " + e.getMessage());
        }
        return policyUsers;
    }

    public Set getRoleUsers(String roleDN) {
        Set roleUsers = null;
        try {
            if (roleDN != null) {
                AMRole role = this.getAdminConnection().getRole(roleDN);
                roleUsers = role.getUserDNs();
                Log.out.debug("[Identity] " + roleDN + " user DNs: " + roleUsers);
            }
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.warning("[Identity] admin connection reset: " + ssoe.getMessage());
        }
        catch (Exception e) {
            Log.out.warning("[Identity] getRoleUsers exception: " + e.getMessage());
        }
        return roleUsers;
    }

    public String getIMAdminUserRoleDN() {
        return _IMAdminRoleDN;
    }

    public Set getIMAdminUsers() {
        return this.getRoleUsers(_IMAdminRoleDN);
    }

    public String getIMTopicsUserRoleDN() {
        return _IMTopicsRoleDN;
    }

    public Set getIMTopicsUsers() {
        return this.getRoleUsers(_IMTopicsRoleDN);
    }

    public String getIMRoomsUserRoleDN() {
        return _IMRoomsRoleDN;
    }

    public Set getIMRoomsUsers() {
        return this.getRoleUsers(_IMRoomsRoleDN);
    }

    public String getIMSendAlertsUserRoleDN() {
        return _IMSendAlertsRoleDN;
    }

    public Set getIMSendAlertsUsers() {
        return this.getRoleUsers(_IMSendAlertsRoleDN);
    }

    public String getIMWatchUserRoleDN() {
        return _IMWatchRoleDN;
    }

    public Set getIMWatchUsers() {
        return this.getRoleUsers(_IMWatchRoleDN);
    }

    public String getIMSaveUserSettingsUserRoleDN() {
        return _IMSaveUserSettingsRoleDN;
    }

    public Set getIMSaveUserSettingsUsers() {
        return this.getRoleUsers(_IMSaveUserSettingsRoleDN);
    }

    public String getTopicsDefault() {
        return _topicsDefault;
    }

    public String getRoomsDefault() {
        return _roomsDefault;
    }

    public String getSendAlertsDefault() {
        return _sendAlertsDefault;
    }

    public String getWatchDefault() {
        return _watchDefault;
    }

    public String getSaveUserSettingsDefault() {
        return _saveUserSettingsDefault;
    }

    public String getUid(String userDN) {
        try {
            AMUser u = this.getAdminConnection().getUser(userDN);
            return u.getStringAttribute("uid");
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.info("[Identity] admin connection reset: " + ssoe.getMessage());
            return null;
        }
        catch (Exception e) {
            Log.out.warning("[Identity] getUid exception: " + e.getMessage());
            return null;
        }
    }

    public Set getUserRoles(iIMUser user) {
        try {
            String userDN = user.getSingleStringValue("dn");
            AMUser u = this.getAdminConnection().getUser(userDN);
            return u.getRoleDNs();
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.info("[Identity] admin connection reset: " + ssoe.getMessage());
            return null;
        }
        catch (Exception e) {
            Log.out.warning("[Identity] getUserRoles exception: " + e.getMessage());
            return null;
        }
    }

    public NMSGroup _getNMSGroup(iIMPrincipal principal, iIMGroup nlg) throws RealmException {
        return super._getNMSGroup(principal, nlg);
    }

    private iIMUser createUser(Map attrs, String domain) {
        String uid = StringUtility.getFirstAttr(attrs.get(this.userUIDAttr));
        iIMUser u = new iIMUser(StringUtility.quoteSpecialCharacters(uid), domain, StringUtility.getFirstAttr(attrs.get(this.userDisplayAttr)), StringUtility.getFirstAttr(attrs.get(this.userMailAttr)));
        u.setDistinguishedName(StringUtility.getFirstAttr(attrs.get("dn")));
        u.setAllAttributes(attrs);
        return u;
    }

    private Map getBasicAttributes(AMUser user, Set attributeNames) throws AMException, SSOException {
        Map attrs = user.getAttributes(attributeNames);
        attrs.put("dn", user.getDN());
        return attrs;
    }

    protected void loadUserAttributes(SSOToken token, AMUser user, Map attributes, Set attributeNames) throws SSOException, AMException {
        try {
            Map basicAttrs = this.getBasicAttributes(user, attributeNames);
            Log.out.debug("[Identity] getBasicAttributes for " + user.getDN());
            attributes.putAll(basicAttrs);
        }
        catch (Exception e) {
            Log.out.info("[Identity] Failed to get basic user attributes for " + user.getDN() + " : " + e.toString());
        }
        if (NMS.getAclStore() == 1) {
            this.loadUserAttrsFromIMPresenceService(token, user, attributes, attributeNames);
        }
        attributes.put("roleDNs", user.getRoleDNs());
        Object[] lcAttrs = _userAttributeNames.toArray();
        int i = 0;
        while (i < lcAttrs.length) {
            String s = (String)lcAttrs[i];
            String lc = s.toLowerCase();
            _userAttributeNames.add(lc);
            ++i;
        }
        attributes.put("changableAttrs", _userAttributeNames);
    }

    private void loadUserAttrsFromIMPresenceService(SSOToken token, AMUser user, Map attributes, Set attributeNames) throws SSOException, AMException {
        ActionDecision val;
        Iterator i;
        Map actionDecisions;
        PolicyDecision policyDecision;
        String resourceName;
        ProtectedResource pr;
        Iterator iter;
        Set prs;
        HashMap envParams;
        PolicyEvaluator pe;
        Set vals;
        String attr;
        Iterator i2;
        Map userService = null;
        try {
            userService = user.getAttributes(_userAttributeNames);
        }
        catch (Exception e) {
            Log.out.info("[Identity] Failed to get user attributes for " + user.getDN() + ": " + e.toString());
        }
        Map dynamicService = null;
        try {
            dynamicService = user.getAttributes(_dynamicAttributeNames);
        }
        catch (Exception e) {
            Log.out.info("[Identity] Failed to get sunIM and sunPresence synamic attributes for " + user.getDN() + " = " + e.toString());
        }
        if (userService != null && !userService.isEmpty()) {
            Log.out.debug("[Identity] " + userService.size() + " user attributes");
            i2 = userService.keySet().iterator();
            while (i2.hasNext()) {
                attr = (String)i2.next();
                vals = (Set)userService.get(attr);
                Log.out.debug("[Identity] user: " + attr + " = " + vals);
                attributes.put(attr, vals);
            }
        }
        if (dynamicService != null && !dynamicService.isEmpty()) {
            Log.out.debug("[Identity] " + dynamicService.size() + " dynamic attributes");
            i2 = dynamicService.keySet().iterator();
            while (i2.hasNext()) {
                attr = (String)i2.next();
                vals = (Set)dynamicService.get(attr);
                Log.out.debug("[Identity] dynamic: " + attr + " = " + vals);
                attributes.put(attr, vals);
            }
        }
        Map oldIMService = null;
        if (_oldIMServiceAttributeNames != null) {
            try {
                oldIMService = user.getAttributes(_oldIMServiceAttributeNames);
            }
            catch (Exception e) {
                Log.out.info("[Identity] No OLD sunIMService dynamic attributes for " + user.getDN() + " = " + e.toString());
            }
        }
        try {
            pe = new PolicyEvaluator(IM_SERVICE);
            envParams = new HashMap();
            prs = pe.getProtectedResourcesIgnoreConditions(token, "---ALL_RESOURCES---");
            if (prs != null && prs.size() >= 1) {
                iter = prs.iterator();
                while (iter.hasNext()) {
                    pr = (ProtectedResource)iter.next();
                    resourceName = pr.getResourceName();
                    Log.out.debug("[Identity] resourceName: " + resourceName);
                    policyDecision = pe.getPolicyDecision(token, resourceName, _imPolicyAttributeNames, envParams);
                    actionDecisions = policyDecision.getActionDecisions();
                    if (actionDecisions == null || actionDecisions.isEmpty()) continue;
                    i = actionDecisions.keySet().iterator();
                    while (i.hasNext()) {
                        val = (ActionDecision)actionDecisions.get(i.next());
                        Log.out.debug("[Identity] " + val.getActionName() + " = " + val.getValues());
                        attributes.put(val.getActionName(), StringUtility.getFirstAttr(val.getValues()));
                    }
                }
            }
        }
        catch (Exception e) {
            Log.out.info("[Identity] Failed to get SunIM policy result for " + user.getDN() + " = " + e.toString());
        }
        try {
            pe = new PolicyEvaluator(PRESENCE_SERVICE);
            envParams = new HashMap();
            prs = pe.getProtectedResourcesIgnoreConditions(token, "---ALL_RESOURCES---");
            if (prs != null && prs.size() >= 1) {
                iter = prs.iterator();
                while (iter.hasNext()) {
                    pr = (ProtectedResource)iter.next();
                    resourceName = pr.getResourceName();
                    Log.out.debug("[Identity] resourceName: " + resourceName);
                    policyDecision = pe.getPolicyDecision(token, resourceName, _presencePolicyAttributeNames, envParams);
                    actionDecisions = policyDecision.getActionDecisions();
                    if (actionDecisions == null || actionDecisions.isEmpty()) continue;
                    i = actionDecisions.keySet().iterator();
                    while (i.hasNext()) {
                        val = (ActionDecision)actionDecisions.get(i.next());
                        Log.out.debug("[Identity] " + val.getActionName() + " = " + val.getValues());
                        attributes.put(val.getActionName(), StringUtility.getFirstAttr(val.getValues()));
                    }
                }
            }
        }
        catch (Exception e) {
            Log.out.info("[Identity] Failed to get SunPresence policy result for " + user.getDN() + " = " + e.toString());
        }
        if (oldIMService != null && !oldIMService.isEmpty()) {
            Iterator i3 = oldIMService.keySet().iterator();
            while (i3.hasNext()) {
                String attr2 = (String)i3.next();
                String val2 = StringUtility.getFirstAttr(oldIMService.get(attr2));
                if (attr2.equalsIgnoreCase("sunimallowfiletransfer")) {
                    if (StringUtility.getBoolean(val2)) {
                        attributes.put("sunIMAllowFileTransfer", "allow");
                    } else {
                        attributes.put("sunIMAllowFileTransfer", "deny");
                    }
                } else if (attr2.equalsIgnoreCase("sunimenablemoderator")) {
                    if (StringUtility.getBoolean(val2)) {
                        attributes.put("sunIMAllowForumModerate", "allow");
                    } else {
                        attributes.put("sunIMAllowForumModerate", "deny");
                    }
                }
                attributes.put(attr2, val2);
            }
        }
    }

    public iIMGroup _getiIMGroup(iIMPrincipal principal, String dn) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return super._getiIMGroup(orgDN, dn);
    }

    public iIMUser _getiIMUser(iIMPrincipal principal, String uid) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return super._getiIMUser(orgDN, uid);
    }

    public UserSearchReply _search(iIMPrincipal principal, String pattern, boolean byid, String filter) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return super._search(orgDN, pattern, byid, filter);
    }

    public iIMUser _auth(String uid, String possiblePass) throws RealmException {
        if (possiblePass == null || possiblePass.equals("")) {
            return null;
        }
        Log.out.debug("[Identity] Authenticating user " + uid);
        iIMUser u = null;
        try {
            u = this.trySSO(uid, possiblePass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (u != null || SSO.getMode() == -1) {
            return u;
        }
        try {
            String domainName = StringUtility.getDomainFromAddress(uid, NMS.getName());
            String orgDN = this.getSearchBase(domainName);
            this._orgToDomainMap.put(orgDN, domainName);
            Log.out.debug("[Identity] domain=" + domainName + " OrgDN=" + orgDN);
            uid = StringUtility.getLocalPartFromAddress(uid);
            uid = StringUtility.unquoteSpecialCharacters(uid);
            SSOToken token = Auth.getSSOToken((String)orgDN, (String)uid, (String)possiblePass);
            if (token == null) {
                Log.out.info("[Identity] Failed to create SSO token for " + uid);
                return null;
            }
            String userId = token.getPrincipal().getName();
            AMUser user = null;
            try {
                user = this.getAdminConnection().getUser(userId);
            }
            catch (SSOException ssoe) {
                this._adminConnection = null;
                Log.out.warning("[Identity] admin connection reset: " + ssoe.getMessage());
                return null;
            }
            HashMap map = new HashMap();
            this.loadUserAttributes(token, user, map, this.userAttributeSet);
            return this.createUser(map, domainName);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            return null;
        }
    }

    public String getSearchBase(iIMPrincipal u) throws RealmException {
        return this.getSearchBase(u.getServer());
    }

    public String getSearchBase(String domainName) throws RealmException {
        String searchBase = null;
        try {
            searchBase = this.getAdminConnection().getOrganizationDN(domainName, null);
        }
        catch (AMException ame) {
            Log.out.printStackTrace((Exception)((Object)ame));
            if (domainName.equalsIgnoreCase(NMS.getName())) {
                String errMsg = "The domain " + domainName + " is not associated with any organization or is assigned to more than one organization. This will cause security issues in multi-domain deployments.  Please make sure that the value of iim_server.domainname in the IM Server configuration file this domain matches one and only one organization's preferred domain.";
                Log.out.warning("[Identity] " + errMsg);
                System.out.println("\nWARNING *** " + errMsg);
                searchBase = this.root;
            }
            String errMsg = "The domain " + domainName + " is not associated with any organization or is assigned to more than one organization. Please make sure this domain matches one and only one organization's preferred domain.";
            Log.out.warning("[Identity] " + errMsg);
            System.out.println("\nWARNING *** " + errMsg);
            throw new RealmException(ame.toString());
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.toString());
        }
        Log.out.debug("[Identity] getSearchBase(" + domainName + ")=" + searchBase);
        return searchBase;
    }

    public String getDomainName(String searchBase) throws RealmException {
        String domainName = (String)this._orgToDomainMap.get(searchBase);
        if (domainName != null) {
            Log.out.debug("[Identity] _orgToDomainMap(" + searchBase + ")=" + domainName);
            return domainName;
        }
        try {
            AMOrganization amOrg = this.getAdminConnection().getOrganization(searchBase);
            domainName = amOrg.getStringAttribute(userDomainAttr);
            domainName = domainName.toLowerCase();
            if (domainName == null || domainName.equals("")) {
                domainName = NMS.getName();
                String errMsg = "The organization " + searchBase + " is not associated with any domain name. This will cause security issues in multi-domain deployments. Please set a domain name for this organization, using the Identity Server Administration Console.";
                System.out.println("\nWARNING *** " + errMsg);
                Log.out.warning("[Identity] " + errMsg);
            } else {
                this._orgToDomainMap.put(searchBase, domainName);
            }
        }
        catch (SSOException ssoe) {
            this._adminConnection = null;
            Log.out.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.toString());
        }
        catch (AMException ame) {
            Log.out.printStackTrace((Exception)((Object)ame));
            throw new RealmException(ame.toString());
        }
        Log.out.debug("[Identity] getDomainName(" + searchBase + ")=" + domainName);
        return domainName;
    }
}

