/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.StringUtility;
import com.sun.im.provider.MessageConverter;
import com.sun.im.service.MessagePart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class ExternalDocumentConverter
extends MessageConverter {
    static final String INPUTFILE_MACRO = "%i";
    static final String OUTPUTFILE_MACRO = "%o";
    static final String FILENAME_MACRO = "%f";
    static final String CONTENTTYPE_MACRO = "%c";
    static final String FORMAT_OPTION = "iim_server.conversion.external.command";
    static String _cmdFormat;

    public void convert(MessagePart part) throws Exception {
        String contentType = part.getContentType();
        if (!contentType.startsWith("text/")) {
            InputStream in = part.getInputStream();
            InputStream converted = this.convertAttachment(contentType, part.getContentName(), in);
            if (converted == in) {
                return;
            }
            if (converted == null) {
                part.clearContent();
            } else {
                part.setContent(converted, null);
            }
        }
    }

    public InputStream convertAttachment(String type, String filename, InputStream in) throws Exception {
        String inputFileName = System.getProperty("java.io.tmpdir") + File.separator + filename;
        File inputFile = new File(inputFileName);
        FileOutputStream fos = new FileOutputStream(inputFileName, false);
        byte[] b = new byte[1024];
        while (in.available() > 0) {
            int len = in.read(b);
            fos.write(b, 0, len);
        }
        String outputFileName = inputFileName + ".cvt";
        String cmd = StringUtility.substitute(_cmdFormat, INPUTFILE_MACRO, inputFileName);
        cmd = StringUtility.substitute(cmd, OUTPUTFILE_MACRO, outputFileName);
        cmd = StringUtility.substitute(cmd, FILENAME_MACRO, filename);
        cmd = StringUtility.substitute(cmd, CONTENTTYPE_MACRO, type);
        Log.out.debug("Invoking external command: " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        int status = p.waitFor();
        Log.out.debug("external command status: " + status);
        inputFile.delete();
        switch (status) {
            case 0: {
                return in;
            }
            case -1: {
                FileInputStream out = null;
                File outputFile = new File(outputFileName);
                if (outputFile.exists()) {
                    out = new FileInputStream(outputFile);
                    outputFile.delete();
                }
                return out;
            }
        }
        throw new Exception("converter failed with status " + status);
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        _cmdFormat = sc.getSetting(FORMAT_OPTION);
    }
}

