/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ByteArrayDataSource;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.HostPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class Email {
    public static final String SMTPHOST = "iim.smtpserver";
    static Properties javamailProperties = System.getProperties();
    private static String defaultCharset = MimeUtility.mimeCharset((String)MimeUtility.getDefaultJavaCharset());
    private static final String mailCharsetName = "iim.mail.charset";
    private static MimetypesFileTypeMap mimeTypes;
    static final String langCharsetFile = "charset.properties";
    static Properties langCharsetMap;

    private static void setMultipartContent(MimePart message, String text, boolean html, Map attachments, String charset) throws MessagingException, IOException {
        MimeMultipart parts = new MimeMultipart();
        InternetHeaders headers = new InternetHeaders();
        if (html) {
            headers.addHeader("Content-type", "text/html");
        } else {
            headers.addHeader("Content-type", "text/plain");
        }
        MimeBodyPart textPart = new MimeBodyPart(headers, null);
        Email.setTextContent((MimePart)textPart, text, html);
        parts.addBodyPart((BodyPart)textPart);
        Iterator i = attachments.keySet().iterator();
        while (i.hasNext()) {
            String filename = (String)i.next();
            headers = new InternetHeaders();
            String ctype = mimeTypes.getContentType(filename);
            headers.addHeader("Content-type", ctype);
            byte[] payload = (byte[])attachments.get(filename);
            MimeBodyPart part = new MimeBodyPart(headers, payload);
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(payload, ctype)));
            Log.out.debug("[Email] attachment: " + filename + " size=" + payload.length + " type=" + ctype);
            part.setFileName(MimeUtility.encodeWord((String)filename, (String)charset, null));
            parts.addBodyPart((BodyPart)part);
        }
        message.setContent((Multipart)parts);
    }

    private static void setTextContent(MimePart part, String text, boolean html) throws MessagingException {
        if (html) {
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(text, "text/html")));
        } else {
            part.setText(text, "UTF-8");
        }
    }

    public static void send(String from, String fromDisplayName, String to, String subj, String text, boolean html, boolean multipart, Map attachments, String lang) {
        Session session = Session.getDefaultInstance((Properties)javamailProperties, null);
        String charset = Email.getMimeCharset(lang);
        try {
            MimeMessage msg = new MimeMessage(session);
            InternetAddress fromAddr = fromDisplayName != null ? new InternetAddress(from, fromDisplayName, charset) : new InternetAddress(from);
            msg.setFrom((Address)fromAddr);
            InternetAddress[] toAddr = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddr);
            msg.setSubject(MimeUtility.encodeWord((String)subj, (String)charset, null));
            if (multipart) {
                Email.setMultipartContent((MimePart)msg, text, html, attachments, charset);
            } else {
                Email.setTextContent((MimePart)msg, text, html);
            }
            Transport.send((Message)msg);
            Log.out.info("sent email message to " + to + " from " + from);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.error("error sending email to " + to + " from " + from + " : " + e.toString());
        }
    }

    public static void sendWithAttachment(String fromAddress, String fromDisplayName, String to, String subj, String text, boolean html, Map attachments, String lang) {
        Email.send(fromAddress, fromDisplayName, to, subj, text, html, true, attachments, lang);
    }

    public static void send(String fromAddress, String fromDisplayName, String to, String subj, String text, boolean html, String lang) {
        Email.send(fromAddress, fromDisplayName, to, subj, text, html, false, null, lang);
    }

    private static void loadLangCharsetMap() {
        try {
            File f = new File(NMS.getConfigDir() + File.separator + langCharsetFile);
            FileInputStream is = new FileInputStream(f);
            langCharsetMap.load(is);
            is.close();
        }
        catch (Exception e) {
            Log.out.error("Could not load charset.properties file " + e.toString());
        }
    }

    public static String getMimeCharset(String lang) {
        String c = null;
        if (lang != null) {
            c = langCharsetMap.getProperty(lang);
        }
        if (c == null) {
            c = defaultCharset;
        }
        return c;
    }

    static {
        Log.out.info("Default platform mail charset: " + defaultCharset);
        ServerConfig sc = ServerConfig.getServerConfig();
        if (sc != null) {
            defaultCharset = sc.getSetting(mailCharsetName, defaultCharset);
            Log.out.info("Default platform mail charset: " + defaultCharset);
            String s = sc.getSetting(SMTPHOST, null);
            if (s != null) {
                HostPort hp = new HostPort(s, 25);
                ((Hashtable)javamailProperties).put("mail.smtp.port", new Integer(hp.getPort()));
                if (hp.getHostName() != null) {
                    ((Hashtable)javamailProperties).put("mail.smtp.host", hp.getHostName());
                }
            }
        }
        mimeTypes = new MimetypesFileTypeMap();
        langCharsetMap = new Properties();
        Email.loadLangCharsetMap();
    }
}

