/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.AclException;
import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.util.PlatformUtil;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;

abstract class BooleanAcl {
    static final String ADMINNAME = "sysAdmin";
    static FileUserSettings us = new FileUserSettings();
    static SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    static final String TOPICSADDDELNAME = "sysTopicsAdd";
    static final String ROOMSADDDELNAME = "sysRoomsAdd";
    static final String SAVEUSERSETTINGSNAME = "sysSaveUserSettings";
    static final String SENDALERTSNAME = "sysSendAlerts";
    static final String WATCHNAME = "sysWatch";
    static final String USER = "user";
    static final String EXT = ".acl";
    static final String SUBDIR = "acls";

    BooleanAcl() {
    }

    public static File getFile(String key) {
        String filename = key + EXT;
        File f = new File(NMS.getConfigDir(), SUBDIR);
        return new File(f, filename);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean check(File f, iIMUser u) {
        block18: {
            block17: {
                d = null;
                Log.out.debug("checking access of " + u.getUID() + " based on " + f.getAbsolutePath());
                userAccess = false;
                defaultAccess = true;
                try {
                    try {
                        d = new BufferedReader(new FileReader(f));
                        while (true) {
                            block19: {
                                if ((line = d.readLine()) != null) break block19;
                            }
                            line = var5_5.trim();
                            if (line.equals("")) continue;
                            st = new StringTokenizer(line, ":");
                            if (st.countTokens() < 2) {
                                Log.out.error(BooleanAcl.res.getString("invalid_line_in_acl") + f.getAbsolutePath());
                                continue;
                            }
                            type = st.nextToken();
                            type = type.trim();
                            value = st.nextToken();
                            value = value.trim();
                            if (type.equals("u")) {
                                value = StringUtility.appendDomainToAddress(value, NMS.getName());
                                if (userAccess) continue;
                                userAccess = u.getUID().equalsIgnoreCase(value);
                                continue;
                            }
                            if (type.equals("g")) {
                                block16: {
                                    group = StringUtility.getLocalPartFromAddress(value);
                                    server = StringUtility.getDomainFromAddress(value, NMS.getName());
                                    nmsg = null;
                                    if (server.equalsIgnoreCase(u.getServer())) {
                                        r = NMS.getRealm();
                                        try {
                                            nmsg = r.getGroup((iIMPrincipal)u, group);
                                            break block16;
                                        }
                                        catch (RealmException e) {
                                            continue;
                                        }
                                    }
                                    nmsg = NMS.get().getInboundGroup(server, group);
                                }
                                if (userAccess) continue;
                                userAccess = nmsg != null && nmsg.hasMember((iIMPrincipal)u) != false;
                                continue;
                            }
                            if (!type.equals("d")) break;
                            defaultAccess = value.equalsIgnoreCase("true");
                        }
                        Log.out.error(BooleanAcl.res.getString("unknown_p_type") + f);
                        var9_12 = false;
                        var15_17 = null;
                        break block17;
                        var6_8 = userAccess != false || defaultAccess != false;
                        break block18;
                    }
                    catch (Exception e) {
                        Log.out.warning("[BooleanAcl] check(" + f.toString() + "," + u.getUID() + ") failed: " + e.toString());
                        Log.out.printStackTrace(e);
                        var15_19 = null;
                        try {
                            if (d == null) return false;
                            d.close();
                            return false;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }
                catch (Throwable var14_25) {
                    var15_20 = null;
                    ** try [egrp 3[TRYBLOCK] [3 : 490->501)] { 
lbl68:
                    // 1 sources

                    if (d == null) throw var14_25;
                    d.close();
                    throw var14_25;
lbl71:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var14_25;
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 490->501)] { 
lbl76:
            // 1 sources

            if (d == null) return var9_12;
            d.close();
            return var9_12;
lbl79:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var9_12;
        }
        var15_18 = null;
        ** try [egrp 3[TRYBLOCK] [3 : 490->501)] { 
lbl85:
        // 1 sources

        if (d == null) return var6_8;
        d.close();
        return var6_8;
lbl88:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var6_8;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static BooleanAccessControlList get(File f) throws AclException {
        d = null;
        try {
            try {
                Log.out.debug("Getting acl file: " + f.getAbsolutePath());
                r = NMS.getRealm();
                ret = new BooleanAccessControlList();
                d = new BufferedReader(new FileReader(f));
                while (true) {
                    if ((line = d.readLine()) == null) {
                        var5_7 = ret;
                        var14_17 = null;
                        break;
                    }
                    line = var4_6.trim();
                    if (line.equals("")) continue;
                    st = new StringTokenizer(line, ":");
                    if (st.countTokens() < 2) {
                        Log.out.error(BooleanAcl.res.getString("invalid_line_in_acl") + f.getAbsolutePath());
                        continue;
                    }
                    type = st.nextToken();
                    type = type.trim();
                    value = st.nextToken();
                    value = value.trim();
                    if (type.equals("u")) {
                        server = StringUtility.getDomainFromAddress(value = StringUtility.appendDomainToAddress(value, NMS.getName()), NMS.getName());
                        if (server.equalsIgnoreCase(NMS.getName())) {
                            try {
                                nmsUser = r.getUser(value);
                                ret.add((iIMPrincipal)nmsUser.getiIMUser());
                            }
                            catch (RealmException re) {
                                Log.out.warning(BooleanAcl.res.getString("cant_find_user_in_acl") + re);
                            }
                            continue;
                        }
                        remoteuids = new String[]{value};
                        nc = Command.create((int)208, (Object)new Boolean(true), (Object)remoteuids);
                        nc.user = null;
                        reply = NMS.get().forwardToServer(server, nc);
                        if (reply == null) {
                            name = StringUtility.getLocalPartFromAddress(value);
                            ret.add((iIMPrincipal)new iIMUser(name, server, name));
                            continue;
                        }
                        if (Command.getReplyCode((CommandData)reply) < 0) {
                            name = StringUtility.getLocalPartFromAddress(value);
                            ret.add((iIMPrincipal)new iIMUser(name, server, name));
                            continue;
                        }
                        gotIt = (iIMUser[])Command.getReplyArg1((CommandData)reply);
                        ret.add((iIMPrincipal)gotIt[0]);
                        continue;
                    }
                    if (type.equals("g")) {
                        group = StringUtility.getLocalPartFromAddress(value);
                        server = StringUtility.getDomainFromAddress(group, NMS.getName());
                        if (server.equalsIgnoreCase(NMS.getName())) {
                            try {
                                nmsg = r.getGroup(null, group);
                                ret.add((iIMPrincipal)nmsg.getiIMGroup());
                            }
                            catch (RealmException e) {
                                Log.out.warning("Invalid group " + value + " in acl : " + f.getName());
                            }
                            continue;
                        }
                        nmsg = NMS.get().getInboundGroup(server, group);
                        if (nmsg != null) {
                            ret.add((iIMPrincipal)nmsg.getiIMGroup());
                            continue;
                        }
                        ret.add((iIMPrincipal)new iIMGroup(group, server, group));
                        continue;
                    }
                    if (!type.equals("d")) continue;
                    ret.setDefault(value.equalsIgnoreCase("true"));
                }
            }
            catch (Exception e) {
                Log.out.error("[BooleanAcl] get(" + f.getAbsolutePath() + ") failed : " + e.toString());
                Log.out.printStackTrace(e);
                var3_5 = null;
                var14_18 = null;
                try {
                    if (d == null) return var3_5;
                    d.close();
                    return var3_5;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return var3_5;
            }
        }
        catch (Throwable var13_23) {
            var14_19 = null;
            try {}
            catch (Exception e) {
                throw var13_23;
            }
            if (d == null) throw var13_23;
            d.close();
            throw var13_23;
        }
        ** try [egrp 4[TRYBLOCK] [4 : 658->669)] { 
lbl93:
        // 1 sources

        if (d == null) return var5_7;
        d.close();
        return var5_7;
lbl96:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var5_7;
    }

    protected static void set(File f, BooleanAccessControlList l) throws IOException {
        PrintWriter d = null;
        try {
            File tempfile = PlatformUtil.getTempFile(f);
            d = new PrintWriter(new BufferedWriter(new FileWriter(tempfile)));
            Enumeration e = l.entries();
            while (e.hasMoreElements()) {
                iIMPrincipal p = (iIMPrincipal)e.nextElement();
                String uid = NMS.getName().equalsIgnoreCase(p.getServer()) ? p.getName() : p.getUID();
                if (p instanceof iIMUser) {
                    d.println("u:" + uid);
                    continue;
                }
                if (!(p instanceof iIMGroup)) continue;
                d.println("g:" + uid);
            }
            d.println("d:" + l.getDefault());
            d.close();
            d = null;
            if (!PlatformUtil.renameTempFile(tempfile, f)) {
                Log.out.error("Renaming the file from " + tempfile.getAbsolutePath() + " to " + f.getAbsolutePath() + " failed");
            }
        }
        catch (IOException e) {
            Log.out.error(res.getString("writing_acl") + e.toString());
            if (d != null) {
                d.close();
            }
            throw e;
        }
    }

    static boolean checkAdmin(iIMUser u) {
        return BooleanAcl.check(BooleanAcl.getFile(ADMINNAME), u);
    }

    static BooleanAccessControlList getAdmin(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(ADMINNAME));
    }

    static void setAdmin(BooleanAccessControlList a, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(ADMINNAME), a);
    }

    static boolean checkTopicsAddDel(iIMUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(TOPICSADDDELNAME), u);
    }

    static BooleanAccessControlList getTopicsAddDel(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(TOPICSADDDELNAME));
    }

    static void setTopicsAddDel(BooleanAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(TOPICSADDDELNAME), l);
    }

    static boolean checkRoomsAddDel(iIMUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(ROOMSADDDELNAME), u);
    }

    static BooleanAccessControlList getRoomsAddDel(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(ROOMSADDDELNAME));
    }

    static void setRoomsAddDel(BooleanAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(ROOMSADDDELNAME), l);
    }

    static boolean checkSaveUserSettings(iIMUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(SAVEUSERSETTINGSNAME), u);
    }

    static BooleanAccessControlList getSaveUserSettings(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(SAVEUSERSETTINGSNAME));
    }

    static void setSaveUserSettings(BooleanAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(SAVEUSERSETTINGSNAME), l);
    }

    static boolean checkWatch(iIMUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(WATCHNAME), u);
    }

    static BooleanAccessControlList getWatch(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(WATCHNAME));
    }

    static void setWatch(BooleanAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(WATCHNAME), l);
    }

    static boolean checkSendAlerts(iIMUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(SENDALERTSNAME), u);
    }

    static BooleanAccessControlList getSendAlerts(iIMUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        return BooleanAcl.get(BooleanAcl.getFile(SENDALERTSNAME));
    }

    static void setSendAlerts(BooleanAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        BooleanAcl.set(BooleanAcl.getFile(SENDALERTSNAME), l);
    }
}

