/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import java.util.Enumeration;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;

    private ApprovalCallback() {
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        StringBuffer ret = new StringBuffer("[ApprovalCallback]");
        ret.append("SubjectDN = " + cert.getSubjectDN().getName() + " \n");
        Enumeration errors = status.getReasons();
        int numReasons = 0;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            ++numReasons;
            switch (reason) {
                case -8172: {
                    ret.append("Received a certificate with untrusted issuer[" + reason + "] \n");
                    break;
                }
                case -8171: {
                    ret.append("Received a untrusted certificate[" + reason + "] \n");
                    break;
                }
                case -8156: {
                    ret.append("CA Cert of the certificate is invalid[" + reason + "] \n");
                    break;
                }
                case -8179: {
                    ret.append("Unknown issuer of the certificate[" + reason + "] \n");
                    break;
                }
                case -12276: {
                    ret.append("Unknown issuer of the certificate[" + reason + "] \n");
                    break;
                }
                default: {
                    ret.append("Untrusted certificate[" + reason + "] \n");
                }
            }
        }
        if (numReasons == 0) {
            ret.append("Received Trusted Certificate \n");
            Log.out.info(ret.toString());
            return true;
        }
        if (trustAllServerCerts) {
            ret.append("Trusting the certificate as the option of trust all certs is set \n");
            Log.out.info(ret.toString());
            return true;
        }
        ret.append("Rejecting the certificate \n");
        Log.out.error(ret.toString());
        return false;
    }

    static {
        try {
            String tmp = System.getProperty("com.iplanet.im.trust_all_server_certs");
            trustAllServerCerts = tmp != null && tmp.equals("true");
        }
        catch (Exception e) {
            e.printStackTrace();
            trustAllServerCerts = false;
        }
    }
}

