/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.PropertiesException;
import java.io.BufferedReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class VAlarm {
    private CalendarComponent container;
    private String description;
    private String summary;
    private String action;
    private Duration trigger;
    private String related;
    private int repeatCount;
    private Duration repeatDuration;
    private String absTrigger;
    private Attach attachment;
    private ArrayList attendeeList;
    public static final String EMAIL = "EMAIL";
    public static final String AUDIO = "AUDIO";
    public static final String DISPLAY = "DISPLAY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String START = "START";
    public static final String END = "END";
    private static final Hashtable _actionValues = new Hashtable();
    private static final Hashtable _relatedValues = new Hashtable();

    public VAlarm() {
        this.related = START;
        this.attendeeList = new ArrayList();
    }

    public VAlarm(CalendarComponent calendarComponent, String string, Duration duration) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = calendarComponent;
        this.setAction(string);
        this.trigger = duration;
    }

    public VAlarm(CalendarComponent calendarComponent, String string, String string2) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = calendarComponent;
        this.setAction(string);
        this.absTrigger = string2;
    }

    private String[] _split(String string, char c, int n) {
        String[] stringArray = new String[n];
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (string.charAt(n5) == c) {
                if (n4 >= n - 1) break;
                stringArray[n4] = string.substring(n3, n5);
                n3 = n5 + 1;
                ++n4;
            }
            ++n5;
        }
        if (n4 < n) {
            stringArray[n4] = string.substring(n3, n2);
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    public VAlarm(CalendarComponent var1_1, String var2_2) throws IllegalArgumentException, PropertiesException {
        block27: {
            super();
            this.related = "START";
            this.attendeeList = new ArrayList<E>();
            var3_3 = new BufferedReader(new StringReader(var2_2));
            var5_4 = null;
            var6_5 = false;
            try {
                var4_6 = var3_3.readLine();
                var5_4 = new StreamTokenizer(new StringReader(var4_6));
                if (var5_4.nextToken() != -3 || !var5_4.sval.equalsIgnoreCase("BEGIN")) {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if ((char)var5_4.nextToken() != ':') {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if (var5_4.nextToken() == -3 && var5_4.sval.equalsIgnoreCase("VALARM")) ** GOTO lbl98
                throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
lbl-1000:
                // 1 sources

                {
                    var5_4 = new StreamTokenizer(new StringReader(var4_6));
                    var5_4.nextToken();
                    var7_7 = var5_4.sval.toUpperCase();
                    if (var7_7.equals("ACTION")) {
                        if ((char)var5_4.nextToken() != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check ACTION tag)");
                        }
                        var5_4.nextToken();
                        this.setAction(var5_4.sval);
                        if (!var5_4.sval.equalsIgnoreCase("EMAIL")) continue;
                        var6_5 = true;
                        continue;
                    }
                    if (var7_7.equals("TRIGGER")) {
                        var8_9 = (char)var5_4.nextToken();
                        if (var8_9 != ';' && var8_9 != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check TRIGGER tag)");
                        }
                        var5_4.nextToken();
                        if (var5_4.ttype == -3 && var5_4.sval.toUpperCase().equals("VALUE")) {
                            var9_13 = "";
                            var5_4.nextToken();
                            var5_4.wordChars(45, 45);
                            var5_4.nextToken();
                            var5_4.nextToken();
                            while (var5_4.nextToken() != -1) {
                                switch (var5_4.ttype) {
                                    case -3: {
                                        var9_13 = var9_13 + var5_4.sval;
                                        break;
                                    }
                                    case -2: {
                                        var9_13 = var9_13 + String.valueOf((int)var5_4.nval);
                                        break;
                                    }
                                    default: {
                                        var10_15 = new char[1];
                                        var10_15[0] = (char)var5_4.ttype;
                                        var9_13 = var9_13 + new String((char[])var10_15);
                                    }
                                }
                            }
                            this.absTrigger = var9_13;
                            continue;
                        }
                        var9_14 = 1;
                        if ((char)var5_4.ttype == '-') {
                            var9_14 = -1;
                            var5_4.nextToken();
                        }
                        var10_15 = "DURATION:" + var5_4.sval;
                        this.trigger = new Duration((String)var10_15);
                        continue;
                    }
                    if (var7_7.equals("DURATION")) {
                        this.repeatDuration = new Duration(var4_6);
                        continue;
                    }
                    if (var7_7.equals("ATTACH")) {
                        this.attachment = new Attach("RFC", var4_6);
                        continue;
                    }
                    if (var7_7.equals("ATTENDEE")) {
                        if (!var6_5) {
                            throw new IllegalArgumentException("Invalid VALARM format(ATTENDEE tag irrelevant)");
                        }
                        var8_10 = new Attendee(var4_6);
                        this.attendeeList.add(var8_10);
                        continue;
                    }
                    if (var7_7.equals("DESCRIPTION")) {
                        var8_11 = this._split(var4_6, ':', 2);
                        if (var8_11.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check DESCRIPTION tag)");
                        }
                        this.description = var8_11[1];
                        continue;
                    }
                    if (var7_7.equals("SUMMARY")) {
                        var8_12 = this._split(var4_6, ':', 2);
                        if (var8_12.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check SUMMARY tag)");
                        }
                        this.summary = var8_12[1];
                        continue;
                    }
                    if (!var7_7.equals("REPEAT")) continue;
                    if ((char)var5_4.nextToken() != ':') {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    if (var5_4.nextToken() != -2) {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    this.setRepeatCount((int)var5_4.nval);
lbl98:
                    // 12 sources

                    ** while ((var4_6 = var3_3.readLine()) != null)
                }
lbl99:
                // 1 sources

            }
            catch (Exception var7_8) {
                if (var7_8 instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)var7_8;
                }
                if (!(var7_8 instanceof PropertiesException)) break block27;
                throw (PropertiesException)var7_8;
            }
        }
    }

    public CalendarComponent getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAction() {
        return this.action;
    }

    public Duration getTrigger() {
        return this.trigger;
    }

    public String getAbsTrigger() {
        return this.absTrigger;
    }

    public String getRelated() {
        return this.related;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setAction(String string) throws PropertiesException {
        if (_actionValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.action = string;
    }

    public void setTrigger(Duration duration) {
        this.trigger = duration;
    }

    public void setAbsTrigger(String string) {
        this.absTrigger = string;
    }

    public void setRelated(String string) throws PropertiesException {
        if (_relatedValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.related = string;
    }

    public void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    public void setRepeat(int n, Duration duration) {
        this.repeatCount = n;
        this.repeatDuration = duration;
    }

    public void addAttendee(Attendee attendee) {
        this.attendeeList.add(attendee);
    }

    public Attendee[] getAttendees() {
        if (this.attendeeList == null || this.attendeeList.size() == 0) {
            return null;
        }
        Attendee[] attendeeArray = new Attendee[this.attendeeList.size()];
        return this.attendeeList.toArray(attendeeArray);
    }

    public String toRFC2445() {
        Object object;
        String string = "BEGIN:VALARM\n";
        string = string + "ACTION:" + this.action + "\n";
        if (this.absTrigger != null) {
            string = string + "TRIGGER;VALUE=DATE-TIME:" + this.absTrigger + "\n";
        } else {
            object = new StringTokenizer(this.trigger.toRFC2445(), ":");
            ((StringTokenizer)object).nextToken();
            string = string + "TRIGGER:" + ((StringTokenizer)object).nextToken() + "\n";
        }
        if (this.description != null) {
            string = string + "DESCRIPTION:" + ICalendar.escape(this.description) + "\n";
        }
        if (this.summary != null) {
            string = string + "SUMMARY:" + ICalendar.escape(this.summary) + "\n";
        }
        if (!this.related.equals(START)) {
            string = string + "RELATED:" + this.related + "\n";
        }
        if (this.repeatCount > 0) {
            string = string + "REPEAT:" + this.repeatCount + "\n";
        }
        if (this.repeatDuration != null) {
            string = string + this.repeatDuration.toRFC2445() + "\n";
        }
        if (this.attachment != null) {
            string = string + this.attachment.toRFC2445() + "\n";
        }
        if (this.attendeeList.size() > 0) {
            object = ((AbstractList)this.attendeeList).iterator();
            while (object.hasNext()) {
                string = string + ((Attendee)object.next()).toRFC2445() + "\n";
            }
        }
        string = string + "END:VALARM";
        return string;
    }

    static {
        _actionValues.put(EMAIL, "Dummy1");
        _actionValues.put(AUDIO, "Dummy2");
        _actionValues.put(DISPLAY, "Dummy3");
        _actionValues.put(PROCEDURE, "Dummy4");
        _relatedValues.put(START, "Dummy1");
        _relatedValues.put(END, "Dummy2");
    }
}

