/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.MissingPropertiesException;
import com.sun.comclient.calendar.VFreeBusy;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class CalendarStore {
    protected CalendarSession session;
    protected String serviceUrl;
    protected Hashtable calendarCache;
    public static final int CONTAINS = 0;
    public static final int BEGINS_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int EXACT = 3;

    protected CalendarStore(CalendarSession calendarSession) {
        this.session = calendarSession;
        this.calendarCache = new Hashtable();
    }

    public void connect() throws CalendarStoreException {
        Properties properties = this.session.getProperties();
        String string = properties.getProperty("cal.host");
        int n = Integer.parseInt(properties.getProperty("cal.port", "-1"));
        String string2 = properties.getProperty("cal.user");
        String string3 = properties.getProperty("cal.password");
        this.connect(string, n, string2, string3);
    }

    public void connect(String string, int n, String string2, String string3) throws CalendarStoreException {
        try {
            this.serviceUrl = this.constructServiceURL(string, n, string2, string3);
        }
        catch (MissingPropertiesException missingPropertiesException) {
            throw new CalendarStoreException("Could not connect: " + missingPropertiesException.getMessage());
        }
        this.connect(this.serviceUrl);
    }

    public void connect(String string, int n) throws CalendarStoreException {
        Properties properties = this.session.getProperties();
        String string2 = properties.getProperty("cal.user");
        String string3 = properties.getProperty("cal.password");
        if (n <= 0) {
            n = -1;
        }
        this.connect(string, n, string2, string3);
    }

    protected abstract String constructServiceURL(String var1, int var2, String var3, String var4) throws MissingPropertiesException;

    public abstract void connect(String var1) throws CalendarStoreException;

    public abstract void disconnect() throws CalendarStoreException;

    public abstract boolean isConnected();

    public void update() {
        Enumeration enumeration = this.calendarCache.elements();
        ICalendar iCalendar = null;
        while (enumeration.hasMoreElements()) {
            iCalendar = (ICalendar)enumeration.nextElement();
            iCalendar.update();
        }
    }

    public CalendarSession getSession() {
        return this.session;
    }

    public String getServiceUrlString() {
        return this.serviceUrl;
    }

    public ICalendar openCalendar() throws CalendarStoreException {
        String string = null;
        string = this.getDefaultCalendarId();
        return this.openCalendar(string);
    }

    public ICalendar openCalendar(String string) throws CalendarStoreException {
        ICalendar iCalendar = (ICalendar)this.calendarCache.get(string);
        if (iCalendar == null && (iCalendar = this.loadCalendar(string)) != null) {
            this.calendarCache.put(string, iCalendar);
        }
        return iCalendar;
    }

    public abstract ICalendar[] getCalendars() throws CalendarStoreException;

    public abstract String[] getSubscribedCalenders() throws CalendarStoreException;

    public abstract String verifyCalendarId(String var1) throws CalendarStoreException;

    protected abstract String getDefaultCalendarId() throws CalendarStoreException;

    protected abstract ICalendar loadCalendar(String var1) throws CalendarStoreException;

    public abstract ICalendar[] searchCalendars(String var1, int var2, int var3) throws CalendarStoreException;

    protected abstract void unloadCalendar(String var1) throws CalendarStoreException;

    public void closeCalendar(String string) throws CalendarStoreException {
        this.unloadCalendar(string);
        this.calendarCache.remove(string);
    }

    public void closeCalendar(ICalendar iCalendar) throws CalendarStoreException {
        this.closeCalendar(iCalendar.getCalID());
    }

    public abstract ICalendar createCalendar(String var1) throws CalendarStoreException;

    public abstract ICalendar createCalendar(String var1, Properties var2) throws CalendarStoreException;

    public abstract void deleteCalendar(String var1) throws CalendarStoreException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4) throws CalendarStoreException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4, String var5, int var6) throws CalendarStoreException;

    public abstract void importCalendar(String var1, String var2, InputStream var3) throws CalendarStoreException;

    public abstract void importCalendar(String var1, DateTime var2, DateTime var3, String var4, InputStream var5) throws CalendarStoreException;

    public abstract VFreeBusy fetchFreeBusy(String var1, DateTime var2, DateTime var3) throws CalendarStoreException;

    public abstract VFreeBusy fetchFreeBusy(String var1, DateTime var2, DateTime var3, String var4, int var5) throws CalendarStoreException;

    public abstract CalendarComponent[] fetchComponents(String var1, DateTime var2, DateTime var3, int var4) throws CalendarStoreException;

    public abstract CalendarComponent[] fetchComponents(String var1, DateTime var2, DateTime var3, int var4, String var5, int var6) throws CalendarStoreException;
}

