/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CommandToNet {
    private byte[] databuff = new byte[4096];
    private ByteArrayInputStream bais = new ByteArrayInputStream(this.databuff);
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private boolean useMux = false;

    public CommandToNet() {
    }

    public CommandToNet(boolean useMultiplexor) {
        this.useMux = useMultiplexor;
    }

    public CommandData readCommand(DataInputStream is) throws IOException, ClassNotFoundException {
        int len;
        if (this.useMux) {
            len = is.readInt();
        }
        if ((len = is.readInt()) > this.databuff.length) {
            this.databuff = new byte[len];
            this.bais = new ByteArrayInputStream(this.databuff);
        }
        int n = 0;
        while (n < len) {
            int in = is.read(this.databuff, n, len - n);
            if (in < 0) {
                throw new EOFException();
            }
            n += in;
        }
        ObjectInputStream obis = new ObjectInputStream(this.bais);
        Object o = obis.readObject();
        obis.close();
        this.bais.reset();
        obis = null;
        if (o instanceof CommandData) {
            return (CommandData)o;
        }
        System.err.println("Plainsocket unknown object type: " + o);
        return null;
    }

    public void sendCommand(DataOutputStream os, CommandData cd) throws IOException {
        ObjectOutputStream obos = new ObjectOutputStream(this.baos);
        obos.writeObject(cd);
        obos.close();
        obos = null;
        int len = this.baos.size();
        if (this.useMux) {
            os.writeInt(len + 4);
        }
        os.writeInt(len);
        this.baos.writeTo(os);
        this.baos.reset();
        os.flush();
    }
}

