/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessagePartImpl;
import com.iplanet.im.net.QueueMsg;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.MessagePart;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.ReadOnlyMessagePart;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseMessageImpl
extends MessagePartImpl
implements ReadOnlyMessage {
    HashMap _props = new HashMap();
    private ArrayList _parts = new ArrayList(1);

    public BaseMessageImpl(Message m) {
        super(m);
        this._message = m;
        this._parent = this;
        this.loadParts();
    }

    public BaseMessageImpl() {
    }

    public String getOriginator() {
        return this._message.getFrom().getUID();
    }

    public String getMessageId() {
        return this._message.getMsgid();
    }

    public Date getExpirationDate() {
        return this._message.getExpireDate();
    }

    public String getContentType() {
        return BaseMessageImpl.getContentType(this._message);
    }

    protected static String getContentType(Message m) {
        String netContentType = m.getContentType();
        if (netContentType.equals("net/text")) {
            return "text/plain";
        }
        if (netContentType.equals("net/html")) {
            return "text/html";
        }
        if (netContentType.equals("net/chat")) {
            return "text/html";
        }
        if (netContentType.equals("net/chatex")) {
            return "text/html";
        }
        if (netContentType.equals("net/invite")) {
            return "text/html";
        }
        if (netContentType.equals("net/url")) {
            return "text/url";
        }
        if (netContentType.equals("net/urlex")) {
            return "text/url";
        }
        if (netContentType.equals("net/htmlex")) {
            return "text/html";
        }
        if (netContentType.equals("net/poll")) {
            return "application/x-iim-poll";
        }
        if (netContentType.equals("net/pollreply")) {
            return "application/x-iim-poll-reply";
        }
        return netContentType;
    }

    public String getHeader(String header) {
        if (header.equalsIgnoreCase("subject")) {
            return this._message.getSubject();
        }
        if (this._message instanceof QueueMsg && header.equalsIgnoreCase("related-message-id")) {
            return ((QueueMsg)this._message).getCorrelationMsgId();
        }
        return (String)this._props.get(header.toLowerCase());
    }

    public void setHeader(String header, String value) {
        if (header.equalsIgnoreCase("subject")) {
            this._message.setSubject(value);
        }
        this._props.put(header.toLowerCase(), value);
    }

    public String[] getRecipients() throws CollaborationException {
        Destination[] dest = this._message.getTo();
        String[] result = new String[dest.length];
        int i = 0;
        while (i < dest.length) {
            result[i] = dest[i].getFQName();
            ++i;
        }
        return result;
    }

    private void loadParts() {
        this._parts.add(this);
        Map attachments = this._message.getAttachments();
        if (attachments != null) {
            Iterator i = attachments.keySet().iterator();
            while (i.hasNext()) {
                String filename = (String)i.next();
                byte[] content = (byte[])attachments.get(filename);
                this._parts.add(new MessagePartImpl(this, this._message, filename, content));
            }
        }
    }

    public MessagePart[] getParts() {
        MessagePart[] parts = new MessagePart[this._parts.size()];
        int n = 0;
        Iterator i = ((AbstractList)this._parts).iterator();
        while (i.hasNext()) {
            parts[n++] = (MessagePart)i.next();
        }
        return parts;
    }

    public List getPartsAsList() {
        return this._parts;
    }

    public ReadOnlyMessagePart[] getReadOnlyParts() {
        return this.getParts();
    }

    public void addPart(MessagePart part) throws CollaborationException {
        String mct = this._message.getContentType();
        if (part != this) {
            Hashtable<String, byte[]> attachments = this._message.getAttachments();
            if (attachments == null) {
                Hashtable<String, Hashtable<String, byte[]>> ht;
                if (mct.equals("net/htmlex") || mct.equals("net/urlex") || mct.equals("net/chatex")) {
                    ht = (Hashtable<String, Hashtable<String, byte[]>>)this._message.getBody();
                } else if (mct.equals("net/html")) {
                    this._message.setContentType("net/htmlex");
                    ht = new Hashtable<String, Hashtable<String, byte[]>>(3);
                    ht.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else if (mct.equals("net/chat")) {
                    this._message.setContentType("net/chatex");
                    ht = new Hashtable(3);
                    ht.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else if (mct.equals("net/url")) {
                    this._message.setContentType("net/urlex");
                    ht = new Hashtable(3);
                    ht.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else {
                    throw new CollaborationException("Cannot add part to message of content-tupe " + mct);
                }
                attachments = new Hashtable<String, byte[]>(3);
                ht.put("FILES", attachments);
            }
            attachments.put(part.getContentName(), ((MessagePartImpl)part).getBytes());
        }
    }

    public void removePart(MessagePart part) throws CollaborationException {
        Map attachments;
        if (part.getContentType().equalsIgnoreCase("application/octet-stream") && (attachments = this._message.getAttachments()) != null) {
            attachments.remove(part.getContentName());
        }
    }
}

