/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.jni;

import com.iplanet.im.util.BrowserLauncher;
import com.iplanet.im.util.PlatformUtil;
import java.awt.Frame;
import java.io.File;

public class JNILink {
    public static boolean JNI_LOADED = false;
    public static boolean USE_WIN_JNI = false;
    public static String JNI_FILE_NAME;
    private static boolean PLAY_NATIVE_SOUND;
    private static boolean BLINK_WIN32_WIN;

    private static native void nativeBlinkWindow(String var0) throws UnsatisfiedLinkError;

    private static native long nativeBringWindowToFront(String var0) throws UnsatisfiedLinkError;

    private static native void nativeAlwaysOnTop(String var0) throws UnsatisfiedLinkError;

    private static native void nativeAlwaysOnTopOff(String var0) throws UnsatisfiedLinkError;

    private static native void nativePlaySound(String var0) throws UnsatisfiedLinkError;

    private static native void nativePlaySoundStrong(String var0) throws UnsatisfiedLinkError;

    private static native int nativeShellExecute(byte[] var0) throws UnsatisfiedLinkError;

    private static native long nativeSetActiveWindowEx(long var0) throws UnsatisfiedLinkError;

    private static native long nativeGetActiveWindowEx() throws UnsatisfiedLinkError;

    private static native void nativeIsIdle(int var0) throws UnsatisfiedLinkError;

    private static native int nativeIsActive() throws UnsatisfiedLinkError;

    private static native long nativeToTop(long var0) throws UnsatisfiedLinkError;

    public static void loadJNILibrary() {
        File f = new File(PlatformUtil.getUserDir(), JNI_FILE_NAME);
        JNILink.loadLibrary(f.toString());
    }

    public static void loadJNILibraryNoPath() {
        JNILink.loadLibrary(JNI_FILE_NAME);
    }

    private static void loadLibrary(String s) {
        if (!(PlatformUtil.isWin() || PlatformUtil.isSun() || PlatformUtil.isLinux())) {
            return;
        }
        System.out.println("\n[jni] Loading library " + s);
        try {
            System.loadLibrary(s);
            if (PlatformUtil.isWin()) {
                USE_WIN_JNI = true;
            }
            JNI_LOADED = true;
        }
        catch (Throwable e) {
            System.out.println("[jni] Library not Loaded: " + e);
            System.out.println("[jni] Library path: " + System.getProperty("java.library.path"));
            e.printStackTrace();
            USE_WIN_JNI = false;
            JNI_LOADED = false;
        }
    }

    public static long getActiveWindow() {
        if (USE_WIN_JNI) {
            try {
                return JNILink.nativeGetActiveWindowEx();
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println("[jni] " + x);
            }
        }
        return 0L;
    }

    public static boolean isActive() {
        try {
            JNILink.nativeIsActive();
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("[jni] " + e);
            return false;
        }
    }

    public static boolean isIdle(int delay) {
        try {
            JNILink.nativeIsIdle(delay);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("[jni] " + e);
            return false;
        }
    }

    public static long setActiveWindow(long l) {
        if (l <= 0L) {
            return 0L;
        }
        if (USE_WIN_JNI) {
            try {
                return JNILink.nativeSetActiveWindowEx(l);
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println("[jni] " + x);
                return 0L;
            }
        }
        return 0L;
    }

    public static void flashWindow(Frame f) {
        if (f != null && f.isVisible()) {
            JNILink.flashWindow(f.getTitle());
        }
    }

    public static void flashWindow(String title) {
        if (USE_WIN_JNI && BLINK_WIN32_WIN) {
            try {
                JNILink.nativeBlinkWindow(title);
            }
            catch (UnsatisfiedLinkError e) {
                BLINK_WIN32_WIN = false;
            }
        }
    }

    public static void toFront(Frame f) {
        long l = JNILink.toFront(f.getTitle());
    }

    public static long toFront(String title) {
        if (USE_WIN_JNI) {
            try {
                return JNILink.nativeBringWindowToFront(title);
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println(x);
            }
        }
        return 0L;
    }

    public static long toTop(long lng) {
        if (USE_WIN_JNI) {
            try {
                return JNILink.nativeToTop(lng);
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println(x);
            }
        }
        return 0L;
    }

    public static void alwaysOnTop(Frame f, boolean b) {
        if (f != null && f.isVisible()) {
            JNILink.alwaysOnTop(f.getTitle(), b);
        }
    }

    public static void alwaysOnTop(String s, boolean b) {
        if (USE_WIN_JNI) {
            if (b) {
                try {
                    JNILink.nativeAlwaysOnTop(s);
                }
                catch (UnsatisfiedLinkError x) {
                    System.out.println(x);
                }
            } else {
                try {
                    JNILink.nativeAlwaysOnTopOff(s);
                }
                catch (UnsatisfiedLinkError x) {
                    System.out.println(x);
                }
            }
        }
    }

    public static void playWinSound(String filename) {
        if (USE_WIN_JNI && PLAY_NATIVE_SOUND) {
            try {
                JNILink.nativePlaySound(filename);
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println(x);
                PLAY_NATIVE_SOUND = false;
            }
        }
    }

    public static void playWinSoundStrong(String filename) {
        if (USE_WIN_JNI && PLAY_NATIVE_SOUND) {
            try {
                JNILink.nativePlaySoundStrong(filename);
            }
            catch (UnsatisfiedLinkError x) {
                System.out.println(x);
                PLAY_NATIVE_SOUND = false;
            }
        }
    }

    public static int executeWinApp(String name) {
        if (USE_WIN_JNI) {
            int n = -1;
            try {
                try {
                    n = JNILink.nativeShellExecute(name.getBytes());
                    System.out.println("[jni] ShellExecute: " + name + " rc=" + n);
                }
                catch (UnsatisfiedLinkError x) {
                    System.out.println(x);
                    Object var5_4 = null;
                    return n;
                }
                catch (Exception e) {
                    System.out.println(e);
                    Object var5_5 = null;
                    return n;
                }
                Object var5_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                return n;
            }
        }
        try {
            try {
                BrowserLauncher.openURL(name);
            }
            catch (Exception e) {
                System.out.println(e);
                Object var7_11 = null;
                return 0;
            }
            Object var7_10 = null;
            return 0;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            return 0;
        }
    }

    static {
        if (PlatformUtil.isWin()) {
            JNI_FILE_NAME = "libiim_Win32";
        } else {
            String osTag = PlatformUtil.getOSName() + "_" + PlatformUtil.getOSArch();
            JNI_FILE_NAME = "iim_" + osTag;
        }
        PLAY_NATIVE_SOUND = true;
        BLINK_WIN32_WIN = true;
    }
}

