/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.CollaborationHelperException;
import com.sun.im.service.PollAnswer;
import com.sun.im.service.SAX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Poll {
    private LinkedList _answers = new LinkedList();
    private String _customId = null;
    private String _question;
    private String _pollID;
    private String _pollType = null;
    private String _access = null;
    private boolean _quote;
    private boolean _customAnswerAllowed = false;
    private PollAnswer _lastParsedAnswer;
    private static final int IN_ROOT = 1;
    private static final int IN_QUESTION = 2;
    private static final int IN_ANSWER = 3;
    private static final int IN_ACCESS = 6;
    private static final int IN_POLL = 4;
    private static final int IN_POLLR = 5;
    public static final String ELEMENT_POLL = "poll";
    public static final String ELEMENT_QUESTION = "question";
    public static final String ELEMENT_ANSWER = "answer";
    public static final String ELEMENT_ACCESS = "access";
    public static final String ELEMENT_POLLR = "pollr";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_CUSTOM = "custom";
    public static final String ATTRIBUTE_QUOTE = "quote";
    public static final String ATTRIBUTE_ANSWERID = "answerid";
    public static final String ATTRIBUTE_TYPE = "anonymous";
    public static final String POLLTYPE_ANONYMOUS = "anon";
    public static final String POLLTYPE_OPEN = "open";
    public static final String POLLACCESS_PRIVATE = "private";
    public static final String POLLACCESS_PARTICIPANTS = "participants";
    public static final String POLLACCESS_PUBLIC = "public";
    public static final String POLLACCESS_NONE = "none";

    public Poll(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)new PollMessageParser());
    }

    public Poll(String message) throws Exception {
        SAX.parse(message, (DefaultHandler)new PollMessageParser());
    }

    public Poll(String question, List answers, boolean custom) {
        this._question = question;
        this.loadAnswers(answers);
        this._customAnswerAllowed = custom;
    }

    public Poll(String pollID, String question, List answers, boolean custom, String pollType, String access) {
        this._pollID = pollID;
        this._question = question;
        this._customAnswerAllowed = custom;
        this._access = access;
        this._pollType = pollType;
        this.loadAnswers(answers);
    }

    private void loadAnswers(List answers) {
        int i = 0;
        while (i < answers.size()) {
            this._answers.add(new PollAnswer(Integer.toString(i), (String)answers.get(i)));
            ++i;
        }
    }

    public String getPollID() {
        return this._pollID;
    }

    public String getQuestion() {
        return this._question;
    }

    public int countAnswers() {
        return this._answers.size();
    }

    public String getAnswer(int index) throws IndexOutOfBoundsException {
        PollAnswer a = (PollAnswer)this._answers.get(index);
        if (a == null) {
            throw new IndexOutOfBoundsException();
        }
        return a.text;
    }

    public String createResponse(int index) {
        PollAnswer a = (PollAnswer)this._answers.get(index);
        if (this._quote) {
            return "<?xml version='1.0'?>\n<pollr answerid='" + a.id + "'>" + a.text.toString() + "</pollr>";
        }
        return "<?xml version='1.0'?>\n<pollr answerid='" + a.id + "' />";
    }

    public String createResponse(String answer) throws CollaborationHelperException {
        boolean match = false;
        StringBuffer buf = new StringBuffer("<?xml version='1.0'?>\n<pollr ");
        if (this._pollID != null) {
            buf.append("id='");
            buf.append(this._pollID);
            buf.append("' ");
        }
        buf.append("answerid='");
        int i = 0;
        while (i < this._answers.size()) {
            if (answer.equals(((PollAnswer)this._answers.get((int)i)).text.toString())) {
                buf.append(i);
                if (this._quote) {
                    buf.append("'>" + answer + "</pollr>");
                } else {
                    buf.append("' />");
                }
                return buf.toString();
            }
            ++i;
        }
        if (this._customAnswerAllowed) {
            buf.append(this._customId);
            buf.append("'>" + answer + "</pollr>");
            return buf.toString();
        }
        throw new CollaborationHelperException("Custom answer not allowed for this poll: " + answer);
    }

    public InputStream createResponseStream(String answer) throws CollaborationHelperException {
        byte[] buf = this.createResponse(answer).getBytes();
        return new ByteArrayInputStream(buf, 0, buf.length);
    }

    public boolean isCustomAnswerAllowed() {
        return this._customAnswerAllowed;
    }

    public boolean isAnonynous() {
        return this._pollType != null && this._pollType.equalsIgnoreCase(POLLTYPE_ANONYMOUS);
    }

    public String getAccess() {
        return this._access;
    }

    public static String createResponse(String pollID, String answer) {
        StringBuffer buf = new StringBuffer("<?xml version='1.0'?>\n<pollr id='");
        buf.append(pollID);
        buf.append("'>");
        buf.append(answer);
        buf.append("</pollr>");
        return buf.toString();
    }

    private PollAnswer findAnswer(String answer) {
        PollAnswer a;
        Iterator i = this._answers.iterator();
        while (i.hasNext()) {
            a = (PollAnswer)i.next();
            if (a.text == null || !answer.equals(a.text)) continue;
            return a;
        }
        if (this._customAnswerAllowed) {
            a = new PollAnswer();
            a.text = answer;
            return a;
        }
        return null;
    }

    private PollAnswer findAnswerFromId(String id) {
        Iterator i = this._answers.iterator();
        while (i.hasNext()) {
            PollAnswer a = (PollAnswer)i.next();
            if (a.id == null || !id.equals(a.id)) continue;
            return a;
        }
        return null;
    }

    public String parseAnswer(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)new PollResponseParser());
        if (this._lastParsedAnswer == null) {
            throw new Exception("Answer does not match anything");
        }
        return this._lastParsedAnswer.text;
    }

    public synchronized String parseAnswer(String str) throws Exception {
        SAX.parse(str, (DefaultHandler)new PollResponseParser());
        if (this._lastParsedAnswer == null) {
            throw new Exception("Answer does not match anything");
        }
        return this._lastParsedAnswer.text;
    }

    public int getCount(String answerID) {
        return 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<?xml version='1.0'?>\n<poll");
        if (this._pollID != null) {
            buf.append(" id='");
            buf.append(this._pollID);
            buf.append("'");
        }
        if (this._customAnswerAllowed) {
            buf.append(" custom='c'");
        }
        if (this._pollType != null) {
            buf.append(" type='");
            buf.append(this._pollType);
            buf.append("'");
        }
        buf.append("><question>");
        buf.append(this._question);
        buf.append("</question>");
        if (this._access != null) {
            buf.append("><access>");
            buf.append(this._access);
            buf.append("</access>");
        }
        int i = 0;
        while (i < this._answers.size()) {
            PollAnswer a = (PollAnswer)this._answers.get(i);
            buf.append("<answer id='");
            buf.append(a.id);
            buf.append("'>");
            buf.append(a.text);
            buf.append("</answer>");
            ++i;
        }
        buf.append("</poll>");
        return buf.toString();
    }

    public static void main(String[] arg) {
    }

    class PollResponseParser
    extends DefaultHandler {
        private int _state;
        private PollAnswer _currentAnswer = null;
        private StringBuffer _quotedAnswer = null;

        PollResponseParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this._state) {
                case 5: {
                    this._quotedAnswer.append(ch, start, length);
                    break;
                }
                default: {
                    throw new SAXException("No characters at this stage");
                }
            }
        }

        public void startDocument() throws SAXException {
            Poll.this._lastParsedAnswer = null;
            this._state = 1;
        }

        public void endDocument() throws SAXException {
            if (this._currentAnswer == null && this._quotedAnswer != null) {
                this._currentAnswer = Poll.this.findAnswer(this._quotedAnswer.toString());
            }
            Poll.this._lastParsedAnswer = this._currentAnswer;
        }

        public void endElement(String nsuri, String localName, String fqName) throws SAXException {
            switch (this._state) {
                case 5: {
                    if (this._currentAnswer != null) {
                        ++this._currentAnswer.count;
                    }
                    this._state = 1;
                    break;
                }
                default: {
                    throw new SAXException("Invalid element end at this stage: " + fqName);
                }
            }
        }

        public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
            switch (this._state) {
                case 1: {
                    if (fqName.equals(Poll.ELEMENT_POLLR)) {
                        this._state = 5;
                        String id = attributes.getValue(Poll.ATTRIBUTE_ANSWERID);
                        if (id != null) {
                            this._currentAnswer = Poll.this.findAnswerFromId(id);
                        }
                        this._quotedAnswer = new StringBuffer();
                        break;
                    }
                    throw new SAXException("Invalid element: " + fqName);
                }
                default: {
                    throw new SAXException("Invalid element at this stage: " + fqName);
                }
            }
        }
    }

    class PollMessageParser
    extends DefaultHandler {
        private int _state;
        private PollAnswer _answer;
        private StringBuffer _buf;

        PollMessageParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this._state) {
                case 2: {
                    Poll.this._question = String.copyValueOf(ch, start, length);
                    break;
                }
                case 3: {
                    this._buf.append(ch, start, length);
                    break;
                }
                case 6: {
                    this._buf.append(ch, start, length);
                    break;
                }
                default: {
                    throw new SAXException("No characters at this stage: ");
                }
            }
        }

        public void startDocument() throws SAXException {
            this._state = 1;
        }

        public void endElement(String nsuri, String localName, String fqName) throws SAXException {
            switch (this._state) {
                case 4: {
                    this._state = 1;
                    break;
                }
                case 2: {
                    this._state = 4;
                    break;
                }
                case 6: {
                    Poll.this._access = this._buf.toString();
                    this._state = 4;
                    break;
                }
                case 3: {
                    this._answer.text = this._buf.toString();
                    Poll.this._answers.add(this._answer);
                    this._state = 4;
                    break;
                }
                default: {
                    throw new SAXException("Invalid element end at this stage: " + fqName);
                }
            }
        }

        public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
            switch (this._state) {
                case 1: {
                    if (fqName.equals(Poll.ELEMENT_POLL)) {
                        Poll.this._pollID = attributes.getValue(Poll.ATTRIBUTE_ID);
                        this._state = 4;
                        Poll.this._customId = attributes.getValue(Poll.ATTRIBUTE_CUSTOM);
                        Poll.this._pollType = attributes.getValue(Poll.ATTRIBUTE_TYPE);
                        if (attributes.getValue(Poll.ATTRIBUTE_QUOTE) == null) break;
                        Poll.this._quote = true;
                        break;
                    }
                    throw new SAXException("Invalid element: " + fqName);
                }
                case 4: {
                    if (fqName.equals(Poll.ELEMENT_QUESTION)) {
                        this._state = 2;
                        break;
                    }
                    if (fqName.equals(Poll.ELEMENT_ANSWER)) {
                        this._state = 3;
                        String id = attributes.getValue(Poll.ATTRIBUTE_ID);
                        if (id == null) {
                            throw new SAXException("Missing answer id");
                        }
                        this._buf = new StringBuffer();
                        this._answer = new PollAnswer(id);
                        break;
                    }
                    if (!fqName.equals(Poll.ELEMENT_ACCESS)) break;
                    this._buf = new StringBuffer();
                    this._state = 6;
                    break;
                }
                default: {
                    throw new SAXException("Invalid element at this stage: " + fqName);
                }
            }
        }
    }
}

