/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.SAX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConferenceEventHelper
extends DefaultHandler {
    private ArrayList _tuples = new ArrayList(2);
    private int _state;
    private ConferenceEventTuple _currentTuple;
    private StringBuffer _customMarkup;
    private final int IN_ROOT = 1;
    private final int IN_CEVENT = 2;
    private final int IN_SUBJECT = 3;
    private final int IN_NOTE = 4;
    private final String ELEMENT_CEVENT = "cevent";
    private final String ELEMENT_SUBJECT = "subject";
    private final String ELEMENT_NOTE = "note";
    private final String ATTRIBUTE_ACCESSLEVEL = "accesslevel";
    private final String ATTRIBUTE_STATUS = "status";
    private final String ATTRIBUTE_DESTINATION = "destination";

    public ConferenceEventHelper(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)this);
    }

    public ConferenceEventHelper(String str) throws Exception {
        SAX.parse(str, (DefaultHandler)this);
    }

    public ConferenceEventHelper() {
        this._tuples = new ArrayList();
    }

    public void addTuple(ConferenceEventTuple tuple) {
        this._tuples.add(tuple);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this._state) {
            case 4: {
                this._customMarkup.append(ch, start, length);
                break;
            }
            default: {
                throw new SAXException("No characters at this stage: ");
            }
        }
    }

    public void startDocument() throws SAXException {
        this._state = 1;
    }

    public void endElement(String nsuri, String localName, String fqName) throws SAXException {
        switch (this._state) {
            case 2: {
                this._state = 1;
                break;
            }
            case 3: {
                this._state = 2;
                this._tuples.add(this._currentTuple);
                break;
            }
            case 4: {
                this._currentTuple.note = this._customMarkup.toString();
                this._state = 3;
                break;
            }
            default: {
                throw new SAXException("Invalid element end at this stage: " + fqName);
            }
        }
    }

    public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
        switch (this._state) {
            case 1: {
                if (fqName.equals("cevent")) {
                    this._state = 2;
                    break;
                }
                throw new SAXException("Invalid element: " + fqName);
            }
            case 2: {
                if (fqName.equals("subject")) {
                    this._state = 3;
                    String status = attributes.getValue("status");
                    String accessLevel = attributes.getValue("status");
                    String destination = attributes.getValue("destination");
                    if (destination == null) {
                        throw new SAXException("Missing destination");
                    }
                    this._currentTuple = new ConferenceEventTuple(destination);
                    this._currentTuple.status = status;
                    this._currentTuple.accesslevel = accessLevel;
                    break;
                }
                throw new SAXException("Unrecognized element: " + fqName);
            }
            case 3: {
                if (fqName.equals("note")) {
                    this._state = 4;
                    this._customMarkup = new StringBuffer();
                    break;
                }
                throw new SAXException("Unrecognized element: " + fqName);
            }
            default: {
                throw new SAXException("Invalid element at this stage: " + fqName);
            }
        }
    }

    public Collection getTuples() {
        return this._tuples;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<?xml version='1.0'?>\n<cevent>");
        int i = 0;
        while (i < this._tuples.size()) {
            ConferenceEventTuple ces = (ConferenceEventTuple)this._tuples.get(i);
            buf.append("<subject destination='" + ces.destination + "'");
            if (ces.status != null) {
                buf.append(" status='" + ces.status + "'");
            }
            if (ces.accesslevel != null) {
                buf.append(" accesslevel='" + ces.accesslevel + "'");
            }
            if (ces.note != null && ces.note.length() > 0) {
                buf.append("><note>" + ces.note + "</note></subject>\n");
            } else {
                buf.append(" />");
            }
            ++i;
        }
        buf.append("</cevent>\n");
        return buf.toString();
    }

    public InputStream getInputStream() throws Exception {
        byte[] bytes = this.toString().getBytes();
        return new ByteArrayInputStream(bytes, 0, bytes.length);
    }
}

