/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.util;

public class ByteObjectPool {
    private byte[][] cached;
    private int array_size = 75;
    private int byte_size = 2048;
    private int last_pos = -1;

    public ByteObjectPool(int array_size, int byte_size) {
        this.array_size = array_size;
        this.byte_size = byte_size;
        this.init();
    }

    public ByteObjectPool() {
        this.init();
    }

    private void init() {
        this.cached = new byte[this.array_size][];
        int n = 0;
        while (n < this.array_size) {
            this.cached[n] = new byte[this.byte_size];
            ++n;
        }
        this.last_pos = this.array_size;
    }

    public synchronized byte[] getObject(int size) {
        if (size > this.byte_size || this.last_pos == 0) {
            return new byte[size];
        }
        --this.last_pos;
        return this.cached[this.last_pos];
    }

    public synchronized void releaseObject(byte[] o) {
        if (o.length != this.byte_size || this.last_pos == this.array_size) {
            return;
        }
        this.cached[this.last_pos] = o;
        ++this.last_pos;
    }
}

