/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public abstract class Message
implements Serializable {
    static final long serialVersionUID = -6972605931843726119L;
    static long lastTime = 0L;
    static int lastTimeIndex = 0;
    static Object timeLock = new Object();
    static Locale defaultLocale = Locale.getDefault();
    protected String msgid;
    protected Destination from = null;
    protected Destination[] to = null;
    protected Date creationDate = new Date();
    protected Date expireDate = null;
    protected Date futureSendDate = null;
    protected String contentType = new String("net/html");
    protected String lang = Locale.getDefault().toString();
    protected String subject = "no subject";
    protected Object body = null;
    protected transient boolean markRead = false;
    public static final String ID_BODY = "BODY";
    private static final String ID_FILES = "FILES";

    public Message() {
        long t = System.currentTimeMillis();
        int index = 0;
        Object object = timeLock;
        synchronized (object) {
            if (lastTime == t) {
                index = ++lastTimeIndex;
            } else {
                lastTime = t;
                lastTimeIndex = 0;
            }
        }
        this.msgid = "iim." + ConnectionFactory.processId + "." + Long.toString(t) + "." + index;
        this.setLocale(defaultLocale);
    }

    public void markRead() {
        this.markRead = true;
    }

    public boolean isMarkedRead() {
        return this.markRead;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public Destination getFrom() {
        return this.from;
    }

    public void setFrom(Destination d) {
        this.from = d;
    }

    public void setTo(Destination[] d) {
        this.to = d;
    }

    public void addTo(Destination d) {
        if (this.to == null || this.to.length == 0) {
            this.to = new Destination[1];
            this.to[0] = d;
        } else {
            Destination[] newTo = new Destination[this.to.length + 1];
            System.arraycopy(this.to, 0, newTo, 0, this.to.length);
            newTo[this.to.length] = d;
            this.to = newTo;
        }
    }

    public Destination[] getTo() {
        return this.to;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object o) {
        this.body = o;
    }

    public void setText(String s) {
        String type = this.getContentType();
        if (type.equals("net/htmlex")) {
            Hashtable ht = (Hashtable)this.getBody();
            ht.put(ID_BODY, s);
        } else if (type.equals("net/url")) {
            try {
                this.body = new URL(s);
            }
            catch (MalformedURLException e) {}
        } else if (type.equals("net/urlex")) {
            Hashtable ht = (Hashtable)this.getBody();
            try {
                ht.put(ID_BODY, new URL(s));
            }
            catch (MalformedURLException e) {}
        } else if (type.equals("net/chatex") || type.equals("net/invite")) {
            Object[] o = (Object[])this.getBody();
            o[0] = s;
        } else {
            this.body = s;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String propValue) {
        this.contentType = propValue;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date propValue) {
        this.creationDate = propValue;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date propValue) {
        this.expireDate = propValue;
    }

    public Date getFutureSendDate() {
        return this.futureSendDate;
    }

    public void setFutureSendDate(Date propValue) {
        this.futureSendDate = propValue;
    }

    public String getMsgid() {
        return this.msgid;
    }

    public void setMsgid(String propValue) {
        this.msgid = propValue;
    }

    public String toString() {
        return Message.toString(this);
    }

    public static final String toString(Message m) {
        if (m == null) {
            return null;
        }
        String type = m.getContentType();
        if (type.equals("net/html")) {
            return (String)m.getBody();
        }
        if (type.equals("net/htmlex")) {
            Hashtable ht = (Hashtable)m.getBody();
            return (String)ht.get(ID_BODY);
        }
        if (type.equals("net/text")) {
            return (String)m.getBody();
        }
        if (type.equals("net/url")) {
            return ((URL)m.getBody()).toString();
        }
        if (type.equals("net/urlex")) {
            Hashtable ht = (Hashtable)m.getBody();
            return ((URL)ht.get(ID_BODY)).toString();
        }
        if (type.equals("net/reply")) {
            return "Reply: " + (String)m.getBody();
        }
        if (type.equals("net/chat")) {
            return (String)m.getBody();
        }
        if (type.equals("net/chatex")) {
            Object[] o = (Object[])m.getBody();
            return (String)o[0];
        }
        if (type.equals("net/typing")) {
            return "Typing";
        }
        if (type.equals("net/typing_off")) {
            return "Typing-Off";
        }
        if (type.equals("net/wb")) {
            return "WhiteBoard";
        }
        if (type.equals("net/wb")) {
            return "WhiteBoard Invite";
        }
        if (type.equals("net/invite")) {
            Object[] o = (Object[])m.getBody();
            return (String)o[0];
        }
        if (type.equals("net/poll")) {
            StringBuffer buf = new StringBuffer("Poll: " + m.getSubject());
            Hashtable ht = (Hashtable)m.getBody();
            Vector list = (Vector)ht.get(ID_BODY);
            int n = 0;
            while (n < list.size()) {
                buf.append("\n");
                buf.append((String)list.elementAt(n));
                ++n;
            }
            buf.append("\n");
            return buf.toString();
        }
        if (type.equals("net/pollreply")) {
            return "Poll reply: " + (String)m.getBody();
        }
        return m.getBody().toString();
    }

    public Map getAttachments() {
        return Message.getAttachments(this);
    }

    public static Map getAttachments(Message m) {
        String type = m.getContentType();
        if (type.equals("net/htmlex") || type.equals("net/urlex")) {
            Hashtable ht = (Hashtable)m.getBody();
            return (Hashtable)ht.get(ID_FILES);
        }
        if (type.equals("net/chatex") || type.equals("net/invite")) {
            Object[] o = (Object[])m.getBody();
            if (o.length > 3 && o[2] != null && o[3] != null) {
                HashMap<String, Object> hm = new HashMap<String, Object>(3);
                hm.put((String)o[2], o[3]);
                return hm;
            }
            return null;
        }
        return null;
    }

    public void printAttachments() {
        Object[] o;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable ht = (Hashtable)this.body;
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (o = (Object[])this.body).length > 2 && o[2] != null) {
            System.out.println((String)o[2]);
        }
    }

    public void addAttachment(String filename, byte[] b) {
        Object[] o;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable ht = (Hashtable)this.body;
            Hashtable attachments = (Hashtable)ht.get(ID_FILES);
            attachments.put(filename, b);
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (o = (Object[])this.body).length > 3) {
            o[2] = filename;
            o[3] = b;
        }
    }

    public void renameAttachment(String oldName, String newName) {
        Object[] o;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable ht = (Hashtable)this.body;
            Hashtable attachments = (Hashtable)ht.get(ID_FILES);
            Object o2 = attachments.remove(oldName);
            if (o2 != null) {
                attachments.put(newName, o2);
            }
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (o = (Object[])this.body).length > 2) {
            o[2] = newName;
        }
    }

    public void removeAttachment(String filename) {
        Object[] o;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable ht = (Hashtable)this.body;
            Hashtable attachments = (Hashtable)ht.get(ID_FILES);
            attachments.remove(filename);
        } else if (this.contentType.equals("net/chatex")) {
            this.contentType = "net/chat";
            Object[] o2 = (Object[])this.body;
            this.body = o2[0];
        } else if (this.contentType.equals("net/invite") && (o = (Object[])this.body).length > 3) {
            o[2] = null;
            o[3] = null;
        }
    }

    public void setLocale(Locale locale) {
        this.lang = locale.toString();
    }

    public String getLangTag() {
        return this.lang;
    }
}

