/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.MessageListener;
import com.sun.im.service.CollaborationException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Connection {
    protected Vector changeListeners = new Vector(2);
    protected Destination destination;
    protected ConnectionFactory cf;
    private int startCnt;
    private boolean isStarted = false;
    protected boolean archive = false;

    void addMessage(Message m, CommandData cd) {
        this.fireMessageAdded(m, cd);
    }

    void delMessage(String msgid, CommandData cd) {
        this.fireMessageDeleted(msgid, cd);
    }

    public String getName() {
        return this.destination.getName();
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void start() throws CollaborationException {
        this.start(null);
    }

    public void start(String note) throws CollaborationException {
        ++this.startCnt;
        this.cf.start(this, note);
        this.isStarted = true;
    }

    public void stop() throws CollaborationException {
        if (this.isStarted) {
            this.cf.stop(this);
            this.isStarted = false;
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public synchronized void addChangeListener(MessageListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.addElement(l);
        }
    }

    public boolean hasChangeListener() {
        return !this.changeListeners.isEmpty();
    }

    public synchronized void removeChangeListener(MessageListener l) {
        this.changeListeners.removeElement(l);
    }

    public synchronized Enumeration getChangeListeners() {
        Vector tl = (Vector)this.changeListeners.clone();
        return tl.elements();
    }

    protected void fireMessageAdded(Message m, CommandData cd) {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        MessageEvent event = new MessageEvent(this, m, cd);
        Enumeration e = this.changeListeners.elements();
        while (e.hasMoreElements()) {
            MessageListener listener = (MessageListener)e.nextElement();
            listener.messageAdded(event);
        }
    }

    protected void fireMessageDeleted(String id, CommandData cd) {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        MessageEvent event = new MessageEvent(this, id, cd);
        Enumeration e = this.changeListeners.elements();
        while (e.hasMoreElements()) {
            MessageListener listener = (MessageListener)e.nextElement();
            listener.messageDeleted(event);
        }
    }

    public void setArchive(boolean b) {
        this.archive = b;
    }

    public boolean isArchiveEnabled() {
        return this.archive;
    }
}

