/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMContactList;
import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.util.StringUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalStoreFolder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;

public class iIMContactGroup
implements PersonalGroup {
    iIMSession _session;
    ArrayList _folders;
    iIMGroup _group;
    String _displayName;
    ArrayList _members;
    String _address;

    protected iIMContactGroup(iIMSession s, String displayName) throws CollaborationException {
        this._displayName = displayName;
        this._session = s;
        this._folders = new ArrayList();
        this._members = new ArrayList();
        this._address = StringUtility.appendDomainToAddress(displayName, this._session.connectionFactory.getServerName());
        this.addAddress(displayName);
    }

    protected iIMContactGroup(iIMSession s, iIMGroup group) throws CollaborationException {
        this._group = group;
        this._session = s;
        this._folders = new ArrayList();
        this._members = new ArrayList();
        this._address = StringUtility.appendDomainToAddress(group.getDisplayName(), this._session.connectionFactory.getServerName());
    }

    protected void setiIMGroup(iIMGroup group) throws CollaborationException {
        this._group = group;
    }

    private void addAddress(String address) throws CollaborationException {
        try {
            if (this._group == null) {
                this._group = this._session.connectionFactory.getiIMGroupFromUID(address);
            }
        }
        catch (CollaborationException e) {
            throw new CollaborationException(e.toString());
        }
    }

    public Collection expand() {
        try {
            iIMUser[] iimusers = this._session.connectionFactory.getiIMUsersInGroup(this._group.getUID());
            int i = 0;
            while (i < iimusers.length) {
                this._members.add(iimusers[i]);
                ++i;
            }
        }
        catch (CollaborationException collaborationException) {
            // empty catch block
        }
        return this._members;
    }

    public String getDisplayName() {
        if (this._group == null) {
            return this._displayName;
        }
        return this._group.getDisplayName();
    }

    public String getEntryId() {
        return this._address;
    }

    public String getType() {
        return "group";
    }

    public void addToFolder(PersonalStoreFolder folder) throws CollaborationException {
        this._folders.add(folder);
        ((iIMContactList)folder).addEntry(this);
    }

    public void removeFromFolder(PersonalStoreFolder folder) throws CollaborationException {
        ((iIMContactList)folder).removeEntry(this);
        ((AbstractCollection)this._folders).remove(folder);
    }

    public void save() throws CollaborationException {
        if (this._group == null) {
            this.remove();
        } else if (this._folders.size() > 0) {
            ((iIMContactList)this._folders.get(0)).save();
        } else {
            throw new CollaborationException("Entry not contained in any folder");
        }
    }

    public void remove() throws CollaborationException {
        int i = 0;
        while (i < this._folders.size()) {
            this.removeFromFolder((iIMContactList)this._folders.get(i));
            ++i;
        }
    }

    public boolean equals(Object o) {
        iIMContactGroup g;
        return o instanceof iIMContactGroup && (g = (iIMContactGroup)o).getEntryId().equals(this._address);
    }
}

