/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import sun.comm.client.Debug;

public class Connection {
    static final String sccs_id = "%W% %G% SMI";
    private URL conn = null;
    private HttpURLConnection urlConn = null;
    private static final String CLIENT_TYPE = "CLI/1.0";

    public String getClassVersion() {
        return sccs_id;
    }

    public Connection(String url) throws MalformedURLException {
        this.conn = new URL(url);
    }

    public HttpURLConnection getURLConnxn() {
        return this.urlConn;
    }

    public HttpURLConnection openConnection() throws IOException {
        this.urlConn = (HttpURLConnection)this.conn.openConnection();
        this.urlConn.setDoOutput(true);
        this.urlConn.setDoInput(true);
        this.urlConn.setRequestProperty("User-Agent", CLIENT_TYPE);
        this.urlConn.setRequestProperty("Connection", "Keep-Alive");
        Locale l = Locale.getDefault();
        String acceptlang = l.getLanguage();
        if (l.getCountry() != null && !l.getCountry().equals("")) {
            acceptlang = acceptlang + "-" + l.getCountry();
        }
        if (acceptlang != null && !acceptlang.trim().equals("")) {
            this.urlConn.setRequestProperty("Accept-Language", acceptlang.trim());
        }
        return this.urlConn;
    }

    public void send(String data) throws IOException {
        this.send(this.urlConn, data);
    }

    public void send(HttpURLConnection uConn, String data) throws IOException {
        if (uConn == null) {
            return;
        }
        OutputStream out = uConn.getOutputStream();
        byte[] utf8 = data.getBytes("UTF-8");
        out.write(utf8);
        out.close();
    }

    public Vector recv() throws IOException {
        InputStream instr = this.urlConn.getInputStream();
        return this.recv(instr);
    }

    public Vector recv(HttpURLConnection uConn) throws IOException {
        InputStream instr = uConn.getInputStream();
        return this.recv(instr);
    }

    public Vector recv(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "UTF8"));
        String str = null;
        Vector<String> strVec = new Vector<String>();
        int i = 0;
        while ((str = in.readLine()) != null) {
            strVec.addElement(str);
            Debug.println("RECV: " + str);
            ++i;
        }
        return strVec;
    }

    public void close() {
        this.close(this.urlConn);
    }

    public void close(HttpURLConnection uConn) {
        uConn.disconnect();
    }
}

