/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.comm.client.CLIInteractive;
import sun.comm.client.CLITask;
import sun.comm.client.CLIUsage;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.Debug;
import sun.comm.client.GetOpts;
import sun.comm.client.HttpsHandlerFactory;
import sun.comm.client.InvalidOptionException;
import sun.comm.client.MissingOptionException;

public class CommAdmin {
    static final String sccs_id = "%W% %G% SMI";
    private static int debugLevel = 0;
    private static FileInputStream inputFile = null;
    private static FileOutputStream outputFile = null;
    private static boolean printUsage = false;
    private static boolean printVersion = false;
    private static boolean nonInteractive = false;
    private static boolean dontLogout = false;
    private static boolean uniqLogin = false;
    private ResourceBundle res = null;
    private CLIValidOptions validOptions = null;
    private String[] optionValues = null;
    private Vector[] optionMultiValues = null;
    private String[][] validOptionsArray = new String[][]{{"h", "false", "false", "false", "true", "OptDesc_help", ""}, {"?", "false", "false", "false", "true", "OptDesc_CLIPhelp", ""}, {"i", "true", "", "false", "true", "OptDesc_infile", ""}, {"s", "false", "false", "false", "true", "OptDesc_ssl", ""}, {"v", "false", "false", "false", "true", "OptDesc_debug", ""}, {"V", "false", "false", "false", "true", "OptDesc_version", ""}, {"nologout", "false", "false", "false", "true", "Dont logout any session (stress tests)", ""}, {"uniqlogin", "false", "false", "false", "true", "Login everytime (stress tests)", ""}};

    public String getClassVersion() {
        return sccs_id;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debugLevel) {
        CommAdmin.debugLevel = debugLevel;
    }

    public static FileInputStream getInputFile() {
        return inputFile;
    }

    public static void setInputFile(String inputFileName) throws FileNotFoundException {
        inputFile = inputFileName.equals("-") ? new FileInputStream(FileDescriptor.in) : new FileInputStream(inputFileName);
        CommAdmin.setNonInteractive(true);
    }

    public static FileOutputStream getOutputFile() {
        return outputFile;
    }

    public static void setOutputFile(String outputFileName) throws IOException {
        outputFile = new FileOutputStream(outputFileName);
    }

    public static boolean getPrintUsage() {
        return printUsage;
    }

    public static void setPrintUsage(boolean printUsage) {
        CommAdmin.printUsage = printUsage;
    }

    public static boolean getPrintVersion() {
        return printVersion;
    }

    public static void setPrintVersion(boolean printVersion) {
        CommAdmin.printVersion = printVersion;
    }

    public static boolean getNonInteractive() {
        return nonInteractive;
    }

    public static void setNonInteractive(boolean nonInteractive) {
        CommAdmin.nonInteractive = nonInteractive;
    }

    public static void setNoLogout(boolean flag) {
        dontLogout = flag;
    }

    public static boolean getDontLogout() {
        return dontLogout;
    }

    public static void setUniqLogin(boolean flag) {
        uniqLogin = flag;
    }

    public static boolean getUniqLogin() {
        return uniqLogin;
    }

    public CommAdmin() {
        this.res = ResourceBundle.getBundle("sun.comm.client.CLIResourceBundle", Locale.getDefault());
        this.validOptions = new CLIValidOptions(this.validOptionsArray);
    }

    public static void main(String[] argv) {
        int i;
        GetOpts opts = null;
        CommAdmin ia = null;
        Vector imAdminArgs = null;
        CLIUsage usage = null;
        ia = new CommAdmin();
        opts = new GetOpts(ia.validOptions.getNames(true), true);
        imAdminArgs = new Vector();
        Debug.setDebug(true);
        CLIValidOptions usageOptions = new CLIValidOptions(ia.validOptions.getValidOptionsArray());
        usageOptions.removeValidOption("nologout");
        usageOptions.removeValidOption("uniqlogin");
        usage = new CLIUsage(ia.res.getString("Task"), ia.res.getString("Object"), usageOptions);
        String[] args = null;
        try {
            args = opts.parseOpts(argv);
        }
        catch (InvalidOptionException e) {
            System.err.println(ia.res.getString("InvalidOption"));
            System.exit(1);
        }
        ia.optionValues = ia.validOptions.getDefaultValues();
        ia.optionMultiValues = new Vector[ia.optionValues.length];
        for (i = 0; i < ia.optionValues.length; ++i) {
            ia.optionMultiValues[i] = new Vector();
            ia.optionMultiValues[i].addElement(ia.optionValues[i]);
        }
        for (i = 0; i < ia.validOptions.size(); ++i) {
            String currentOption = ia.validOptions.getName(i);
            if (!opts.isOpt(currentOption)) continue;
            Vector arg = opts.getMultiArgs(currentOption);
            if (arg != null) {
                ia.optionValues[i] = (String)arg.elementAt(arg.size() - 1);
                ia.optionMultiValues[i] = arg;
                continue;
            }
            if (!ia.validOptions.getTakesArg(i)) {
                ia.optionValues[i] = "true";
                ia.optionMultiValues[i] = new Vector();
                ia.optionMultiValues[i].addElement("true");
                continue;
            }
            System.err.println(ia.res.getString("OptNeedsArg") + currentOption);
            System.err.println(ia.res.getString("InvalidOption"));
            System.exit(1);
        }
        int index = 0;
        index = ia.validOptions.indexOf("V");
        boolean verOpt = Boolean.valueOf(ia.optionValues[index]);
        if (verOpt) {
            CLIInteractive.printResult(ia.res.getString("VersionInfo"));
            System.exit(0);
        }
        if (argv.length < 2) {
            usage.printUsage(false);
            System.exit(1);
        }
        if (!ia.optionValues[index = ia.validOptions.indexOf("i")].equals("")) {
            try {
                CommAdmin.setInputFile(ia.optionValues[index]);
            }
            catch (FileNotFoundException e) {
                System.err.println(ia.res.getString("FileNotFound") + ia.optionValues[index]);
                usage.printUsage(false);
                System.exit(4);
            }
        }
        index = ia.validOptions.indexOf("v");
        Debug.setDebug(Boolean.valueOf(ia.optionValues[index]));
        index = ia.validOptions.indexOf("h");
        boolean helpSwitch = Boolean.valueOf(ia.optionValues[index]);
        index = ia.validOptions.indexOf("?");
        helpSwitch = helpSwitch || Boolean.valueOf(ia.optionValues[index]) != false;
        CommAdmin.setPrintUsage(helpSwitch);
        index = ia.validOptions.indexOf("s");
        boolean secure = Boolean.valueOf(ia.optionValues[index]);
        index = ia.validOptions.indexOf("nologout");
        CommAdmin.setNoLogout(Boolean.valueOf(ia.optionValues[index]));
        index = ia.validOptions.indexOf("uniqlogin");
        CommAdmin.setUniqLogin(Boolean.valueOf(ia.optionValues[index]));
        int status = 0;
        HttpsHandlerFactory fac = new HttpsHandlerFactory();
        URL.setURLStreamHandlerFactory(fac);
        CLITask objTask = new CLITask(secure);
        try {
            status = objTask.doStuff(args);
        }
        catch (MissingOptionException e) {
            CLIInteractive.printResult("\n");
            status = 3;
        }
        catch (InvalidOptionException e) {
            CLIInteractive.printError(ia.res.getString("InvalidOption") + ": " + e.getMessage());
            status = 2;
        }
        if (CommAdmin.getPrintUsage()) {
            usage.getValidOptions().addValidOptions(objTask.getValidOptions());
            usage.getValidOptions().sort();
            String str = null;
            str = objTask.getUsageObject();
            if (str != null) {
                usage.setObjectName(str);
            }
            if ((str = objTask.getUsageTask()) != null) {
                usage.setTaskName(str);
            }
            usage.printUsage(true);
        }
        System.exit(status);
    }
}

