/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Date;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import sun.comm.dirmig.SmartWriter;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commDomainGroup;
import sun.comm.dirmig.commEntry;

public class commLogger {
    private static SmartWriter sLogFile = null;
    private static int sLogLevel = 0;
    private static String sStringSpacer = " ^^ ";
    private static String sNewLine = "\n";
    private static String sArrow = " => ";
    private static String sMissingCodedString = null;
    private static String sException = null;
    private static String sLdapException = null;
    private static String sDnTitle = "dn => ";

    public commLogger(String theFile, int theLogLevel) throws Exception {
        sLogFile = new SmartWriter(theFile);
        sLogLevel = theLogLevel;
        sMissingCodedString = commConfig.getLogString("missing_coded_string");
        sException = commConfig.getLogString("exception");
        sLdapException = commConfig.getLogString("ldap_exception");
    }

    public static void writeLog(String theString, int theLevel) throws Exception {
        if (theString == null) {
            return;
        }
        if (theLevel >= sLogLevel) {
            String[] aStrings = new String[]{theString};
            commLogger.printLine(aStrings);
        }
    }

    public static void writeLog(int theStringCode, int theLevel) throws Exception {
        String aStatusString = commConfig.getCodedString(theStringCode);
        if (aStatusString == null) {
            aStatusString = sMissingCodedString + theStringCode;
        }
        if (theLevel >= sLogLevel) {
            String[] aStrings = new String[]{aStatusString};
            commLogger.printLine(aStrings);
        }
    }

    public static void writeLog(int theCode, String theString) throws Exception {
        String aStatusString = commConfig.getCodedString(theCode);
        if (aStatusString == null) {
            aStatusString = sMissingCodedString + theCode;
        }
        String[] aStrings = new String[]{aStatusString, sArrow, theString};
        commLogger.printLine(aStrings);
    }

    public static void writeLog(String theString) throws Exception {
        String[] aStrings = new String[]{theString};
        commLogger.printLine(aStrings);
    }

    public static void writeLog(int theErrorCode, Exception theException) throws Exception {
        String[] aStrings = new String[10];
        String aErrorString = commConfig.getCodedString(theErrorCode);
        int aIdx = 0;
        if (aErrorString == null) {
            aErrorString = sMissingCodedString + theErrorCode;
        }
        aStrings[aIdx++] = aErrorString;
        if (sLogLevel >= 2) {
            aStrings[aIdx++] = sException;
            aStrings[aIdx++] = sArrow;
            aStrings[aIdx++] = theException.getMessage();
        }
        aStrings[aIdx] = null;
        commLogger.printLine(aStrings);
    }

    public static void writeLog(int theErrorCode, LDAPException theLdapException) throws Exception {
        String[] aStrings = new String[10];
        String aErrorString = commConfig.getCodedString(theErrorCode);
        int aIdx = 0;
        if (aErrorString == null) {
            aErrorString = sMissingCodedString + theErrorCode;
        }
        aStrings[aIdx++] = aErrorString;
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = sLdapException;
        aStrings[aIdx++] = sArrow;
        aStrings[aIdx++] = theLdapException.errorCodeToString();
        aStrings[aIdx] = null;
        commLogger.printLine(aStrings);
    }

    public static void writeLog(int theErrorCode, LDAPException theLdapException, commEntry theCommEntry) throws Exception {
        commLogger.writeLog(theErrorCode, theLdapException, theCommEntry.getLDAPEntry());
    }

    public static void writeLog(int theErrorCode, LDAPException theLdapException, LDAPEntry theLdapEntry) throws Exception {
        int aIdx = 0;
        String aErrorString = commConfig.getCodedString(theErrorCode);
        String[] aStrings = new String[14];
        if (aErrorString == null) {
            aErrorString = sMissingCodedString + theErrorCode;
        }
        aStrings[aIdx++] = aErrorString;
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = sDnTitle;
        aStrings[aIdx++] = theLdapEntry.getDN();
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = sLdapException;
        aStrings[aIdx++] = sArrow;
        aStrings[aIdx++] = theLdapException.errorCodeToString();
        if (sLogLevel >= 2) {
            aStrings[aIdx++] = sNewLine;
            aStrings[aIdx++] = commEntry.LdapEntryToLdif(theLdapEntry, true);
        }
        aStrings[aIdx] = null;
        commLogger.printLine(aStrings);
    }

    public static void writeLog(int theErrorCode, LDAPException theLdapException, LDAPModificationSet theLdapModificationSet, String theDn) throws Exception {
        int aIdx = 0;
        String aErrorString = commConfig.getCodedString(theErrorCode);
        String[] aStrings = new String[14];
        if (aErrorString == null) {
            aErrorString = sMissingCodedString + theErrorCode;
        }
        aStrings[aIdx++] = aErrorString;
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = sDnTitle;
        aStrings[aIdx++] = theDn;
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = sLdapException;
        aStrings[aIdx++] = sArrow;
        aStrings[aIdx++] = theLdapException.errorCodeToString();
        if (sLogLevel >= 2) {
            aStrings[aIdx++] = sNewLine;
            aStrings[aIdx++] = commEntry.LdapModificationSetToLdif(theLdapModificationSet, theDn);
        }
        aStrings[aIdx] = null;
        commLogger.printLine(aStrings);
    }

    public static void writeLog(int theCode, commDomainGroup theDomainGroup) throws Exception {
        int aIdx = 0;
        String aErrorString = commConfig.getCodedString(theCode);
        String[] aStrings = new String[12];
        if (aErrorString == null) {
            aErrorString = sMissingCodedString + theCode;
        }
        aStrings[aIdx++] = aErrorString;
        aStrings[aIdx++] = sStringSpacer;
        aStrings[aIdx++] = theDomainGroup.getErrorMessage();
        aStrings[aIdx++] = sNewLine;
        commLogger.printLine(aStrings);
    }

    public static void writeLog(String theString, Exception theException, commEntry theCommEntry, int theLevel) throws Exception {
    }

    public static void writeLog(String theString, LDAPException theLdapException, Exception theException, commEntry theCommEntry, LDAPEntry theLdapEntry, LDAPModificationSet theLdapModificationSet, int theLevel) throws Exception {
    }

    protected static void printLine(String[] theStrings) throws Exception {
        Date aNow = new Date(System.currentTimeMillis());
        String aCurrentTime = aNow.toString();
        StringBuffer aStringBuffer = new StringBuffer(120);
        int aIdx = 0;
        aStringBuffer.append(aCurrentTime).append(sStringSpacer);
        for (aIdx = 0; aIdx < theStrings.length && theStrings[aIdx] != null; ++aIdx) {
            aStringBuffer.append(theStrings[aIdx]);
        }
        sLogFile.printLine(aStringBuffer.toString());
    }

    public static String formatMargin(String theString, int theMargin, String theContinuationLine) {
        StringBuffer aStringBuffer = new StringBuffer(theString);
        String aInsertString = null;
        int aFormattedLength = 0;
        aInsertString = theContinuationLine != null ? "\n" + theContinuationLine : "\n";
        while (aStringBuffer.length() - aFormattedLength > theMargin) {
            aStringBuffer.insert(aFormattedLength + theMargin, aInsertString);
            aFormattedLength += theMargin;
        }
        return aStringBuffer.toString();
    }
}

