/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPEntry;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commConfigService;
import sun.comm.dirmig.commDirectory;
import sun.comm.dirmig.commEntry;
import sun.comm.dirmig.commOsiEntry;

public class commDomainEntry
extends commEntry {
    String sBaseDn = null;
    String sDomainName = null;
    String sCanonicalName = null;
    String sCanonicalAttrValue = null;
    String sPreferredMailHost = null;
    commOsiEntry sOsiCommEntry = null;
    int sSchemaType = 0;
    int sErrorCode = 100;
    boolean sIndirectState = false;
    Vector sAssociatedDomains = null;
    Vector sFailedOsiList = null;

    public commDomainEntry(LDAPEntry theLdapEntry) {
        super(theLdapEntry);
        this.objectType = "Domain";
        String aSI_markerClass = commConfig.getMarkerClass("Domain", "Base", "S1");
        try {
            if (commDirectory.attributeHasValue(theLdapEntry, "objectclass", aSI_markerClass)) {
                this.sSchemaType = 1;
                this.sDomainName = commDirectory.domainDnToDomainName(theLdapEntry.getDN());
                this.sCanonicalAttrValue = commDirectory.getFirstAttrValue(theLdapEntry, "inetCanonicalDomainName");
                if (this.sCanonicalAttrValue != null) {
                    this.sCanonicalName = this.sCanonicalAttrValue = this.sCanonicalAttrValue.trim();
                } else {
                    this.sCanonicalAttrValue = null;
                    this.sCanonicalName = this.sDomainName;
                }
            } else {
                this.sSchemaType = 2;
                this.sDomainName = commDirectory.getFirstAttrValue(theLdapEntry, "sunpreferreddomain");
                this.sCanonicalName = this.sDomainName = this.sDomainName.trim();
            }
        }
        catch (Exception theException) {
            theException.printStackTrace();
        }
    }

    public commDomainEntry(LDAPEntry theLdapEntry, String theDomainName, LDAPEntry theOsiEntry) throws Exception {
        super(theLdapEntry);
        this.objectType = "Domain";
        Object aAttrValues = null;
        Object aCanonicalNameValue = null;
        this.sSchemaType = 1;
        this.sDomainName = theDomainName;
        this.sCanonicalName = commDirectory.getFirstAttrValue(theLdapEntry, "inetCanonicalDomainName");
        this.setOsiNode(theOsiEntry);
    }

    public Set prepareForMigration(commConfigService theOsiServiceToUpdate, commConfigService theDcServiceToAdd, commConfigService theServiceToMove, int theMigrationType) {
        commConfigService aTotalConfigService = null;
        commConfigService aDcServiceToMove = null;
        Vector aOsiAttrVector = theOsiServiceToUpdate.getAttributeSet();
        Vector aDcAttrVector = theDcServiceToAdd.getAttributeSet();
        Object aMoveLdapAttributeSet = null;
        HashSet<commEntry> aEntrySet = new HashSet<commEntry>();
        try {
            if (theMigrationType == 2) {
                this.sOsiCommEntry.removeExistingAttributes(aOsiAttrVector, this);
                this.removeExistingAttributes(aDcAttrVector, this);
                aEntrySet.add(this.sOsiCommEntry);
                aEntrySet.add(this);
            } else {
                aDcServiceToMove = theServiceToMove.getExclusive(this.myLDAPEntry);
                aTotalConfigService = new commConfigService("totalServices");
                aTotalConfigService.add(theOsiServiceToUpdate);
                aTotalConfigService.add(theDcServiceToAdd);
                aTotalConfigService.add(aDcServiceToMove);
                this.sOsiCommEntry.removeExistingAttributes(aTotalConfigService.getAttributeSet(), this);
                aEntrySet.add(this.sOsiCommEntry);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return aEntrySet;
    }

    public void setOsiNode(LDAPEntry theOsiNode) {
        if (theOsiNode != null) {
            this.sBaseDn = commDirectory.normalizeDn(theOsiNode.getDN());
            this.sOsiCommEntry = new commOsiEntry(theOsiNode);
        } else {
            this.sBaseDn = null;
            this.sOsiCommEntry = null;
        }
    }

    public String getUgBaseDn() {
        return this.sBaseDn;
    }

    public String getDomainName() {
        return this.sDomainName;
    }

    public String getCanonicalName() {
        return this.sCanonicalName;
    }

    public String getCanonicalAttrValue() {
        return this.sCanonicalAttrValue;
    }

    public String getMailHost() {
        return this.sPreferredMailHost;
    }

    public void setMailHost(String host) {
        this.sPreferredMailHost = host;
    }

    public void clearAssociatedValues() {
        this.sAssociatedDomains = null;
    }

    public void setAssociatedValues(Vector theDomainNames) {
        this.sAssociatedDomains = theDomainNames;
    }

    public Vector getAssociatedDomains() {
        return this.sAssociatedDomains;
    }

    public void setIndirectState() {
        this.sIndirectState = true;
    }

    public boolean getIndirectState() {
        return this.sIndirectState;
    }

    public void setOsiFailureList(Vector theList) {
        this.sErrorCode = 101;
        this.sFailedOsiList = theList;
    }

    public Vector getFailedOsiList() {
        return this.sFailedOsiList;
    }

    public void setErrorCode(int theCode) {
        this.sErrorCode = theCode;
    }

    public int getErrorCode() {
        return this.sErrorCode;
    }

    private String dcToDomainName() {
        String aReturnString = null;
        Object aDnValue = null;
        String[] aElements = this.getDn().split(",");
        int aElementCount = aElements.length - 2;
        int aIdx = 0;
        for (aIdx = 0; aIdx < aElementCount; ++aIdx) {
            aReturnString = aReturnString + aElements[aIdx].split("=")[1].trim() + ".";
        }
        aReturnString = aReturnString + aElements[aIdx].split("=")[1].trim();
        return aReturnString;
    }
}

