/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import sun.comm.dirmig.GetOpts;
import sun.comm.dirmig.InvalidOptionException;
import sun.comm.dirmig.ValDomain;
import sun.comm.dirmig.commAdminEntry;
import sun.comm.dirmig.commAttrValuePair;
import sun.comm.dirmig.commAttribute;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commConfigEntry;
import sun.comm.dirmig.commConfigService;
import sun.comm.dirmig.commDirMigException;
import sun.comm.dirmig.commDirectory;
import sun.comm.dirmig.commDomainEntry;
import sun.comm.dirmig.commDomainGroup;
import sun.comm.dirmig.commEntry;
import sun.comm.dirmig.commLdifLogger;
import sun.comm.dirmig.commLogger;
import sun.comm.dirmig.commSearchConstraints;
import sun.comm.dirmig.commSearchResults;
import sun.comm.dirmig.commUtil;
import sun.comm.dirmig.inputFileParser;
import sun.comm.dirmig.userPrefsProperties;

public class commDirMig {
    private commConfig sConfiguration = null;
    private commDirectory sDirectory = null;
    private Vector sDomainNames = null;
    private Vector sServicesToAdd = new Vector();
    private Map sDomainMap = new HashMap();
    private Map domainHostMap = null;
    private Vector sBadDomainList = new Vector();
    private static commLogger sLog = null;
    private commLdifLogger sLdifAudit = null;
    private commLdifLogger sLdifUndo = null;
    private static PrintWriter sLdifOutputFile = null;
    int sMigrationType = 1;
    private boolean domainConsistencyCheck = false;
    public static final String PACKAGE_NAME = "sun.comm.dirmig.resource";
    private String[] noArgOptions = null;
    private static Hashtable optionArgsAndValues = null;
    private String[] validOptionsArray = new String[]{"D:", "w:", "p:", "X:", "b:", "r:", "u:", "t:", "S:", "o", "a:", "d:", "f:", "l:", "H:", "k:", "v", "c", "i:", "h", "?", "V", "m:"};

    public static void main(String[] args) {
        commDirMig aCommDirMig = new commDirMig();
        try {
            aCommDirMig.sConfiguration = new commConfig(PACKAGE_NAME, "en");
            aCommDirMig.processCommandLine(args);
            aCommDirMig.initializeLogging();
            aCommDirMig.sConfiguration.loadMigrationInformation();
            aCommDirMig.initializeDirectory();
            aCommDirMig.migrateDirectory();
        }
        catch (LDAPException le) {
            try {
                commLogger.writeLog(commConfig.getCodedString(12) + le.errorCodeToString());
                String matchedDN = le.getMatchedDN();
                if (matchedDN != null) {
                    commLogger.writeLog(commConfig.getCodedString(10) + matchedDN);
                }
                StackTraceElement[] trace = le.getStackTrace();
                for (int w = 0; w < trace.length; ++w) {
                    commLogger.writeLog(trace[w].toString());
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
        catch (Exception theException) {
            try {
                StackTraceElement[] trace = theException.getStackTrace();
                for (int w = 0; w < trace.length; ++w) {
                    commLogger.writeLog(trace[w].toString());
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    public int migrateDirectory() throws Exception {
        Set aDomainSet = null;
        Iterator aDomainListIterator = null;
        String osiRoot = (String)commDirMig.getOptionValue("b");
        String defAuthLDAPDN = commConfig.getString("RDN", "defaultAuthLDAP") + "," + osiRoot;
        LDAPEntry defAuthLDAPEntry = null;
        LDAPAttribute sunKeyAttr = null;
        try {
            defAuthLDAPEntry = this.sDirectory.getLDAPEntry(defAuthLDAPDN);
            sunKeyAttr = defAuthLDAPEntry.getAttribute("sunkeyvalue");
            String[] sunKeyVal = sunKeyAttr.getStringValueArray();
            String passwd = null;
            for (int i = 0; i < sunKeyVal.length; ++i) {
                if (sunKeyVal[i].indexOf("iplanet-am-auth-ldap-bind-passwd") == -1) continue;
                int eqInd = sunKeyVal[i].indexOf("=");
                passwd = sunKeyVal[i].substring(eqInd + 1);
                break;
            }
            commConfig.setMacroValue("%LDAP_BIND_PASSWORD%", passwd);
        }
        catch (LDAPException e) {
            System.err.println(commConfig.getCodedString(15));
            commLogger.writeLog(commConfig.getCodedString(12) + e.errorCodeToString());
            String matchedDN = e.getMatchedDN();
            if (matchedDN != null) {
                commLogger.writeLog(commConfig.getCodedString(10) + matchedDN);
            }
            StackTraceElement[] trace = e.getStackTrace();
            for (int w = 0; w < trace.length; ++w) {
                commLogger.writeLog(trace[w].toString());
            }
        }
        aDomainSet = this.getDomainList();
        aDomainSet = this.checkDomainConsistency(aDomainSet);
        if (this.domainConsistencyCheck) {
            System.exit(0);
        }
        aDomainListIterator = aDomainSet.iterator();
        while (aDomainListIterator.hasNext()) {
            this.migrateDomain((commDomainEntry)aDomainListIterator.next());
        }
        this.migrateTopLevelAdmin();
        String schemaTopEntryDN = commConfig.getString("DN", "schematopentry");
        String schemaTypeVal = "schematype=";
        String migType = (String)commDirMig.getOptionValue("t");
        schemaTypeVal = migType.equals("2") ? schemaTypeVal + "1.5" : schemaTypeVal + "2";
        try {
            LDAPAttribute sunkeyAttr = new LDAPAttribute("sunkeyvalue", schemaTypeVal);
            LDAPModification mod = new LDAPModification(2, sunkeyAttr);
            this.sDirectory.getConnection().modify(schemaTopEntryDN, mod);
        }
        catch (LDAPException e) {
            commLogger.writeLog(commConfig.getCodedString(12) + e.errorCodeToString());
            String matchedDN = e.getMatchedDN();
            if (matchedDN != null) {
                commLogger.writeLog(commConfig.getCodedString(10) + matchedDN);
            }
            StackTraceElement[] trace = e.getStackTrace();
            for (int w = 0; w < trace.length; ++w) {
                commLogger.writeLog(trace[w].toString());
            }
        }
        return 0;
    }

    protected Set checkDomainConsistency(Set theDomainSet) throws Exception {
        commDomainEntry aDomainEntry = null;
        commDomainGroup aDomainGroup = null;
        Iterator<Object> aIterator = null;
        Object aOsiNode = null;
        HashSet<commDomainEntry> aDomainEntrySet = new HashSet<commDomainEntry>();
        Set aKeySet = null;
        Vector aInfiniteLoopList = new Vector();
        int aDomainGroupStatus = 1;
        boolean aReturnInt = false;
        aIterator = theDomainSet.iterator();
        while (aIterator.hasNext()) {
            aDomainEntry = (commDomainEntry)aIterator.next();
            this.sDirectory.resolveOsiNode(aDomainEntry);
            if (aDomainEntry.getErrorCode() == 100) {
                this.addToDomainMap(aDomainEntry);
                continue;
            }
            commLogger.writeLog(4, aDomainEntry.getDomainName());
            this.sBadDomainList.add(aDomainEntry);
        }
        aKeySet = this.sDomainMap.keySet();
        aIterator = aKeySet.iterator();
        while (aIterator.hasNext()) {
            aDomainGroup = (commDomainGroup)this.sDomainMap.get(aIterator.next());
            aDomainGroupStatus = aDomainGroup.getState();
            if (aDomainGroupStatus == 2 || aDomainGroupStatus == 3) {
                aDomainGroup.updatePrimaryDomain();
                aDomainEntrySet.add(aDomainGroup.getPrimaryDomain());
                continue;
            }
            commLogger.writeLog(5, aDomainGroup);
        }
        return aDomainEntrySet;
    }

    public int migrateDomain(commDomainEntry theDomain) throws Exception {
        this.migrateDomainNode(theDomain);
        this.migrateEntry(theDomain);
        this.createAdminRoles(theDomain);
        this.createDomainSubEntries(theDomain);
        this.migrateAdmin(theDomain);
        return 0;
    }

    public int migrateEntry(commDomainEntry theDomain) throws Exception {
        Object aEntrySet = null;
        Object aUserServiceSet = null;
        Iterator aIterator = commConfig.getObjectTypeIterator();
        Iterator aSearchResultsIterator = null;
        String aObjectType = null;
        int aReturn = 0;
        commSearchResults aCommSearchResults = null;
        commSearchConstraints aCommSearchConstraints = null;
        commEntry aCommEntry = null;
        LDAPException aLdapException = null;
        while (aIterator.hasNext()) {
            aObjectType = ((commAttrValuePair)aIterator.next()).getAttributeName();
            if (aObjectType.indexOf("Domain") != -1 || aObjectType.indexOf("Admin") != -1) continue;
            aCommSearchConstraints = new commSearchConstraints(aObjectType, theDomain);
            aCommSearchConstraints.setAsyncSearch();
            aCommSearchResults = this.sDirectory.searchObjects(aCommSearchConstraints);
            aSearchResultsIterator = aCommSearchResults.iterator();
            while (aSearchResultsIterator.hasNext()) {
                aCommEntry = (commEntry)aSearchResultsIterator.next();
                if (this.prepareEntry(aObjectType, aCommEntry, theDomain) != 0) continue;
                this.sDirectory.modify(aCommEntry);
            }
            aLdapException = aCommSearchResults.getLdapException();
            if (aLdapException != null) {
                aCommSearchResults.clear();
                throw aLdapException;
            }
            aCommSearchResults.clear();
        }
        return aReturn;
    }

    public int prepareEntries(String theObjectType, Set theEntrySet, commDomainEntry theDomain) throws Exception {
        Iterator aIterator = theEntrySet.iterator();
        commEntry aCommEntry = null;
        while (aIterator.hasNext()) {
            aCommEntry = (commEntry)aIterator.next();
            this.prepareEntry(theObjectType, aCommEntry, theDomain);
        }
        return 0;
    }

    public int prepareEntry(String theObjectType, commEntry theCommEntry, commDomainEntry theDomain) throws Exception {
        commConfigService aCommConfigService = null;
        Vector migratedAttrSet = null;
        Vector currentSvcs = theCommEntry.getCurrentServices();
        Vector allSvcs = new Vector();
        commUtil.mergeVector(allSvcs, currentSvcs);
        commUtil.mergeVector(allSvcs, this.sServicesToAdd);
        aCommConfigService = this.sConfiguration.getConfigService(theObjectType, allSvcs);
        migratedAttrSet = aCommConfigService.getAttributeSet();
        theCommEntry.prepareForMigration(allSvcs, migratedAttrSet, theDomain);
        return 0;
    }

    protected int migrateDomainNode(commDomainEntry theDomainEntry) throws Exception {
        Vector aCurrentServices = theDomainEntry.getCurrentServices();
        Vector aTotalServices = new Vector();
        Vector aNewServices = new Vector();
        Object aIterator = null;
        Object aService = null;
        commConfigService aConfigOsiServiceToAdd = null;
        commConfigService aConfigDcServiceToAdd = null;
        commConfigService aConfigServiceToMove = null;
        Object aMigratedAttributeSet = null;
        Set aEntrySet = null;
        commUtil.mergeVector(aTotalServices, aCurrentServices);
        commUtil.mergeVector(aTotalServices, this.sServicesToAdd);
        aConfigOsiServiceToAdd = this.sConfiguration.getConfigService("DomainOsi", aTotalServices);
        aConfigDcServiceToAdd = this.sConfiguration.getConfigService("DomainDc", aTotalServices);
        aConfigServiceToMove = this.sConfiguration.getConfigServiceToMove("DomainDc", aTotalServices);
        aEntrySet = theDomainEntry.prepareForMigration(aConfigOsiServiceToAdd, aConfigDcServiceToAdd, aConfigServiceToMove, this.sMigrationType);
        this.outputEntriesModify(aEntrySet);
        return 0;
    }

    public int outputEntriesModify(Set theEntrySet) throws Exception {
        this.sDirectory.modify(theEntrySet);
        return 0;
    }

    public int outputEntryModify(commEntry theCommEntry) throws Exception {
        HashSet<commEntry> aSet = new HashSet<commEntry>();
        aSet.add(theCommEntry);
        this.sDirectory.modify(aSet);
        return 0;
    }

    protected int outputLdif(Set theEntries) throws Exception {
        Iterator aIterator = theEntries.iterator();
        commEntry aCommEntry = null;
        while (aIterator.hasNext()) {
            sLdifOutputFile.println(aCommEntry.getModLdif());
        }
        return 0;
    }

    public int outputEntriesAdd(Vector theEntryVector) throws Exception {
        return this.sDirectory.add(theEntryVector);
    }

    public int outputEntriesAdd(Set theEntrySet) throws Exception {
        return this.sDirectory.add(theEntrySet);
    }

    public int migrateTopLevelAdmin() throws Exception {
        Vector aServices = new Vector();
        String[] aAttributesToRetrieve = null;
        String baseDN = (String)commDirMig.getOptionValue("b");
        String serviceAdminGroupDN = commConfig.getString("RDN", "serviceadmin") + "," + baseDN;
        LDAPEntry adminGroupEntry = this.sDirectory.getLDAPEntry(serviceAdminGroupDN);
        if (adminGroupEntry == null) {
            return 0;
        }
        LDAPAttribute memberAttr = adminGroupEntry.getAttribute("uniquemember");
        if (memberAttr == null) {
            return 0;
        }
        aAttributesToRetrieve = this.getAttributesToRetrieve("Admin", aServices);
        String[] adminDNs = memberAttr.getStringValueArray();
        HashSet<commAdminEntry> aEntrySet = new HashSet<commAdminEntry>();
        for (int i = 0; i < adminDNs.length; ++i) {
            LDAPEntry adminLdapEntry = this.sDirectory.getLDAPEntry(adminDNs[i], aAttributesToRetrieve);
            commAdminEntry adminEntry = new commAdminEntry(adminLdapEntry, "serviceadmin", baseDN);
            aEntrySet.add(adminEntry);
        }
        this.prepareEntries("Admin", aEntrySet, null);
        this.outputEntriesModify(aEntrySet);
        return 0;
    }

    protected int migrateAdmin(commDomainEntry theDomain) throws Exception {
        String baseDN = theDomain.getUgBaseDn();
        String domainAdminGroupDN = commConfig.getString("RDN", "domainadmin") + "," + baseDN;
        LDAPEntry adminGroupEntry = this.sDirectory.getLDAPEntry(domainAdminGroupDN);
        LDAPAttribute memberAttr = adminGroupEntry.getAttribute("uniquemember");
        if (memberAttr == null) {
            return 0;
        }
        String[] adminDNs = memberAttr.getStringValueArray();
        HashSet<commAdminEntry> aEntrySet = new HashSet<commAdminEntry>();
        for (int i = 0; i < adminDNs.length; ++i) {
            LDAPEntry adminLdapEntry = this.sDirectory.getLDAPEntry(adminDNs[i]);
            commAdminEntry adminEntry = new commAdminEntry(adminLdapEntry, "domainadmin", baseDN);
            aEntrySet.add(adminEntry);
        }
        this.prepareEntries("Admin", aEntrySet, theDomain);
        this.outputEntriesModify(aEntrySet);
        return 0;
    }

    protected int createAdminRoles(commDomainEntry theDomain) throws Exception {
        Iterator aIterator = commConfig.getDomainAdminKeySetIterator();
        commConfigEntry aConfigEntry = null;
        commEntry aCommEntry = null;
        Vector<commEntry> aEntryList = new Vector<commEntry>();
        Vector aCulledEntryList = null;
        Object aDnValue = null;
        int aReturnInt = 0;
        while (aIterator.hasNext()) {
            aConfigEntry = commConfig.getAdminEntry(aIterator.next());
            if (aConfigEntry.getOrder() == 15) continue;
            aCommEntry = new commEntry(aConfigEntry, theDomain);
            aEntryList.add(aCommEntry);
        }
        aCulledEntryList = this.checkEntryPresence(aEntryList);
        this.outputEntriesAdd(aCulledEntryList);
        return aReturnInt;
    }

    protected int createDomainSubEntries(commDomainEntry theDomain) throws Exception {
        Iterator aIterator = commConfig.getDomainSubEntryIterator();
        commEntry aCommEntry = null;
        commConfigEntry aConfigEntry = null;
        Vector<commEntry> aEntryList = new Vector<commEntry>();
        Vector aCulledEntryList = null;
        int aReturnInt = 0;
        while (aIterator.hasNext()) {
            aConfigEntry = (commConfigEntry)aIterator.next();
            aCommEntry = new commEntry(aConfigEntry, theDomain);
            aEntryList.add(aCommEntry);
        }
        aCulledEntryList = this.checkEntryPresence(aEntryList);
        this.outputEntriesAdd(aCulledEntryList);
        return aReturnInt;
    }

    protected Vector checkEntryPresence(Vector theEntryList) throws Exception {
        Iterator aIterator = theEntryList.iterator();
        Vector<commEntry> aReturnList = new Vector<commEntry>();
        String aEntryDn = null;
        LDAPEntry aLdapEntry = null;
        commEntry aCommEntry = null;
        while (aIterator.hasNext()) {
            aCommEntry = (commEntry)aIterator.next();
            aEntryDn = aCommEntry.getDn();
            aLdapEntry = this.sDirectory.getLDAPEntry(aEntryDn);
            if (aLdapEntry != null) continue;
            aReturnList.add(aCommEntry);
        }
        return aReturnList;
    }

    protected Set getDomainList() throws Exception {
        Iterator<Object> aIterator = null;
        commDomainEntry aDomainEntry = null;
        Object aDomainGroup = null;
        Set aDomainEntrySet = new HashSet();
        Set aDomainAliasSet = null;
        Object aKeySet = null;
        Vector aInfiniteLoopList = new Vector();
        Vector<String> aDomainsTraversed = new Vector<String>();
        boolean aDomainGroupStatus = true;
        if (this.sDomainNames != null && this.sDomainNames.size() == 1 && this.sDomainNames.indexOf("*") >= 0) {
            aDomainEntrySet = this.sDirectory.searchObjects("Domain", "All", null, null, 1);
        } else {
            aIterator = this.sDomainNames != null ? this.sDomainNames.iterator() : this.domainHostMap.keySet().iterator();
            String domainName = null;
            while (aIterator.hasNext()) {
                try {
                    domainName = (String)aIterator.next();
                    aDomainEntry = this.sDirectory.getDomain_ByDomainName_SI(domainName);
                    this.sDirectory.resolveOsiNode(aDomainEntry);
                    if (aDomainEntry.getErrorCode() == 100) {
                        if (aDomainsTraversed.indexOf(aDomainEntry.getUgBaseDn()) != -1) continue;
                        aDomainAliasSet = this.sDirectory.searchObjects("Domain", "All-Inetdomainbasedn", aDomainEntry, null, 1);
                        if (this.domainHostMap != null) {
                            Iterator domIterator = aDomainAliasSet.iterator();
                            while (domIterator.hasNext()) {
                                commDomainEntry eachDomainEntry = (commDomainEntry)domIterator.next();
                                eachDomainEntry.setMailHost((String)this.domainHostMap.get(domainName));
                            }
                        }
                        aDomainEntrySet.addAll(aDomainAliasSet);
                        aDomainsTraversed.add(aDomainEntry.getUgBaseDn());
                        continue;
                    }
                    commLogger.writeLog(4, aDomainEntry.getDomainName());
                    this.sBadDomainList.add(aDomainEntry);
                }
                catch (LDAPException theException) {
                    System.err.println(commConfig.getCodedString(9) + domainName);
                    commLogger.writeLog(commConfig.getCodedString(12) + theException.errorCodeToString());
                    commLogger.writeLog(commConfig.getCodedString(9) + domainName);
                    String matchedDN = theException.getMatchedDN();
                    if (matchedDN != null) {
                        commLogger.writeLog(commConfig.getCodedString(10) + matchedDN);
                    }
                    StackTraceElement[] trace = theException.getStackTrace();
                    for (int w = 0; w < trace.length; ++w) {
                        commLogger.writeLog(trace[w].toString());
                    }
                }
            }
        }
        return aDomainEntrySet;
    }

    public Set resolveDomainOsiNode(Set theDomainEntrySet) {
        commDomainEntry aDomainEntry = null;
        Iterator aIterator = null;
        HashSet<commDomainEntry> aDomainEntrySet = new HashSet<commDomainEntry>();
        aIterator = theDomainEntrySet.iterator();
        while (aIterator.hasNext()) {
            aDomainEntry = (commDomainEntry)aIterator.next();
            this.sDirectory.resolveOsiNode(aDomainEntry);
            if (aDomainEntry.getErrorCode() == 100) {
                aDomainEntrySet.add(aDomainEntry);
                continue;
            }
            this.sBadDomainList.add(aDomainEntry);
        }
        return aDomainEntrySet;
    }

    protected void processCommandLine(String[] args) throws Exception {
        block5: {
            GetOpts opts = null;
            GetOpts mergedOpts = null;
            opts = new GetOpts(this.validOptionsArray, true);
            try {
                this.noArgOptions = opts.parseOpts(args);
                mergedOpts = this.mergeCommandLineAndInputFileOptions(opts);
                this.printUsageOrVersion(mergedOpts);
                this.createUserPrefsPropertyFile(mergedOpts);
                this.validateOpts(mergedOpts);
                optionArgsAndValues = this.getOptionArgsAndValues(mergedOpts);
            }
            catch (InvalidOptionException e) {
                String msg = e.getMessage();
                System.err.println(msg);
                if (!(msg.startsWith("Invalid Domain Name") || msg.startsWith("When -k is specified only erroneous provisioning of domains are checked and logged. -o does not take affect. No migration takes place") || msg.startsWith("When -k is specified erroneous provisioning of all domains are checked and logged. -d doesn't take affect"))) {
                    System.err.println("Usage :\nMandatory Options : \n\n-D  <authentication id> \n-w  <password> \n-t  migration type : allowed values are <1,2,3> \n                   (1= S1 to s2, 2= S1 to S2c, 3= S2c to S2) \n\nMandatory and configurable options :\n\n-X  <directory server hostname> \n-p  <directory server port no.> \n-b  <OSI root suffix> \n-r  <DC root suffix> \n\nNon Mandatory Options :\n\n-S  service to add : allowed values are <mail,cal>  \n                   service to be added to user, groups of the domain \n-H  <mailHost>     The mailhost to be used to add mail services to users \n                   and groups. This is mandatory when -S mail is used. \n\n-o                 To change directory data this option is needed.\n\t\t\tIf this option is not given only ldif s are generated \n                   no directory changes are done \n\n-a  <audit ldif file> \n                   default name of the file is commdirmig.audit.ldif \n-u  <undo ldif file> \n                   default name of the file is commdirmig.undo.ldif \n-d  <domain>       * means all domains \n-f  <file>         an input file with domain names \n                   or with sets of domain names and preferredMailHost \n                   values, which can be used as mailhost when mail \n                   service is being added to users and groups of the domain \n                    either of -d or -f can be used at a time \n\n-l  <log filename> dfeualt name of the file is commdirmig.log \n                   \n-m  <logmaxsize>   It is an integer followed by an unit. \n                   Unit should be k or m; k for KiloBytes, m for Megabytes \n\n-k  \t\tcheck for erroneously provisioned domains. Bad domains \n                   are reported in the log file \n\n-v  verbose \n-c  continue on error \n-i  <input file>   contains option arguments in a file \n-h  prints help information \n-?  prints help information \n-V  version \n\n");
                }
                if (msg.startsWith("When -k is specified only erroneous provisioning of domains are checked and logged. -o does not take affect. No migration takes place") || msg.startsWith("When -k is specified erroneous provisioning of all domains are checked and logged. -d doesn't take affect")) break block5;
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                StackTraceElement[] trace = e.getStackTrace();
                commLogger.writeLog(13, e.toString());
                for (int w = 0; w < trace.length; ++w) {
                    commLogger.writeLog(trace[w].toString());
                }
            }
        }
    }

    private GetOpts mergeCommandLineAndInputFileOptions(GetOpts opts) throws Exception {
        String infile = null;
        inputFileParser parser = null;
        String[] argz = null;
        GetOpts infileOpts = null;
        String[] infileNoArgsOptions = null;
        String option = null;
        Enumeration commandLineOpts = null;
        infile = opts.getArg("i");
        if (infile == null) {
            return opts;
        }
        parser = new inputFileParser(new FileInputStream(infile));
        argz = parser.parseNextOptionSet();
        infileOpts = new GetOpts(this.validOptionsArray, true);
        infileNoArgsOptions = infileOpts.parseOpts(argz);
        commandLineOpts = opts.getAllOptions();
        while (commandLineOpts.hasMoreElements()) {
            option = (String)commandLineOpts.nextElement();
            if (infileOpts.isOpt(option)) {
                if ((option = option.trim()).equalsIgnoreCase("d") || option.equalsIgnoreCase("S")) {
                    Vector values1 = this.splitCommaSeparatedList(opts.getMultiArgs(option));
                    Vector values2 = this.splitCommaSeparatedList(infileOpts.getMultiArgs(option));
                    values1.addAll(values2);
                    infileOpts.replaceMultiArgsOpt(option, values1);
                    continue;
                }
                infileOpts.replaceOpt(option, opts.getArg(option));
                continue;
            }
            infileOpts.setOpt(option, opts.getArg(option));
        }
        return infileOpts;
    }

    private void createUserPrefsPropertyFile(GetOpts options) throws Exception {
        PrintWriter writer = null;
        File libdir = new File("../lib");
        File prefsFile = new File("../lib/commdirmig-userprefs.properties");
        String ldap_host = null;
        String ldap_port = null;
        String osi_root = null;
        String dc_root = null;
        String logmaxsize = null;
        libdir.mkdir();
        if (prefsFile.createNewFile()) {
            writer = new PrintWriter(new FileOutputStream(prefsFile), true);
            ldap_host = options.getArg("X");
            if (ldap_host == null) {
                prefsFile.delete();
                throw new InvalidOptionException("Directory server host name is required");
            }
            writer.println("ldaphost=" + ldap_host);
            ldap_port = options.getArg("p");
            if (ldap_port == null) {
                prefsFile.delete();
                throw new InvalidOptionException("Directory server port no. is required");
            }
            writer.println("ldapport=" + ldap_port);
            osi_root = options.getArg("b");
            if (osi_root == null) {
                prefsFile.delete();
                throw new InvalidOptionException("OSI root suffix is required");
            }
            writer.println("osiroot=" + osi_root);
            dc_root = options.getArg("r");
            if (dc_root == null) {
                prefsFile.delete();
                throw new InvalidOptionException("DC root suffix is required");
            }
            writer.println("dcroot=" + dc_root);
            logmaxsize = options.getArg("m");
            if (logmaxsize != null) {
                writer.println("logmaxsize=" + logmaxsize);
            } else {
                writer.println("logmaxsize=500k");
            }
            writer.close();
        }
    }

    private void validateOpts(GetOpts opts) throws Exception {
        String admin = null;
        String password = null;
        String mig_type = null;
        Object mailhost = null;
        Vector services = null;
        Vector domains = null;
        ValDomain valDomain = null;
        Vector<String> svcList = null;
        admin = opts.getArg("D");
        password = opts.getArg("w");
        mig_type = opts.getArg("t");
        services = opts.getMultiArgs("S");
        if (admin == null) {
            throw new InvalidOptionException("Administrator login id is required ");
        }
        if (password == null) {
            throw new InvalidOptionException("Administrator password is required ");
        }
        if (mig_type == null) {
            throw new InvalidOptionException("Migration type is required");
        }
        if (!((mig_type = mig_type.trim()).equals("1") || mig_type.equals("2") || mig_type.equals("3"))) {
            throw new InvalidOptionException("Invalid Value for Migration Type, Valid values are 1, 2, 3");
        }
        if (opts.isOpt("H") && services == null) {
            throw new InvalidOptionException("Mailhost is valid only when mail service to be added");
        }
        if (services != null) {
            if (services.size() > 2) {
                throw new InvalidOptionException("Invalid no. of Services");
            }
            svcList = new Vector<String>();
            for (int i = 0; i < services.size(); ++i) {
                String svc = ((String)services.elementAt(i)).trim();
                if (svc.indexOf(",") == -1) {
                    svcList.add(svc.toLowerCase());
                    if (svc.equalsIgnoreCase("mail") || svc.equalsIgnoreCase("cal")) continue;
                    throw new InvalidOptionException("Invalid Service value " + svc);
                }
                String[] svcs = svc.split(",");
                if (svcs.length > 2) {
                    throw new InvalidOptionException("Invalid no. of Services");
                }
                for (int l = 0; l < svcs.length; ++l) {
                    svcs[l] = svcs[l].trim();
                    svcList.add(svcs[l].toLowerCase());
                    if (svcs[l].equalsIgnoreCase("mail") || svcs[l].equalsIgnoreCase("cal")) continue;
                    throw new InvalidOptionException("Invalid Service value " + svcs[l]);
                }
            }
        }
        if (opts.isOpt("H") && (svcList == null || svcList.indexOf("mail") == -1)) {
            throw new InvalidOptionException("Mailhost is valid only when mail service to be added");
        }
        if (svcList != null && !opts.isOpt("H") && svcList.indexOf("mail") != -1) {
            throw new InvalidOptionException("Mailhost is required option to add mail service");
        }
        if (opts.isOpt("o") && opts.isOpt("k")) {
            throw new InvalidOptionException("When -k is specified only erroneous provisioning of domains are checked and logged. -o does not take affect. No migration takes place");
        }
        if (opts.isOpt("d") && opts.isOpt("k")) {
            throw new InvalidOptionException("When -k is specified erroneous provisioning of all domains are checked and logged. -d doesn't take affect");
        }
        if (opts.isOpt("d") && opts.isOpt("f")) {
            throw new InvalidOptionException("-d and -f both can not be used together");
        }
        domains = opts.getMultiArgs("d");
        if (domains != null && domains.size() != 0) {
            valDomain = new ValDomain();
            for (int j = 0; j < domains.size(); ++j) {
                String dom = (String)domains.elementAt(j);
                if (dom.indexOf(",") == -1) {
                    if (valDomain.validate(dom)) continue;
                    throw new InvalidOptionException("Invalid Domain Name " + dom);
                }
                String[] doms = dom.split(",");
                for (int k = 0; k < doms.length; ++k) {
                    if (valDomain.validate(doms[k])) continue;
                    throw new InvalidOptionException("Invalid Domain Name " + doms[k]);
                }
            }
        }
    }

    private void printUsageOrVersion(GetOpts opts) {
        if (opts.isOpt("h") || opts.isOpt("?")) {
            System.out.println("Usage :\nMandatory Options : \n\n-D  <authentication id> \n-w  <password> \n-t  migration type : allowed values are <1,2,3> \n                   (1= S1 to s2, 2= S1 to S2c, 3= S2c to S2) \n\nMandatory and configurable options :\n\n-X  <directory server hostname> \n-p  <directory server port no.> \n-b  <OSI root suffix> \n-r  <DC root suffix> \n\nNon Mandatory Options :\n\n-S  service to add : allowed values are <mail,cal>  \n                   service to be added to user, groups of the domain \n-H  <mailHost>     The mailhost to be used to add mail services to users \n                   and groups. This is mandatory when -S mail is used. \n\n-o                 To change directory data this option is needed.\n\t\t\tIf this option is not given only ldif s are generated \n                   no directory changes are done \n\n-a  <audit ldif file> \n                   default name of the file is commdirmig.audit.ldif \n-u  <undo ldif file> \n                   default name of the file is commdirmig.undo.ldif \n-d  <domain>       * means all domains \n-f  <file>         an input file with domain names \n                   or with sets of domain names and preferredMailHost \n                   values, which can be used as mailhost when mail \n                   service is being added to users and groups of the domain \n                    either of -d or -f can be used at a time \n\n-l  <log filename> dfeualt name of the file is commdirmig.log \n                   \n-m  <logmaxsize>   It is an integer followed by an unit. \n                   Unit should be k or m; k for KiloBytes, m for Megabytes \n\n-k  \t\tcheck for erroneously provisioned domains. Bad domains \n                   are reported in the log file \n\n-v  verbose \n-c  continue on error \n-i  <input file>   contains option arguments in a file \n-h  prints help information \n-?  prints help information \n-V  version \n\n");
            System.exit(0);
        }
        if (opts.isOpt("V")) {
            System.out.println("commdirmig 1.0");
            System.exit(0);
        }
    }

    private Hashtable getOptionArgsAndValues(GetOpts myopts) throws Exception {
        Hashtable<String, Object> toReturn = new Hashtable<String, Object>();
        String bindPassword = null;
        String ldap_host = null;
        String ldap_port = null;
        String osi_root = null;
        String dc_root = null;
        String mail_host = null;
        String migration_type = null;
        Vector services_to_add = null;
        Vector services = null;
        String ldif_output_file = null;
        String undo_ldif_file = null;
        Vector domains = null;
        Vector domainSet = null;
        String domainsfile = null;
        String logfile = null;
        String inputfile = null;
        Object onLine = null;
        String logmaxsize = null;
        userPrefsProperties prefs = new userPrefsProperties();
        toReturn.put("D", myopts.getArg("D"));
        bindPassword = myopts.getArg("w");
        if (new File(bindPassword).exists()) {
            String passwdFromFile = this.readPasswordFile(bindPassword);
            toReturn.put("w", passwdFromFile);
        } else {
            toReturn.put("w", bindPassword);
        }
        ldap_host = myopts.getArg("X");
        if (ldap_host != null) {
            toReturn.put("X", ldap_host);
        } else {
            ldap_host = prefs.getString("ldaphost");
            if (ldap_host != null) {
                toReturn.put("X", ldap_host);
            } else {
                throw new InvalidOptionException("Directory server host name is required");
            }
        }
        ldap_port = myopts.getArg("p");
        if (ldap_port != null) {
            toReturn.put("p", ldap_port);
        } else {
            ldap_port = prefs.getString("ldapport");
            if (ldap_port != null) {
                toReturn.put("p", ldap_port);
            } else {
                throw new InvalidOptionException("Directory server port no. is required");
            }
        }
        osi_root = myopts.getArg("b");
        if (osi_root != null) {
            toReturn.put("b", osi_root);
        } else {
            osi_root = prefs.getString("osiroot");
            if (osi_root != null) {
                toReturn.put("b", osi_root);
            } else {
                throw new InvalidOptionException("OSI root suffix is required");
            }
        }
        dc_root = myopts.getArg("r");
        if (dc_root != null) {
            toReturn.put("r", dc_root);
        } else {
            dc_root = prefs.getString("dcroot");
            if (dc_root != null) {
                toReturn.put("r", dc_root);
            } else {
                throw new InvalidOptionException("DC root suffix is required");
            }
        }
        mail_host = myopts.getArg("H");
        if (mail_host != null) {
            toReturn.put("H", mail_host);
        }
        if ((migration_type = myopts.getArg("t")) != null) {
            toReturn.put("t", migration_type);
            this.sMigrationType = Integer.valueOf(migration_type);
        }
        if ((services = myopts.getMultiArgs("S")) != null && services.size() >= 1) {
            services_to_add = this.splitCommaSeparatedList(services);
            toReturn.put("S", services_to_add);
            this.sServicesToAdd = new Vector();
            for (int i = 0; i < services_to_add.size(); ++i) {
                if (((String)services_to_add.elementAt(i)).equalsIgnoreCase("mail")) {
                    this.sServicesToAdd.add("Mail");
                    continue;
                }
                if (!((String)services_to_add.elementAt(i)).equalsIgnoreCase("cal")) continue;
                this.sServicesToAdd.add("Calendar");
            }
        }
        if ((ldif_output_file = myopts.getArg("a")) != null) {
            toReturn.put("a", ldif_output_file);
        }
        if ((undo_ldif_file = myopts.getArg("u")) != null) {
            toReturn.put("u", undo_ldif_file);
        }
        if (myopts.isOpt("k")) {
            toReturn.put("k", "yes");
            this.domainConsistencyCheck = true;
            Vector<String> doms = new Vector<String>();
            doms.addElement("*");
            toReturn.put("d", doms);
            this.sDomainNames = doms;
        } else {
            domains = myopts.getMultiArgs("d");
            if (domains != null && domains.size() >= 1) {
                domainSet = this.splitCommaSeparatedList(domains);
                this.sDomainNames = new Vector();
                toReturn.put("d", domainSet);
                for (int i = 0; i < domainSet.size(); ++i) {
                    this.sDomainNames.add(domainSet.elementAt(i));
                }
            }
        }
        logfile = myopts.getArg("l");
        if (logfile != null) {
            toReturn.put("l", logfile);
        }
        if ((logmaxsize = myopts.getArg("m")) != null) {
            toReturn.put("m", logmaxsize);
        }
        if ((domainsfile = myopts.getArg("f")) != null) {
            toReturn.put("f", domainsfile);
            this.readDomainHostInfo(domainsfile, mail_host);
        }
        if ((inputfile = myopts.getArg("i")) != null) {
            toReturn.put("i", inputfile);
        }
        if (myopts.isOpt("o")) {
            toReturn.put("o", "yes");
        }
        if (myopts.isOpt("c")) {
            toReturn.put("c", "yes");
        }
        if (myopts.isOpt("V")) {
            toReturn.put("V", "yes");
        }
        return toReturn;
    }

    public static Object getOptionValue(String theOption) throws Exception {
        return optionArgsAndValues.get(theOption);
    }

    public void initializeDirectory() throws LDAPException {
        String ldap_host = null;
        String ldap_port = null;
        String admin_id = null;
        String admin_password = null;
        String osi_root = null;
        String dc_root = null;
        int port = 389;
        ldap_host = (String)optionArgsAndValues.get("X");
        ldap_port = (String)optionArgsAndValues.get("p");
        port = Integer.valueOf(ldap_port);
        admin_id = (String)optionArgsAndValues.get("D");
        admin_password = (String)optionArgsAndValues.get("w");
        osi_root = (String)optionArgsAndValues.get("b");
        dc_root = (String)optionArgsAndValues.get("r");
        this.sDirectory = new commDirectory(ldap_host, port, admin_id, admin_password, osi_root);
        this.sDirectory.setDCRoot(dc_root);
        this.sDirectory.setCommConfig(this.sConfiguration);
        this.sDirectory.setLogs(this.sLdifAudit, this.sLdifUndo);
    }

    public void initializeLogging() throws Exception {
        Object aCommLogger = null;
        Object aAuditLdif = null;
        String aLogOutputFile = (String)commDirMig.getOptionValue("l");
        String aLdifAuditFile = (String)commDirMig.getOptionValue("a");
        String aLdifUndoFile = (String)commDirMig.getOptionValue("u");
        int aLogLevel = 1;
        if (aLogOutputFile == null) {
            aLogOutputFile = "commdirmig.log";
        }
        if (commDirMig.getOptionValue("V") != null) {
            aLogLevel = 2;
        }
        sLog = new commLogger(aLogOutputFile, aLogLevel);
        if (aLdifAuditFile == null) {
            aLdifAuditFile = "commdirmig.audit.ldif";
        }
        this.sLdifAudit = new commLdifLogger(aLdifAuditFile);
        if (aLdifUndoFile == null) {
            aLdifUndoFile = "commdirmig.undo.ldif";
        }
        this.sLdifUndo = new commLdifLogger(aLdifUndoFile);
    }

    public static PrintWriter getLdifOutputFile() {
        return sLdifOutputFile;
    }

    public void addToDomainMap(commDomainEntry theDomain) {
        commDomainGroup aDomainGroup = null;
        String aUgBaseDn = null;
        if (theDomain == null) {
            return;
        }
        aUgBaseDn = theDomain.getUgBaseDn();
        aDomainGroup = (commDomainGroup)this.sDomainMap.get(aUgBaseDn);
        if (aDomainGroup == null) {
            aDomainGroup = new commDomainGroup(theDomain);
            this.sDomainMap.put(aUgBaseDn, aDomainGroup);
        } else {
            aDomainGroup.add(theDomain);
        }
    }

    private void readDomainHostInfo(String domainsFile, String mailHostInCommandLine) throws Exception {
        this.domainHostMap = new HashMap();
        inputFileParser domainFileParser = new inputFileParser(new FileInputStream(domainsFile));
        String[] domainInfo = domainFileParser.parseNextOptionSet();
        while (domainInfo != null && domainInfo.length != 0) {
            if (domainInfo.length == 4) {
                this.domainHostMap.put(domainInfo[1], domainInfo[3]);
            } else if (domainInfo.length == 2) {
                this.domainHostMap.put(domainInfo[1], mailHostInCommandLine);
            }
            domainInfo = domainFileParser.parseNextOptionSet();
        }
    }

    private String readPasswordFile(String fileName) throws Exception {
        String toReturn = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        toReturn = reader.readLine();
        if (toReturn == null) {
            throw new commDirMigException("Password file is empty");
        }
        return toReturn;
    }

    private Vector splitCommaSeparatedList(Vector list) {
        Vector<String> listToReturn = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            String domain = (String)list.elementAt(i);
            String[] domArray = null;
            if (domain.indexOf(",") != -1) {
                domArray = domain.split(",");
                for (int j = 0; j < domArray.length; ++j) {
                    if (listToReturn.indexOf(domArray[j]) != -1) continue;
                    listToReturn.addElement(domArray[j]);
                }
                continue;
            }
            if (listToReturn.indexOf(domain) != -1) continue;
            listToReturn.addElement(domain);
        }
        return listToReturn;
    }

    public String[] getAttributesToRetrieve(String theObjectType, Vector theServices) throws Exception {
        Vector aMigratedAttrVector = null;
        commConfigService aCommConfigService = null;
        int aSize = 0;
        int aIdx = 0;
        commAttribute aCommAttribute = null;
        String[] aAttributeNames = null;
        aCommConfigService = this.sConfiguration.getConfigService(theObjectType, theServices);
        aMigratedAttrVector = aCommConfigService.getAttributeSet();
        aSize = aMigratedAttrVector.size();
        aAttributeNames = new String[aSize + 1];
        for (aIdx = 0; aIdx < aSize; ++aIdx) {
            aCommAttribute = (commAttribute)((Object)aMigratedAttrVector.elementAt(aIdx));
            aAttributeNames[aIdx] = aCommAttribute.getName();
        }
        aAttributeNames[aIdx] = "objectclass";
        return aAttributeNames;
    }

    private static void test() {
        Vector<String> aTargetVector = new Vector<String>();
        Vector<String> aSourceVector = new Vector<String>();
        Iterator aIterator = null;
        String aString = null;
        aTargetVector.add("attribute");
        aTargetVector.add("Move");
        aTargetVector.add("Service");
        aTargetVector.add("op");
        aSourceVector.add("attribute");
        aSourceVector.add("Move");
        aSourceVector.add("Service");
        aSourceVector.add("Object");
        aSourceVector.add("DomainSubEntry");
        aSourceVector.add("DomainAdminEntry");
        commUtil.mergeVector(aTargetVector, aSourceVector);
        aIterator = aTargetVector.iterator();
        while (aIterator.hasNext()) {
            aString = (String)aIterator.next();
        }
    }
}

