/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPEntry;
import sun.comm.dirmig.commAttrValuePair;
import sun.comm.dirmig.commAttribute;
import sun.comm.dirmig.commConfigEntry;
import sun.comm.dirmig.commConfigService;
import sun.comm.dirmig.commConstants;
import sun.comm.dirmig.commDirMig;
import sun.comm.dirmig.commDomainEntry;
import sun.comm.dirmig.commResourceSet;
import sun.comm.dirmig.commResourceSetIterator;

public class commConfig {
    private static commResourceSet sResourceSet;
    private Vector sServices = new Vector();
    Vector sDomainSubEntryTypes = new Vector();
    Vector sDomainAdminTypes = new Vector();
    private Map sServiceMap = new HashMap();
    private Map sObjectIdentifer = new HashMap();
    private static Vector sDomainSubEntries;
    private static Map sMacros;
    private static Map sDomainAdminEntries;
    private static Set sObjects;

    public commConfig(String theResourceBundle, String theLocale) throws Exception {
        sResourceSet = new commResourceSet(theResourceBundle, theLocale);
    }

    public commConfig(String theResourceBundle, Locale theLocaleLocale) throws Exception {
        sResourceSet = new commResourceSet(theResourceBundle, theLocaleLocale);
    }

    public commConfigService getConfigService(String theObjectName, Vector theServices) throws Exception {
        return this.getConfigService(theObjectName, theServices, null);
    }

    public commConfigService getConfigServiceToMove(String theObjectName, Vector theServices) throws Exception {
        return this.getConfigService(theObjectName, this.createMoveServiceKey(theServices), "Move");
    }

    private commConfigService getConfigService(String theObjectName, Vector theServices, String theOrder) throws Exception {
        String aServiceKey = null;
        commConfigService aConfigService = null;
        aServiceKey = this.createServiceKey(theObjectName, theServices);
        aConfigService = (commConfigService)this.sServiceMap.get(aServiceKey);
        if (aConfigService == null) {
            aConfigService = this.makeServiceCombination(theObjectName, theServices, aServiceKey);
        }
        return aConfigService;
    }

    public Vector getServiceAttributeSet(String theEntryName, Vector theServices) throws Exception {
        commConfigService aConfigService = null;
        Vector attributeSet = null;
        aConfigService = this.getConfigService(theEntryName, theServices);
        if (aConfigService != null) {
            attributeSet = aConfigService.getAttributeSet();
        }
        return attributeSet;
    }

    public Vector getUserServiceAttributeSet(Vector theServices) throws Exception {
        return this.getServiceAttributeSet("User", theServices);
    }

    public Vector getDomainServiceAttributeSet(Vector theServices) throws Exception {
        return this.getServiceAttributeSet("Domain", theServices);
    }

    public Vector getStaticGroupServiceAttributeSet(Vector theServices) throws Exception {
        return this.getServiceAttributeSet("StaticGroup", theServices);
    }

    public Vector getResourceServiceAttributeSet(Vector theServices) throws Exception {
        return this.getServiceAttributeSet("Resource", theServices);
    }

    public static Iterator getObjectTypeIterator() {
        return sObjects.iterator();
    }

    public static Iterator getDomainSubEntryIterator() {
        return sDomainSubEntries.iterator();
    }

    public static Iterator getDomainAdminKeySetIterator() {
        return sDomainAdminEntries.keySet().iterator();
    }

    public static commConfigEntry getAdminEntry(Object theKey) {
        return (commConfigEntry)sDomainAdminEntries.get(theKey);
    }

    public void loadMigrationInformation() throws Exception {
        this.loadServices();
        this.loadObjects();
        this.loadDomainSubEntryTypes();
        this.loadDomainAdminTypes();
        this.loadServiceMap();
        this.loadDomainSubEntries();
        this.loadDomainAdminEntries();
        this.loadMacros();
    }

    private void loadServices() {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        aCommIterator = new commResourceSetIterator(sResourceSet, "Service");
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            this.sServices.add(aConfigAttribute);
        }
    }

    private void loadDomainSubEntryTypes() {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        aCommIterator = new commResourceSetIterator(sResourceSet, "DomainSubEntry");
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            this.sDomainSubEntryTypes.add(aConfigAttribute);
        }
    }

    private void loadDomainAdminTypes() {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        aCommIterator = new commResourceSetIterator(sResourceSet, "DomainAdminEntry");
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            this.sDomainAdminTypes.add(aConfigAttribute);
        }
    }

    private void loadObjects() {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        aCommIterator = new commResourceSetIterator(sResourceSet, "Object");
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            sObjects.add(aConfigAttribute);
        }
    }

    private void loadMacros() throws Exception {
        String aMacroString = null;
        aMacroString = (String)commDirMig.getOptionValue("b");
        if (aMacroString != null) {
            sMacros.put("%OSI_ROOT%", aMacroString);
        }
        if ((aMacroString = (String)commDirMig.getOptionValue("r")) != null) {
            sMacros.put("%DC_ROOT%", aMacroString);
        }
        if ((aMacroString = (String)commDirMig.getOptionValue("H")) != null) {
            sMacros.put("%MAIL_HOST%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("Domain", "Base", "S1")) != null) {
            sMacros.put("%DOMAIN_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("User", "Base", "S1")) != null) {
            sMacros.put("%USER_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("StaticGroup", "Base", "S1")) != null) {
            sMacros.put("%STATIC_GROUP_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("DynamicGroup", "Base", "S1")) != null) {
            sMacros.put("%DYNAMIC_GROUP_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("Resource", "Base", "S1")) != null) {
            sMacros.put("%RESOURCE_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("PeopleContainer", "Base", "S1")) != null) {
            sMacros.put("%PEOPLE_CONTAINER_MARKER%", aMacroString);
        }
        if ((aMacroString = commConfig.getMarkerClass("GroupContainer", "Base", "S1")) != null) {
            sMacros.put("%GROUP_CONTAINER_MARKER%", aMacroString);
        }
    }

    private void loadServiceMap() throws Exception {
        Iterator aObjectIterator = null;
        Iterator aServiceIterator = null;
        Object aIterator = null;
        commAttrValuePair aObjectAttribute = null;
        commAttrValuePair aServiceAttribute = null;
        commConfigService aConfigService = null;
        StringBuffer aKey = null;
        String aKeyString = null;
        Object aServiceName = null;
        aObjectIterator = sObjects.iterator();
        while (aObjectIterator.hasNext()) {
            aObjectAttribute = (commAttrValuePair)aObjectIterator.next();
            aServiceIterator = this.sServices.iterator();
            while (aServiceIterator.hasNext()) {
                aKey = new StringBuffer();
                aServiceAttribute = (commAttrValuePair)aServiceIterator.next();
                aConfigService = this.createService(aObjectAttribute, aServiceAttribute, "attribute");
                aKey.append(aObjectAttribute.getAttributeName()).append(aServiceAttribute.getAttributeName());
                aKeyString = aKey.toString();
                this.sServiceMap.put(aKey.toString(), aConfigService);
                aConfigService = this.createService(aObjectAttribute, aServiceAttribute, "Move");
                aKey.append("Move");
                aKeyString = aKey.toString();
                this.sServiceMap.put(aKey.toString(), aConfigService);
            }
        }
        this.sServices.addAll(this.createMoveServiceAvPair(this.sServices));
    }

    private void loadDomainSubEntries() throws Exception {
        Iterator aDomainSETIterator = null;
        commAttrValuePair aSubEntryType = null;
        Object aServiceAttribute = null;
        commConfigEntry aConfigEntry = null;
        aDomainSETIterator = this.sDomainSubEntryTypes.iterator();
        while (aDomainSETIterator.hasNext()) {
            aSubEntryType = (commAttrValuePair)aDomainSETIterator.next();
            aConfigEntry = this.createEntry("DomainSubEntry", aSubEntryType);
            sDomainSubEntries.add(aConfigEntry);
        }
    }

    private void loadDomainAdminEntries() throws Exception {
        Iterator aDomainAdminTypeIterator = null;
        commAttrValuePair aAdminType = null;
        Object aServiceAttribute = null;
        commConfigEntry aConfigEntry = null;
        aDomainAdminTypeIterator = this.sDomainAdminTypes.iterator();
        while (aDomainAdminTypeIterator.hasNext()) {
            aAdminType = (commAttrValuePair)aDomainAdminTypeIterator.next();
            aConfigEntry = this.createEntry("DomainAdminEntry", aAdminType);
            sDomainAdminEntries.put("DomainAdminEntry" + aAdminType.getAttributeName(), aConfigEntry);
        }
    }

    private commConfigService createService(commAttrValuePair theObject, commAttrValuePair theService, String theServiceClass) {
        return this.createService(theObject.getAttributeName(), theService.getAttributeName(), theServiceClass);
    }

    private commConfigService createService(String theObjectName, String theServiceName, String theServiceClass) {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        commConfigService aConfigService = new commConfigService(theServiceName);
        aCommIterator = new commResourceSetIterator(sResourceSet, theObjectName, theServiceName, theServiceClass);
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            aConfigService.addAttribute(aConfigAttribute);
        }
        return aConfigService;
    }

    private commConfigEntry createEntry(String theEntryClass, commAttrValuePair theEntryType) {
        commResourceSetIterator aCommIterator = null;
        commAttrValuePair aConfigAttribute = null;
        commConfigEntry aConfigEntry = new commConfigEntry(theEntryType);
        aCommIterator = new commResourceSetIterator(sResourceSet, theEntryClass, theEntryType.getAttributeName());
        while ((aConfigAttribute = aCommIterator.nextAttrValue()) != null) {
            aConfigEntry.addAttribute(aConfigAttribute);
        }
        return aConfigEntry;
    }

    private commConfigService makeServiceCombination(String theEntryName, Vector theRequestedServices, String theServiceKey) throws Exception {
        String aStandardServiceKey = null;
        String aServiceName = null;
        Set aServiceNameSet = null;
        Iterator aIterator = null;
        commConfigService aStandardService = null;
        commConfigService aCombinationService = new commConfigService(theServiceKey);
        aServiceNameSet = this.getServiceNames(theRequestedServices);
        aIterator = aServiceNameSet.iterator();
        while (aIterator.hasNext()) {
            aServiceName = (String)aIterator.next();
            aStandardServiceKey = theEntryName + aServiceName;
            aStandardService = (commConfigService)this.sServiceMap.get(aStandardServiceKey);
            aCombinationService.add(aStandardService);
        }
        this.sServiceMap.put(theServiceKey, aCombinationService);
        return aCombinationService;
    }

    private String createServiceKey(String theEntryName, Vector theServices) {
        String aServiceKey = new String(theEntryName);
        Set aServiceNameSet = null;
        Iterator aIterator = null;
        aServiceNameSet = this.getServiceNames(theServices);
        aIterator = aServiceNameSet.iterator();
        while (aIterator.hasNext()) {
            aServiceKey = aServiceKey.concat((String)aIterator.next());
        }
        return aServiceKey;
    }

    private Set getServiceNames(Vector theServices) {
        HashSet<String> aServiceNameSet = new HashSet<String>();
        Iterator aServiceIterator = null;
        commAttrValuePair aAttrValuePair = null;
        aServiceIterator = this.sServices.iterator();
        while (aServiceIterator.hasNext()) {
            aAttrValuePair = (commAttrValuePair)aServiceIterator.next();
            if (theServices.indexOf(aAttrValuePair.getAttributeName()) != -1) {
                aServiceNameSet.add(aAttrValuePair.getAttributeName());
                continue;
            }
            if (!aAttrValuePair.getAttributeName().equalsIgnoreCase("Base")) continue;
            aServiceNameSet.add(aAttrValuePair.getAttributeName());
        }
        return aServiceNameSet;
    }

    public static String getMarkerClass(String theObjectType, String theServiceName, String theSchema) {
        String aResourceString = null;
        String aMarkerClass = null;
        aResourceString = theObjectType + "-" + "Marker" + "-" + theServiceName;
        aMarkerClass = sResourceSet.getString(aResourceString, theSchema);
        if (aMarkerClass != null) {
            aMarkerClass = aMarkerClass.trim();
        }
        return aMarkerClass;
    }

    public static String getFactoryClass(String theObjectType) {
        Object aResourceString = null;
        String aFactoryClass = null;
        aFactoryClass = sResourceSet.getString(theObjectType, "Factory");
        return aFactoryClass;
    }

    public static String getCodedString(int theCode) {
        return sResourceSet.getString("Coded", Integer.toString(theCode));
    }

    public static String getLogString(String theIndexString) {
        return sResourceSet.getString("Log", theIndexString);
    }

    public static String getString(String key1, String key2) {
        return sResourceSet.getString(key1, key2);
    }

    public static String getSearchFilter(String theObject, String theSearchType, commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        String aResourceRoot = theObject;
        Object aResourceSuffix = null;
        String aResourceString = null;
        String aFilter = null;
        HashMap aValueMap = new HashMap();
        aResourceString = sResourceSet.getString(aResourceRoot, theSearchType);
        aFilter = commConstants.substitute(aResourceString, theDomain, theEntry, theValueMap);
        return aFilter;
    }

    public static String getMacroValue(String theMacroName) throws Exception {
        return (String)sMacros.get(theMacroName);
    }

    public static void setMacroValue(String theMacroName, String theMacroValue) throws Exception {
        sMacros.put(theMacroName, theMacroValue);
    }

    private Vector createMoveServiceKey(Vector theServices) {
        Vector<String> aReturnVector = new Vector<String>();
        Iterator aIterator = theServices.iterator();
        String aMoveServiceKey = null;
        while (aIterator.hasNext()) {
            aMoveServiceKey = (String)aIterator.next() + "Move";
            aReturnVector.add(aMoveServiceKey);
        }
        return aReturnVector;
    }

    private Vector createMoveServiceAvPair(Vector theServices) {
        Iterator aIterator = theServices.iterator();
        String aServiceName = null;
        Vector<commAttrValuePair> aMoveServices = new Vector<commAttrValuePair>();
        while (aIterator.hasNext()) {
            aServiceName = ((commAttrValuePair)aIterator.next()).getAttributeName() + "Move";
            aMoveServices.add(new commAttrValuePair(aServiceName));
        }
        return aMoveServices;
    }

    public void test() throws Exception {
        HashSet aAllTheServices_1 = new HashSet();
        HashSet aAllTheServices_2 = new HashSet();
        Object aAttributes = null;
        Object aMarkerClass = null;
        Object aFactoryClass = null;
        String aSearchFilter = null;
        Object aDnValue = null;
        Object aAttributeValue = null;
        Object aReturnString = null;
        Object aValues = null;
        Object aConfigService = null;
        Object aConfigEntry = null;
        Object aAttributeIterator = null;
        Object aEntryIterator = null;
        Iterator aIterator = null;
        Object aCommAttribute = null;
        Object aCommIterator = null;
        Object aValueEnumerator = null;
        HashMap aValueMap = new HashMap();
        aIterator = this.getDomainAdminKeySetIterator();
        this.testConfigEntries(aIterator, sDomainAdminEntries);
        aIterator = this.getDomainSubEntryIterator();
        this.testConfigEntries(aIterator, null);
        aSearchFilter = commConfig.getSearchFilter("Domain", "All", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("Domain", "Single", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("User", "All", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("User", "Single", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("StaticGroup", "All", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("DynamicGroup", "All", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("Resource", "All", null, null, null);
        aSearchFilter = commConfig.getSearchFilter("Resource", "Single", null, null, null);
        aSearchFilter = commConstants.substitute("%USER_UID%@%DOMAIN_NAME%", null, null, null);
        aSearchFilter = commConstants.substitute("%USER_UID%", null, null, null);
        aSearchFilter = commConstants.substitute("sunpreferreddomain=%DOMAIN_NAME%", null, null, null);
        aSearchFilter = commConstants.substitute("%USER_UID%@wellknown.domain", null, null, null);
    }

    private void testConfigEntries(Iterator theIterator, Map theMap) throws Exception {
        commConfigEntry aConfigEntry = null;
        String aDnValue = null;
        String aAttributeValue = null;
        String aReturnString = null;
        String aNameString = null;
        Iterator aAttributeIterator = null;
        commAttribute aCommAttribute = null;
        Enumeration aValueEnumerator = null;
        HashMap<String, String> aValueMap = new HashMap<String, String>();
        aValueMap.put("%OSI_ROOT%", "o=domainRoot");
        aValueMap.put("%USER_UID%", "babbott");
        aValueMap.put("%DOMAIN_UG_DN%", "o=aIsDomain1,o=domainRoot");
        aValueMap.put("%DOMAIN_NAME%", "aIsDomain1.com");
        aValueMap.put("%MAIL_HOST%", "blink.com");
        aValueMap.put("%GROUP_NAME%", "GroupOne");
        while (theIterator.hasNext()) {
            aConfigEntry = theMap != null ? (commConfigEntry)theMap.get(theIterator.next()) : (commConfigEntry)theIterator.next();
            aNameString = aConfigEntry.getOrder() == 15 ? aConfigEntry.getName() : aConfigEntry.getName();
            aDnValue = aConfigEntry.getDnValue();
            aDnValue = commConstants.substitute(aDnValue, aValueMap);
            aAttributeIterator = aConfigEntry.getAttributeIterator();
            while (aAttributeIterator.hasNext()) {
                aCommAttribute = (commAttribute)((Object)aAttributeIterator.next());
                aValueEnumerator = aCommAttribute.getStringValues();
                while (aValueEnumerator.hasMoreElements()) {
                    aAttributeValue = (String)aValueEnumerator.nextElement();
                    if (aCommAttribute.getClassType() == 4) {
                        aReturnString = commConstants.substitute(aAttributeValue, aValueMap);
                        System.out.println(aReturnString);
                        continue;
                    }
                    System.out.println(aAttributeValue);
                }
            }
        }
    }

    static {
        sDomainSubEntries = new Vector();
        sMacros = new HashMap();
        sDomainAdminEntries = new HashMap();
        sObjects = new HashSet();
    }
}

